//Gemma-7B DATASET v1.0 Category: Simulation of the Solar System ; Style: configurable
#include <stdio.h>
#include <math.h>

#define NUM_PLANETS 8

typedef struct Planet {
  char name[20];
  double mass;
  double distance;
  double orbital_speed;
  double rotation_speed;
  int colour;
} Planet;

Planet planets[NUM_PLANETS] = {
  {"Sun", 998000, 0, 0, 0, 0, 0},
  {"Mercury", 0.055, 59, 29.2, 0, 1, 1},
  {"Venus", 0.815, 67, 24.0, 0, 2, 2},
  {"Earth", 1, 93, 16.7, 0, 3, 3},
  {"Mars", 0.105, 248, 24.0, 0, 4, 4},
  {"Jupiter", 530, 520, 13.8, 0, 5, 5},
  {"Saturn", 95, 886, 9.6, 0, 6, 6},
  {"Uranus", 14, 1920, 6.8, 0, 7, 7}
};

void draw_planets() {
  for (int i = 0; i < NUM_PLANETS; i++) {
    switch (planets[i].colour) {
      case 0:
        printf("Drawing %s in red...\n", planets[i].name);
        break;
      case 1:
        printf("Drawing %s in green...\n", planets[i].name);
        break;
      case 2:
        printf("Drawing %s in blue...\n", planets[i].name);
        break;
      case 3:
        printf("Drawing %s in yellow...\n", planets[i].name);
        break;
      case 4:
        printf("Drawing %s in orange...\n", planets[i].name);
        break;
      case 5:
        printf("Drawing %s in purple...\n", planets[i].name);
        break;
      case 6:
        printf("Drawing %s in pink...\n", planets[i].name);
        break;
      case 7:
        printf("Drawing %s in gray...\n", planets[i].name);
        break;
    }
  }
}

int main() {
  draw_planets();
  return 0;
}