//Falcon-180B DATASET v1.0 Category: Building a FTP Client ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT "21"
#define USER "username"
#define PASS "password"
#define CURL_STATICLIB

size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    size_t realsize = size * nmemb;
    FILE* file = (FILE*)userp;
    return fwrite(contents, realsize, 1, file);
}

int progress_callback(void* clientp, curl_off_t dltotal, curl_off_t dlnow, curl_off_t ultotal, curl_off_t ulnow) {
    float progress = ((float)dlnow / (float)dltotal) * 100;
    printf("%.2f%%\r", progress);
    if(progress == 100) {
        printf("\n");
    }
    return 0;
}

int main(int argc, char* argv[]) {
    CURL* curl;
    FILE* file;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        char readbuffer[16384];
        file = fopen("download.txt", "wb");

        curl_easy_setopt(curl, CURLOPT_URL, "ftp://example.com/file.txt");
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, file);
        curl_easy_setopt(curl, CURLOPT_USERPWD, USER ":" PASS);
        curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION, progress_callback);

        res = curl_easy_perform(curl);

        if(res!= CURLE_OK) {
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(res));
        }

        fclose(file);
        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();
    return 0;
}