//Code Llama-13B DATASET v1.0 Category: Socket programming ; Style: complete
// A unique C Socket programming example program
#include <stdio.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#define PORT 8080

int main() {
    int sock, conn;
    char buffer[1024];
    struct sockaddr_in server, client;

    // Creating socket file descriptor
    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Specifying address and port
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = INADDR_ANY;
    server.sin_port = htons(PORT);

    // Binding newly created socket to given address and port
    if (bind(sock, (struct sockaddr *)&server, sizeof(server)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    // Putting socket in listening state
    if (listen(sock, 3) < 0) {
        perror("listen failed");
        exit(EXIT_FAILURE);
    }

    // Accepting incoming connections
    int client_len = sizeof(client);
    conn = accept(sock, (struct sockaddr *)&client, (socklen_t *)&client_len);
    if (conn < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    // Receiving data from client
    int n = read(conn, buffer, 1024);
    if (n < 0) {
        perror("read failed");
        exit(EXIT_FAILURE);
    }
    printf("Client message: %s\n", buffer);

    // Sending data to client
    char *msg = "Hello, client!";
    n = write(conn, msg, strlen(msg));
    if (n < 0) {
        perror("write failed");
        exit(EXIT_FAILURE);
    }

    // Closing connection
    close(conn);
    close(sock);

    return EXIT_SUCCESS;
}