//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

#define DB_NAME "example.db"

// Function to execute a SQL statement
int executeSQL(sqlite3 *db, const char *sql) {
    char *err_msg = 0;
    int rc = sqlite3_exec(db, sql, 0, 0, &err_msg);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
        return rc;
    }
    return SQLITE_OK;
}

// Callback function to display results of SELECT query
static int selectCallback(void *data, int argc, char **argv, char **azColName) {
    printf("%s: ", (const char *)data);
    for (int i = 0; i < argc; i++) {
        printf("%s = %s ", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Function to create a table
void createTable(sqlite3 *db) {
    const char *sql = "CREATE TABLE IF NOT EXISTS Students("
                      "Id INTEGER PRIMARY KEY AUTOINCREMENT,"
                      "Name TEXT NOT NULL,"
                      "Age INTEGER NOT NULL,"
                      "GPA REAL NOT NULL);";
    
    if (executeSQL(db, sql) != SQLITE_OK) {
        printf("Failed to create table\n");
    } else {
        printf("Table created successfully\n");
    }
}

// Function to insert data into the table
void insertData(sqlite3 *db, const char *name, int age, double gpa) {
    char sql[256];
    snprintf(sql, sizeof(sql), "INSERT INTO Students(Name, Age, GPA) VALUES('%s', %d, %.2f);", name, age, gpa);
    
    if (executeSQL(db, sql) != SQLITE_OK) {
        printf("Failed to insert data\n");
    } else {
        printf("Data inserted successfully\n");
    }
}

// Function to select data from the table
void selectData(sqlite3 *db) {
    const char *data = "Callback data";
    const char *sql = "SELECT * FROM Students;";
    
    if (executeSQL(db, sql) == SQLITE_OK) {
        printf("Data retrieved successfully:\n");
        sqlite3_exec(db, sql, selectCallback, (void *)data, NULL);
    } else {
        printf("Failed to retrieve data\n");
    }
}

// Function to close the database
void closeDatabase(sqlite3 *db) {
    sqlite3_close(db);
}

int main() {
    sqlite3 *db;
    int rc;

    rc = sqlite3_open(DB_NAME, &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return rc;
    }

    createTable(db);
    
    insertData(db, "Alice", 20, 3.5);
    insertData(db, "Bob", 22, 3.8);
    insertData(db, "Charlie", 19, 3.2);
    
    selectData(db);
    
    closeDatabase(db);
    return 0;
}