//GEMINI-pro DATASET v1.0 Category: Chess engine ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BOARD_SIZE 8

typedef struct {
    int x;
    int y;
} Position;

typedef struct {
    char type;
    char color;
} Piece;

typedef struct {
    Piece pieces[BOARD_SIZE][BOARD_SIZE];
} Board;

void initBoard(Board *board) {
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            board->pieces[i][j].type = ' ';
            board->pieces[i][j].color = ' ';
        }
    }

    // Set up the pawns
    for (int i = 0; i < BOARD_SIZE; i++) {
        board->pieces[1][i].type = 'P';
        board->pieces[1][i].color = 'w';
        board->pieces[6][i].type = 'P';
        board->pieces[6][i].color = 'b';
    }

    // Set up the rooks
    board->pieces[0][0].type = 'R';
    board->pieces[0][0].color = 'w';
    board->pieces[0][7].type = 'R';
    board->pieces[0][7].color = 'w';
    board->pieces[7][0].type = 'R';
    board->pieces[7][0].color = 'b';
    board->pieces[7][7].type = 'R';
    board->pieces[7][7].color = 'b';

    // Set up the knights
    board->pieces[0][1].type = 'N';
    board->pieces[0][1].color = 'w';
    board->pieces[0][6].type = 'N';
    board->pieces[0][6].color = 'w';
    board->pieces[7][1].type = 'N';
    board->pieces[7][1].color = 'b';
    board->pieces[7][6].type = 'N';
    board->pieces[7][6].color = 'b';

    // Set up the bishops
    board->pieces[0][2].type = 'B';
    board->pieces[0][2].color = 'w';
    board->pieces[0][5].type = 'B';
    board->pieces[0][5].color = 'w';
    board->pieces[7][2].type = 'B';
    board->pieces[7][2].color = 'b';
    board->pieces[7][5].type = 'B';
    board->pieces[7][5].color = 'b';

    // Set up the queen
    board->pieces[0][3].type = 'Q';
    board->pieces[0][3].color = 'w';
    board->pieces[7][3].type = 'Q';
    board->pieces[7][3].color = 'b';

    // Set up the king
    board->pieces[0][4].type = 'K';
    board->pieces[0][4].color = 'w';
    board->pieces[7][4].type = 'K';
    board->pieces[7][4].color = 'b';
}

void printBoard(Board *board) {
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            printf("%c", board->pieces[i][j].type);
        }
        printf("\n");
    }
}

int main() {
    Board board;
    initBoard(&board);
    printBoard(&board);
    return 0;
}