//Falcon2-11B DATASET v1.0 Category: Greedy Algorithms ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>

void min_heapify(int* arr, int i, int n) {
    int l = 2 * i + 1, r = 2 * i + 2;
    int smallest = i;

    if (l < n && arr[l] < arr[smallest]) {
        smallest = l;
    }

    if (r < n && arr[r] < arr[smallest]) {
        smallest = r;
    }

    if (smallest!= i) {
        int tmp = arr[i];
        arr[i] = arr[smallest];
        arr[smallest] = tmp;

        min_heapify(arr, smallest, n);
    }
}

void heap_sort(int* arr, int n) {
    for (int i = n / 2 - 1; i >= 0; i--) {
        min_heapify(arr, i, n);
    }

    for (int i = n - 1; i >= 0; i--) {
        int tmp = arr[0];
        arr[0] = arr[i];
        arr[i] = tmp;

        min_heapify(arr, 0, i);
    }
}

int main() {
    int arr[] = {7, 5, 2, 3, 1, 9};
    int n = sizeof(arr) / sizeof(arr[0]);

    heap_sort(arr, n);

    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }

    return 0;
}