//Code Llama-13B DATASET v1.0 Category: Simple Web Server ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define BUF_SIZE 1024

int main(int argc, char *argv[]) {
    int server_fd, client_fd;
    struct sockaddr_in server_addr, client_addr;
    socklen_t client_len = sizeof(client_addr);
    char buffer[BUF_SIZE];

    // Create a socket
    server_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (server_fd == -1) {
        perror("socket");
        exit(1);
    }

    // Set up address structure
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(8080);
    server_addr.sin_addr.s_addr = INADDR_ANY;

    // Bind the socket to the address
    if (bind(server_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("bind");
        exit(1);
    }

    // Listen on the socket
    if (listen(server_fd, 5) == -1) {
        perror("listen");
        exit(1);
    }

    // Accept a connection
    client_fd = accept(server_fd, (struct sockaddr *)&client_addr, &client_len);
    if (client_fd == -1) {
        perror("accept");
        exit(1);
    }

    // Read data from the client
    int bytes_read = recv(client_fd, buffer, BUF_SIZE, 0);
    if (bytes_read == -1) {
        perror("recv");
        exit(1);
    }

    // Write data to the client
    int bytes_written = send(client_fd, buffer, bytes_read, 0);
    if (bytes_written == -1) {
        perror("send");
        exit(1);
    }

    // Close the socket
    close(client_fd);

    return 0;
}