//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: recursive
// Cafe Billing System in a recursive style

#include <stdio.h>

// Function to calculate the total cost of a customer's order
int calculateCost(int items[], int quantity[], int size) {
    int total = 0;
    for (int i = 0; i < size; i++) {
        total += items[i] * quantity[i];
    }
    return total;
}

// Function to display the order summary
void displayOrderSummary(int items[], int quantity[], int size) {
    printf("Order Summary:\n");
    for (int i = 0; i < size; i++) {
        printf("%s: %d x %d = %d\n", items[i], quantity[i], quantity[i] * items[i]);
    }
}

// Function to calculate the tip
int calculateTip(int total) {
    return total * 0.15;
}

// Function to calculate the total cost of the order, including the tip
int calculateTotal(int total, int tip) {
    return total + tip;
}

// Function to display the final bill
void displayFinalBill(int total, int tip, int totalWithTip) {
    printf("Total: %d\n", total);
    printf("Tip: %d\n", tip);
    printf("Total with tip: %d\n", totalWithTip);
}

int main() {
    int items[] = {1, 2, 3, 4, 5};
    int quantity[] = {2, 3, 4, 5, 6};
    int size = sizeof(items) / sizeof(items[0]);

    int total = calculateCost(items, quantity, size);
    displayOrderSummary(items, quantity, size);

    int tip = calculateTip(total);
    int totalWithTip = calculateTotal(total, tip);

    displayFinalBill(total, tip, totalWithTip);

    return 0;
}