//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>

// Define the structure of a survivor
typedef struct survivor {
    char name[20];
    int age;
    int strength;
    int intelligence;
} survivor;

// Define the comparator function for sorting survivors by strength
int compare_strength(const void *a, const void *b) {
    survivor *survivor_a = (survivor *)a;
    survivor *survivor_b = (survivor *)b;
    return survivor_a->strength - survivor_b->strength;
}

// Define the comparator function for sorting survivors by intelligence
int compare_intelligence(const void *a, const void *b) {
    survivor *survivor_a = (survivor *)a;
    survivor *survivor_b = (survivor *)b;
    return survivor_a->intelligence - survivor_b->intelligence;
}

int main() {
    // Define an array of survivors
    survivor survivors[] = {
        {"John", 25, 8, 6},
        {"Jane", 22, 6, 8},
        {"Mark", 30, 9, 5},
        {"Sarah", 28, 7, 7},
        {"Bob", 26, 8, 6}
    };

    // Get the number of survivors
    int num_survivors = sizeof(survivors) / sizeof(survivors[0]);

    // Sort the survivors by strength
    qsort(survivors, num_survivors, sizeof(survivor), compare_strength);

    // Print the sorted survivors by strength
    printf("Survivors sorted by strength:\n");
    for (int i = 0; i < num_survivors; i++) {
        printf("%s\n", survivors[i].name);
    }

    // Sort the survivors by intelligence
    qsort(survivors, num_survivors, sizeof(survivor), compare_intelligence);

    // Print the sorted survivors by intelligence
    printf("Survivors sorted by intelligence:\n");
    for (int i = 0; i < num_survivors; i++) {
        printf("%s\n", survivors[i].name);
    }

    return 0;
}