//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_CATEGORIES 10
#define MAX_PRODUCT_NAME 50
#define MAX_CATEGORY_NAME 20

typedef struct {
    char name[MAX_PRODUCT_NAME];
    int quantity;
    float price;
    int category;
} Product;

typedef struct {
    char name[MAX_CATEGORY_NAME];
    int num_products;
} Category;

Product products[MAX_PRODUCTS];
Category categories[MAX_CATEGORIES];
int num_products = 0;
int num_categories = 0;

void addProduct(char* name, int quantity, float price, int category) {
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Maximum number of products reached.\n");
        return;
    }
    strcpy(products[num_products].name, name);
    products[num_products].quantity = quantity;
    products[num_products].price = price;
    products[num_products].category = category;
    num_products++;
}

void addCategory(char* name) {
    if (num_categories >= MAX_CATEGORIES) {
        printf("Error: Maximum number of categories reached.\n");
        return;
    }
    strcpy(categories[num_categories].name, name);
    categories[num_categories].num_products = 0;
    num_categories++;
}

void printProductList(int category) {
    int i, j;
    for (i = 0; i < num_products; i++) {
        if (products[i].category == category) {
            printf("%-20s %10d $%.2f\n", products[i].name, products[i].quantity, products[i].price);
        }
    }
}

void printCategoryList() {
    int i;
    for (i = 0; i < num_categories; i++) {
        printf("%-20s %10d\n", categories[i].name, categories[i].num_products);
    }
}

int main() {
    addCategory("Electronics");
    addCategory("Clothing");
    addCategory("Books");

    addProduct("iPhone", 10, 999.99, 0);
    addProduct("Samsung Galaxy", 5, 799.99, 0);
    addProduct("T-Shirt", 20, 19.99, 1);
    addProduct("Harry Potter", 15, 9.99, 2);

    printCategoryList();

    printProductList(0);
    printProductList(1);
    printProductList(2);

    return 0;
}