//Code Llama-13B DATASET v1.0 Category: Music Library Management System ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SONGS 100

typedef struct {
  char title[50];
  char artist[50];
  int duration;
} Song;

void printSong(Song song) {
  printf("%s - %s (%d seconds)\n", song.title, song.artist, song.duration);
}

void addSong(Song* library, int* count, Song song) {
  if (*count >= MAX_SONGS) {
    printf("Library is full, cannot add more songs.\n");
    return;
  }
  library[*count] = song;
  *count += 1;
}

void removeSong(Song* library, int* count, int index) {
  if (index < 0 || index >= *count) {
    printf("Invalid index.\n");
    return;
  }
  for (int i = index; i < *count - 1; i++) {
    library[i] = library[i + 1];
  }
  *count -= 1;
}

void printLibrary(Song* library, int count) {
  printf("Song Library:\n");
  for (int i = 0; i < count; i++) {
    printSong(library[i]);
  }
}

int main() {
  Song library[MAX_SONGS];
  int count = 0;

  // Add songs to the library
  Song song1 = {"Happy", "Lady Gaga", 180};
  Song song2 = {"Bad Guy", "Billie Eilish", 190};
  Song song3 = {"Old Town Road", "Lil Nas X", 180};
  addSong(library, &count, song1);
  addSong(library, &count, song2);
  addSong(library, &count, song3);

  // Print the library
  printLibrary(library, count);

  // Remove a song from the library
  removeSong(library, &count, 0);

  // Print the library again
  printLibrary(library, count);

  return 0;
}