//GEMINI-pro DATASET v1.0 Category: Building a SMTP Client ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
  int sockfd;
  struct sockaddr_in servaddr;

  // Create a socket
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1) {
    perror("socket");
    exit(1);
  }

  // Set up the server address
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons(25);
  if (inet_pton(AF_INET, "127.0.0.1", &servaddr.sin_addr) <= 0) {
    perror("inet_pton");
    exit(1);
  }

  // Connect to the server
  if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
    perror("connect");
    exit(1);
  }

  // Send a HELO command
  char *helo = "HELO example.com\r\n";
  if (send(sockfd, helo, strlen(helo), 0) < 0) {
    perror("send");
    exit(1);
  }

  // Receive the server's response
  char buf[1024];
  int n;
  n = recv(sockfd, buf, sizeof(buf), 0);
  if (n < 0) {
    perror("recv");
    exit(1);
  }
  printf("%s", buf);

  // Send a MAIL FROM command
  char *mail_from = "MAIL FROM: <sender@example.com>\r\n";
  if (send(sockfd, mail_from, strlen(mail_from), 0) < 0) {
    perror("send");
    exit(1);
  }

  // Receive the server's response
  n = recv(sockfd, buf, sizeof(buf), 0);
  if (n < 0) {
    perror("recv");
    exit(1);
  }
  printf("%s", buf);

  // Send a RCPT TO command
  char *rcpt_to = "RCPT TO: <recipient@example.com>\r\n";
  if (send(sockfd, rcpt_to, strlen(rcpt_to), 0) < 0) {
    perror("send");
    exit(1);
  }

  // Receive the server's response
  n = recv(sockfd, buf, sizeof(buf), 0);
  if (n < 0) {
    perror("recv");
    exit(1);
  }
  printf("%s", buf);

  // Send a DATA command
  char *data = "DATA\r\n";
  if (send(sockfd, data, strlen(data), 0) < 0) {
    perror("send");
    exit(1);
  }

  // Receive the server's response
  n = recv(sockfd, buf, sizeof(buf), 0);
  if (n < 0) {
    perror("recv");
    exit(1);
  }
  printf("%s", buf);

  // Send the email body
  char *body = "This is the email body.\r\n";
  if (send(sockfd, body, strlen(body), 0) < 0) {
    perror("send");
    exit(1);
  }

  // Send a period to indicate the end of the email body
  char *period = ".\r\n";
  if (send(sockfd, period, strlen(period), 0) < 0) {
    perror("send");
    exit(1);
  }

  // Receive the server's response
  n = recv(sockfd, buf, sizeof(buf), 0);
  if (n < 0) {
    perror("recv");
    exit(1);
  }
  printf("%s", buf);

  // Send a QUIT command
  char *quit = "QUIT\r\n";
  if (send(sockfd, quit, strlen(quit), 0) < 0) {
    perror("send");
    exit(1);
  }

  // Receive the server's response
  n = recv(sockfd, buf, sizeof(buf), 0);
  if (n < 0) {
    perror("recv");
    exit(1);
  }
  printf("%s", buf);

  // Close the socket
  close(sockfd);

  return 0;
}