//Gemma-7B DATASET v1.0 Category: Breakout Game Clone ; Style: standalone
#include <stdio.h>
#include <stdlib.h>

#define LEFT 0
#define RIGHT 1
#define UP 2
#define DOWN 3

#define GRID_SIZE 5
#define BALL_SIZE 2

int main()
{
    int x_pos = 0;
    int y_pos = 0;
    int direction = RIGHT;

    // Game grid
    char grid[GRID_SIZE][GRID_SIZE] = {{'-', '-', '-', '-', '-'},
                                {'-', 'O', '-', '-', '-'},
                                {'-', '-', 'O', '-', '-'},
                                {'-', '-', '-', 'O', '-'},
                                {'-', '-', '-', '-', '-'}};

    // Ball movement
    char ball[BALL_SIZE][BALL_SIZE] = {{'-', '-'},
                                {'*', '-'}};

    // Game loop
    while (!grid[y_pos][x_pos] && direction != DOWN)
    {
        switch (direction)
        {
            case LEFT:
                x_pos--;
                break;
            case RIGHT:
                x_pos++;
                break;
            case UP:
                y_pos--;
                break;
            case DOWN:
                y_pos++;
                break;
        }

        // Draw the grid
        for (int y = 0; y < GRID_SIZE; y++)
        {
            for (int x = 0; x < GRID_SIZE; x++)
            {
                printf("%c ", grid[y][x]);
            }
            printf("\n");
        }

        // Move the ball
        ball[0][0] = x_pos;
        ball[0][1] = y_pos;

        // Check if the ball has reached the edge of the grid
        if (x_pos < 0 || x_pos >= GRID_SIZE - 1)
        {
            direction = LEFT;
            x_pos++;
        }
        if (y_pos < 0)
        {
            direction = UP;
            y_pos++;
        }
    }

    // Game over
    printf("Game over!");

    return 0;
}