//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define NUM_LIGHTS 5
#define LIGHT_ON 1
#define LIGHT_OFF 0

// Struct to represent a light
typedef struct {
    char name[20];
    int state;
} Light;

// Function to turn a light on
void turnOnLight(Light* light) {
    light->state = LIGHT_ON;
    printf("Turning on %s\n", light->name);
}

// Function to turn a light off
void turnOffLight(Light* light) {
    light->state = LIGHT_OFF;
    printf("Turning off %s\n", light->name);
}

// Function to toggle a light
void toggleLight(Light* light) {
    if (light->state == LIGHT_ON) {
        turnOffLight(light);
    } else {
        turnOnLight(light);
    }
}

// Function to set the state of a light
void setLightState(Light* light, int state) {
    light->state = state;
    if (state == LIGHT_ON) {
        printf("Turning on %s\n", light->name);
    } else {
        printf("Turning off %s\n", light->name);
    }
}

// Function to print the state of all lights
void printLightStates(Light lights[], int numLights) {
    for (int i = 0; i < numLights; i++) {
        printf("%s: %s\n", lights[i].name, lights[i].state == LIGHT_ON? "On" : "Off");
    }
}

// Main function
int main() {
    // Initialize lights
    Light lights[NUM_LIGHTS];
    for (int i = 0; i < NUM_LIGHTS; i++) {
        sprintf(lights[i].name, "Light %d", i + 1);
        lights[i].state = LIGHT_OFF;
    }

    // Example usage
    turnOnLight(&lights[0]);
    toggleLight(&lights[1]);
    setLightState(&lights[2], LIGHT_ON);

    printLightStates(lights, NUM_LIGHTS);

    return 0;
}