//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of items in the warehouse
#define MAX_ITEMS 100

// Define the structure of an item in the warehouse
typedef struct item {
    char name[50];
    int quantity;
    float price;
} item;

// Declare the array of items in the warehouse
item warehouse[MAX_ITEMS];

// Declare the number of items in the warehouse
int num_items = 0;

// Function to add an item to the warehouse
void add_item(char *name, int quantity, float price) {
    // Check if the warehouse is full
    if (num_items == MAX_ITEMS) {
        printf("Error: Warehouse is full.\n");
        return;
    }

    // Add the item to the warehouse
    strcpy(warehouse[num_items].name, name);
    warehouse[num_items].quantity = quantity;
    warehouse[num_items].price = price;

    // Increment the number of items in the warehouse
    num_items++;
}

// Function to remove an item from the warehouse
void remove_item(char *name) {
    // Find the item in the warehouse
    int i;
    for (i = 0; i < num_items; i++) {
        if (strcmp(warehouse[i].name, name) == 0) {
            break;
        }
    }

    // Check if the item was found
    if (i == num_items) {
        printf("Error: Item not found.\n");
        return;
    }

    // Remove the item from the warehouse
    for (; i < num_items - 1; i++) {
        warehouse[i] = warehouse[i + 1];
    }

    // Decrement the number of items in the warehouse
    num_items--;
}

// Function to print the items in the warehouse
void print_items() {
    // Print the header
    printf("Items in the warehouse:\n");
    printf("-----------------------------\n");
    printf("Name\tQuantity\tPrice\n");

    // Print the items
    int i;
    for (i = 0; i < num_items; i++) {
        printf("%s\t%d\t%.2f\n", warehouse[i].name, warehouse[i].quantity, warehouse[i].price);
    }
}

// Function to get the total value of the items in the warehouse
float get_total_value() {
    // Calculate the total value
    float total_value = 0;
    int i;
    for (i = 0; i < num_items; i++) {
        total_value += warehouse[i].quantity * warehouse[i].price;
    }

    // Return the total value
    return total_value;
}

// Function to main
int main() {
    // Add some items to the warehouse
    add_item("Apple", 10, 1.0);
    add_item("Banana", 20, 2.0);
    add_item("Orange", 30, 3.0);

    // Print the items in the warehouse
    print_items();

    // Get the total value of the items in the warehouse
    float total_value = get_total_value();
    printf("Total value of the items in the warehouse: %.2f\n", total_value);

    // Remove an item from the warehouse
    remove_item("Apple");

    // Print the items in the warehouse
    print_items();

    // Get the total value of the items in the warehouse
    total_value = get_total_value();
    printf("Total value of the items in the warehouse: %.2f\n", total_value);

    return 0;
}