//Falcon-180B DATASET v1.0 Category: Memory Game ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 10
#define NUM_CARDS (SIZE * SIZE)

int cards[NUM_CARDS];
int num_cards = 0;
int num_matches = 0;

void init_cards() {
    for (int i = 0; i < NUM_CARDS; i++) {
        cards[i] = i + 1;
    }
}

void shuffle_cards() {
    srand(time(NULL));
    for (int i = 0; i < NUM_CARDS; i++) {
        int j = rand() % NUM_CARDS;
        int temp = cards[i];
        cards[i] = cards[j];
        cards[j] = temp;
    }
}

void print_cards() {
    for (int i = 0; i < NUM_CARDS; i++) {
        printf("%d ", cards[i]);
    }
    printf("\n");
}

int main() {
    init_cards();
    shuffle_cards();
    print_cards();

    int x, y, choice;
    while (num_cards > 0) {
        printf("Enter two numbers (x and y) to flip cards: ");
        scanf("%d %d", &x, &y);

        if (x < 1 || x > SIZE || y < 1 || y > SIZE) {
            printf("Invalid input!\n");
            continue;
        }

        int card1 = cards[(y-1)*SIZE + x-1];
        int card2 = cards[(y-1)*SIZE + x-1 + SIZE];

        if (card1 == card2) {
            num_matches++;
        } else {
            printf("Not a match!\n");
        }

        cards[(y-1)*SIZE + x-1] = -1;
        cards[(y-1)*SIZE + x-1 + SIZE] = -1;
        num_cards--;
    }

    printf("You have %d matches out of %d cards.\n", num_matches, NUM_CARDS);

    return 0;
}