//GEMINI-pro DATASET v1.0 Category: File handling ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
  char *name;
  int age;
  char *address;
} Person;

int main() {
  // Create a file
  FILE *fp = fopen("people.txt", "w");
  if (fp == NULL) {
    perror("Error opening file");
    return EXIT_FAILURE;
  }

  // Write some data to the file
  Person p1 = {"John Doe", 30, "123 Main Street"};
  Person p2 = {"Jane Doe", 25, "456 Elm Street"};
  fwrite(&p1, sizeof(Person), 1, fp);
  fwrite(&p2, sizeof(Person), 1, fp);

  // Close the file
  fclose(fp);

  // Reopen the file for reading
  fp = fopen("people.txt", "r");
  if (fp == NULL) {
    perror("Error opening file");
    return EXIT_FAILURE;
  }

  // Read the data from the file
  Person p[2];
  fread(&p[0], sizeof(Person), 1, fp);
  fread(&p[1], sizeof(Person), 1, fp);

  // Print the data
  for (int i = 0; i < 2; i++) {
    printf("Name: %s\n", p[i].name);
    printf("Age: %d\n", p[i].age);
    printf("Address: %s\n\n", p[i].address);
  }

  // Close the file
  fclose(fp);

  return EXIT_SUCCESS;
}