//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESS_NUM 10

typedef struct Process {
    int id;
    char name[20];
    int cpu_burst_time;
    int waiting_time;
    int turn_around_time;
} Process;

void calculate_waiting_time(Process *process) {
    process->waiting_time = process->cpu_burst_time - 1;
}

void calculate_turn_around_time(Process *process) {
    process->turn_around_time = process->waiting_time + process->cpu_burst_time;
}

void simulate_cpu_scheduling(Process *processes) {
    int quantum_time = 0;
    int current_process = 0;

    for (int i = 0; i < MAX_PROCESS_NUM; i++) {
        processes[i].waiting_time = processes[i].cpu_burst_time - 1;
    }

    while (processes[current_process].waiting_time > 0) {
        quantum_time++;
        processes[current_process].waiting_time--;
        printf("Process %d is running for quantum time %d\n", processes[current_process].id, quantum_time);
    }

    for (int i = 0; i < MAX_PROCESS_NUM; i++) {
        calculate_turn_around_time(&processes[i]);
    }

    printf("Process Statistics:\n");
    for (int i = 0; i < MAX_PROCESS_NUM; i++) {
        printf("Process %d:\n", processes[i].id);
        printf("  Name: %s\n", processes[i].name);
        printf("  CPU Burst Time: %d\n", processes[i].cpu_burst_time);
        printf("  Waiting Time: %d\n", processes[i].waiting_time);
        printf("  Turnaround Time: %d\n", processes[i].turn_around_time);
        printf("\n");
    }
}

int main() {
    Process processes[MAX_PROCESS_NUM];

    for (int i = 0; i < MAX_PROCESS_NUM; i++) {
        processes[i].id = i + 1;
        processes[i].name[0] = 'A' + i;
        processes[i].cpu_burst_time = rand() % 10 + 1;
    }

    simulate_cpu_scheduling(processes);

    return 0;
}