//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

// Define the maximum number of devices that can be controlled
#define MAX_DEVICES 10

// Define the different types of devices that can be controlled
typedef enum {
    DEVICE_TYPE_LIGHT,
    DEVICE_TYPE_FAN,
    DEVICE_TYPE_THERMOSTAT
} device_type_t;

// Define the structure of a device
typedef struct {
    char *name;
    device_type_t type;
    bool state;
} device_t;

// Create an array of devices
device_t devices[MAX_DEVICES];

// Initialize the devices
void init_devices() {
    // Add a light device
    devices[0].name = "Light 1";
    devices[0].type = DEVICE_TYPE_LIGHT;
    devices[0].state = false;

    // Add a fan device
    devices[1].name = "Fan 1";
    devices[1].type = DEVICE_TYPE_FAN;
    devices[1].state = false;

    // Add a thermostat device
    devices[2].name = "Thermostat 1";
    devices[2].type = DEVICE_TYPE_THERMOSTAT;
    devices[2].state = false;
}

// Print the status of all devices
void print_devices() {
    for (int i = 0; i < MAX_DEVICES; i++) {
        printf("%s: ", devices[i].name);
        switch (devices[i].type) {
            case DEVICE_TYPE_LIGHT:
                printf("Light");
                break;
            case DEVICE_TYPE_FAN:
                printf("Fan");
                break;
            case DEVICE_TYPE_THERMOSTAT:
                printf("Thermostat");
                break;
        }
        printf(" is ");
        if (devices[i].state) {
            printf("on\n");
        } else {
            printf("off\n");
        }
    }
}

// Turn on a device
void turn_on(char *name) {
    for (int i = 0; i < MAX_DEVICES; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = true;
            break;
        }
    }
}

// Turn off a device
void turn_off(char *name) {
    for (int i = 0; i < MAX_DEVICES; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = false;
            break;
        }
    }
}

// Main function
int main() {
    // Initialize the devices
    init_devices();

    // Print the status of all devices
    print_devices();

    // Turn on the light
    turn_on("Light 1");

    // Turn off the fan
    turn_off("Fan 1");

    // Print the status of all devices
    print_devices();

    return 0;
}