//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>

// Our trusty socket
int sockfd;

// The address we're connecting to
struct sockaddr_in servaddr;

// The message we're sending
char *message = "Hello from the client!";

// The response we'll receive
char response[1024];

int main() {
  // Create a socket
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1) {
    perror("socket");
    exit(EXIT_FAILURE);
  }

  // Set up the server address
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons(8080);
  if (inet_pton(AF_INET, "127.0.0.1", &servaddr.sin_addr) <= 0) {
    perror("inet_pton");
    exit(EXIT_FAILURE);
  }

  // Connect to the server
  if (connect(sockfd, (struct sockaddr *) &servaddr, sizeof(servaddr)) < 0) {
    perror("connect");
    exit(EXIT_FAILURE);
  }

  // Send the message
  if (send(sockfd, message, strlen(message), 0) < 0) {
    perror("send");
    exit(EXIT_FAILURE);
  }

  // Receive the response
  if (recv(sockfd, response, sizeof(response), 0) < 0) {
    perror("recv");
    exit(EXIT_FAILURE);
  }

  // Print the response
  printf("Response: %s\n", response);

  // Close the socket
  close(sockfd);

  return 0;
}