//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define RED 1
#define YELLOW 2
#define GREEN 3
#define PEDESTRIAN_RED 4
#define PEDESTRIAN_GREEN 5

void traffic_light_controller(int *current_light, int *pedestrian_light, int duration) {
    // Set initial lights
    *current_light = RED;
    *pedestrian_light = PEDESTRIAN_RED;

    // Loop until duration has elapsed
    while (duration-- > 0) {
        // Change lights
        switch (*current_light) {
            case RED:
                *current_light = GREEN;
                *pedestrian_light = PEDESTRIAN_RED;
                break;
            case YELLOW:
                *current_light = RED;
                *pedestrian_light = PEDESTRIAN_GREEN;
                break;
            case GREEN:
                *current_light = YELLOW;
                *pedestrian_light = PEDESTRIAN_RED;
                break;
            case PEDESTRIAN_RED:
                *pedestrian_light = PEDESTRIAN_GREEN;
                break;
            case PEDESTRIAN_GREEN:
                *pedestrian_light = PEDESTRIAN_RED;
                break;
        }

        // Print current lights
        printf("Current light: ");
        switch (*current_light) {
            case RED:
                printf("red\n");
                break;
            case YELLOW:
                printf("yellow\n");
                break;
            case GREEN:
                printf("green\n");
                break;
            default:
                printf("unknown\n");
        }

        printf("Pedestrian light: ");
        switch (*pedestrian_light) {
            case RED:
                printf("red\n");
                break;
            case YELLOW:
                printf("yellow\n");
                break;
            case GREEN:
                printf("green\n");
                break;
            default:
                printf("unknown\n");
        }

        // Delay for 1 second
        sleep(1);
    }
}

int main() {
    int duration = 60; // 60 seconds
    int current_light = RED;
    int pedestrian_light = PEDESTRIAN_RED;

    srand(time(NULL));

    // Randomize duration
    duration += rand() % 30;

    printf("Traffic light controller starting...\n");
    traffic_light_controller(&current_light, &pedestrian_light, duration);

    return 0;
}