//Falcon-180B DATASET v1.0 Category: System boot optimizer ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 100
#define MAX_PROCESS_NAME_LENGTH 20

typedef struct process {
    char name[MAX_PROCESS_NAME_LENGTH];
    int priority;
    int state;
} Process;

void addProcess(Process* processes, int numProcesses, char* name, int priority) {
    if (numProcesses >= MAX_PROCESSES) {
        printf("Error: Maximum number of processes reached.\n");
        return;
    }

    strncpy(processes[numProcesses].name, name, MAX_PROCESS_NAME_LENGTH);
    processes[numProcesses].priority = priority;
    processes[numProcesses].state = 0;
    numProcesses++;
}

void removeProcess(Process* processes, int numProcesses, char* name) {
    int i;
    for (i = 0; i < numProcesses; i++) {
        if (strcmp(processes[i].name, name) == 0) {
            processes[i] = processes[numProcesses - 1];
            numProcesses--;
            break;
        }
    }
}

void printProcesses(Process* processes, int numProcesses) {
    int i;
    for (i = 0; i < numProcesses; i++) {
        printf("%s (%d)\n", processes[i].name, processes[i].priority);
    }
}

int main() {
    Process processes[MAX_PROCESSES];
    int numProcesses = 0;

    addProcess(processes, numProcesses, "Process A", 5);
    addProcess(processes, numProcesses, "Process B", 3);
    addProcess(processes, numProcesses, "Process C", 7);

    printf("Initial processes:\n");
    printProcesses(processes, numProcesses);

    removeProcess(processes, numProcesses, "Process B");

    printf("\nAfter removing Process B:\n");
    printProcesses(processes, numProcesses);

    return 0;
}