//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_CUSTOMERS 100
#define MAX_ORDERS 1000

typedef struct {
    char name[50];
    int id;
} Customer;

typedef struct {
    char name[50];
    float price;
} Item;

typedef struct {
    int customerId;
    int orderId;
    Item item;
    float quantity;
} Order;

Customer customers[MAX_CUSTOMERS];
Item items[MAX_ITEMS];
Order orders[MAX_ORDERS];

int numCustomers = 0;
int numItems = 0;
int numOrders = 0;

void addCustomer(char* name, int id) {
    strcpy(customers[numCustomers].name, name);
    customers[numCustomers].id = id;
    numCustomers++;
}

void addItem(char* name, float price) {
    strcpy(items[numItems].name, name);
    items[numItems].price = price;
    numItems++;
}

void placeOrder(int customerId, int orderId, Item item, float quantity) {
    orders[numOrders].customerId = customerId;
    orders[numOrders].orderId = orderId;
    orders[numOrders].item = item;
    orders[numOrders].quantity = quantity;
    numOrders++;
}

void printOrder(Order order) {
    printf("Customer ID: %d\n", order.customerId);
    printf("Order ID: %d\n", order.orderId);
    printf("Item: %s\n", order.item.name);
    printf("Quantity: %f\n", order.quantity);
    printf("Price: $%.2f\n\n", order.item.price * order.quantity);
}

void printOrders() {
    for (int i = 0; i < numOrders; i++) {
        printOrder(orders[i]);
    }
}

int main() {
    // Add customers
    addCustomer("Alice", 1);
    addCustomer("Bob", 2);

    // Add items
    addItem("Coffee", 2.50);
    addItem("Tea", 1.75);

    // Place orders
    placeOrder(1, 1, (Item){"Coffee", 2.50}, 2);
    placeOrder(2, 2, (Item){"Tea", 1.75}, 1);

    // Print orders
    printOrders();

    return 0;
}