//Gemma-7B DATASET v1.0 Category: Pong Game with AI Opponent ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PADDLE_SIZE 10
#define BALL_SIZE 10

typedef struct Paddle {
  int x;
  int y;
  int dx;
  int dy;
} Paddle;

typedef struct Ball {
  int x;
  int y;
  int dx;
  int dy;
} Ball;

Paddle p1;
Paddle p2;
Ball ball;

void initialize() {
  p1.x = 0;
  p1.y = MAX_PADDLE_SIZE - 1;
  p1.dx = 0;
  p1.dy = -1;

  p2.x = MAX_PADDLE_SIZE - 1;
  p2.y = 0;
  p2.dx = 0;
  p2.dy = 1;

  ball.x = MAX_PADDLE_SIZE / 2;
  ball.y = MAX_PADDLE_SIZE / 2;
  ball.dx = 1;
  ball.dy = 1;
}

void move_paddle(Paddle *paddle) {
  int key = getchar();

  switch (key) {
    case 'w':
      paddle->y--;
      break;
    case 's':
      paddle->y++;
      break;
  }
}

void move_ball() {
  ball.x += ball.dx;
  ball.y += ball.dy;

  if (ball.x >= p2.x || ball.x <= p1.x) {
    ball.dx *= -1;
  }

  if (ball.y >= p2.y || ball.y <= p1.y) {
    ball.dy *= -1;
  }
}

int main() {
  initialize();

  while (1) {
    move_paddle(&p1);
    move_paddle(&p2);
    move_ball();

    if (ball.x >= MAX_PADDLE_SIZE || ball.x <= 0) {
      printf("Game Over!\n");
      break;
    }
  }

  return 0;
}