//Falcon-180B DATASET v1.0 Category: Browser Plugin ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PLUGINS 10
#define MAX_PLUGIN_NAME_LEN 50
#define MAX_PLUGIN_CODE_LEN 1024

typedef struct {
    char name[MAX_PLUGIN_NAME_LEN];
    char code[MAX_PLUGIN_CODE_LEN];
} Plugin;

int num_plugins = 0;
Plugin plugins[MAX_PLUGINS];

void add_plugin(char* name, char* code) {
    if (num_plugins >= MAX_PLUGINS) {
        printf("Error: Maximum number of plugins reached.\n");
        return;
    }
    strcpy(plugins[num_plugins].name, name);
    strcpy(plugins[num_plugins].code, code);
    num_plugins++;
}

void remove_plugin(char* name) {
    int i;
    for (i = 0; i < num_plugins; i++) {
        if (strcmp(plugins[i].name, name) == 0) {
            memmove(&plugins[i], &plugins[i+1], (num_plugins - i - 1) * sizeof(Plugin));
            num_plugins--;
            break;
        }
    }
}

void list_plugins() {
    int i;
    for (i = 0; i < num_plugins; i++) {
        printf("%s\n", plugins[i].name);
    }
}

void execute_plugin(char* name) {
    int i;
    for (i = 0; i < num_plugins; i++) {
        if (strcmp(plugins[i].name, name) == 0) {
            printf("Executing %s...\n", name);
            system(plugins[i].code);
            break;
        }
    }
}

int main() {
    add_plugin("Hello World", "echo 'Hello World!'");
    list_plugins();
    execute_plugin("Hello World");
    remove_plugin("Hello World");
    list_plugins();
    return 0;
}