//Gemma-7B DATASET v1.0 Category: Networking ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

int main()
{
    int sockfd, newsockfd, portnum = 8888, bytesRead;
    struct sockaddr_in server_addr, client_addr;
    char buffer[1024];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(portnum));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to a port
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(portnum);
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for clients
    listen(sockfd, 5);

    // Accept a client connection
    newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, NULL);
    if (newsockfd < 0)
    {
        perror("Error accepting client connection");
        exit(1);
    }

    // Read data from the client
    bytesRead = read(newsockfd, buffer, 1024);
    if (bytesRead < 0)
    {
        perror("Error reading data");
        exit(1);
    }

    // Write data to the client
    write(newsockfd, buffer, bytesRead);

    // Close the client connection
    close(newsockfd);

    return 0;
}