//Gemma-7B DATASET v1.0 Category: Banking Record System ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CUSTOMERS 10

typedef struct Customer {
    char name[20];
    int account_number;
    double balance;
} Customer;

Customer customers[MAX_CUSTOMERS];

void create_customer(char *name, int account_number, double balance) {
    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        if (customers[i].account_number == 0) {
            strcpy(customers[i].name, name);
            customers[i].account_number = account_number;
            customers[i].balance = balance;
            return;
        }
    }

    printf("Error: Maximum number of customers reached.\n");
}

void deposit(int account_number, double amount) {
    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        if (customers[i].account_number == account_number) {
            customers[i].balance += amount;
            printf("Deposit successful.\n");
            return;
        }
    }

    printf("Error: Customer not found.\n");
}

void withdraw(int account_number, double amount) {
    for (int i = 0; i < MAX_CUSTOMERS; i++) {
        if (customers[i].account_number == account_number) {
            if (amount <= customers[i].balance) {
                customers[i].balance -= amount;
                printf("Withdrawal successful.\n");
                return;
            } else {
                printf("Insufficient funds.\n");
            }
        }
    }

    printf("Error: Customer not found.\n");
}

int main() {
    create_customer("John Doe", 1234, 1000.0);
    create_customer("Jane Doe", 5678, 2000.0);

    deposit(1234, 500.0);
    withdraw(5678, 200.0);

    printf("Customer name: %s, Account number: %d, Balance: %.2lf\n", customers[0].name, customers[0].account_number, customers[0].balance);
    printf("Customer name: %s, Account number: %d, Balance: %.2lf\n", customers[1].name, customers[1].account_number, customers[1].balance);

    return 0;
}