//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SYMBOLS 100
#define MAX_HISTORY 1000

typedef struct {
    char symbol[10];
    double price;
    int history_index;
} Symbol;

Symbol symbols[MAX_SYMBOLS];
double history[MAX_HISTORY];
int num_symbols = 0;
int history_index = 0;

void add_symbol(char* symbol) {
    if (num_symbols >= MAX_SYMBOLS) {
        printf("Error: Maximum number of symbols reached.\n");
        return;
    }

    strcpy(symbols[num_symbols].symbol, symbol);
    symbols[num_symbols].price = 0.0;
    symbols[num_symbols].history_index = history_index;

    num_symbols++;
}

void update_price(char* symbol, double price) {
    int i;
    for (i = 0; i < num_symbols; i++) {
        if (strcmp(symbols[i].symbol, symbol) == 0) {
            symbols[i].price = price;
            break;
        }
    }
}

void add_history(double price) {
    if (history_index >= MAX_HISTORY) {
        history_index = 0;
    }

    history[history_index++] = price;
}

void print_history() {
    int i;
    for (i = 0; i < history_index; i++) {
        printf("%lf ", history[i]);
    }
    printf("\n");
}

int main() {
    add_symbol("AAPL");
    add_symbol("GOOG");
    add_symbol("MSFT");

    update_price("AAPL", 100.0);
    update_price("GOOG", 200.0);
    update_price("MSFT", 300.0);

    add_history(100.0);
    add_history(200.0);
    add_history(300.0);

    print_history();

    return 0;
}