//LLAMA2-13B DATASET v1.0 Category: Password management ; Style: configurable
#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <stdlib.h>

// Define the maximum number of passwords to store
#define MAX_PASSWORDS 10

// Define the password file name
#define PASSWORD_FILE "my_passwords.dat"

// Define the password struct
typedef struct {
    char *username;
    char *password;
} password_t;

// Define the password array
password_t passwords[MAX_PASSWORDS];

// Define the current password index
int curr_password_idx = 0;

// Define the password file pointer
FILE *password_file = NULL;

// Function to open the password file
void open_password_file() {
    password_file = fopen(PASSWORD_FILE, "wb");
    if (password_file == NULL) {
        perror("Error opening password file");
        exit(1);
    }
}

// Function to close the password file
void close_password_file() {
    if (password_file != NULL) {
        fclose(password_file);
        password_file = NULL;
    }
}

// Function to read a password from the file
password_t *read_password_from_file(void) {
    int i = 0;
    password_t *password = NULL;

    // Read the password file line by line
    while ((i < MAX_PASSWORDS) && (password == NULL)) {
        char line[1024];
        if (fgets(line, 1024, password_file) != NULL) {
            // Check if the line is a password entry
            if (sscanf(line, "%[^:]:%[^\n]", password->username, password->password) == 2) {
                // Found a password entry, return it
                return password;
            }
        }
        i++;
    }

    // If no password entry was found, return NULL
    return NULL;
}

// Function to write a password to the file
void write_password_to_file(password_t *password) {
    char line[1024];

    // Format the password entry as a line in the file
    sprintf(line, "%s:%s\n", password->username, password->password);

    // Write the line to the password file
    fputs(line, password_file);
}

// Function to retrieve a password from the file
password_t *retrieve_password(const char *username) {
    int i = 0;
    password_t *password = NULL;

    // Loop through the password array
    while ((i < MAX_PASSWORDS) && (password == NULL)) {
        if (strcmp(passwords[i].username, username) == 0) {
            // Found a matching password entry, return it
            return &passwords[i];
        }
        i++;
    }

    // If no matching password entry was found, return NULL
    return NULL;
}

int main(void) {
    // Open the password file
    open_password_file();

    // Add some test passwords
    passwords[0].username = "user1";
    passwords[0].password = "password1";
    passwords[1].username = "user2";
    passwords[1].password = "password2";

    // Write the passwords to the file
    write_password_to_file(&passwords[0]);
    write_password_to_file(&passwords[1]);

    // Close the password file
    close_password_file();

    // Retrieves a password from the file
    password_t *password = retrieve_password("user1");

    // Print the retrieved password
    printf("Retrieved password for user1: %s\n", password->password);

    return 0;
}