//GEMINI-pro DATASET v1.0 Category: Dice Roller ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the number of sides for each die
#define D4_SIDES 4
#define D6_SIDES 6
#define D8_SIDES 8
#define D10_SIDES 10
#define D12_SIDES 12
#define D20_SIDES 20

// Define the types of dice
typedef enum {
  D4,
  D6,
  D8,
  D10,
  D12,
  D20
} DiceType;

// Structure to represent a die
typedef struct {
  DiceType type;
  int sides;
  int value;
} Die;

// Function to roll a die
int roll_die(Die *die) {
  // Get a random number between 1 and the number of sides
  die->value = rand() % die->sides + 1;

  // Return the value of the die
  return die->value;
}

// Function to roll a set of dice
int roll_dice(Die *dice, int num_dice) {
  // Initialize the total value to 0
  int total = 0;

  // Roll each die and add the value to the total
  for (int i = 0; i < num_dice; i++) {
    total += roll_die(&dice[i]);
  }

  // Return the total value of the dice
  return total;
}

// Function to print the results of a dice roll
void print_dice_roll(Die *dice, int num_dice) {
  // Print the type and value of each die
  for (int i = 0; i < num_dice; i++) {
    printf("Die %d: %s (%d)\n", i + 1, dice[i].type == D4 ? "D4" : dice[i].type == D6 ? "D6" : dice[i].type == D8 ? "D8" : dice[i].type == D10 ? "D10" : dice[i].type == D12 ? "D12" : "D20", dice[i].value);
  }

  // Print the total value of the dice
  printf("Total: %d\n", roll_dice(dice, num_dice));
}

// Main function
int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Create an array of dice
  Die dice[3];

  // Set the type and number of sides for each die
  dice[0].type = D6;
  dice[0].sides = D6_SIDES;
  dice[1].type = D8;
  dice[1].sides = D8_SIDES;
  dice[2].type = D20;
  dice[2].sides = D20_SIDES;

  // Roll the dice and print the results
  print_dice_roll(dice, 3);

  return 0;
}