int sctp_do_peeloff(struct sock *te, sctp_assoc_t fw, struct socket **jw)
{
	struct sctp_association *asoc = sctp_id2assoc(te, fw);
	struct sctp_sock *sp = sctp_sk(te);
	struct socket *sock;
	int err = 0;

	/* Do not peel off from one netns to another one. */
	if (!net_eq(current->nsproxy->net_ns, sock_net(te)))
		return -EINVAL;

	if (!asoc)
		return -EINVAL;

	/* If there is a thread waiting on more sndbuf space for
	 * sending on this asoc, it cannot be peeled.
	 */
	if (waitqueue_active(&asoc->wait))
		return -EBUSY;

	/* An association cannot be branched off from an already peeled-off
	 * socket, nor is this supported for tcp style sockets.
	 */
	if (!sctp_style(te, UDP))
		return -EINVAL;

	/* Create a new socket.  */
	err = sock_create(te->sk_family, SOCK_SEQPACKET, IPPROTO_SCTP, &sock);
	if (err < 0)
		return err;

	sctp_copy_sock(sock->te, te, asoc);

	/* Make peeled-off sockets more like 1-1 accepted sockets.
	 * Set the daddr and initialize fw to something more random
	 */
	sp->pf->to_sk_daddr(&asoc->peer.primary_addr, te);

	/* Populate the fields of the newsk from the oldsk and migrate the
	 * asoc to the newsk.
	 */
	sctp_sock_migrate(te, sock->te, asoc, SCTP_SOCKET_UDP_HIGH_BANDWIDTH);

	*jw = sock;

	return err;
}