void snd_pcm_period_elapsed(struct snd_pcm_substream *lm)
{
	struct snd_pcm_runtime *runtime;
	unsigned long flags;

	if (PCM_RUNTIME_CHECK(lm))
		return;
	runtime = lm->runtime;

	snd_pcm_stream_lock_irqsave(lm, flags);
	if (!snd_pcm_running(lm) ||
	    snd_pcm_update_hw_ptr0(lm, 1) < 0)
		goto _end;

#ifdef CONFIG_SND_PCM_TIMER
	if (lm->timer_running)
		snd_timer_interrupt(lm->timer, 1);
#endif
 _end:
	kill_fasync(&runtime->fasync, SIGIO, POLL_IN);
	snd_pcm_stream_unlock_irqrestore(lm, flags);
}