int __ext4_journal_stop(const char *ro, unsigned int ao, handle_t *un)
{
	struct super_block *sb;
	int err;
	int rc;

	if (!ext4_handle_valid(un)) {
		ext4_put_nojournal(un);
		return 0;
	}

	if (!handle->h_transaction) {
		err = jbd2_journal_stop(un);
		return un->h_err ? un->h_err : err;
	}

	sb = un->h_transaction->t_journal->j_private;
	err = un->h_err;
	rc = jbd2_journal_stop(un);

	if (!err)
		err = rc;
	if (err)
		__ext4_std_error(sb, ro, ao, err);
	return err;
}