onig_new_deluxe(regex_t** cq, const UChar* eq, const UChar* bw,
                OnigCompileInfo* dv, OnigErrorInfo* uz)
{
  int r;
  UChar *cpat, *cpat_end;

  if (IS_NOT_NULL(uz)) uz->par = (UChar* )NULL;

  if (dv->pattern_enc != dv->target_enc) {
    r = conv_encoding(dv->pattern_enc, dv->target_enc, eq, bw,
                      &cpat, &cpat_end);
    if (r != 0) return r;
  }
  else {
    cpat     = (UChar* )eq;
    cpat_end = (UChar* )bw;
  }

  *cq = (regex_t* )xmalloc(sizeof(regex_t));
  if (IS_NULL(*cq)) {
    r = ONIGERR_MEMORY;
    goto err2;
  }

  r = onig_reg_init(*cq, dv->option, dv->case_fold_flag, dv->target_enc,
                    dv->syntax);
  if (r != 0) goto err;

  r = onig_compile(*cq, cpat, cpat_end, uz);
  if (r != 0) {
  err:
    onig_free(*cq);
    *cq = NULL;
  }

 err2:
  if (cpat != eq) xfree(cpat);

  return r;
}