import{s as It,n as Gt,o as Et}from"../chunks/scheduler.8c3d61f6.js";import{S as Lt,i as Qt,g as l,s as i,r as H,A as Pt,h as s,f as o,c as a,j as Wt,u as F,x as r,k as Rt,y as St,a as n,v as A,d as W,t as R,w as I}from"../chunks/index.da70eac4.js";import{C as wt}from"../chunks/CodeBlock.00a903b3.js";import{H as bt,E as Xt}from"../chunks/EditOnGithub.1e64e623.js";function Dt(Mt){let c,L,G,Q,d,P,m,_t='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch. It provides high-performance dtypes, optimization techniques, and kernels for inference and training, featuring composability with native PyTorch features like <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a>, FullyShardedDataParallel (FSDP), and more.',S,u,gt="Before you begin, make sure you have Pytorch 2.5+ and TorchAO installed.",X,p,D,h,Tt='Quantize a model by passing <a href="/docs/diffusers/pr_10009/en/api/quantization#diffusers.TorchAoConfig">TorchAoConfig</a> to <a href="/docs/diffusers/pr_10009/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> (you can also load pre-quantized models). This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',Y,f,vt="The example below only quantizes the weights to int8.",V,y,N,w,xt='TorchAO is fully compatible with <a href="./optimization/torch2.0#torchcompile">torch.compile</a>, setting it apart from other quantization methods. This makes it easy to speed up inference with just one line of code.',O,b,K,M,qt='For speed and memory benchmarks on Flux and CogVideoX, please refer to the table <a href="https://github.com/huggingface/diffusers/pull/10009#issue-2688781450" rel="nofollow">here</a>. You can also find some torchao <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">benchmarks</a> numbers for various hardware.',tt,_,Ct='torchao also supports an automatic quantization API through <a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md#autoquantization" rel="nofollow">autoquant</a>. Autoquantization determines the best quantization strategy applicable to a model by comparing the performance of each technique on chosen input types and shapes. Currently, this can be used directly on the underlying modeling components. Diffusers will also expose an autoquant configuration option in the future.',et,g,Ut="The <code>TorchAoConfig</code> class accepts three parameters:",ot,T,jt='<li><code>quant_type</code>: A string value mentioning one of the quantization types below.</li> <li><code>modules_to_not_convert</code>: A list of module full/partial module names for which quantization should not be performed. For example, to not perform any quantization of the <a href="/docs/diffusers/pr_10009/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>’s first block, one would specify: <code>modules_to_not_convert=[&quot;single_transformer_blocks.0&quot;]</code>.</li> <li><code>kwargs</code>: A dict of keyword arguments to pass to the underlying quantization method which will be invoked based on <code>quant_type</code>.</li>',nt,v,it,x,Jt="torchao supports weight-only quantization and weight and dynamic-activation quantization for int8, float3-float8, and uint1-uint7.",at,q,zt="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",lt,C,$t="Dynamic activation quantization stores the model weights in a low-bit dtype, while also quantizing the activations on-the-fly to save additional memory. This lowers the memory requirements from model weights, while also lowering the memory overhead from activation computations. However, this may come at a quality tradeoff at times, so it is recommended to test different models thoroughly.",st,U,Zt="The quantization methods supported are as follows:",rt,j,kt="<li><p><strong>Integer quantization:</strong></p> <ul><li>Full function names: <code>int4_weight_only</code>, <code>int8_dynamic_activation_int4_weight</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code></li> <li>Shorthands: <code>int4wo</code>, <code>int4dq</code>, <code>int8wo</code>, <code>int8dq</code></li> <li>Documentation shorthands/Common speak: <code>int_a16w4</code>, <code>int_a8w4</code>, <code>int_a16w8</code>, <code>int_a8w8</code></li></ul></li> <li><p><strong>Floating point 8-bit quantization:</strong></p> <ul><li>Full function names: <code>float8_weight_only</code>, <code>float8_dynamic_activation_float8_weight</code>, <code>float8_static_activation_float8_weight</code></li> <li>Shorthands: <code>float8wo</code>, <code>float8wo_e5m2</code>, <code>float8wo_e4m3</code>, <code>float8dq</code>, <code>float8dq_e4m3</code>, <code>float8_e4m3_tensor</code>, <code>float8_e4m3_row</code>, <code>float8sq</code></li> <li>Documentation shorthands/Common speak: <code>float8_e5m2_a16w8</code>, <code>float8_e4m3_a16w8</code>, <code>float_a8w8</code>, <code>float_a16w8</code></li></ul></li> <li><p><strong>Floating point X-bit quantization:</strong></p> <ul><li>Full function names: <code>fpx_weight_only</code></li> <li>Shorthands: <code>fpX_eAwB</code>, where <code>X</code> is the number of bits (between <code>1</code> to <code>7</code>), <code>A</code> is the number of exponent bits and <code>B</code> is the number of mantissa bits. The constraint of <code>X == A + B + 1</code> must be satisfied for a given shorthand notation.</li> <li>Documentation shorthands/Common speak: <code>float_a16w3</code>, <code>float_a16w4</code>, <code>float_a16w5</code>, <code>float_a16w6</code>, <code>float_a16w7</code>, <code>float_a16w8</code></li></ul></li> <li><p><strong>Unsigned Integer quantization:</strong></p> <ul><li>Full function names: <code>uintx_weight_only</code></li> <li>Shorthands: <code>uint1wo</code>, <code>uint2wo</code>, <code>uint3wo</code>, <code>uint4wo</code>, <code>uint5wo</code>, <code>uint6wo</code>, <code>uint7wo</code></li> <li>Documentation shorthands/Common speak: <code>uint_a16w1</code>, <code>uint_a16w2</code>, <code>uint_a16w3</code>, <code>uint_a16w4</code>, <code>uint_a16w5</code>, <code>uint_a16w6</code>, <code>uint_a16w7</code></li></ul></li>",ct,J,Bt="The “Documentation shorthands/Common speak” refers to the underlying storage dtype with the number of bits for storing activations and weights, respectively. For example, int_a16w8 stores the activations in 16-bit and the weights in 8-bit.",dt,z,Ht="Some quantization methods are aliases (for example, <code>int8wo</code> is the commonly used shorthand for <code>int8_weight_only</code>). This allows using the quantization methods described in the torchao docs as-is, while also making it convenient to remember their shorthand notations.",mt,$,Ft="Refer to the official torchao documentation for a better understanding of the available quantization methods and the exhaustive list of configuration options available.",ut,Z,pt,k,At='<li><a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/README.md" rel="nofollow">TorchAO Quantization API</a></li> <li><a href="https://github.com/sayakpaul/diffusers-torchao" rel="nofollow">Diffusers-TorchAO examples</a></li>',ht,B,ft,E,yt;return d=new bt({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),p=new wt({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwdG9yY2glMjB0b3JjaGFv",highlighted:"pip install -U torch torchao",wrap:!1}}),y=new wt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUyQyUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZsdXguMS1EZXYlMjIlMEFkdHlwZSUyMCUzRCUyMHRvcmNoLmJmbG9hdDE2JTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFRvcmNoQW9Db25maWcoJTIyaW50OHdvJTIyKSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRGR0eXBlJTJDJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, FluxTransformer2DModel, TorchAoConfig

model_id = <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>
dtype = torch.bfloat16

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = FluxTransformer2DModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=dtype,
)
pipe = FluxPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=dtype,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),b=new wt({props:{code:"JTIzJTIwSW4lMjB0aGUlMjBhYm92ZSUyMGNvZGUlMkMlMjBhZGQlMjB0aGUlMjBmb2xsb3dpbmclMjBhZnRlciUyMGluaXRpYWxpemluZyUyMHRoZSUyMHRyYW5zZm9ybWVyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjB0b3JjaC5jb21waWxlKHRyYW5zZm9ybWVyJTJDJTIwbW9kZSUzRCUyMm1heC1hdXRvdHVuZSUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-comment"># In the above code, add the following after initializing the transformer</span>
transformer = torch.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new bt({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),Z=new bt({props:{title:"Resources",local:"resources",headingTag:"h2"}}),B=new Xt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){c=l("meta"),L=i(),G=l("p"),Q=i(),H(d.$$.fragment),P=i(),m=l("p"),m.innerHTML=_t,S=i(),u=l("p"),u.textContent=gt,X=i(),H(p.$$.fragment),D=i(),h=l("p"),h.innerHTML=Tt,Y=i(),f=l("p"),f.textContent=vt,V=i(),H(y.$$.fragment),N=i(),w=l("p"),w.innerHTML=xt,O=i(),H(b.$$.fragment),K=i(),M=l("p"),M.innerHTML=qt,tt=i(),_=l("p"),_.innerHTML=Ct,et=i(),g=l("p"),g.innerHTML=Ut,ot=i(),T=l("ul"),T.innerHTML=jt,nt=i(),H(v.$$.fragment),it=i(),x=l("p"),x.textContent=Jt,at=i(),q=l("p"),q.innerHTML=zt,lt=i(),C=l("p"),C.textContent=$t,st=i(),U=l("p"),U.textContent=Zt,rt=i(),j=l("ul"),j.innerHTML=kt,ct=i(),J=l("p"),J.textContent=Bt,dt=i(),z=l("p"),z.innerHTML=Ht,mt=i(),$=l("p"),$.textContent=Ft,ut=i(),H(Z.$$.fragment),pt=i(),k=l("ul"),k.innerHTML=At,ht=i(),H(B.$$.fragment),ft=i(),E=l("p"),this.h()},l(t){const e=Pt("svelte-u9bgzb",document.head);c=s(e,"META",{name:!0,content:!0}),e.forEach(o),L=a(t),G=s(t,"P",{}),Wt(G).forEach(o),Q=a(t),F(d.$$.fragment,t),P=a(t),m=s(t,"P",{"data-svelte-h":!0}),r(m)!=="svelte-3zt1h"&&(m.innerHTML=_t),S=a(t),u=s(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-xmmcvn"&&(u.textContent=gt),X=a(t),F(p.$$.fragment,t),D=a(t),h=s(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1bi0jbj"&&(h.innerHTML=Tt),Y=a(t),f=s(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1d14wga"&&(f.textContent=vt),V=a(t),F(y.$$.fragment,t),N=a(t),w=s(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1mb3hq5"&&(w.innerHTML=xt),O=a(t),F(b.$$.fragment,t),K=a(t),M=s(t,"P",{"data-svelte-h":!0}),r(M)!=="svelte-exfnd4"&&(M.innerHTML=qt),tt=a(t),_=s(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1fx3nq1"&&(_.innerHTML=Ct),et=a(t),g=s(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1eoai4f"&&(g.innerHTML=Ut),ot=a(t),T=s(t,"UL",{"data-svelte-h":!0}),r(T)!=="svelte-2fscyb"&&(T.innerHTML=jt),nt=a(t),F(v.$$.fragment,t),it=a(t),x=s(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1dy3rwb"&&(x.textContent=Jt),at=a(t),q=s(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-17x1tdo"&&(q.innerHTML=zt),lt=a(t),C=s(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1nbmql6"&&(C.textContent=$t),st=a(t),U=s(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-4xexxq"&&(U.textContent=Zt),rt=a(t),j=s(t,"UL",{"data-svelte-h":!0}),r(j)!=="svelte-kn0fen"&&(j.innerHTML=kt),ct=a(t),J=s(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1rvxdxz"&&(J.textContent=Bt),dt=a(t),z=s(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1r64eqr"&&(z.innerHTML=Ht),mt=a(t),$=s(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-9cn9y3"&&($.textContent=Ft),ut=a(t),F(Z.$$.fragment,t),pt=a(t),k=s(t,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-96lbpr"&&(k.innerHTML=At),ht=a(t),F(B.$$.fragment,t),ft=a(t),E=s(t,"P",{}),Wt(E).forEach(o),this.h()},h(){Rt(c,"name","hf:doc:metadata"),Rt(c,"content",Yt)},m(t,e){St(document.head,c),n(t,L,e),n(t,G,e),n(t,Q,e),A(d,t,e),n(t,P,e),n(t,m,e),n(t,S,e),n(t,u,e),n(t,X,e),A(p,t,e),n(t,D,e),n(t,h,e),n(t,Y,e),n(t,f,e),n(t,V,e),A(y,t,e),n(t,N,e),n(t,w,e),n(t,O,e),A(b,t,e),n(t,K,e),n(t,M,e),n(t,tt,e),n(t,_,e),n(t,et,e),n(t,g,e),n(t,ot,e),n(t,T,e),n(t,nt,e),A(v,t,e),n(t,it,e),n(t,x,e),n(t,at,e),n(t,q,e),n(t,lt,e),n(t,C,e),n(t,st,e),n(t,U,e),n(t,rt,e),n(t,j,e),n(t,ct,e),n(t,J,e),n(t,dt,e),n(t,z,e),n(t,mt,e),n(t,$,e),n(t,ut,e),A(Z,t,e),n(t,pt,e),n(t,k,e),n(t,ht,e),A(B,t,e),n(t,ft,e),n(t,E,e),yt=!0},p:Gt,i(t){yt||(W(d.$$.fragment,t),W(p.$$.fragment,t),W(y.$$.fragment,t),W(b.$$.fragment,t),W(v.$$.fragment,t),W(Z.$$.fragment,t),W(B.$$.fragment,t),yt=!0)},o(t){R(d.$$.fragment,t),R(p.$$.fragment,t),R(y.$$.fragment,t),R(b.$$.fragment,t),R(v.$$.fragment,t),R(Z.$$.fragment,t),R(B.$$.fragment,t),yt=!1},d(t){t&&(o(L),o(G),o(Q),o(P),o(m),o(S),o(u),o(X),o(D),o(h),o(Y),o(f),o(V),o(N),o(w),o(O),o(K),o(M),o(tt),o(_),o(et),o(g),o(ot),o(T),o(nt),o(it),o(x),o(at),o(q),o(lt),o(C),o(st),o(U),o(rt),o(j),o(ct),o(J),o(dt),o(z),o(mt),o($),o(ut),o(pt),o(k),o(ht),o(ft),o(E)),o(c),I(d,t),I(p,t),I(y,t),I(b,t),I(v,t),I(Z,t),I(B,t)}}}const Yt='{"title":"torchao","local":"torchao","sections":[{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Vt(Mt){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ee extends Lt{constructor(c){super(),Qt(this,c,Vt,Dt,It,{})}}export{ee as component};
