import{s as ie,b as oe,n as pe,o as re}from"../chunks/scheduler.aec39e6a.js";import{S as ye,i as me,e as M,s as a,c as o,h as je,a as i,d as l,b as n,f as Ht,g as p,j as c,k as U,l as ce,m as s,n as r,t as y,o as m,p as j}from"../chunks/index.4ee0a2d0.js";import{C as de,H as tt,E as ue}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4e496d99.js";import{C as u}from"../chunks/CodeBlock.2b572cc3.js";function he(vt){let h,st,et,at,J,nt,f,Mt,g,St="The get started guide will show you how to quickly use Hugging Face on Amazon SageMaker with the SDK. Learn how to fine-tune and deploy a pretrained 🤗 Transformers model on SageMaker for a binary text classification task.",it,d,qt,ot,b,xt='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb file</a> to follow along!',pt,w,rt,T,Et='Get started by installing the necessary Hugging Face libraries and SageMaker. You will also need to install <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch</a> if you don’t already have it installed. If you run this example in SageMaker Studio, it is already installed in the notebook kernel!',yt,C,mt,k,Qt='If you want to run this example in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio.html" rel="nofollow">SageMaker Studio</a>, upgrade <a href="https://ipywidgets.readthedocs.io/en/latest/" rel="nofollow">ipywidgets</a> for the 🤗 Datasets library and restart the kernel:',jt,A,ct,I,Lt='Next, you should set up your environment: a SageMaker session and an S3 bucket. The S3 bucket will store data, models, and logs. You will need access to an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM execution role</a> with the required permissions.',dt,Z,Pt='If you are planning on using SageMaker in a local environment, you need to provide the <code>role</code> yourself. Learn more about how to set this up <a href="https://huggingface.co/docs/sagemaker/train#installation-and-setup" rel="nofollow">here</a>.',ut,$,Dt="⚠️ The execution role is only available when you run a notebook within SageMaker. If you try to run <code>get_execution_role</code> in a notebook not on SageMaker, you will get a region error.",ht,B,Ut,X,Jt,W,Kt='The 🤗 Datasets library makes it easy to download and preprocess a dataset for training. Download and tokenize the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">IMDb</a> dataset:',ft,_,gt,z,bt,G,Ot='Next, upload the preprocessed dataset to your S3 session bucket with 🤗 Datasets S3 <a href="https://huggingface.co/docs/datasets/filesystems.html" rel="nofollow">filesystem</a> implementation:',wt,Y,Tt,R,Ct,N,te="Create a Hugging Face Estimator to handle end-to-end SageMaker training and deployment. The most important parameters to pay attention to are:",kt,F,ee='<li><code>entry_point</code> refers to the fine-tuning script which you can find in <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a>.</li> <li><code>instance_type</code> refers to the SageMaker instance that will be launched. Take a look <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> refers to the training hyperparameters the model will be fine-tuned with.</li>',At,V,It,H,le="Begin training with one line of code:",Zt,v,$t,S,Bt,q,se="Once the training job is complete, deploy your fine-tuned model by calling <code>deploy()</code> with the number of instances and instance type:",Xt,x,Wt,E,ae="Call <code>predict()</code> on your data:",_t,Q,zt,L,ne="After running your request, delete the endpoint:",Gt,P,Yt,D,Rt,K,Me="Congratulations, you’ve just fine-tuned and deployed a pretrained 🤗 Transformers model on SageMaker for binary text classification! 🎉",Nt,O,Ft,lt,Vt;return J=new de({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new tt({props:{title:"Train and deploy a Hugging Face model on Amazon SageMaker with the SDK",local:"train-and-deploy-a-hugging-face-model-on-amazon-sagemaker-with-the-sdk",headingTag:"h1"}}),w=new tt({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),C=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNhZ2VtYWtlciUzRSUzRDIuMTQwLjAlMjIlMjAlMjJ0cmFuc2Zvcm1lcnMlM0QlM0Q0LjI2LjElMjIlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xMC4xJTIyJTIwLS11cGdyYWRl",highlighted:'pip install <span class="hljs-string">&quot;sagemaker&gt;=2.140.0&quot;</span> <span class="hljs-string">&quot;transformers==4.26.1&quot;</span> <span class="hljs-string">&quot;datasets[s3]==2.10.1&quot;</span> --upgrade',wrap:!1}}),A=new u({props:{code:"JTI1JTI1Y2FwdHVyZSUwQWltcG9ydCUyMElQeXRob24lMEEhY29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGlweXdpZGdldHMlMjAteSUwQUlQeXRob24uQXBwbGljYXRpb24uaW5zdGFuY2UoKS5rZXJuZWwuZG9fc2h1dGRvd24oVHJ1ZSk=",highlighted:`%%capture
<span class="hljs-keyword">import</span> IPython
!conda install -c conda-forge ipywidgets -y
IPython.Application.instance().kernel.do_shutdown(<span class="hljs-literal">True</span>)`,wrap:!1}}),B=new u({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjAlM0QlMjBOb25lJTBBaWYlMjBzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjBpcyUyME5vbmUlMjBhbmQlMjBzZXNzJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb25fYnVja2V0JTIwJTNEJTIwc2Vzcy5kZWZhdWx0X2J1Y2tldCgpJTBBJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker

sess = sagemaker.Session()
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    sagemaker_session_bucket = sess.default_bucket()

role = sagemaker.get_execution_role()
sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)`,wrap:!1}}),X=new tt({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),_=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBsb2FkJTIwZGF0YXNldCUwQXRyYWluX2RhdGFzZXQlMkMlMjB0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTVCJTIydHJhaW4lMjIlMkMlMjAlMjJ0ZXN0JTIyJTVEKSUwQSUwQSUyMyUyMGxvYWQlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBJTIzJTIwY3JlYXRlJTIwdG9rZW5pemF0aW9uJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMjMlMjB0b2tlbml6ZSUyMHRyYWluJTIwYW5kJTIwdGVzdCUyMGRhdGFzZXRzJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRyYWluX2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0Lm1hcCh0b2tlbml6ZSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQSUwQSUyMyUyMHNldCUyMGRhdGFzZXQlMjBmb3JtYXQlMjBmb3IlMjBQeVRvcmNoJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMCUyMHRyYWluX2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0cmFpbl9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIpJTBBdGVzdF9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># load dataset</span>
train_dataset, test_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=[<span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>])

<span class="hljs-comment"># load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>)

<span class="hljs-comment"># create tokenization function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># tokenize train and test datasets</span>
train_dataset = train_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)
test_dataset = test_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># set dataset format for PyTorch</span>
train_dataset =  train_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
train_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])
test_dataset = test_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
test_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),z=new tt({props:{title:"Upload dataset to S3 bucket",local:"upload-dataset-to-s3-bucket",headingTag:"h2"}}),Y=new u({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMHMzJTBBdHJhaW5pbmdfaW5wdXRfcGF0aCUyMCUzRCUyMGYnczMlM0ElMkYlMkYlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMkYlN0JzM19wcmVmaXglN0QlMkZ0cmFpbiclMEF0cmFpbl9kYXRhc2V0LnNhdmVfdG9fZGlzayh0cmFpbmluZ19pbnB1dF9wYXRoKSUwQSUwQSUyMyUyMHNhdmUlMjB0ZXN0X2RhdGFzZXQlMjB0byUyMHMzJTBBdGVzdF9pbnB1dF9wYXRoJTIwJTNEJTIwZidzMyUzQSUyRiUyRiU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyRiU3QnMzX3ByZWZpeCU3RCUyRnRlc3QnJTBBdGVzdF9kYXRhc2V0LnNhdmVfdG9fZGlzayh0ZXN0X2lucHV0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to s3</span>
training_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/train&#x27;</span>
train_dataset.save_to_disk(training_input_path)

<span class="hljs-comment"># save test_dataset to s3</span>
test_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/test&#x27;</span>
test_dataset.save_to_disk(test_input_path)`,wrap:!1}}),R=new tt({props:{title:"Start a training job",local:"start-a-training-job",headingTag:"h2"}}),V=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

hyperparameters={
    <span class="hljs-string">&quot;epochs&quot;</span>: <span class="hljs-number">1</span>,                                       <span class="hljs-comment"># number of training epochs</span>
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-number">32</span>,                            <span class="hljs-comment"># training batch size</span>
    <span class="hljs-string">&quot;model_name&quot;</span>:<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>  <span class="hljs-comment"># name of pretrained model</span>
}

huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;train.py&quot;</span>,                 <span class="hljs-comment"># fine-tuning script to use in training job</span>
    source_dir=<span class="hljs-string">&quot;./scripts&quot;</span>,                 <span class="hljs-comment"># directory where fine-tuning script is stored</span>
    instance_type=<span class="hljs-string">&quot;ml.p3.2xlarge&quot;</span>,          <span class="hljs-comment"># instance type</span>
    instance_count=<span class="hljs-number">1</span>,                       <span class="hljs-comment"># number of instances</span>
    role=role,                              <span class="hljs-comment"># IAM role used in training job to access AWS resources (S3)</span>
    transformers_version=<span class="hljs-string">&quot;4.36&quot;</span>,             <span class="hljs-comment"># Transformers version</span>
    pytorch_version=<span class="hljs-string">&quot;2.1.0&quot;</span>,                  <span class="hljs-comment"># PyTorch version</span>
    py_version=<span class="hljs-string">&quot;py310&quot;</span>,                      <span class="hljs-comment"># Python version</span>
    hyperparameters=hyperparameters         <span class="hljs-comment"># hyperparameters to use in training job</span>
)`,wrap:!1}}),v=new u({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglN0IlMjJ0cmFpbiUyMiUzQSUyMHRyYWluaW5nX2lucHV0X3BhdGglMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwdGVzdF9pbnB1dF9wYXRoJTdEKQ==",highlighted:'huggingface_estimator.fit({<span class="hljs-string">&quot;train&quot;</span>: training_input_path, <span class="hljs-string">&quot;test&quot;</span>: test_input_path})',wrap:!1}}),S=new tt({props:{title:"Deploy model",local:"deploy-model",headingTag:"h2"}}),x=new u({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMm1sLmc0ZG4ueGxhcmdlJTIyKQ==",highlighted:'predictor = huggingface_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>,<span class="hljs-string">&quot;ml.g4dn.xlarge&quot;</span>)',wrap:!1}}),Q=new u({props:{code:"c2VudGltZW50X2lucHV0JTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySXQlMjBmZWVscyUyMGxpa2UlMjBhJTIwY3VydGFpbiUyMGNsb3NpbmcuLi50aGVyZSUyMHdhcyUyMGFuJTIwZWxlZ2FuY2UlMjBpbiUyMHRoZSUyMHdheSUyMHRoZXklMjBtb3ZlZCUyMHRvd2FyZCUyMGNvbmNsdXNpb24uJTIwTm8lMjBmYW4lMjBpcyUyMGdvaW5nJTIwdG8lMjB3YXRjaCUyMGFuZCUyMGZlZWwlMjBzaG9ydC1jaGFuZ2VkLiUyMiU3RCUwQSUwQXByZWRpY3Rvci5wcmVkaWN0KHNlbnRpbWVudF9pbnB1dCk=",highlighted:`sentiment_input = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;It feels like a curtain closing...there was an elegance in the way they moved toward conclusion. No fan is going to watch and feel short-changed.&quot;</span>}

predictor.predict(sentiment_input)`,wrap:!1}}),P=new u({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:"predictor.delete_endpoint()",wrap:!1}}),D=new tt({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),O=new ue({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/sagemaker-sdk-quickstart.md"}}),{c(){h=M("meta"),st=a(),et=M("p"),at=a(),o(J.$$.fragment),nt=a(),o(f.$$.fragment),Mt=a(),g=M("p"),g.textContent=St,it=a(),d=M("iframe"),ot=a(),b=M("p"),b.innerHTML=xt,pt=a(),o(w.$$.fragment),rt=a(),T=M("p"),T.innerHTML=Et,yt=a(),o(C.$$.fragment),mt=a(),k=M("p"),k.innerHTML=Qt,jt=a(),o(A.$$.fragment),ct=a(),I=M("p"),I.innerHTML=Lt,dt=a(),Z=M("p"),Z.innerHTML=Pt,ut=a(),$=M("p"),$.innerHTML=Dt,ht=a(),o(B.$$.fragment),Ut=a(),o(X.$$.fragment),Jt=a(),W=M("p"),W.innerHTML=Kt,ft=a(),o(_.$$.fragment),gt=a(),o(z.$$.fragment),bt=a(),G=M("p"),G.innerHTML=Ot,wt=a(),o(Y.$$.fragment),Tt=a(),o(R.$$.fragment),Ct=a(),N=M("p"),N.textContent=te,kt=a(),F=M("ul"),F.innerHTML=ee,At=a(),o(V.$$.fragment),It=a(),H=M("p"),H.textContent=le,Zt=a(),o(v.$$.fragment),$t=a(),o(S.$$.fragment),Bt=a(),q=M("p"),q.innerHTML=se,Xt=a(),o(x.$$.fragment),Wt=a(),E=M("p"),E.innerHTML=ae,_t=a(),o(Q.$$.fragment),zt=a(),L=M("p"),L.textContent=ne,Gt=a(),o(P.$$.fragment),Yt=a(),o(D.$$.fragment),Rt=a(),K=M("p"),K.textContent=Me,Nt=a(),o(O.$$.fragment),Ft=a(),lt=M("p"),this.h()},l(t){const e=je("svelte-u9bgzb",document.head);h=i(e,"META",{name:!0,content:!0}),e.forEach(l),st=n(t),et=i(t,"P",{}),Ht(et).forEach(l),at=n(t),p(J.$$.fragment,t),nt=n(t),p(f.$$.fragment,t),Mt=n(t),g=i(t,"P",{"data-svelte-h":!0}),c(g)!=="svelte-w5bkwl"&&(g.textContent=St),it=n(t),d=i(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),Ht(d).forEach(l),ot=n(t),b=i(t,"P",{"data-svelte-h":!0}),c(b)!=="svelte-mi6lna"&&(b.innerHTML=xt),pt=n(t),p(w.$$.fragment,t),rt=n(t),T=i(t,"P",{"data-svelte-h":!0}),c(T)!=="svelte-198besl"&&(T.innerHTML=Et),yt=n(t),p(C.$$.fragment,t),mt=n(t),k=i(t,"P",{"data-svelte-h":!0}),c(k)!=="svelte-yozy2b"&&(k.innerHTML=Qt),jt=n(t),p(A.$$.fragment,t),ct=n(t),I=i(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1sllt2f"&&(I.innerHTML=Lt),dt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-tg9h77"&&(Z.innerHTML=Pt),ut=n(t),$=i(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-y9vgbx"&&($.innerHTML=Dt),ht=n(t),p(B.$$.fragment,t),Ut=n(t),p(X.$$.fragment,t),Jt=n(t),W=i(t,"P",{"data-svelte-h":!0}),c(W)!=="svelte-b8daui"&&(W.innerHTML=Kt),ft=n(t),p(_.$$.fragment,t),gt=n(t),p(z.$$.fragment,t),bt=n(t),G=i(t,"P",{"data-svelte-h":!0}),c(G)!=="svelte-nm384r"&&(G.innerHTML=Ot),wt=n(t),p(Y.$$.fragment,t),Tt=n(t),p(R.$$.fragment,t),Ct=n(t),N=i(t,"P",{"data-svelte-h":!0}),c(N)!=="svelte-16p4w97"&&(N.textContent=te),kt=n(t),F=i(t,"UL",{"data-svelte-h":!0}),c(F)!=="svelte-1bnefx4"&&(F.innerHTML=ee),At=n(t),p(V.$$.fragment,t),It=n(t),H=i(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-b865q9"&&(H.textContent=le),Zt=n(t),p(v.$$.fragment,t),$t=n(t),p(S.$$.fragment,t),Bt=n(t),q=i(t,"P",{"data-svelte-h":!0}),c(q)!=="svelte-twh61n"&&(q.innerHTML=se),Xt=n(t),p(x.$$.fragment,t),Wt=n(t),E=i(t,"P",{"data-svelte-h":!0}),c(E)!=="svelte-19s4ndj"&&(E.innerHTML=ae),_t=n(t),p(Q.$$.fragment,t),zt=n(t),L=i(t,"P",{"data-svelte-h":!0}),c(L)!=="svelte-l180zc"&&(L.textContent=ne),Gt=n(t),p(P.$$.fragment,t),Yt=n(t),p(D.$$.fragment,t),Rt=n(t),K=i(t,"P",{"data-svelte-h":!0}),c(K)!=="svelte-g7jk9r"&&(K.textContent=Me),Nt=n(t),p(O.$$.fragment,t),Ft=n(t),lt=i(t,"P",{}),Ht(lt).forEach(l),this.h()},h(){U(h,"name","hf:doc:metadata"),U(h,"content",Ue),U(d,"width","560"),U(d,"height","315"),oe(d.src,qt="https://www.youtube.com/embed/pYqjCzoyWyo")||U(d,"src",qt),U(d,"title","YouTube video player"),U(d,"frameborder","0"),U(d,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),d.allowFullscreen=""},m(t,e){ce(document.head,h),s(t,st,e),s(t,et,e),s(t,at,e),r(J,t,e),s(t,nt,e),r(f,t,e),s(t,Mt,e),s(t,g,e),s(t,it,e),s(t,d,e),s(t,ot,e),s(t,b,e),s(t,pt,e),r(w,t,e),s(t,rt,e),s(t,T,e),s(t,yt,e),r(C,t,e),s(t,mt,e),s(t,k,e),s(t,jt,e),r(A,t,e),s(t,ct,e),s(t,I,e),s(t,dt,e),s(t,Z,e),s(t,ut,e),s(t,$,e),s(t,ht,e),r(B,t,e),s(t,Ut,e),r(X,t,e),s(t,Jt,e),s(t,W,e),s(t,ft,e),r(_,t,e),s(t,gt,e),r(z,t,e),s(t,bt,e),s(t,G,e),s(t,wt,e),r(Y,t,e),s(t,Tt,e),r(R,t,e),s(t,Ct,e),s(t,N,e),s(t,kt,e),s(t,F,e),s(t,At,e),r(V,t,e),s(t,It,e),s(t,H,e),s(t,Zt,e),r(v,t,e),s(t,$t,e),r(S,t,e),s(t,Bt,e),s(t,q,e),s(t,Xt,e),r(x,t,e),s(t,Wt,e),s(t,E,e),s(t,_t,e),r(Q,t,e),s(t,zt,e),s(t,L,e),s(t,Gt,e),r(P,t,e),s(t,Yt,e),r(D,t,e),s(t,Rt,e),s(t,K,e),s(t,Nt,e),r(O,t,e),s(t,Ft,e),s(t,lt,e),Vt=!0},p:pe,i(t){Vt||(y(J.$$.fragment,t),y(f.$$.fragment,t),y(w.$$.fragment,t),y(C.$$.fragment,t),y(A.$$.fragment,t),y(B.$$.fragment,t),y(X.$$.fragment,t),y(_.$$.fragment,t),y(z.$$.fragment,t),y(Y.$$.fragment,t),y(R.$$.fragment,t),y(V.$$.fragment,t),y(v.$$.fragment,t),y(S.$$.fragment,t),y(x.$$.fragment,t),y(Q.$$.fragment,t),y(P.$$.fragment,t),y(D.$$.fragment,t),y(O.$$.fragment,t),Vt=!0)},o(t){m(J.$$.fragment,t),m(f.$$.fragment,t),m(w.$$.fragment,t),m(C.$$.fragment,t),m(A.$$.fragment,t),m(B.$$.fragment,t),m(X.$$.fragment,t),m(_.$$.fragment,t),m(z.$$.fragment,t),m(Y.$$.fragment,t),m(R.$$.fragment,t),m(V.$$.fragment,t),m(v.$$.fragment,t),m(S.$$.fragment,t),m(x.$$.fragment,t),m(Q.$$.fragment,t),m(P.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),Vt=!1},d(t){t&&(l(st),l(et),l(at),l(nt),l(Mt),l(g),l(it),l(d),l(ot),l(b),l(pt),l(rt),l(T),l(yt),l(mt),l(k),l(jt),l(ct),l(I),l(dt),l(Z),l(ut),l($),l(ht),l(Ut),l(Jt),l(W),l(ft),l(gt),l(bt),l(G),l(wt),l(Tt),l(Ct),l(N),l(kt),l(F),l(At),l(It),l(H),l(Zt),l($t),l(Bt),l(q),l(Xt),l(Wt),l(E),l(_t),l(zt),l(L),l(Gt),l(Yt),l(Rt),l(K),l(Nt),l(Ft),l(lt)),l(h),j(J,t),j(f,t),j(w,t),j(C,t),j(A,t),j(B,t),j(X,t),j(_,t),j(z,t),j(Y,t),j(R,t),j(V,t),j(v,t),j(S,t),j(x,t),j(Q,t),j(P,t),j(D,t),j(O,t)}}}const Ue='{"title":"Train and deploy a Hugging Face model on Amazon SageMaker with the SDK","local":"train-and-deploy-a-hugging-face-model-on-amazon-sagemaker-with-the-sdk","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Upload dataset to S3 bucket","local":"upload-dataset-to-s3-bucket","sections":[],"depth":2},{"title":"Start a training job","local":"start-a-training-job","sections":[],"depth":2},{"title":"Deploy model","local":"deploy-model","sections":[],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Je(vt){return re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends ye{constructor(h){super(),me(this,h,Je,he,ie,{})}}export{Te as component};
