import{s as ba,n as ja,o as wa}from"../chunks/scheduler.25b97de1.js";import{S as Ja,i as Ta,g as i,s as l,r as o,A as xa,h as p,f as t,c as n,j as Ma,u as m,x as r,k as qs,y as Ua,a,v as c,d as h,t as d,w as g}from"../chunks/index.d9030fc9.js";import{C as u}from"../chunks/CodeBlock.e6cd0d95.js";import{D as va}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as Ys,E as $a}from"../chunks/EditOnGithub.91d95064.js";function Ca(xt){let f,Ls,As,Ss,j,Ps,w,Ds,J,Ut=`Visual Question Answering (VQA) is the task of answering open-ended questions based on an image.
The input to models supporting this task is typically a combination of an image and a question, and the output is an
answer expressed in natural language.`,Ks,T,vt="Some noteworthy use case examples for VQA include:",Os,x,$t="<li>Accessibility applications for visually impaired individuals.</li> <li>Education: posing questions about visual materials presented in lectures or textbooks. VQA can also be utilized in interactive museum exhibits or historical sites.</li> <li>Customer service and e-commerce: VQA can enhance user experience by letting users ask questions about products.</li> <li>Image retrieval: VQA models can be used to retrieve images with specific characteristics. For example, the user can ask “Is there a dog?” to find all images with dogs from a set of images.</li>",se,U,Ct="In this guide you’ll learn how to:",ee,v,_t='<li>Fine-tune a classification VQA model, specifically <a href="../model_doc/vilt">ViLT</a>, on the <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> dataset</a>.</li> <li>Use your fine-tuned ViLT for inference.</li> <li>Run zero-shot VQA inference with a generative model, like BLIP-2.</li>',te,$,ae,C,Zt=`ViLT model incorporates text embeddings into a Vision Transformer (ViT), allowing it to have a minimal design for
Vision-and-Language Pre-training (VLP). This model can be used for several downstream tasks. For the VQA task, a classifier
head is placed on top (a linear layer on top of the final hidden state of the <code>[CLS]</code> token) and randomly initialized.
Visual Question Answering is thus treated as a <strong>classification problem</strong>.`,le,_,kt=`More recent models, such as BLIP, BLIP-2, and InstructBLIP, treat VQA as a generative task. Later in this guide we
illustrate how to use them for zero-shot VQA inference.`,ne,Z,Vt="Before you begin, make sure you have all the necessary libraries installed.",ie,k,pe,V,Gt=`We encourage you to share your model with the community. Log in to your Hugging Face account to upload it to the 🤗 Hub.
When prompted, enter your token to log in:`,re,G,oe,W,Wt="Let’s define the model checkpoint as a global variable.",me,I,ce,B,he,X,It=`For illustration purposes, in this guide we use a very small sample of the annotated visual question answering <code>Graphcore/vqa</code> dataset.
You can find the full dataset on <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow">🤗 Hub</a>.`,de,Q,Bt=`As an alternative to the <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> dataset</a>, you can download the
same data manually from the official <a href="https://visualqa.org/download.html" rel="nofollow">VQA dataset page</a>. If you prefer to follow the
tutorial with your custom data, check out how to <a href="https://huggingface.co/docs/datasets/image_dataset#loading-script" rel="nofollow">Create an image dataset</a>
guide in the 🤗 Datasets documentation.`,ge,R,Xt="Let’s load the first 200 examples from the validation split and explore the dataset’s features:",ue,H,fe,F,Qt="Let’s take a look at an example to understand the dataset’s features:",ye,N,Me,z,Rt="The features relevant to the task include:",be,Y,Ht="<li><code>question</code>: the question to be answered from the image</li> <li><code>image_id</code>: the path to the image the question refers to</li> <li><code>label</code>: the annotations</li>",je,A,Ft="We can remove the rest of the features as they won’t be necessary:",we,E,Je,q,Nt=`As you can see, the <code>label</code> feature contains several answers to the same question (called <code>ids</code> here) collected by different human annotators.
This is because the answer to a question can be subjective. In this case, the question is “where is he looking?“. Some people
annotated this with “down”, others with “at table”, another one with “skateboard”, etc.`,Te,L,zt="Take a look at the image and consider which answer would you give:",xe,S,Ue,y,Yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/vqa-example.png" alt="VQA Image Example"/>',ve,P,At=`Due to the questions’ and answers’ ambiguity, datasets like this are treated as a multi-label classification problem (as
multiple answers are possibly valid). Moreover, rather than just creating a one-hot encoded vector, one creates a
soft encoding, based on the number of times a certain answer appeared in the annotations.`,$e,D,Et=`For instance, in the example above, because the answer “down” is selected way more often than other answers, it has a
score (called <code>weight</code> in the dataset) of 1.0, and the rest of the answers have scores &lt; 1.0.`,Ce,K,qt=`To later instantiate the model with an appropriate classification head, let’s create two dictionaries: one that maps
the label name to an integer and vice versa:`,_e,O,Ze,ss,Lt="Now that we have the mappings, we can replace the string answers with their ids, and flatten the dataset for a more convenient further preprocessing.",ke,es,Ve,ts,Ge,as,St=`The next step is to load a ViLT processor to prepare the image and text data for the model.
<a href="/docs/transformers/pr_29693/en/model_doc/vilt#transformers.ViltProcessor">ViltProcessor</a> wraps a BERT tokenizer and ViLT image processor into a convenient single processor:`,We,ls,Ie,ns,Pt=`To preprocess the data we need to encode the images and questions using the <a href="/docs/transformers/pr_29693/en/model_doc/vilt#transformers.ViltProcessor">ViltProcessor</a>. The processor will use
the <a href="/docs/transformers/pr_29693/en/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> to tokenize the text and create <code>input_ids</code>, <code>attention_mask</code> and <code>token_type_ids</code> for the text data.
As for images, the processor will leverage <a href="/docs/transformers/pr_29693/en/model_doc/vilt#transformers.ViltImageProcessor">ViltImageProcessor</a> to resize and normalize the image, and create <code>pixel_values</code> and <code>pixel_mask</code>.`,Be,is,Dt=`All these preprocessing steps are done under the hood, we only need to call the <code>processor</code>. However, we still need to
prepare the target labels. In this representation, each element corresponds to a possible answer (label). For correct answers, the element holds
their respective score (weight), while the remaining elements are set to zero.`,Xe,ps,Kt="The following function applies the <code>processor</code> to the images and questions and formats the labels as described above:",Qe,rs,Re,os,Ot=`To apply the preprocessing function over the entire dataset, use 🤗 Datasets <code>map</code> function. You can speed up <code>map</code> by
setting <code>batched=True</code> to process multiple elements of the dataset at once. At this point, feel free to remove the columns you don’t need.`,He,ms,Fe,cs,sa='As a final step, create a batch of examples using <a href="/docs/transformers/pr_29693/en/main_classes/data_collator#transformers.DefaultDataCollator">DefaultDataCollator</a>:',Ne,hs,ze,ds,Ye,gs,ea=`You’re ready to start training your model now! Load ViLT with <a href="/docs/transformers/pr_29693/en/model_doc/vilt#transformers.ViltForQuestionAnswering">ViltForQuestionAnswering</a>. Specify the number of labels
along with the label mappings:`,Ae,us,Ee,fs,ta="At this point, only three steps remain:",qe,ys,aa='<li>Define your training hyperparameters in <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>:</li>',Le,Ms,Se,M,la='<li>Pass the training arguments to <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, processor, and data collator.</li>',Pe,bs,De,b,na='<li>Call <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',Ke,js,Oe,ws,ia='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method to share your final model on the 🤗 Hub:',st,Js,et,Ts,tt,xs,pa=`Now that you have fine-tuned a ViLT model, and uploaded it to the 🤗 Hub, you can use it for inference. The simplest
way to try out your fine-tuned model for inference is to use it in a <a href="/docs/transformers/pr_29693/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a>.`,at,Us,lt,vs,ra=`The model in this guide has only been trained on 200 examples, so don’t expect a lot from it. Let’s see if it at least
learned something from the data and take the first example from the dataset to illustrate inference:`,nt,$s,it,Cs,oa="Even though not very confident, the model indeed has learned something. With more examples and longer training, you’ll get far better results!",pt,_s,ma="You can also manually replicate the results of the pipeline if you’d like:",rt,Zs,ca="<li>Take an image and a question, prepare them for the model using the processor from your model.</li> <li>Forward the result or preprocessing through the model.</li> <li>From the logits, get the most likely answer’s id, and find the actual answer in the <code>id2label</code>.</li>",ot,ks,mt,Vs,ct,Gs,ha=`The previous model treated VQA as a classification task. Some recent models, such as BLIP, BLIP-2, and InstructBLIP approach
VQA as a generative task. Let’s take <a href="../model_doc/blip-2">BLIP-2</a> as an example. It introduced a new visual-language pre-training
paradigm in which any combination of pre-trained vision encoder and LLM can be used (learn more in the <a href="https://huggingface.co/blog/blip-2" rel="nofollow">BLIP-2 blog post</a>).
This enables achieving state-of-the-art results on multiple visual-language tasks including visual question answering.`,ht,Ws,da=`Let’s illustrate how you can use this model for VQA. First, let’s load the model. Here we’ll explicitly send the model to a
GPU, if available, which we didn’t need to do earlier when training, as <a href="/docs/transformers/pr_29693/en/main_classes/trainer#transformers.Trainer">Trainer</a> handles this automatically:`,dt,Is,gt,Bs,ga="The model takes image and text as input, so let’s use the exact same image/question pair from the first example in the VQA dataset:",ut,Xs,ft,Qs,ua="To use BLIP-2 for visual question answering task, the textual prompt has to follow a specific format: <code>Question: {} Answer:</code>.",yt,Rs,Mt,Hs,fa="Now we need to preprocess the image/prompt with the model’s processor, pass the processed input through the model, and decode the output:",bt,Fs,jt,Ns,ya=`As you can see, the model recognized the crowd, and the direction of the face (looking down), however, it seems to miss
the fact the crowd is behind the skater. Still, in cases where acquiring human-annotated datasets is not feasible, this
approach can quickly produce useful results.`,wt,zs,Jt,Es,Tt;return j=new Ys({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h1"}}),w=new va({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/visual_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/visual_question_answering.ipynb"}]}}),$=new Ys({props:{title:"Fine-tuning ViLT",local:"fine-tuning-vilt",headingTag:"h2"}}),k=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets",wrap:!1}}),G=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),I=new u({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMmRhbmRlbGluJTJGdmlsdC1iMzItbWxtJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;dandelin/vilt-b32-mlm&quot;</span>',wrap:!1}}),B=new Ys({props:{title:"Load the data",local:"load-the-data",headingTag:"h2"}}),H=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJHcmFwaGNvcmUlMkZ2cWElMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0EyMDAlNUQlMjIpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;Graphcore/vqa&quot;</span>, split=<span class="hljs-string">&quot;validation[:200]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),N=new u({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Where is he looking?&#x27;</span>,
 <span class="hljs-string">&#x27;question_type&#x27;</span>: <span class="hljs-string">&#x27;none of the above&#x27;</span>,
 <span class="hljs-string">&#x27;question_id&#x27;</span>: <span class="hljs-number">262148000</span>,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/ca733e0e000fb2d7a09fbcc94dbfe7b5a30750681d0e965f8e0a23b1c2f98c75/val2014/COCO_val2014_000000262148.jpg&#x27;</span>,
 <span class="hljs-string">&#x27;answer_type&#x27;</span>: <span class="hljs-string">&#x27;other&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: {<span class="hljs-string">&#x27;ids&#x27;</span>: [<span class="hljs-string">&#x27;at table&#x27;</span>, <span class="hljs-string">&#x27;down&#x27;</span>, <span class="hljs-string">&#x27;skateboard&#x27;</span>, <span class="hljs-string">&#x27;table&#x27;</span>],
  <span class="hljs-string">&#x27;weights&#x27;</span>: [<span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">1.0</span>,
   <span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">0.30000001192092896</span>]}}`,wrap:!1}}),E=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTVCJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdhbnN3ZXJfdHlwZSclNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>])',wrap:!1}}),S=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGRhdGFzZXQlNUIwJTVEJTVCJ2ltYWdlX2lkJyU1RCklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),O=new u({props:{code:"aW1wb3J0JTIwaXRlcnRvb2xzJTBBJTBBbGFiZWxzJTIwJTNEJTIwJTVCaXRlbSU1QidpZHMnJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwZGF0YXNldCU1QidsYWJlbCclNUQlNUQlMEFmbGF0dGVuZWRfbGFiZWxzJTIwJTNEJTIwbGlzdChpdGVydG9vbHMuY2hhaW4oKmxhYmVscykpJTBBdW5pcXVlX2xhYmVscyUyMCUzRCUyMGxpc3Qoc2V0KGZsYXR0ZW5lZF9sYWJlbHMpKSUwQSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpZHglMjBmb3IlMjBpZHglMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHVuaXF1ZV9sYWJlbHMpJTdEJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpZHglM0ElMjBsYWJlbCUyMGZvciUyMGxhYmVsJTJDJTIwaWR4JTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> itertools

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [item[<span class="hljs-string">&#x27;ids&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&#x27;label&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>flattened_labels = <span class="hljs-built_in">list</span>(itertools.chain(*labels))
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_labels = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(flattened_labels))

<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: idx <span class="hljs-keyword">for</span> idx, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(unique_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {idx: label <span class="hljs-keyword">for</span> label, idx <span class="hljs-keyword">in</span> label2id.items()} `,wrap:!1}}),es=new u({props:{code:"ZGVmJTIwcmVwbGFjZV9pZHMoaW5wdXRzKSUzQSUwQSUyMCUyMGlucHV0cyU1QiUyMmxhYmVsJTIyJTVEJTVCJTIyaWRzJTIyJTVEJTIwJTNEJTIwJTVCbGFiZWwyaWQlNUJ4JTVEJTIwZm9yJTIweCUyMGluJTIwaW5wdXRzJTVCJTIybGFiZWwlMjIlNUQlNUIlMjJpZHMlMjIlNUQlNUQlMEElMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocmVwbGFjZV9pZHMpJTBBZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQuZmVhdHVyZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">replace_ids</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>  inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>] = [label2id[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>]]
<span class="hljs-meta">... </span>  <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(replace_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset.features
{<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;image_id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.weights&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;float64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),ts=new Ys({props:{title:"Preprocessing data",local:"preprocessing-data",headingTag:"h2"}}),ls=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBWaWx0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),rs=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBwcmVwcm9jZXNzX2RhdGEoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcGF0aHMlMjAlM0QlMjBleGFtcGxlcyU1QidpbWFnZV9pZCclNUQlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5vcGVuKGltYWdlX3BhdGgpJTIwZm9yJTIwaW1hZ2VfcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQlMEElMjAlMjAlMjAlMjB0ZXh0cyUyMCUzRCUyMGV4YW1wbGVzJTVCJ3F1ZXN0aW9uJyU1RCUyMCUyMCUyMCUyMCUwQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHRleHRzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGluZyU1QmslNUQlMjAlM0QlMjB2LnNxdWVlemUoKSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjBmb3IlMjBsYWJlbHMlMkMlMjBzY29yZXMlMjBpbiUyMHppcChleGFtcGxlcyU1QidsYWJlbC5pZHMnJTVEJTJDJTIwZXhhbXBsZXMlNUInbGFiZWwud2VpZ2h0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0JTIwJTNEJTIwdG9yY2guemVyb3MobGVuKGlkMmxhYmVsKSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCU1QmxhYmVsJTVEJTIwJTNEJTIwc2NvcmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRzLmFwcGVuZCh0YXJnZXQpJTBBJTBBJTIwJTIwJTIwJTIwZW5jb2RpbmclNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW5jb2Rpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_paths = examples[<span class="hljs-string">&#x27;image_id&#x27;</span>]
<span class="hljs-meta">... </span>    images = [Image.<span class="hljs-built_in">open</span>(image_path) <span class="hljs-keyword">for</span> image_path <span class="hljs-keyword">in</span> image_paths]
<span class="hljs-meta">... </span>    texts = examples[<span class="hljs-string">&#x27;question&#x27;</span>]    

<span class="hljs-meta">... </span>    encoding = processor(images, texts, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items():
<span class="hljs-meta">... </span>          encoding[k] = v.squeeze()
    
<span class="hljs-meta">... </span>    targets = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> labels, scores <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;label.ids&#x27;</span>], examples[<span class="hljs-string">&#x27;label.weights&#x27;</span>]):
<span class="hljs-meta">... </span>        target = torch.zeros(<span class="hljs-built_in">len</span>(id2label))

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, scores):
<span class="hljs-meta">... </span>            target[label] = score
      
<span class="hljs-meta">... </span>        targets.append(target)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;labels&quot;</span>] = targets
    
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`,wrap:!1}}),ms=new u({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXQlMjAlM0QlMjBmbGF0X2RhdGFzZXQubWFwKHByZXByb2Nlc3NfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIncXVlc3Rpb24nJTJDJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdpbWFnZV9pZCclMkMlMjAnYW5zd2VyX3R5cGUnJTJDJTIwJ2xhYmVsLmlkcyclMkMlMjAnbGFiZWwud2VpZ2h0cyclNUQpJTBBcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset = flat_dataset.<span class="hljs-built_in">map</span>(preprocess_data, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&#x27;question&#x27;</span>,<span class="hljs-string">&#x27;question_type&#x27;</span>,  <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label.ids&#x27;</span>, <span class="hljs-string">&#x27;label.weights&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;pixel_values&#x27;</span>, <span class="hljs-string">&#x27;pixel_mask&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),hs=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`,wrap:!1}}),ds=new Ys({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),us=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVmlsdEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRGxlbihpZDJsYWJlbCklMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(model_checkpoint, num_labels=<span class="hljs-built_in">len</span>(id2label), id2label=id2label, label2id=label2id)`,wrap:!1}}),Ms=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),bs=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=processed_dataset,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),js=new u({props:{code:"dHJhaW5lci50cmFpbigpJTIw",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train() ',wrap:!1}}),Js=new u({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Ts=new Ys({props:{title:"Inference",local:"inference",headingTag:"h2"}}),Us=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnZpc3VhbC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;visual-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)`,wrap:!1}}),$s=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQlMEFwcmludChxdWVzdGlvbiklMEFwaXBlKGltYWdlJTJDJTIwcXVlc3Rpb24lMkMlMjB0b3BfayUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(image, question, top_k=<span class="hljs-number">1</span>)
<span class="hljs-string">&quot;Where is he looking?&quot;</span>
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.5498199462890625</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;down&#x27;</span>}]`,wrap:!1}}),ks=new u({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwVmlsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihleGFtcGxlJTVCJ2ltYWdlX2lkJyU1RCklMEFxdWVzdGlvbiUyMCUzRCUyMGV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWlkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmlkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer:&quot;</span>, model.config.id2label[idx])
Predicted answer: down`,wrap:!1}}),Vs=new Ys({props:{title:"Zero-shot VQA",local:"zero-shot-vqa",headingTag:"h2"}}),Is=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCbGlwMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmJsaXAyLW9wdC0yLjdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcDJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZibGlwMi1vcHQtMi43YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Blip2ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Blip2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),Xs=new u({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]`,wrap:!1}}),Rs=new u({props:{code:"cHJvbXB0JTIwJTNEJTIwZiUyMlF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjBBbnN3ZXIlM0ElMjIlMjA=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span> Answer:&quot;</span> ',wrap:!1}}),Fs=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQuc3RyaXAoKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>].strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-string">&quot;He is looking at the crowd&quot;</span> `,wrap:!1}}),zs=new $a({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/visual_question_answering.md"}}),{c(){f=i("meta"),Ls=l(),As=i("p"),Ss=l(),o(j.$$.fragment),Ps=l(),o(w.$$.fragment),Ds=l(),J=i("p"),J.textContent=Ut,Ks=l(),T=i("p"),T.textContent=vt,Os=l(),x=i("ul"),x.innerHTML=$t,se=l(),U=i("p"),U.textContent=Ct,ee=l(),v=i("ul"),v.innerHTML=_t,te=l(),o($.$$.fragment),ae=l(),C=i("p"),C.innerHTML=Zt,le=l(),_=i("p"),_.textContent=kt,ne=l(),Z=i("p"),Z.textContent=Vt,ie=l(),o(k.$$.fragment),pe=l(),V=i("p"),V.textContent=Gt,re=l(),o(G.$$.fragment),oe=l(),W=i("p"),W.textContent=Wt,me=l(),o(I.$$.fragment),ce=l(),o(B.$$.fragment),he=l(),X=i("p"),X.innerHTML=It,de=l(),Q=i("p"),Q.innerHTML=Bt,ge=l(),R=i("p"),R.textContent=Xt,ue=l(),o(H.$$.fragment),fe=l(),F=i("p"),F.textContent=Qt,ye=l(),o(N.$$.fragment),Me=l(),z=i("p"),z.textContent=Rt,be=l(),Y=i("ul"),Y.innerHTML=Ht,je=l(),A=i("p"),A.textContent=Ft,we=l(),o(E.$$.fragment),Je=l(),q=i("p"),q.innerHTML=Nt,Te=l(),L=i("p"),L.textContent=zt,xe=l(),o(S.$$.fragment),Ue=l(),y=i("div"),y.innerHTML=Yt,ve=l(),P=i("p"),P.textContent=At,$e=l(),D=i("p"),D.innerHTML=Et,Ce=l(),K=i("p"),K.textContent=qt,_e=l(),o(O.$$.fragment),Ze=l(),ss=i("p"),ss.textContent=Lt,ke=l(),o(es.$$.fragment),Ve=l(),o(ts.$$.fragment),Ge=l(),as=i("p"),as.innerHTML=St,We=l(),o(ls.$$.fragment),Ie=l(),ns=i("p"),ns.innerHTML=Pt,Be=l(),is=i("p"),is.innerHTML=Dt,Xe=l(),ps=i("p"),ps.innerHTML=Kt,Qe=l(),o(rs.$$.fragment),Re=l(),os=i("p"),os.innerHTML=Ot,He=l(),o(ms.$$.fragment),Fe=l(),cs=i("p"),cs.innerHTML=sa,Ne=l(),o(hs.$$.fragment),ze=l(),o(ds.$$.fragment),Ye=l(),gs=i("p"),gs.innerHTML=ea,Ae=l(),o(us.$$.fragment),Ee=l(),fs=i("p"),fs.textContent=ta,qe=l(),ys=i("ol"),ys.innerHTML=aa,Le=l(),o(Ms.$$.fragment),Se=l(),M=i("ol"),M.innerHTML=la,Pe=l(),o(bs.$$.fragment),De=l(),b=i("ol"),b.innerHTML=na,Ke=l(),o(js.$$.fragment),Oe=l(),ws=i("p"),ws.innerHTML=ia,st=l(),o(Js.$$.fragment),et=l(),o(Ts.$$.fragment),tt=l(),xs=i("p"),xs.innerHTML=pa,at=l(),o(Us.$$.fragment),lt=l(),vs=i("p"),vs.textContent=ra,nt=l(),o($s.$$.fragment),it=l(),Cs=i("p"),Cs.textContent=oa,pt=l(),_s=i("p"),_s.textContent=ma,rt=l(),Zs=i("ol"),Zs.innerHTML=ca,ot=l(),o(ks.$$.fragment),mt=l(),o(Vs.$$.fragment),ct=l(),Gs=i("p"),Gs.innerHTML=ha,ht=l(),Ws=i("p"),Ws.innerHTML=da,dt=l(),o(Is.$$.fragment),gt=l(),Bs=i("p"),Bs.textContent=ga,ut=l(),o(Xs.$$.fragment),ft=l(),Qs=i("p"),Qs.innerHTML=ua,yt=l(),o(Rs.$$.fragment),Mt=l(),Hs=i("p"),Hs.textContent=fa,bt=l(),o(Fs.$$.fragment),jt=l(),Ns=i("p"),Ns.textContent=ya,wt=l(),o(zs.$$.fragment),Jt=l(),Es=i("p"),this.h()},l(s){const e=xa("svelte-u9bgzb",document.head);f=p(e,"META",{name:!0,content:!0}),e.forEach(t),Ls=n(s),As=p(s,"P",{}),Ma(As).forEach(t),Ss=n(s),m(j.$$.fragment,s),Ps=n(s),m(w.$$.fragment,s),Ds=n(s),J=p(s,"P",{"data-svelte-h":!0}),r(J)!=="svelte-vljp1h"&&(J.textContent=Ut),Ks=n(s),T=p(s,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1r09kty"&&(T.textContent=vt),Os=n(s),x=p(s,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-geftd8"&&(x.innerHTML=$t),se=n(s),U=p(s,"P",{"data-svelte-h":!0}),r(U)!=="svelte-jr2b5g"&&(U.textContent=Ct),ee=n(s),v=p(s,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-168wjvr"&&(v.innerHTML=_t),te=n(s),m($.$$.fragment,s),ae=n(s),C=p(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-132kvya"&&(C.innerHTML=Zt),le=n(s),_=p(s,"P",{"data-svelte-h":!0}),r(_)!=="svelte-x085ix"&&(_.textContent=kt),ne=n(s),Z=p(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-qn4ey1"&&(Z.textContent=Vt),ie=n(s),m(k.$$.fragment,s),pe=n(s),V=p(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1yqpblu"&&(V.textContent=Gt),re=n(s),m(G.$$.fragment,s),oe=n(s),W=p(s,"P",{"data-svelte-h":!0}),r(W)!=="svelte-hhk89w"&&(W.textContent=Wt),me=n(s),m(I.$$.fragment,s),ce=n(s),m(B.$$.fragment,s),he=n(s),X=p(s,"P",{"data-svelte-h":!0}),r(X)!=="svelte-n8sxxt"&&(X.innerHTML=It),de=n(s),Q=p(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-b7b4c0"&&(Q.innerHTML=Bt),ge=n(s),R=p(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-16i329z"&&(R.textContent=Xt),ue=n(s),m(H.$$.fragment,s),fe=n(s),F=p(s,"P",{"data-svelte-h":!0}),r(F)!=="svelte-10yp249"&&(F.textContent=Qt),ye=n(s),m(N.$$.fragment,s),Me=n(s),z=p(s,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1g3cog6"&&(z.textContent=Rt),be=n(s),Y=p(s,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-o5tqko"&&(Y.innerHTML=Ht),je=n(s),A=p(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-73ooet"&&(A.textContent=Ft),we=n(s),m(E.$$.fragment,s),Je=n(s),q=p(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ozbkx3"&&(q.innerHTML=Nt),Te=n(s),L=p(s,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1iqjyc4"&&(L.textContent=zt),xe=n(s),m(S.$$.fragment,s),Ue=n(s),y=p(s,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1tjg4st"&&(y.innerHTML=Yt),ve=n(s),P=p(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-7dyn3e"&&(P.textContent=At),$e=n(s),D=p(s,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1g9udhi"&&(D.innerHTML=Et),Ce=n(s),K=p(s,"P",{"data-svelte-h":!0}),r(K)!=="svelte-11t4fgj"&&(K.textContent=qt),_e=n(s),m(O.$$.fragment,s),Ze=n(s),ss=p(s,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-1p4inua"&&(ss.textContent=Lt),ke=n(s),m(es.$$.fragment,s),Ve=n(s),m(ts.$$.fragment,s),Ge=n(s),as=p(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-r2rc"&&(as.innerHTML=St),We=n(s),m(ls.$$.fragment,s),Ie=n(s),ns=p(s,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-1huutua"&&(ns.innerHTML=Pt),Be=n(s),is=p(s,"P",{"data-svelte-h":!0}),r(is)!=="svelte-kuuiuf"&&(is.innerHTML=Dt),Xe=n(s),ps=p(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-cgn1al"&&(ps.innerHTML=Kt),Qe=n(s),m(rs.$$.fragment,s),Re=n(s),os=p(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1og8o1g"&&(os.innerHTML=Ot),He=n(s),m(ms.$$.fragment,s),Fe=n(s),cs=p(s,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-1jkhkbf"&&(cs.innerHTML=sa),Ne=n(s),m(hs.$$.fragment,s),ze=n(s),m(ds.$$.fragment,s),Ye=n(s),gs=p(s,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-89w8ee"&&(gs.innerHTML=ea),Ae=n(s),m(us.$$.fragment,s),Ee=n(s),fs=p(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-l42k0i"&&(fs.textContent=ta),qe=n(s),ys=p(s,"OL",{"data-svelte-h":!0}),r(ys)!=="svelte-dhcog7"&&(ys.innerHTML=aa),Le=n(s),m(Ms.$$.fragment,s),Se=n(s),M=p(s,"OL",{start:!0,"data-svelte-h":!0}),r(M)!=="svelte-j7iq9w"&&(M.innerHTML=la),Pe=n(s),m(bs.$$.fragment,s),De=n(s),b=p(s,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-qmi5j"&&(b.innerHTML=na),Ke=n(s),m(js.$$.fragment,s),Oe=n(s),ws=p(s,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-15mx2rv"&&(ws.innerHTML=ia),st=n(s),m(Js.$$.fragment,s),et=n(s),m(Ts.$$.fragment,s),tt=n(s),xs=p(s,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-muls0b"&&(xs.innerHTML=pa),at=n(s),m(Us.$$.fragment,s),lt=n(s),vs=p(s,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1lvulzt"&&(vs.textContent=ra),nt=n(s),m($s.$$.fragment,s),it=n(s),Cs=p(s,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-mc0cvg"&&(Cs.textContent=oa),pt=n(s),_s=p(s,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-o6117l"&&(_s.textContent=ma),rt=n(s),Zs=p(s,"OL",{"data-svelte-h":!0}),r(Zs)!=="svelte-346f3f"&&(Zs.innerHTML=ca),ot=n(s),m(ks.$$.fragment,s),mt=n(s),m(Vs.$$.fragment,s),ct=n(s),Gs=p(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-4nhby3"&&(Gs.innerHTML=ha),ht=n(s),Ws=p(s,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-bcj04n"&&(Ws.innerHTML=da),dt=n(s),m(Is.$$.fragment,s),gt=n(s),Bs=p(s,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-w113ee"&&(Bs.textContent=ga),ut=n(s),m(Xs.$$.fragment,s),ft=n(s),Qs=p(s,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-n2zykh"&&(Qs.innerHTML=ua),yt=n(s),m(Rs.$$.fragment,s),Mt=n(s),Hs=p(s,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-10l7d2y"&&(Hs.textContent=fa),bt=n(s),m(Fs.$$.fragment,s),jt=n(s),Ns=p(s,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-1wjg6co"&&(Ns.textContent=ya),wt=n(s),m(zs.$$.fragment,s),Jt=n(s),Es=p(s,"P",{}),Ma(Es).forEach(t),this.h()},h(){qs(f,"name","hf:doc:metadata"),qs(f,"content",_a),qs(y,"class","flex justify-center"),qs(M,"start","2"),qs(b,"start","3")},m(s,e){Ua(document.head,f),a(s,Ls,e),a(s,As,e),a(s,Ss,e),c(j,s,e),a(s,Ps,e),c(w,s,e),a(s,Ds,e),a(s,J,e),a(s,Ks,e),a(s,T,e),a(s,Os,e),a(s,x,e),a(s,se,e),a(s,U,e),a(s,ee,e),a(s,v,e),a(s,te,e),c($,s,e),a(s,ae,e),a(s,C,e),a(s,le,e),a(s,_,e),a(s,ne,e),a(s,Z,e),a(s,ie,e),c(k,s,e),a(s,pe,e),a(s,V,e),a(s,re,e),c(G,s,e),a(s,oe,e),a(s,W,e),a(s,me,e),c(I,s,e),a(s,ce,e),c(B,s,e),a(s,he,e),a(s,X,e),a(s,de,e),a(s,Q,e),a(s,ge,e),a(s,R,e),a(s,ue,e),c(H,s,e),a(s,fe,e),a(s,F,e),a(s,ye,e),c(N,s,e),a(s,Me,e),a(s,z,e),a(s,be,e),a(s,Y,e),a(s,je,e),a(s,A,e),a(s,we,e),c(E,s,e),a(s,Je,e),a(s,q,e),a(s,Te,e),a(s,L,e),a(s,xe,e),c(S,s,e),a(s,Ue,e),a(s,y,e),a(s,ve,e),a(s,P,e),a(s,$e,e),a(s,D,e),a(s,Ce,e),a(s,K,e),a(s,_e,e),c(O,s,e),a(s,Ze,e),a(s,ss,e),a(s,ke,e),c(es,s,e),a(s,Ve,e),c(ts,s,e),a(s,Ge,e),a(s,as,e),a(s,We,e),c(ls,s,e),a(s,Ie,e),a(s,ns,e),a(s,Be,e),a(s,is,e),a(s,Xe,e),a(s,ps,e),a(s,Qe,e),c(rs,s,e),a(s,Re,e),a(s,os,e),a(s,He,e),c(ms,s,e),a(s,Fe,e),a(s,cs,e),a(s,Ne,e),c(hs,s,e),a(s,ze,e),c(ds,s,e),a(s,Ye,e),a(s,gs,e),a(s,Ae,e),c(us,s,e),a(s,Ee,e),a(s,fs,e),a(s,qe,e),a(s,ys,e),a(s,Le,e),c(Ms,s,e),a(s,Se,e),a(s,M,e),a(s,Pe,e),c(bs,s,e),a(s,De,e),a(s,b,e),a(s,Ke,e),c(js,s,e),a(s,Oe,e),a(s,ws,e),a(s,st,e),c(Js,s,e),a(s,et,e),c(Ts,s,e),a(s,tt,e),a(s,xs,e),a(s,at,e),c(Us,s,e),a(s,lt,e),a(s,vs,e),a(s,nt,e),c($s,s,e),a(s,it,e),a(s,Cs,e),a(s,pt,e),a(s,_s,e),a(s,rt,e),a(s,Zs,e),a(s,ot,e),c(ks,s,e),a(s,mt,e),c(Vs,s,e),a(s,ct,e),a(s,Gs,e),a(s,ht,e),a(s,Ws,e),a(s,dt,e),c(Is,s,e),a(s,gt,e),a(s,Bs,e),a(s,ut,e),c(Xs,s,e),a(s,ft,e),a(s,Qs,e),a(s,yt,e),c(Rs,s,e),a(s,Mt,e),a(s,Hs,e),a(s,bt,e),c(Fs,s,e),a(s,jt,e),a(s,Ns,e),a(s,wt,e),c(zs,s,e),a(s,Jt,e),a(s,Es,e),Tt=!0},p:ja,i(s){Tt||(h(j.$$.fragment,s),h(w.$$.fragment,s),h($.$$.fragment,s),h(k.$$.fragment,s),h(G.$$.fragment,s),h(I.$$.fragment,s),h(B.$$.fragment,s),h(H.$$.fragment,s),h(N.$$.fragment,s),h(E.$$.fragment,s),h(S.$$.fragment,s),h(O.$$.fragment,s),h(es.$$.fragment,s),h(ts.$$.fragment,s),h(ls.$$.fragment,s),h(rs.$$.fragment,s),h(ms.$$.fragment,s),h(hs.$$.fragment,s),h(ds.$$.fragment,s),h(us.$$.fragment,s),h(Ms.$$.fragment,s),h(bs.$$.fragment,s),h(js.$$.fragment,s),h(Js.$$.fragment,s),h(Ts.$$.fragment,s),h(Us.$$.fragment,s),h($s.$$.fragment,s),h(ks.$$.fragment,s),h(Vs.$$.fragment,s),h(Is.$$.fragment,s),h(Xs.$$.fragment,s),h(Rs.$$.fragment,s),h(Fs.$$.fragment,s),h(zs.$$.fragment,s),Tt=!0)},o(s){d(j.$$.fragment,s),d(w.$$.fragment,s),d($.$$.fragment,s),d(k.$$.fragment,s),d(G.$$.fragment,s),d(I.$$.fragment,s),d(B.$$.fragment,s),d(H.$$.fragment,s),d(N.$$.fragment,s),d(E.$$.fragment,s),d(S.$$.fragment,s),d(O.$$.fragment,s),d(es.$$.fragment,s),d(ts.$$.fragment,s),d(ls.$$.fragment,s),d(rs.$$.fragment,s),d(ms.$$.fragment,s),d(hs.$$.fragment,s),d(ds.$$.fragment,s),d(us.$$.fragment,s),d(Ms.$$.fragment,s),d(bs.$$.fragment,s),d(js.$$.fragment,s),d(Js.$$.fragment,s),d(Ts.$$.fragment,s),d(Us.$$.fragment,s),d($s.$$.fragment,s),d(ks.$$.fragment,s),d(Vs.$$.fragment,s),d(Is.$$.fragment,s),d(Xs.$$.fragment,s),d(Rs.$$.fragment,s),d(Fs.$$.fragment,s),d(zs.$$.fragment,s),Tt=!1},d(s){s&&(t(Ls),t(As),t(Ss),t(Ps),t(Ds),t(J),t(Ks),t(T),t(Os),t(x),t(se),t(U),t(ee),t(v),t(te),t(ae),t(C),t(le),t(_),t(ne),t(Z),t(ie),t(pe),t(V),t(re),t(oe),t(W),t(me),t(ce),t(he),t(X),t(de),t(Q),t(ge),t(R),t(ue),t(fe),t(F),t(ye),t(Me),t(z),t(be),t(Y),t(je),t(A),t(we),t(Je),t(q),t(Te),t(L),t(xe),t(Ue),t(y),t(ve),t(P),t($e),t(D),t(Ce),t(K),t(_e),t(Ze),t(ss),t(ke),t(Ve),t(Ge),t(as),t(We),t(Ie),t(ns),t(Be),t(is),t(Xe),t(ps),t(Qe),t(Re),t(os),t(He),t(Fe),t(cs),t(Ne),t(ze),t(Ye),t(gs),t(Ae),t(Ee),t(fs),t(qe),t(ys),t(Le),t(Se),t(M),t(Pe),t(De),t(b),t(Ke),t(Oe),t(ws),t(st),t(et),t(tt),t(xs),t(at),t(lt),t(vs),t(nt),t(it),t(Cs),t(pt),t(_s),t(rt),t(Zs),t(ot),t(mt),t(ct),t(Gs),t(ht),t(Ws),t(dt),t(gt),t(Bs),t(ut),t(ft),t(Qs),t(yt),t(Mt),t(Hs),t(bt),t(jt),t(Ns),t(wt),t(Jt),t(Es)),t(f),g(j,s),g(w,s),g($,s),g(k,s),g(G,s),g(I,s),g(B,s),g(H,s),g(N,s),g(E,s),g(S,s),g(O,s),g(es,s),g(ts,s),g(ls,s),g(rs,s),g(ms,s),g(hs,s),g(ds,s),g(us,s),g(Ms,s),g(bs,s),g(js,s),g(Js,s),g(Ts,s),g(Us,s),g($s,s),g(ks,s),g(Vs,s),g(Is,s),g(Xs,s),g(Rs,s),g(Fs,s),g(zs,s)}}}const _a='{"title":"Visual Question Answering","local":"visual-question-answering","sections":[{"title":"Fine-tuning ViLT","local":"fine-tuning-vilt","sections":[],"depth":2},{"title":"Load the data","local":"load-the-data","sections":[],"depth":2},{"title":"Preprocessing data","local":"preprocessing-data","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Zero-shot VQA","local":"zero-shot-vqa","sections":[],"depth":2}],"depth":1}';function Za(xt){return wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ba extends Ja{constructor(f){super(),Ta(this,f,Za,Ca,ba,{})}}export{Ba as component};
