import{s as ot,n as it,o as pt}from"../chunks/scheduler.f6319a2a.js";import{S as yt,i as Ut,g as M,s as n,r as p,A as ut,h as o,f as s,c as a,j as at,u as y,x as i,k as Mt,y as rt,a as e,v as U,d as u,t as r,w as J}from"../chunks/index.85aa684c.js";import{C as T}from"../chunks/CodeBlock.97b48fd2.js";import{D as Jt}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as Nl,E as ct}from"../chunks/EditOnGithub.006048dd.js";function Tt(kl){let c,O,P,ll,j,tl,w,sl,m,El="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",el,b,Rl="<p>Let’s start with the golden question: why not keep it simple and use a standard text-to-SQL pipeline?</p>",nl,h,Gl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",al,d,Xl="👉 Instead, an agent system is able to critically inspect outputs and decide if the query needs to be changed or not, thus giving it a huge performance boost.",Ml,I,Vl="Let’s build this agent! 💪",ol,C,xl="First, we setup the SQL environment:",il,g,pl,B,yl,f,Hl="Now let’s make our SQL table retrievable by a tool.",Ul,Q,$l="The tool’s description attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. This is where we want to describe the SQL table.",ul,q,rl,v,Jl,S,Yl='Now let’s build our tool. It needs the following: (read <a href="../tutorials/tools">the tool doc</a> for more detail)',cl,W,Fl="<li>A docstring with an <code>Args:</code> part listing arguments.</li> <li>Type hints on both inputs and output.</li>",Tl,Z,jl,A,zl="Now let us create an agent that leverages this tool.",wl,_,Ll="We use the <code>CodeAgent</code>, which is smolagents’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",ml,N,Dl="The model is the LLM that powers the agent system. <code>HfApiModel</code> allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API.",bl,k,hl,E,dl,R,Pl="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Il,G,Kl="So let’s make a second table recording the names of waiters for each receipt_id!",Cl,X,gl,V,Ol="Since we changed the table, we update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",Bl,x,fl,H,lt='Since this request is a bit harder than the previous one, we’ll switch the LLM engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>!',Ql,$,ql,Y,tt="It directly works! The setup was surprisingly simple, wasn’t it?",vl,F,st="This example is done! We’ve touched upon these concepts:",Sl,z,et="<li>Building new tools.</li> <li>Updating a tool’s description.</li> <li>Switching to a stronger LLM helps agent reasoning.</li>",Wl,L,nt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",Zl,D,Al,K,_l;return j=new Nl({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),w=new Jt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"}]}}),g=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">insert_rows_into_table</span>(<span class="hljs-params">rows, table, engine=engine</span>):
    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
        stmt = insert(table).values(**row)
        <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
            connection.execute(stmt)

table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
insert_rows_into_table(rows, receipts)`,wrap:!1}}),B=new Nl({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h3"}}),q=new T({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),v=new T({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),Z=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),k=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzcWxfZW5naW5lJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RIZkFwaU1vZGVsKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS04Qi1JbnN0cnVjdCUyMiklMkMlMEEpJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),E=new Nl({props:{title:"Level 2: Table joins",local:"level-2-table-joins",headingTag:"h3"}}),X=new T({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEF3YWl0ZXJzJTIwJTNEJTIwVGFibGUoJTBBJTIwJTIwJTIwJTIwdGFibGVfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhX29iaiUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJyZWNlaXB0X2lkJTIyJTJDJTIwSW50ZWdlciUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIyd2FpdGVyX25hbWUlMjIlMkMlMjBTdHJpbmcoMTYpJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSklMEFtZXRhZGF0YV9vYmouY3JlYXRlX2FsbChlbmdpbmUpJTBBJTBBcm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJDb3JleSUyMEpvaG5zb24lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMiUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWljaGFlbCUyMFdhdHRzJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDMlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjA0JTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTdEJTJDJTBBJTVEJTBBaW5zZXJ0X3Jvd3NfaW50b190YWJsZShyb3dzJTJDJTIwd2FpdGVycyk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
waiters = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
insert_rows_into_table(rows, waiters)`,wrap:!1}}),x=new T({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),$=new T({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREhmQXBpTW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),D=new ct({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/text_to_sql.md"}}),{c(){c=M("meta"),O=n(),P=M("p"),ll=n(),p(j.$$.fragment),tl=n(),p(w.$$.fragment),sl=n(),m=M("p"),m.innerHTML=El,el=n(),b=M("blockquote"),b.innerHTML=Rl,nl=n(),h=M("p"),h.textContent=Gl,al=n(),d=M("p"),d.textContent=Xl,Ml=n(),I=M("p"),I.textContent=Vl,ol=n(),C=M("p"),C.textContent=xl,il=n(),p(g.$$.fragment),pl=n(),p(B.$$.fragment),yl=n(),f=M("p"),f.textContent=Hl,Ul=n(),Q=M("p"),Q.textContent=$l,ul=n(),p(q.$$.fragment),rl=n(),p(v.$$.fragment),Jl=n(),S=M("p"),S.innerHTML=Yl,cl=n(),W=M("ul"),W.innerHTML=Fl,Tl=n(),p(Z.$$.fragment),jl=n(),A=M("p"),A.textContent=zl,wl=n(),_=M("p"),_.innerHTML=Ll,ml=n(),N=M("p"),N.innerHTML=Dl,bl=n(),p(k.$$.fragment),hl=n(),p(E.$$.fragment),dl=n(),R=M("p"),R.textContent=Pl,Il=n(),G=M("p"),G.textContent=Kl,Cl=n(),p(X.$$.fragment),gl=n(),V=M("p"),V.innerHTML=Ol,Bl=n(),p(x.$$.fragment),fl=n(),H=M("p"),H.innerHTML=lt,Ql=n(),p($.$$.fragment),ql=n(),Y=M("p"),Y.textContent=tt,vl=n(),F=M("p"),F.textContent=st,Sl=n(),z=M("ul"),z.innerHTML=et,Wl=n(),L=M("p"),L.textContent=nt,Zl=n(),p(D.$$.fragment),Al=n(),K=M("p"),this.h()},l(l){const t=ut("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(s),O=a(l),P=o(l,"P",{}),at(P).forEach(s),ll=a(l),y(j.$$.fragment,l),tl=a(l),y(w.$$.fragment,l),sl=a(l),m=o(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1rrh2b0"&&(m.innerHTML=El),el=a(l),b=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(b)!=="svelte-1yhwgse"&&(b.innerHTML=Rl),nl=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1hw7g6s"&&(h.textContent=Gl),al=a(l),d=o(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-i6rawm"&&(d.textContent=Xl),Ml=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1tzrwc8"&&(I.textContent=Vl),ol=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-sjpq7n"&&(C.textContent=xl),il=a(l),y(g.$$.fragment,l),pl=a(l),y(B.$$.fragment,l),yl=a(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-fdu5cw"&&(f.textContent=Hl),Ul=a(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-groxlc"&&(Q.textContent=$l),ul=a(l),y(q.$$.fragment,l),rl=a(l),y(v.$$.fragment,l),Jl=a(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1snt6vj"&&(S.innerHTML=Yl),cl=a(l),W=o(l,"UL",{"data-svelte-h":!0}),i(W)!=="svelte-idbd3h"&&(W.innerHTML=Fl),Tl=a(l),y(Z.$$.fragment,l),jl=a(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1t4r7cu"&&(A.textContent=zl),wl=a(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-sv1k2f"&&(_.innerHTML=Ll),ml=a(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1krfyi9"&&(N.innerHTML=Dl),bl=a(l),y(k.$$.fragment,l),hl=a(l),y(E.$$.fragment,l),dl=a(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-nr3fl7"&&(R.textContent=Pl),Il=a(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1ru0803"&&(G.textContent=Kl),Cl=a(l),y(X.$$.fragment,l),gl=a(l),V=o(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-l5upel"&&(V.innerHTML=Ol),Bl=a(l),y(x.$$.fragment,l),fl=a(l),H=o(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1uns4lf"&&(H.innerHTML=lt),Ql=a(l),y($.$$.fragment,l),ql=a(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1umn140"&&(Y.textContent=tt),vl=a(l),F=o(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-13g6phr"&&(F.textContent=st),Sl=a(l),z=o(l,"UL",{"data-svelte-h":!0}),i(z)!=="svelte-1pz5sot"&&(z.innerHTML=et),Wl=a(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-bt1f1w"&&(L.textContent=nt),Zl=a(l),y(D.$$.fragment,l),Al=a(l),K=o(l,"P",{}),at(K).forEach(s),this.h()},h(){Mt(c,"name","hf:doc:metadata"),Mt(c,"content",jt)},m(l,t){rt(document.head,c),e(l,O,t),e(l,P,t),e(l,ll,t),U(j,l,t),e(l,tl,t),U(w,l,t),e(l,sl,t),e(l,m,t),e(l,el,t),e(l,b,t),e(l,nl,t),e(l,h,t),e(l,al,t),e(l,d,t),e(l,Ml,t),e(l,I,t),e(l,ol,t),e(l,C,t),e(l,il,t),U(g,l,t),e(l,pl,t),U(B,l,t),e(l,yl,t),e(l,f,t),e(l,Ul,t),e(l,Q,t),e(l,ul,t),U(q,l,t),e(l,rl,t),U(v,l,t),e(l,Jl,t),e(l,S,t),e(l,cl,t),e(l,W,t),e(l,Tl,t),U(Z,l,t),e(l,jl,t),e(l,A,t),e(l,wl,t),e(l,_,t),e(l,ml,t),e(l,N,t),e(l,bl,t),U(k,l,t),e(l,hl,t),U(E,l,t),e(l,dl,t),e(l,R,t),e(l,Il,t),e(l,G,t),e(l,Cl,t),U(X,l,t),e(l,gl,t),e(l,V,t),e(l,Bl,t),U(x,l,t),e(l,fl,t),e(l,H,t),e(l,Ql,t),U($,l,t),e(l,ql,t),e(l,Y,t),e(l,vl,t),e(l,F,t),e(l,Sl,t),e(l,z,t),e(l,Wl,t),e(l,L,t),e(l,Zl,t),U(D,l,t),e(l,Al,t),e(l,K,t),_l=!0},p:it,i(l){_l||(u(j.$$.fragment,l),u(w.$$.fragment,l),u(g.$$.fragment,l),u(B.$$.fragment,l),u(q.$$.fragment,l),u(v.$$.fragment,l),u(Z.$$.fragment,l),u(k.$$.fragment,l),u(E.$$.fragment,l),u(X.$$.fragment,l),u(x.$$.fragment,l),u($.$$.fragment,l),u(D.$$.fragment,l),_l=!0)},o(l){r(j.$$.fragment,l),r(w.$$.fragment,l),r(g.$$.fragment,l),r(B.$$.fragment,l),r(q.$$.fragment,l),r(v.$$.fragment,l),r(Z.$$.fragment,l),r(k.$$.fragment,l),r(E.$$.fragment,l),r(X.$$.fragment,l),r(x.$$.fragment,l),r($.$$.fragment,l),r(D.$$.fragment,l),_l=!1},d(l){l&&(s(O),s(P),s(ll),s(tl),s(sl),s(m),s(el),s(b),s(nl),s(h),s(al),s(d),s(Ml),s(I),s(ol),s(C),s(il),s(pl),s(yl),s(f),s(Ul),s(Q),s(ul),s(rl),s(Jl),s(S),s(cl),s(W),s(Tl),s(jl),s(A),s(wl),s(_),s(ml),s(N),s(bl),s(hl),s(dl),s(R),s(Il),s(G),s(Cl),s(gl),s(V),s(Bl),s(fl),s(H),s(Ql),s(ql),s(Y),s(vl),s(F),s(Sl),s(z),s(Wl),s(L),s(Zl),s(Al),s(K)),s(c),J(j,l),J(w,l),J(g,l),J(B,l),J(q,l),J(v,l),J(Z,l),J(k,l),J(E,l),J(X,l),J(x,l),J($,l),J(D,l)}}}const jt='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":3},{"title":"Level 2: Table joins","local":"level-2-table-joins","sections":[],"depth":3}],"depth":1}';function wt(kl){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends yt{constructor(c){super(),Ut(this,c,wt,Tt,ot,{})}}export{Ct as component};
