import{s as Wl,o as Il,n as Ll}from"../chunks/scheduler.c57aa7ef.js";import{S as Gl,i as Al,g as i,s,r as p,A as Ql,h as o,f as a,c as n,j as Cl,u as d,x as r,k as Ga,y as Vl,a as l,v as m,d as f,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as Bl}from"../chunks/Tip.9268b0ca.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as y,E as Xl}from"../chunks/EditOnGithub.958a8a49.js";function xl(et){let c,b='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=b},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=b)},m(w,g){l(w,c,g)},p:Ll,d(w){w&&a(c)}}}function Hl(et){let c,b='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=b},l(w){c=o(w,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=b)},m(w,g){l(w,c,g)},p:Ll,d(w){w&&a(c)}}}function ql(et){let c,b,w,g,$,at,Z,Aa='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/pr_1857/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/pr_1857/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',lt,j,Qa="This guide explores in more detail other options and features for using LoRA.",st,v,nt,U,Va='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',it,k,Xa='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',ot,R,rt,C,xa="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",pt,B,dt,L,mt,W,Ha='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',ft,I,qa="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",ht,G,ut,A,Fa="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",ct,Q,Mt,V,za='For detailed instruction on using PiSSA, please follow <a href="https://github.com/fxmeng/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',wt,X,yt,x,Ea='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',bt,H,Ya="You just need to pass a single additional option to use OLoRA:",gt,q,Tt,F,Na='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',Jt,z,_t,E,$t,Y,Sa='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Zt,N,Pa="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",jt,S,vt,P,Da="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Ut,D,kt,K,Ka='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Rt,O,Oa="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Ct,ee,el="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",Bt,te,tl="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Lt,T,Wt,ae,It,le,al='Another way to initialize <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Gt,se,At,ne,Qt,ie,ll='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Vt,oe,Xt,re,sl="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",xt,pe,Ht,de,nl="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",qt,me,Ft,fe,zt,he,il='<li>DoRA only supports linear and Conv2d layers at the momement.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Et,ue,Yt,ce,ol='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Nt,Me,St,we,Pt,ye,rl='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Dt,be,Kt,ge,pl='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adpaters.',Ot,Te,dl=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,ea,Je,ta,_e,ml='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',aa,$e,fl="Below is a diagram that explains the intuition of LoRA adapter merging:",la,J,hl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',sa,Ze,ul="We show in the snippets below how to run that using PEFT.",na,je,ia,ve,cl='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/pr_1857/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/pr_1857/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',oa,Ue,ra,ke,Ml='The <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',pa,Re,wl="First load the base model:",da,Ce,ma,Be,yl="Then we load the first adapter:",fa,Le,ha,We,bl="Then load a different adapter and merge it with the first one:",ua,Ie,ca,_,Ma,Ge,gl="Now, perform inference:",wa,Ae,ya,Qe,ba,Ve,Tl='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/pr_1857/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',ga,Xe,Ta,xe,Jl='To return the base model, you could use <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/pr_1857/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Ja,He,_a,qe,$a,Fe,_l="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Za,ze,$l="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an examle of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",ja,Ee,va,Ye,Zl="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Ua,Ne,ka,Se,jl="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",Ra,Pe,Ca,De,vl="Using this features has some drawbacks, namely:",Ba,Ke,Ul='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',La,Oe,Wa,tt,Ia;return $=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),v=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),R=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),L=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),G=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),Q=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),X=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),q=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),z=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),E=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),S=new y({props:{title:"A more convienient way",local:"a-more-convienient-way",headingTag:"h4"}}),D=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),T=new Bl({props:{$$slots:{default:[xl]},$$scope:{ctx:et}}}),ae=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),se=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ne=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),oe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),pe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),me=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),fe=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),ue=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Me=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),we=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),be=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),Je=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),je=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),Ue=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Ce=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Le=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Ie=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),_=new Bl({props:{$$slots:{default:[Hl]},$$scope:{ctx:et}}}),Ae=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Qe=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Xe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),He=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),qe=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),Ne=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Pe=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),Oe=new Xl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),b=s(),w=i("p"),g=s(),p($.$$.fragment),at=s(),Z=i("p"),Z.innerHTML=Aa,lt=s(),j=i("p"),j.textContent=Qa,st=s(),p(v.$$.fragment),nt=s(),U=i("p"),U.innerHTML=Va,it=s(),k=i("p"),k.innerHTML=Xa,ot=s(),p(R.$$.fragment),rt=s(),C=i("p"),C.innerHTML=xa,pt=s(),p(B.$$.fragment),dt=s(),p(L.$$.fragment),mt=s(),W=i("p"),W.innerHTML=Ha,ft=s(),I=i("p"),I.textContent=qa,ht=s(),p(G.$$.fragment),ut=s(),A=i("p"),A.textContent=Fa,ct=s(),p(Q.$$.fragment),Mt=s(),V=i("p"),V.innerHTML=za,wt=s(),p(X.$$.fragment),yt=s(),x=i("p"),x.innerHTML=Ea,bt=s(),H=i("p"),H.textContent=Ya,gt=s(),p(q.$$.fragment),Tt=s(),F=i("p"),F.innerHTML=Na,Jt=s(),p(z.$$.fragment),_t=s(),p(E.$$.fragment),$t=s(),Y=i("p"),Y.innerHTML=Sa,Zt=s(),N=i("p"),N.innerHTML=Pa,jt=s(),p(S.$$.fragment),vt=s(),P=i("p"),P.innerHTML=Da,Ut=s(),p(D.$$.fragment),kt=s(),K=i("p"),K.innerHTML=Ka,Rt=s(),O=i("p"),O.innerHTML=Oa,Ct=s(),ee=i("p"),ee.innerHTML=el,Bt=s(),te=i("ul"),te.innerHTML=tl,Lt=s(),p(T.$$.fragment),Wt=s(),p(ae.$$.fragment),It=s(),le=i("p"),le.innerHTML=al,Gt=s(),p(se.$$.fragment),At=s(),p(ne.$$.fragment),Qt=s(),ie=i("p"),ie.innerHTML=ll,Vt=s(),p(oe.$$.fragment),Xt=s(),re=i("p"),re.innerHTML=sl,xt=s(),p(pe.$$.fragment),Ht=s(),de=i("p"),de.innerHTML=nl,qt=s(),p(me.$$.fragment),Ft=s(),p(fe.$$.fragment),zt=s(),he=i("ul"),he.innerHTML=il,Et=s(),p(ue.$$.fragment),Yt=s(),ce=i("p"),ce.innerHTML=ol,Nt=s(),p(Me.$$.fragment),St=s(),p(we.$$.fragment),Pt=s(),ye=i("p"),ye.innerHTML=rl,Dt=s(),p(be.$$.fragment),Kt=s(),ge=i("p"),ge.innerHTML=pl,Ot=s(),Te=i("p"),Te.innerHTML=dl,ea=s(),p(Je.$$.fragment),ta=s(),_e=i("p"),_e.innerHTML=ml,aa=s(),$e=i("p"),$e.textContent=fl,la=s(),J=i("div"),J.innerHTML=hl,sa=s(),Ze=i("p"),Ze.textContent=ul,na=s(),p(je.$$.fragment),ia=s(),ve=i("p"),ve.innerHTML=cl,oa=s(),p(Ue.$$.fragment),ra=s(),ke=i("p"),ke.innerHTML=Ml,pa=s(),Re=i("p"),Re.textContent=wl,da=s(),p(Ce.$$.fragment),ma=s(),Be=i("p"),Be.textContent=yl,fa=s(),p(Le.$$.fragment),ha=s(),We=i("p"),We.textContent=bl,ua=s(),p(Ie.$$.fragment),ca=s(),p(_.$$.fragment),Ma=s(),Ge=i("p"),Ge.textContent=gl,wa=s(),p(Ae.$$.fragment),ya=s(),p(Qe.$$.fragment),ba=s(),Ve=i("p"),Ve.innerHTML=Tl,ga=s(),p(Xe.$$.fragment),Ta=s(),xe=i("p"),xe.innerHTML=Jl,Ja=s(),p(He.$$.fragment),_a=s(),p(qe.$$.fragment),$a=s(),Fe=i("p"),Fe.textContent=_l,Za=s(),ze=i("p"),ze.innerHTML=$l,ja=s(),p(Ee.$$.fragment),va=s(),Ye=i("p"),Ye.innerHTML=Zl,Ua=s(),p(Ne.$$.fragment),ka=s(),Se=i("p"),Se.innerHTML=jl,Ra=s(),p(Pe.$$.fragment),Ca=s(),De=i("p"),De.textContent=vl,Ba=s(),Ke=i("ul"),Ke.innerHTML=Ul,La=s(),p(Oe.$$.fragment),Wa=s(),tt=i("p"),this.h()},l(e){const t=Ql("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),b=n(e),w=o(e,"P",{}),Cl(w).forEach(a),g=n(e),d($.$$.fragment,e),at=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-lp55s5"&&(Z.innerHTML=Aa),lt=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ovsn32"&&(j.textContent=Qa),st=n(e),d(v.$$.fragment,e),nt=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1xhnn2s"&&(U.innerHTML=Va),it=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1fujb7a"&&(k.innerHTML=Xa),ot=n(e),d(R.$$.fragment,e),rt=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-mwvui1"&&(C.innerHTML=xa),pt=n(e),d(B.$$.fragment,e),dt=n(e),d(L.$$.fragment,e),mt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1skluc"&&(W.innerHTML=Ha),ft=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1hy0lgx"&&(I.textContent=qa),ht=n(e),d(G.$$.fragment,e),ut=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-auzrbb"&&(A.textContent=Fa),ct=n(e),d(Q.$$.fragment,e),Mt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-u5znzv"&&(V.innerHTML=za),wt=n(e),d(X.$$.fragment,e),yt=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-17kc0j8"&&(x.innerHTML=Ea),bt=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1j9g8qn"&&(H.textContent=Ya),gt=n(e),d(q.$$.fragment,e),Tt=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-sulxp4"&&(F.innerHTML=Na),Jt=n(e),d(z.$$.fragment,e),_t=n(e),d(E.$$.fragment,e),$t=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ts8vpq"&&(Y.innerHTML=Sa),Zt=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-7f0aai"&&(N.innerHTML=Pa),jt=n(e),d(S.$$.fragment,e),vt=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-14vtcq9"&&(P.innerHTML=Da),Ut=n(e),d(D.$$.fragment,e),kt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1nywyxh"&&(K.innerHTML=Ka),Rt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1d2jix1"&&(O.innerHTML=Oa),Ct=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-yl8kok"&&(ee.innerHTML=el),Bt=n(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-12tl4fy"&&(te.innerHTML=tl),Lt=n(e),d(T.$$.fragment,e),Wt=n(e),d(ae.$$.fragment,e),It=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1y5tkxc"&&(le.innerHTML=al),Gt=n(e),d(se.$$.fragment,e),At=n(e),d(ne.$$.fragment,e),Qt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ukfkwt"&&(ie.innerHTML=ll),Vt=n(e),d(oe.$$.fragment,e),Xt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-8wzhde"&&(re.innerHTML=sl),xt=n(e),d(pe.$$.fragment,e),Ht=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-16lyt50"&&(de.innerHTML=nl),qt=n(e),d(me.$$.fragment,e),Ft=n(e),d(fe.$$.fragment,e),zt=n(e),he=o(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-1kxp9oz"&&(he.innerHTML=il),Et=n(e),d(ue.$$.fragment,e),Yt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-15vxux2"&&(ce.innerHTML=ol),Nt=n(e),d(Me.$$.fragment,e),St=n(e),d(we.$$.fragment,e),Pt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1mosto0"&&(ye.innerHTML=rl),Dt=n(e),d(be.$$.fragment,e),Kt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1safyei"&&(ge.innerHTML=pl),Ot=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-foj0wd"&&(Te.innerHTML=dl),ea=n(e),d(Je.$$.fragment,e),ta=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-bw1ypc"&&(_e.innerHTML=ml),aa=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1wwmf5r"&&($e.textContent=fl),la=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1f6iuw5"&&(J.innerHTML=hl),sa=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-hlzwis"&&(Ze.textContent=ul),na=n(e),d(je.$$.fragment,e),ia=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-9mgwq9"&&(ve.innerHTML=cl),oa=n(e),d(Ue.$$.fragment,e),ra=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-11tu9we"&&(ke.innerHTML=Ml),pa=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1mwdwt1"&&(Re.textContent=wl),da=n(e),d(Ce.$$.fragment,e),ma=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-nuhu05"&&(Be.textContent=yl),fa=n(e),d(Le.$$.fragment,e),ha=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1n53hd9"&&(We.textContent=bl),ua=n(e),d(Ie.$$.fragment,e),ca=n(e),d(_.$$.fragment,e),Ma=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-qwbdkg"&&(Ge.textContent=gl),wa=n(e),d(Ae.$$.fragment,e),ya=n(e),d(Qe.$$.fragment,e),ba=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-17ak8jm"&&(Ve.innerHTML=Tl),ga=n(e),d(Xe.$$.fragment,e),Ta=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1d6ehsq"&&(xe.innerHTML=Jl),Ja=n(e),d(He.$$.fragment,e),_a=n(e),d(qe.$$.fragment,e),$a=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1fq5tpu"&&(Fe.textContent=_l),Za=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-6zt8d6"&&(ze.innerHTML=$l),ja=n(e),d(Ee.$$.fragment,e),va=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-6wkyom"&&(Ye.innerHTML=Zl),Ua=n(e),d(Ne.$$.fragment,e),ka=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1o40ch6"&&(Se.innerHTML=jl),Ra=n(e),d(Pe.$$.fragment,e),Ca=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-fpz5mj"&&(De.textContent=vl),Ba=n(e),Ke=o(e,"UL",{"data-svelte-h":!0}),r(Ke)!=="svelte-1jk1r7d"&&(Ke.innerHTML=Ul),La=n(e),d(Oe.$$.fragment,e),Wa=n(e),tt=o(e,"P",{}),Cl(tt).forEach(a),this.h()},h(){Ga(c,"name","hf:doc:metadata"),Ga(c,"content",Fl),Ga(J,"class","flex justify-center")},m(e,t){Vl(document.head,c),l(e,b,t),l(e,w,t),l(e,g,t),m($,e,t),l(e,at,t),l(e,Z,t),l(e,lt,t),l(e,j,t),l(e,st,t),m(v,e,t),l(e,nt,t),l(e,U,t),l(e,it,t),l(e,k,t),l(e,ot,t),m(R,e,t),l(e,rt,t),l(e,C,t),l(e,pt,t),m(B,e,t),l(e,dt,t),m(L,e,t),l(e,mt,t),l(e,W,t),l(e,ft,t),l(e,I,t),l(e,ht,t),m(G,e,t),l(e,ut,t),l(e,A,t),l(e,ct,t),m(Q,e,t),l(e,Mt,t),l(e,V,t),l(e,wt,t),m(X,e,t),l(e,yt,t),l(e,x,t),l(e,bt,t),l(e,H,t),l(e,gt,t),m(q,e,t),l(e,Tt,t),l(e,F,t),l(e,Jt,t),m(z,e,t),l(e,_t,t),m(E,e,t),l(e,$t,t),l(e,Y,t),l(e,Zt,t),l(e,N,t),l(e,jt,t),m(S,e,t),l(e,vt,t),l(e,P,t),l(e,Ut,t),m(D,e,t),l(e,kt,t),l(e,K,t),l(e,Rt,t),l(e,O,t),l(e,Ct,t),l(e,ee,t),l(e,Bt,t),l(e,te,t),l(e,Lt,t),m(T,e,t),l(e,Wt,t),m(ae,e,t),l(e,It,t),l(e,le,t),l(e,Gt,t),m(se,e,t),l(e,At,t),m(ne,e,t),l(e,Qt,t),l(e,ie,t),l(e,Vt,t),m(oe,e,t),l(e,Xt,t),l(e,re,t),l(e,xt,t),m(pe,e,t),l(e,Ht,t),l(e,de,t),l(e,qt,t),m(me,e,t),l(e,Ft,t),m(fe,e,t),l(e,zt,t),l(e,he,t),l(e,Et,t),m(ue,e,t),l(e,Yt,t),l(e,ce,t),l(e,Nt,t),m(Me,e,t),l(e,St,t),m(we,e,t),l(e,Pt,t),l(e,ye,t),l(e,Dt,t),m(be,e,t),l(e,Kt,t),l(e,ge,t),l(e,Ot,t),l(e,Te,t),l(e,ea,t),m(Je,e,t),l(e,ta,t),l(e,_e,t),l(e,aa,t),l(e,$e,t),l(e,la,t),l(e,J,t),l(e,sa,t),l(e,Ze,t),l(e,na,t),m(je,e,t),l(e,ia,t),l(e,ve,t),l(e,oa,t),m(Ue,e,t),l(e,ra,t),l(e,ke,t),l(e,pa,t),l(e,Re,t),l(e,da,t),m(Ce,e,t),l(e,ma,t),l(e,Be,t),l(e,fa,t),m(Le,e,t),l(e,ha,t),l(e,We,t),l(e,ua,t),m(Ie,e,t),l(e,ca,t),m(_,e,t),l(e,Ma,t),l(e,Ge,t),l(e,wa,t),m(Ae,e,t),l(e,ya,t),m(Qe,e,t),l(e,ba,t),l(e,Ve,t),l(e,ga,t),m(Xe,e,t),l(e,Ta,t),l(e,xe,t),l(e,Ja,t),m(He,e,t),l(e,_a,t),m(qe,e,t),l(e,$a,t),l(e,Fe,t),l(e,Za,t),l(e,ze,t),l(e,ja,t),m(Ee,e,t),l(e,va,t),l(e,Ye,t),l(e,Ua,t),m(Ne,e,t),l(e,ka,t),l(e,Se,t),l(e,Ra,t),m(Pe,e,t),l(e,Ca,t),l(e,De,t),l(e,Ba,t),l(e,Ke,t),l(e,La,t),m(Oe,e,t),l(e,Wa,t),l(e,tt,t),Ia=!0},p(e,[t]){const kl={};t&2&&(kl.$$scope={dirty:t,ctx:e}),T.$set(kl);const Rl={};t&2&&(Rl.$$scope={dirty:t,ctx:e}),_.$set(Rl)},i(e){Ia||(f($.$$.fragment,e),f(v.$$.fragment,e),f(R.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(G.$$.fragment,e),f(Q.$$.fragment,e),f(X.$$.fragment,e),f(q.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(T.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(we.$$.fragment,e),f(be.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f(Ue.$$.fragment,e),f(Ce.$$.fragment,e),f(Le.$$.fragment,e),f(Ie.$$.fragment,e),f(_.$$.fragment,e),f(Ae.$$.fragment,e),f(Qe.$$.fragment,e),f(Xe.$$.fragment,e),f(He.$$.fragment,e),f(qe.$$.fragment,e),f(Ee.$$.fragment,e),f(Ne.$$.fragment,e),f(Pe.$$.fragment,e),f(Oe.$$.fragment,e),Ia=!0)},o(e){h($.$$.fragment,e),h(v.$$.fragment,e),h(R.$$.fragment,e),h(B.$$.fragment,e),h(L.$$.fragment,e),h(G.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(q.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(T.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(we.$$.fragment,e),h(be.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ce.$$.fragment,e),h(Le.$$.fragment,e),h(Ie.$$.fragment,e),h(_.$$.fragment,e),h(Ae.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(He.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ne.$$.fragment,e),h(Pe.$$.fragment,e),h(Oe.$$.fragment,e),Ia=!1},d(e){e&&(a(b),a(w),a(g),a(at),a(Z),a(lt),a(j),a(st),a(nt),a(U),a(it),a(k),a(ot),a(rt),a(C),a(pt),a(dt),a(mt),a(W),a(ft),a(I),a(ht),a(ut),a(A),a(ct),a(Mt),a(V),a(wt),a(yt),a(x),a(bt),a(H),a(gt),a(Tt),a(F),a(Jt),a(_t),a($t),a(Y),a(Zt),a(N),a(jt),a(vt),a(P),a(Ut),a(kt),a(K),a(Rt),a(O),a(Ct),a(ee),a(Bt),a(te),a(Lt),a(Wt),a(It),a(le),a(Gt),a(At),a(Qt),a(ie),a(Vt),a(Xt),a(re),a(xt),a(Ht),a(de),a(qt),a(Ft),a(zt),a(he),a(Et),a(Yt),a(ce),a(Nt),a(St),a(Pt),a(ye),a(Dt),a(Kt),a(ge),a(Ot),a(Te),a(ea),a(ta),a(_e),a(aa),a($e),a(la),a(J),a(sa),a(Ze),a(na),a(ia),a(ve),a(oa),a(ra),a(ke),a(pa),a(Re),a(da),a(ma),a(Be),a(fa),a(ha),a(We),a(ua),a(ca),a(Ma),a(Ge),a(wa),a(ya),a(ba),a(Ve),a(ga),a(Ta),a(xe),a(Ja),a(_a),a($a),a(Fe),a(Za),a(ze),a(ja),a(va),a(Ye),a(Ua),a(ka),a(Se),a(Ra),a(Ca),a(De),a(Ba),a(Ke),a(La),a(Wa),a(tt)),a(c),u($,e),u(v,e),u(R,e),u(B,e),u(L,e),u(G,e),u(Q,e),u(X,e),u(q,e),u(z,e),u(E,e),u(S,e),u(D,e),u(T,e),u(ae,e),u(se,e),u(ne,e),u(oe,e),u(pe,e),u(me,e),u(fe,e),u(ue,e),u(Me,e),u(we,e),u(be,e),u(Je,e),u(je,e),u(Ue,e),u(Ce,e),u(Le,e),u(Ie,e),u(_,e),u(Ae,e),u(Qe,e),u(Xe,e),u(He,e),u(qe,e),u(Ee,e),u(Ne,e),u(Pe,e),u(Oe,e)}}}const Fl='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convienient way","local":"a-more-convienient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function zl(et){return Il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dl extends Gl{constructor(c){super(),Al(this,c,zl,ql,Wl,{})}}export{Dl as component};
