import{s as mt,o as jt}from"../chunks/scheduler.37c15a92.js";import{S as ut,i as Ut,g as M,s as n,r as o,A as ht,h as p,f as t,c as a,j as yt,u as r,x as i,k as Tt,y as dt,a as e,v as J,d as c,t as w,w as y,m as kl,n as $l}from"../chunks/index.2bf4358c.js";import{T as Vl}from"../chunks/Tip.363c041f.js";import{C as j}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as It}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as U,E as bt}from"../chunks/EditOnGithub.8916dc7c.js";function ft(h){let T;return{c(){T=kl("This exercise can be run on a free Google Colab T4 GPU. For the best experience, follow along with the notebook linked above and try it out yourself.")},l(m){T=$l(m,"This exercise can be run on a free Google Colab T4 GPU. For the best experience, follow along with the notebook linked above and try it out yourself.")},m(m,u){e(m,T,u)},d(m){m&&t(T)}}}function Ct(h){let T;return{c(){T=kl("We won't cover the details of LoRA in this chapter, but you can learn more in [Chapter 11](/en/chapter11/3).")},l(m){T=$l(m,"We won't cover the details of LoRA in this chapter, but you can learn more in [Chapter 11](/en/chapter11/3).")},m(m,u){e(m,T,u)},d(m){m&&t(T)}}}function gt(h){let T;return{c(){T=kl("Training may take some time. You might not see rewards increase immediately - it can take 150-200 steps before you start seeing improvements. Be patient!")},l(m){T=$l(m,"Training may take some time. You might not see rewards increase immediately - it can take 150-200 steps before you start seeing improvements. Be patient!")},m(m,u){e(m,T,u)},d(m){m&&t(T)}}}function Bt(h){let T,m,u,gs,f,Bs,C,Gs,g,El='In this exercise, you’ll fine-tune a model with GRPO (Group Relative Policy Optimization) using Unsloth, to improve a model’s reasoning capabilities. We covered GRPO in <a href="/en/chapter3/3">Chapter 3</a>.',As,B,Ql="Unsloth is a library that accelerates LLM fine-tuning, making it possible to train models faster and with less computational resources. Unsloth is plugs into TRL, so we’ll build on what we learned in the previous sections, and adapt it for Unsloth specifics.",_s,d,Zs,G,Vs,A,Rl="First, let’s install the necessary libraries. We’ll need Unsloth for the accelerated fine-tuning and vLLM for fast inference.",ks,_,$s,Z,Es,V,Nl="Unsloth provides a class (<code>FastLanguageModel</code>) that integrates transformers with Unsloth optimizations. Let’s import it:",Qs,k,Rs,$,vl="Now, let’s load the Llama 3.1 8B Instruct model and configure it for fine-tuning:",Ns,E,vs,Q,xl="This code loads the model in 4-bit quantization to save memory and applies LoRA (Low-Rank Adaptation) for efficient fine-tuning. The <code>target_modules</code> parameter specifies which layers of the model to fine-tune, and <code>use_gradient_checkpointing</code> enables training with longer contexts.",xs,I,Xs,R,Ws,N,Xl="For this exercise, we’ll use the GSM8K dataset, which contains grade school math problems. We’ll format the data to encourage the model to show its reasoning before providing an answer.",Fs,v,Wl="First, we will define the format of the prompts and answers:",zs,x,qs,X,Fl="Now, let’s prepare the dataset:",Ys,W,Hs,F,zl="The dataset is prepared by extracting the answer from the dataset and formatting it as a string.",Ss,z,Ls,q,ql='As we discussed in <a href="/en/chapter13/4">an earlier page</a>, GRPO can use reward functions to guide the model’s learning based on verifiable criteria like length and formatting.',Ds,Y,Yl="In this exercise, we’ll define several reward functions that encourage different aspects of good reasoning. For example, we’ll reward the model for providing an integer answer, and for following the strict format.",Ps,H,Ks,S,Hl="These reward functions serve different purposes:",Os,L,Sl="<thead><tr><th>Reward Function</th> <th>Purpose</th></tr></thead> <tbody><tr><td><code>correctness_reward_func</code></td> <td>Rewards the model when its answer matches the correct answer</td></tr> <tr><td><code>int_reward_func</code></td> <td>Rewards the model for providing a numeric answer</td></tr> <tr><td><code>strict_format_reward_func</code> and <code>soft_format_reward_func</code></td> <td>Reward the model for following the specified format</td></tr> <tr><td><code>xmlcount_reward_func</code></td> <td>Rewards proper XML tag usage and penalizes extra content after the closing tags</td></tr></tbody>",sl,D,ll,P,Ll='Now we’ll set up the GRPO trainer with our model, tokenizer, and reward functions. This part follows the same approach as the <a href="/en/chapter12/5">previous exercise</a>.',tl,K,el,O,Dl="The <code>GRPOConfig</code> sets various hyperparameters for training:",nl,ss,Pl="<li><code>use_vllm</code>: Enables fast inference with vLLM</li> <li><code>learning_rate</code>: Controls how quickly the model learns</li> <li><code>num_generations</code>: Number of completions to generate for each prompt</li> <li><code>max_steps</code>: Total number of training steps to perform</li>",al,ls,Kl="Now let’s start the training:",Ml,ts,pl,b,il,es,ol,ns,Ol="After training, let’s test our model to see how it performs. First, we’ll save the LoRA weights:",rl,as,Jl,Ms,st="Now, let’s test the model with a new question:",cl,ps,wl,is,lt="You should see that the model now follows the specified format, showing its reasoning before providing an answer.",yl,os,Tl,rs,tt="Unsloth provides several options for saving your fine-tuned model, but we’ll focus on the most common.",ml,Js,jl,cs,ul,ws,et="We’ll push the model to the Hugging Face Hub using the <code>push_to_hub_merged</code> method. This method allows us to push the model in multiple quantization formats.",Ul,ys,hl,Ts,nt="Unsloth also supports saving to GGUF format for use with llama.cpp:",dl,ms,Il,js,at="The GGUF files can be used with llama.cpp or UI-based systems like Jan or Open WebUI.",bl,us,fl,Us,Mt="In this exercise, you’ve learned how to:",Cl,hs,pt="<li>Set up Unsloth for accelerated fine-tuning</li> <li>Prepare data for GRPO training</li> <li>Define custom reward functions to guide the model’s learning</li> <li>Train a model using GRPO</li> <li>Test the fine-tuned model</li> <li>Save the model in various formats</li>",gl,ds,it="GRPO is a powerful technique for aligning language models with specific behaviors, and Unsloth makes it accessible even on limited hardware. By combining multiple reward functions, you can guide the model to follow a specific format while also improving its reasoning capabilities.",Bl,Is,ot="For more information and resources, check out:",Gl,bs,rt='<li><a href="https://docs.unsloth.ai/" rel="nofollow">Unsloth Documentation</a></li> <li><a href="https://discord.gg/unsloth" rel="nofollow">Unsloth Discord</a></li> <li><a href="https://github.com/unslothai/unsloth" rel="nofollow">Unsloth GitHub</a></li>',Al,fs,_l,Cs,Zl;return f=new It({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://github.com/unslothai/notebooks/blob/main/nb/HuggingFace%20Course-Llama3.1_(8B)-GRPO.ipynb"}]}}),C=new U({props:{title:"Practical Exercise: GRPO with Unsloth",local:"practical-exercise-grpo-with-unsloth",headingTag:"h1"}}),d=new Vl({props:{$$slots:{default:[ft]},$$scope:{ctx:h}}}),G=new U({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),_=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHVuc2xvdGglMjB2bGxtJTBBcGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpbGxvdw==",highlighted:`pip install unsloth vllm
pip install --upgrade pillow`,wrap:!1}}),Z=new U({props:{title:"Setting up Unsloth",local:"setting-up-unsloth",headingTag:"h2"}}),k=new j({props:{code:"ZnJvbSUyMHVuc2xvdGglMjBpbXBvcnQlMjBGYXN0TGFuZ3VhZ2VNb2RlbA==",highlighted:'<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel',wrap:!1}}),E=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel
<span class="hljs-keyword">import</span> torch

max_seq_length = <span class="hljs-number">1024</span>  <span class="hljs-comment"># Can increase for longer reasoning traces</span>
lora_rank = <span class="hljs-number">32</span>  <span class="hljs-comment"># Larger rank = smarter, but slower</span>

model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;meta-llama/meta-Llama-3.1-8B-Instruct&quot;</span>,
    max_seq_length=max_seq_length,
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># False for LoRA 16bit</span>
    fast_inference=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable vLLM fast inference</span>
    max_lora_rank=lora_rank,
    gpu_memory_utilization=<span class="hljs-number">0.6</span>,  <span class="hljs-comment"># Reduce if out of memory</span>
)

model = FastLanguageModel.get_peft_model(
    model,
    r=lora_rank,  <span class="hljs-comment"># Choose any number &gt; 0! Suggested 8, 16, 32, 64, 128</span>
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],  <span class="hljs-comment"># Remove QKVO if out of memory</span>
    lora_alpha=lora_rank,
    use_gradient_checkpointing=<span class="hljs-string">&quot;unsloth&quot;</span>,  <span class="hljs-comment"># Enable long context finetuning</span>
    random_state=<span class="hljs-number">3407</span>,
)`,wrap:!1}}),I=new Vl({props:{$$slots:{default:[Ct]},$$scope:{ctx:h}}}),R=new U({props:{title:"Data Preparation",local:"data-preparation",headingTag:"h2"}}),x=new j({props:{code:"",highlighted:`<span class="hljs-comment"># Define the system prompt that instructs the model to use a specific format</span>
SYSTEM_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
Respond in the following format:
&lt;reasoning&gt;
...
&lt;/reasoning&gt;
&lt;answer&gt;
...
&lt;/answer&gt;
&quot;&quot;&quot;</span>

XML_COT_FORMAT = <span class="hljs-string">&quot;&quot;&quot;\\
&lt;reasoning&gt;
{reasoning}
&lt;/reasoning&gt;
&lt;answer&gt;
{answer}
&lt;/answer&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),W=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset


<span class="hljs-comment"># Helper functions to extract answers from different formats</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_xml_answer</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    answer = text.split(<span class="hljs-string">&quot;&lt;answer&gt;&quot;</span>)[-<span class="hljs-number">1</span>]
    answer = answer.split(<span class="hljs-string">&quot;&lt;/answer&gt;&quot;</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> answer.strip()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_hash_answer</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span> | <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;####&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> text:
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>
    <span class="hljs-keyword">return</span> text.split(<span class="hljs-string">&quot;####&quot;</span>)[<span class="hljs-number">1</span>].strip()


<span class="hljs-comment"># Function to prepare the GSM8K dataset</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_gsm8k_questions</span>(<span class="hljs-params">split=<span class="hljs-string">&quot;train&quot;</span></span>) -&gt; Dataset:
    data = load_dataset(<span class="hljs-string">&quot;openai/gsm8k&quot;</span>, <span class="hljs-string">&quot;main&quot;</span>)[split]
    data = data.<span class="hljs-built_in">map</span>(
        <span class="hljs-keyword">lambda</span> x: {
            <span class="hljs-string">&quot;prompt&quot;</span>: [
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
                {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: x[<span class="hljs-string">&quot;question&quot;</span>]},
            ],
            <span class="hljs-string">&quot;answer&quot;</span>: extract_hash_answer(x[<span class="hljs-string">&quot;answer&quot;</span>]),
        }
    )
    <span class="hljs-keyword">return</span> data


dataset = get_gsm8k_questions()`,wrap:!1}}),z=new U({props:{title:"Defining Reward Functions",local:"defining-reward-functions",headingTag:"h2"}}),H=new j({props:{code:"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",highlighted:`<span class="hljs-comment"># Reward function that checks if the answer is correct</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">correctness_reward_func</span>(<span class="hljs-params">prompts, completions, answer, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    q = prompts[<span class="hljs-number">0</span>][-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>]
    extracted_responses = [extract_xml_answer(r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;-&quot;</span> * <span class="hljs-number">20</span>,
        <span class="hljs-string">f&quot;Question:\\n<span class="hljs-subst">{q}</span>&quot;</span>,
        <span class="hljs-string">f&quot;\\nAnswer:\\n<span class="hljs-subst">{answer[<span class="hljs-number">0</span>]}</span>&quot;</span>,
        <span class="hljs-string">f&quot;\\nResponse:\\n<span class="hljs-subst">{responses[<span class="hljs-number">0</span>]}</span>&quot;</span>,
        <span class="hljs-string">f&quot;\\nExtracted:\\n<span class="hljs-subst">{extracted_responses[<span class="hljs-number">0</span>]}</span>&quot;</span>,
    )
    <span class="hljs-keyword">return</span> [<span class="hljs-number">2.0</span> <span class="hljs-keyword">if</span> r == a <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> r, a <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(extracted_responses, answer)]


<span class="hljs-comment"># Reward function that checks if the answer is an integer</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">int_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    extracted_responses = [extract_xml_answer(r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-keyword">return</span> [<span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> r.isdigit() <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> extracted_responses]


<span class="hljs-comment"># Reward function that checks if the completion follows the strict format</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">strict_format_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    pattern = <span class="hljs-string">r&quot;^&lt;reasoning&gt;\\n.*?\\n&lt;/reasoning&gt;\\n&lt;answer&gt;\\n.*?\\n&lt;/answer&gt;\\n$&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    matches = [re.<span class="hljs-keyword">match</span>(pattern, r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-keyword">return</span> [<span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">in</span> matches]


<span class="hljs-comment"># Reward function that checks if the completion follows a more relaxed format</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">soft_format_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    pattern = <span class="hljs-string">r&quot;&lt;reasoning&gt;.*?&lt;/reasoning&gt;\\s*&lt;answer&gt;.*?&lt;/answer&gt;&quot;</span>
    responses = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    matches = [re.<span class="hljs-keyword">match</span>(pattern, r) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> responses]
    <span class="hljs-keyword">return</span> [<span class="hljs-number">0.5</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> <span class="hljs-keyword">match</span> <span class="hljs-keyword">in</span> matches]


<span class="hljs-comment"># Reward function that counts XML tags and penalizes extra content</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">count_xml</span>(<span class="hljs-params">text</span>) -&gt; <span class="hljs-built_in">float</span>:
    count = <span class="hljs-number">0.0</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;&lt;reasoning&gt;\\n&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;\\n&lt;/reasoning&gt;\\n&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;\\n&lt;answer&gt;\\n&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
        count -= <span class="hljs-built_in">len</span>(text.split(<span class="hljs-string">&quot;\\n&lt;/answer&gt;\\n&quot;</span>)[-<span class="hljs-number">1</span>]) * <span class="hljs-number">0.001</span>
    <span class="hljs-keyword">if</span> text.count(<span class="hljs-string">&quot;\\n&lt;/answer&gt;&quot;</span>) == <span class="hljs-number">1</span>:
        count += <span class="hljs-number">0.125</span>
        count -= (<span class="hljs-built_in">len</span>(text.split(<span class="hljs-string">&quot;\\n&lt;/answer&gt;&quot;</span>)[-<span class="hljs-number">1</span>]) - <span class="hljs-number">1</span>) * <span class="hljs-number">0.001</span>
    <span class="hljs-keyword">return</span> count


<span class="hljs-keyword">def</span> <span class="hljs-title function_">xmlcount_reward_func</span>(<span class="hljs-params">completions, **kwargs</span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    contents = [completion[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]
    <span class="hljs-keyword">return</span> [count_xml(c) <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> contents]`,wrap:!1}}),D=new U({props:{title:"Training with GRPO",local:"training-with-grpo",headingTag:"h2"}}),K=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> GRPOConfig, GRPOTrainer

max_prompt_length = <span class="hljs-number">256</span>
training_args = GRPOConfig(
    learning_rate=<span class="hljs-number">5e-6</span>,
    adam_beta1=<span class="hljs-number">0.9</span>,
    adam_beta2=<span class="hljs-number">0.99</span>,
    weight_decay=<span class="hljs-number">0.1</span>,
    warmup_ratio=<span class="hljs-number">0.1</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;cosine&quot;</span>,
    optim=<span class="hljs-string">&quot;paged_adamw_8bit&quot;</span>,
    logging_steps=<span class="hljs-number">1</span>,
    per_device_train_batch_size=<span class="hljs-number">1</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Increase to 4 for smoother training</span>
    num_generations=<span class="hljs-number">6</span>,  <span class="hljs-comment"># Decrease if out of memory</span>
    max_prompt_length=max_prompt_length,
    max_completion_length=max_seq_length - max_prompt_length,
    <span class="hljs-comment"># num_train_epochs = 1,  # Set to 1 for a full training run</span>
    max_steps=<span class="hljs-number">250</span>,
    save_steps=<span class="hljs-number">250</span>,
    max_grad_norm=<span class="hljs-number">0.1</span>,
    report_to=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Can use Weights &amp; Biases</span>
    output_dir=<span class="hljs-string">&quot;outputs&quot;</span>,
)

trainer = GRPOTrainer(
    model=model,
    processing_class=tokenizer,
    reward_funcs=[
        xmlcount_reward_func,
        soft_format_reward_func,
        strict_format_reward_func,
        int_reward_func,
        correctness_reward_func,
    ],
    args=training_args,
    train_dataset=dataset,
)`,wrap:!1}}),ts=new j({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),b=new Vl({props:{warning:!0,$$slots:{default:[gt]},$$scope:{ctx:h}}}),es=new U({props:{title:"Testing the Model",local:"testing-the-model",headingTag:"h2"}}),as=new j({props:{code:"bW9kZWwuc2F2ZV9sb3JhKCUyMmdycG9fc2F2ZWRfbG9yYSUyMik=",highlighted:'model.save_lora(<span class="hljs-string">&quot;grpo_saved_lora&quot;</span>)',wrap:!1}}),ps=new j({props:{code:"ZnJvbSUyMHZsbG0lMjBpbXBvcnQlMjBTYW1wbGluZ1BhcmFtcyUwQSUwQXRleHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYWxjdWxhdGUlMjBwaS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUwQSklMEElMEFzYW1wbGluZ19wYXJhbXMlMjAlM0QlMjBTYW1wbGluZ1BhcmFtcyglMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOCUyQyUwQSUyMCUyMCUyMCUyMHRvcF9wJTNEMC45NSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQW91dHB1dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBtb2RlbC5mYXN0X2dlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGluZ19wYXJhbXMlM0RzYW1wbGluZ19wYXJhbXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3JhX3JlcXVlc3QlM0Rtb2RlbC5sb2FkX2xvcmEoJTIyZ3Jwb19zYXZlZF9sb3JhJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCklNUIwJTVEJTBBJTIwJTIwJTIwJTIwLm91dHB1dHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwLnRleHQlMEEpJTBBJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> SamplingParams

text = tokenizer.apply_chat_template(
    [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Calculate pi.&quot;</span>},
    ],
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)

sampling_params = SamplingParams(
    temperature=<span class="hljs-number">0.8</span>,
    top_p=<span class="hljs-number">0.95</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)
output = (
    model.fast_generate(
        text,
        sampling_params=sampling_params,
        lora_request=model.load_lora(<span class="hljs-string">&quot;grpo_saved_lora&quot;</span>),
    )[<span class="hljs-number">0</span>]
    .outputs[<span class="hljs-number">0</span>]
    .text
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),os=new U({props:{title:"Saving the Model",local:"saving-the-model",headingTag:"h2"}}),Js=new j({props:{code:"JTIzJTIwU2F2ZSUyMHRvJTIwMTYtYml0JTIwcHJlY2lzaW9uJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkX21lcmdlZCglMjJtb2RlbCUyMiUyQyUyMHRva2VuaXplciUyQyUyMHNhdmVfbWV0aG9kJTNEJTIybWVyZ2VkXzE2Yml0JTIyKQ==",highlighted:`<span class="hljs-comment"># Save to 16-bit precision</span>
model.save_pretrained_merged(<span class="hljs-string">&quot;model&quot;</span>, tokenizer, save_method=<span class="hljs-string">&quot;merged_16bit&quot;</span>)`,wrap:!1}}),cs=new U({props:{title:"Pushing to Hugging Face Hub",local:"pushing-to-hugging-face-hub",headingTag:"h2"}}),ys=new j({props:{code:"JTIzJTIwUHVzaCUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMjAocmVxdWlyZXMlMjBhJTIwdG9rZW4pJTBBbW9kZWwucHVzaF90b19odWJfbWVyZ2VkKCUwQSUyMCUyMCUyMCUyMCUyMnlvdXItdXNlcm5hbWUlMkZtb2RlbC1uYW1lJTIyJTJDJTIwdG9rZW5pemVyJTJDJTIwc2F2ZV9tZXRob2QlM0QlMjJtZXJnZWRfMTZiaXQlMjIlMkMlMjB0b2tlbiUzRCUyMnlvdXItdG9rZW4lMjIlMEEp",highlighted:`<span class="hljs-comment"># Push to Hugging Face Hub (requires a token)</span>
model.push_to_hub_merged(
    <span class="hljs-string">&quot;your-username/model-name&quot;</span>, tokenizer, save_method=<span class="hljs-string">&quot;merged_16bit&quot;</span>, token=<span class="hljs-string">&quot;your-token&quot;</span>
)`,wrap:!1}}),ms=new j({props:{code:"bW9kZWwucHVzaF90b19odWJfZ2d1ZiglMEElMjAlMjAlMjAlMjAlMjJ5b3VyLXVzZXJuYW1lJTJGbW9kZWwtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9tZXRob2QlM0QlNUIlMjJxNF9rX20lMjIlMkMlMjAlMjJxOF8wJTIyJTJDJTIwJTIycTVfa19tJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0QlMjJ5b3VyLXRva2VuJTIyJTJDJTBBKQ==",highlighted:`model.push_to_hub_gguf(
    <span class="hljs-string">&quot;your-username/model-name&quot;</span>,
    tokenizer,
    quantization_method=[<span class="hljs-string">&quot;q4_k_m&quot;</span>, <span class="hljs-string">&quot;q8_0&quot;</span>, <span class="hljs-string">&quot;q5_k_m&quot;</span>],
    token=<span class="hljs-string">&quot;your-token&quot;</span>,
)`,wrap:!1}}),us=new U({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),fs=new bt({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/6.mdx"}}),{c(){T=M("meta"),m=n(),u=M("p"),gs=n(),o(f.$$.fragment),Bs=n(),o(C.$$.fragment),Gs=n(),g=M("p"),g.innerHTML=El,As=n(),B=M("p"),B.textContent=Ql,_s=n(),o(d.$$.fragment),Zs=n(),o(G.$$.fragment),Vs=n(),A=M("p"),A.textContent=Rl,ks=n(),o(_.$$.fragment),$s=n(),o(Z.$$.fragment),Es=n(),V=M("p"),V.innerHTML=Nl,Qs=n(),o(k.$$.fragment),Rs=n(),$=M("p"),$.textContent=vl,Ns=n(),o(E.$$.fragment),vs=n(),Q=M("p"),Q.innerHTML=xl,xs=n(),o(I.$$.fragment),Xs=n(),o(R.$$.fragment),Ws=n(),N=M("p"),N.textContent=Xl,Fs=n(),v=M("p"),v.textContent=Wl,zs=n(),o(x.$$.fragment),qs=n(),X=M("p"),X.textContent=Fl,Ys=n(),o(W.$$.fragment),Hs=n(),F=M("p"),F.textContent=zl,Ss=n(),o(z.$$.fragment),Ls=n(),q=M("p"),q.innerHTML=ql,Ds=n(),Y=M("p"),Y.textContent=Yl,Ps=n(),o(H.$$.fragment),Ks=n(),S=M("p"),S.textContent=Hl,Os=n(),L=M("table"),L.innerHTML=Sl,sl=n(),o(D.$$.fragment),ll=n(),P=M("p"),P.innerHTML=Ll,tl=n(),o(K.$$.fragment),el=n(),O=M("p"),O.innerHTML=Dl,nl=n(),ss=M("ul"),ss.innerHTML=Pl,al=n(),ls=M("p"),ls.textContent=Kl,Ml=n(),o(ts.$$.fragment),pl=n(),o(b.$$.fragment),il=n(),o(es.$$.fragment),ol=n(),ns=M("p"),ns.textContent=Ol,rl=n(),o(as.$$.fragment),Jl=n(),Ms=M("p"),Ms.textContent=st,cl=n(),o(ps.$$.fragment),wl=n(),is=M("p"),is.textContent=lt,yl=n(),o(os.$$.fragment),Tl=n(),rs=M("p"),rs.textContent=tt,ml=n(),o(Js.$$.fragment),jl=n(),o(cs.$$.fragment),ul=n(),ws=M("p"),ws.innerHTML=et,Ul=n(),o(ys.$$.fragment),hl=n(),Ts=M("p"),Ts.textContent=nt,dl=n(),o(ms.$$.fragment),Il=n(),js=M("p"),js.textContent=at,bl=n(),o(us.$$.fragment),fl=n(),Us=M("p"),Us.textContent=Mt,Cl=n(),hs=M("ol"),hs.innerHTML=pt,gl=n(),ds=M("p"),ds.textContent=it,Bl=n(),Is=M("p"),Is.textContent=ot,Gl=n(),bs=M("ul"),bs.innerHTML=rt,Al=n(),o(fs.$$.fragment),_l=n(),Cs=M("p"),this.h()},l(s){const l=ht("svelte-u9bgzb",document.head);T=p(l,"META",{name:!0,content:!0}),l.forEach(t),m=a(s),u=p(s,"P",{}),yt(u).forEach(t),gs=a(s),r(f.$$.fragment,s),Bs=a(s),r(C.$$.fragment,s),Gs=a(s),g=p(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-28ga60"&&(g.innerHTML=El),As=a(s),B=p(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-v44mtq"&&(B.textContent=Ql),_s=a(s),r(d.$$.fragment,s),Zs=a(s),r(G.$$.fragment,s),Vs=a(s),A=p(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-7apc0w"&&(A.textContent=Rl),ks=a(s),r(_.$$.fragment,s),$s=a(s),r(Z.$$.fragment,s),Es=a(s),V=p(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-uhz6q0"&&(V.innerHTML=Nl),Qs=a(s),r(k.$$.fragment,s),Rs=a(s),$=p(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1lwmntb"&&($.textContent=vl),Ns=a(s),r(E.$$.fragment,s),vs=a(s),Q=p(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-ihivum"&&(Q.innerHTML=xl),xs=a(s),r(I.$$.fragment,s),Xs=a(s),r(R.$$.fragment,s),Ws=a(s),N=p(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1jqnhvo"&&(N.textContent=Xl),Fs=a(s),v=p(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-222xwa"&&(v.textContent=Wl),zs=a(s),r(x.$$.fragment,s),qs=a(s),X=p(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-uuip11"&&(X.textContent=Fl),Ys=a(s),r(W.$$.fragment,s),Hs=a(s),F=p(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-yuvu2n"&&(F.textContent=zl),Ss=a(s),r(z.$$.fragment,s),Ls=a(s),q=p(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1wqrmwt"&&(q.innerHTML=ql),Ds=a(s),Y=p(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1bbmyq2"&&(Y.textContent=Yl),Ps=a(s),r(H.$$.fragment,s),Ks=a(s),S=p(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-10lwv8u"&&(S.textContent=Hl),Os=a(s),L=p(s,"TABLE",{"data-svelte-h":!0}),i(L)!=="svelte-beg5py"&&(L.innerHTML=Sl),sl=a(s),r(D.$$.fragment,s),ll=a(s),P=p(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1h10geb"&&(P.innerHTML=Ll),tl=a(s),r(K.$$.fragment,s),el=a(s),O=p(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1jo17wb"&&(O.innerHTML=Dl),nl=a(s),ss=p(s,"UL",{"data-svelte-h":!0}),i(ss)!=="svelte-eo3csz"&&(ss.innerHTML=Pl),al=a(s),ls=p(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-c65a8i"&&(ls.textContent=Kl),Ml=a(s),r(ts.$$.fragment,s),pl=a(s),r(b.$$.fragment,s),il=a(s),r(es.$$.fragment,s),ol=a(s),ns=p(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-dwjtn"&&(ns.textContent=Ol),rl=a(s),r(as.$$.fragment,s),Jl=a(s),Ms=p(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-6mnmyk"&&(Ms.textContent=st),cl=a(s),r(ps.$$.fragment,s),wl=a(s),is=p(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-n6ify3"&&(is.textContent=lt),yl=a(s),r(os.$$.fragment,s),Tl=a(s),rs=p(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-8mgtgx"&&(rs.textContent=tt),ml=a(s),r(Js.$$.fragment,s),jl=a(s),r(cs.$$.fragment,s),ul=a(s),ws=p(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-5e9stk"&&(ws.innerHTML=et),Ul=a(s),r(ys.$$.fragment,s),hl=a(s),Ts=p(s,"P",{"data-svelte-h":!0}),i(Ts)!=="svelte-hwdwrb"&&(Ts.textContent=nt),dl=a(s),r(ms.$$.fragment,s),Il=a(s),js=p(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-102ov0f"&&(js.textContent=at),bl=a(s),r(us.$$.fragment,s),fl=a(s),Us=p(s,"P",{"data-svelte-h":!0}),i(Us)!=="svelte-onfwxy"&&(Us.textContent=Mt),Cl=a(s),hs=p(s,"OL",{"data-svelte-h":!0}),i(hs)!=="svelte-j3tqlf"&&(hs.innerHTML=pt),gl=a(s),ds=p(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-ntlp2y"&&(ds.textContent=it),Bl=a(s),Is=p(s,"P",{"data-svelte-h":!0}),i(Is)!=="svelte-1r9yves"&&(Is.textContent=ot),Gl=a(s),bs=p(s,"UL",{"data-svelte-h":!0}),i(bs)!=="svelte-1fz95oy"&&(bs.innerHTML=rt),Al=a(s),r(fs.$$.fragment,s),_l=a(s),Cs=p(s,"P",{}),yt(Cs).forEach(t),this.h()},h(){Tt(T,"name","hf:doc:metadata"),Tt(T,"content",Gt)},m(s,l){dt(document.head,T),e(s,m,l),e(s,u,l),e(s,gs,l),J(f,s,l),e(s,Bs,l),J(C,s,l),e(s,Gs,l),e(s,g,l),e(s,As,l),e(s,B,l),e(s,_s,l),J(d,s,l),e(s,Zs,l),J(G,s,l),e(s,Vs,l),e(s,A,l),e(s,ks,l),J(_,s,l),e(s,$s,l),J(Z,s,l),e(s,Es,l),e(s,V,l),e(s,Qs,l),J(k,s,l),e(s,Rs,l),e(s,$,l),e(s,Ns,l),J(E,s,l),e(s,vs,l),e(s,Q,l),e(s,xs,l),J(I,s,l),e(s,Xs,l),J(R,s,l),e(s,Ws,l),e(s,N,l),e(s,Fs,l),e(s,v,l),e(s,zs,l),J(x,s,l),e(s,qs,l),e(s,X,l),e(s,Ys,l),J(W,s,l),e(s,Hs,l),e(s,F,l),e(s,Ss,l),J(z,s,l),e(s,Ls,l),e(s,q,l),e(s,Ds,l),e(s,Y,l),e(s,Ps,l),J(H,s,l),e(s,Ks,l),e(s,S,l),e(s,Os,l),e(s,L,l),e(s,sl,l),J(D,s,l),e(s,ll,l),e(s,P,l),e(s,tl,l),J(K,s,l),e(s,el,l),e(s,O,l),e(s,nl,l),e(s,ss,l),e(s,al,l),e(s,ls,l),e(s,Ml,l),J(ts,s,l),e(s,pl,l),J(b,s,l),e(s,il,l),J(es,s,l),e(s,ol,l),e(s,ns,l),e(s,rl,l),J(as,s,l),e(s,Jl,l),e(s,Ms,l),e(s,cl,l),J(ps,s,l),e(s,wl,l),e(s,is,l),e(s,yl,l),J(os,s,l),e(s,Tl,l),e(s,rs,l),e(s,ml,l),J(Js,s,l),e(s,jl,l),J(cs,s,l),e(s,ul,l),e(s,ws,l),e(s,Ul,l),J(ys,s,l),e(s,hl,l),e(s,Ts,l),e(s,dl,l),J(ms,s,l),e(s,Il,l),e(s,js,l),e(s,bl,l),J(us,s,l),e(s,fl,l),e(s,Us,l),e(s,Cl,l),e(s,hs,l),e(s,gl,l),e(s,ds,l),e(s,Bl,l),e(s,Is,l),e(s,Gl,l),e(s,bs,l),e(s,Al,l),J(fs,s,l),e(s,_l,l),e(s,Cs,l),Zl=!0},p(s,[l]){const Jt={};l&2&&(Jt.$$scope={dirty:l,ctx:s}),d.$set(Jt);const ct={};l&2&&(ct.$$scope={dirty:l,ctx:s}),I.$set(ct);const wt={};l&2&&(wt.$$scope={dirty:l,ctx:s}),b.$set(wt)},i(s){Zl||(c(f.$$.fragment,s),c(C.$$.fragment,s),c(d.$$.fragment,s),c(G.$$.fragment,s),c(_.$$.fragment,s),c(Z.$$.fragment,s),c(k.$$.fragment,s),c(E.$$.fragment,s),c(I.$$.fragment,s),c(R.$$.fragment,s),c(x.$$.fragment,s),c(W.$$.fragment,s),c(z.$$.fragment,s),c(H.$$.fragment,s),c(D.$$.fragment,s),c(K.$$.fragment,s),c(ts.$$.fragment,s),c(b.$$.fragment,s),c(es.$$.fragment,s),c(as.$$.fragment,s),c(ps.$$.fragment,s),c(os.$$.fragment,s),c(Js.$$.fragment,s),c(cs.$$.fragment,s),c(ys.$$.fragment,s),c(ms.$$.fragment,s),c(us.$$.fragment,s),c(fs.$$.fragment,s),Zl=!0)},o(s){w(f.$$.fragment,s),w(C.$$.fragment,s),w(d.$$.fragment,s),w(G.$$.fragment,s),w(_.$$.fragment,s),w(Z.$$.fragment,s),w(k.$$.fragment,s),w(E.$$.fragment,s),w(I.$$.fragment,s),w(R.$$.fragment,s),w(x.$$.fragment,s),w(W.$$.fragment,s),w(z.$$.fragment,s),w(H.$$.fragment,s),w(D.$$.fragment,s),w(K.$$.fragment,s),w(ts.$$.fragment,s),w(b.$$.fragment,s),w(es.$$.fragment,s),w(as.$$.fragment,s),w(ps.$$.fragment,s),w(os.$$.fragment,s),w(Js.$$.fragment,s),w(cs.$$.fragment,s),w(ys.$$.fragment,s),w(ms.$$.fragment,s),w(us.$$.fragment,s),w(fs.$$.fragment,s),Zl=!1},d(s){s&&(t(m),t(u),t(gs),t(Bs),t(Gs),t(g),t(As),t(B),t(_s),t(Zs),t(Vs),t(A),t(ks),t($s),t(Es),t(V),t(Qs),t(Rs),t($),t(Ns),t(vs),t(Q),t(xs),t(Xs),t(Ws),t(N),t(Fs),t(v),t(zs),t(qs),t(X),t(Ys),t(Hs),t(F),t(Ss),t(Ls),t(q),t(Ds),t(Y),t(Ps),t(Ks),t(S),t(Os),t(L),t(sl),t(ll),t(P),t(tl),t(el),t(O),t(nl),t(ss),t(al),t(ls),t(Ml),t(pl),t(il),t(ol),t(ns),t(rl),t(Jl),t(Ms),t(cl),t(wl),t(is),t(yl),t(Tl),t(rs),t(ml),t(jl),t(ul),t(ws),t(Ul),t(hl),t(Ts),t(dl),t(Il),t(js),t(bl),t(fl),t(Us),t(Cl),t(hs),t(gl),t(ds),t(Bl),t(Is),t(Gl),t(bs),t(Al),t(_l),t(Cs)),t(T),y(f,s),y(C,s),y(d,s),y(G,s),y(_,s),y(Z,s),y(k,s),y(E,s),y(I,s),y(R,s),y(x,s),y(W,s),y(z,s),y(H,s),y(D,s),y(K,s),y(ts,s),y(b,s),y(es,s),y(as,s),y(ps,s),y(os,s),y(Js,s),y(cs,s),y(ys,s),y(ms,s),y(us,s),y(fs,s)}}}const Gt='{"title":"Practical Exercise: GRPO with Unsloth","local":"practical-exercise-grpo-with-unsloth","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Setting up Unsloth","local":"setting-up-unsloth","sections":[],"depth":2},{"title":"Data Preparation","local":"data-preparation","sections":[],"depth":2},{"title":"Defining Reward Functions","local":"defining-reward-functions","sections":[],"depth":2},{"title":"Training with GRPO","local":"training-with-grpo","sections":[],"depth":2},{"title":"Testing the Model","local":"testing-the-model","sections":[],"depth":2},{"title":"Saving the Model","local":"saving-the-model","sections":[],"depth":2},{"title":"Pushing to Hugging Face Hub","local":"pushing-to-hugging-face-hub","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function At(h){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends ut{constructor(T){super(),Ut(this,T,At,Bt,mt,{})}}export{Qt as component};
