import{s as $t,o as vt,n as Be}from"../chunks/scheduler.8c3d61f6.js";import{S as Wt,i as Rt,g as p,s as a,r as u,A as Xt,h as y,f as s,c as i,j as _t,u as c,x as d,k as mt,y as Ft,a as n,v as J,d as M,t as T,w as b}from"../chunks/index.da70eac4.js";import{T as pt}from"../chunks/Tip.1d9b8c37.js";import{C as k}from"../chunks/CodeBlock.00a903b3.js";import{H,E as Gt}from"../chunks/EditOnGithub.1e64e623.js";import{H as kt,a as It}from"../chunks/HfOption.c1483eb1.js";function Et(E){let o,Z="Quantizing a model in 8-bit halves the memory-usage:",m,h,f=`bitsandbytes is supported in both Transformers and Diffusers, so you can quantize both the
<a href="/docs/diffusers/pr_10012/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,C,w,G,j,z="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",Q,g,W,B,N="Let’s generate an image using our quantized models.",R,_,q=`Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the
CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.`,X,I,V,U,x='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/8bit.png"/>',F,$,Y='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/pr_10012/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 8-bit models locally with <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',v;return w=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl84Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>,
)

text_encoder_2_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>,
)

transformer_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),g=new k({props:{code:"dHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSk=",highlighted:`transformer_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float32,
)`,wrap:!1}}),I=new k({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9rd2FyZ3MlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEElMEFpbWFnZS5yZXNpemUoKDIyNCUyQyUyMDIyNCkp",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_8bit,
    text_encoder_2=text_encoder_2_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
    **pipe_kwargs,
).images[<span class="hljs-number">0</span>]

image.resize((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))`,wrap:!1}}),{c(){o=p("p"),o.textContent=Z,m=a(),h=p("p"),h.innerHTML=f,C=a(),u(w.$$.fragment),G=a(),j=p("p"),j.innerHTML=z,Q=a(),u(g.$$.fragment),W=a(),B=p("p"),B.textContent=N,R=a(),_=p("p"),_.innerHTML=q,X=a(),u(I.$$.fragment),V=a(),U=p("div"),U.innerHTML=x,F=a(),$=p("p"),$.innerHTML=Y,this.h()},l(t){o=y(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-4djpqq"&&(o.textContent=Z),m=i(t),h=y(t,"P",{"data-svelte-h":!0}),d(h)!=="svelte-1jjzczl"&&(h.innerHTML=f),C=i(t),c(w.$$.fragment,t),G=i(t),j=y(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1qozsrk"&&(j.innerHTML=z),Q=i(t),c(g.$$.fragment,t),W=i(t),B=y(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-2bde4h"&&(B.textContent=N),R=i(t),_=y(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1eyrcy7"&&(_.innerHTML=q),X=i(t),c(I.$$.fragment,t),V=i(t),U=y(t,"DIV",{class:!0,"data-svelte-h":!0}),d(U)!=="svelte-14afenp"&&(U.innerHTML=x),F=i(t),$=y(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-gmmigy"&&($.innerHTML=Y),this.h()},h(){mt(U,"class","flex justify-center")},m(t,r){n(t,o,r),n(t,m,r),n(t,h,r),n(t,C,r),J(w,t,r),n(t,G,r),n(t,j,r),n(t,Q,r),J(g,t,r),n(t,W,r),n(t,B,r),n(t,R,r),n(t,_,r),n(t,X,r),J(I,t,r),n(t,V,r),n(t,U,r),n(t,F,r),n(t,$,r),v=!0},p:Be,i(t){v||(M(w.$$.fragment,t),M(g.$$.fragment,t),M(I.$$.fragment,t),v=!0)},o(t){T(w.$$.fragment,t),T(g.$$.fragment,t),T(I.$$.fragment,t),v=!1},d(t){t&&(s(o),s(m),s(h),s(C),s(G),s(j),s(Q),s(W),s(B),s(R),s(_),s(X),s(V),s(U),s(F),s($)),b(w,t),b(g,t),b(I,t)}}}function Vt(E){let o,Z="Quantizing a model in 4-bit reduces your memory-usage by 4x:",m,h,f=`bitsandbytes is supported in both Transformers and Diffusers, so you can can quantize both the
<a href="/docs/diffusers/pr_10012/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a> and <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>.`,C,w,G,j,z="By default, all the other modules such as <code>torch.nn.LayerNorm</code> are converted to <code>torch.float16</code>. You can change the data type of these modules with the <code>torch_dtype</code> parameter.",Q,g,W,B,N="Let’s generate an image using our quantized models.",R,_,q="Setting <code>device_map=&quot;auto&quot;</code> automatically fills all available space on the GPU(s) first, then the CPU, and finally, the hard drive (the absolute slowest option) if there is still not enough memory.",X,I,V,U,x='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/4bit.png"/>',F,$,Y='Once a model is quantized, you can push the model to the Hub with the <a href="/docs/diffusers/pr_10012/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method. The quantization <code>config.json</code> file is pushed first, followed by the quantized model weights. You can also save the serialized 4-bit models locally with <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.',v;return w=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0JTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2Rlcl8yJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSklMEElMEF0cmFuc2Zvcm1lcl80Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),g=new k({props:{code:"dHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSk=",highlighted:`transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float32,
)`,wrap:!1}}),I=new k({props:{code:"cGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfMl80Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEEpJTBBJTBBcGlwZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1aWRhbmNlX3NjYWxlJTIyJTNBJTIwMy41JTJDJTBBJTIwJTIwJTIwJTIwJTIybnVtX2luZmVyZW5jZV9zdGVwcyUyMiUzQSUyMDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDUxMiUyQyUwQSU3RCUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9rd2FyZ3MlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEElMEFpbWFnZS5yZXNpemUoKDIyNCUyQyUyMDIyNCkp",highlighted:`pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=transformer_4bit,
    text_encoder_2=text_encoder_2_4bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

pipe_kwargs = {
    <span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>,
    <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>,
    <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">3.5</span>,
    <span class="hljs-string">&quot;num_inference_steps&quot;</span>: <span class="hljs-number">50</span>,
    <span class="hljs-string">&quot;max_sequence_length&quot;</span>: <span class="hljs-number">512</span>,
}

image = pipe(
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
    **pipe_kwargs,
).images[<span class="hljs-number">0</span>]

image.resize((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))`,wrap:!1}}),{c(){o=p("p"),o.textContent=Z,m=a(),h=p("p"),h.innerHTML=f,C=a(),u(w.$$.fragment),G=a(),j=p("p"),j.innerHTML=z,Q=a(),u(g.$$.fragment),W=a(),B=p("p"),B.textContent=N,R=a(),_=p("p"),_.innerHTML=q,X=a(),u(I.$$.fragment),V=a(),U=p("div"),U.innerHTML=x,F=a(),$=p("p"),$.innerHTML=Y,this.h()},l(t){o=y(t,"P",{"data-svelte-h":!0}),d(o)!=="svelte-i07c71"&&(o.textContent=Z),m=i(t),h=y(t,"P",{"data-svelte-h":!0}),d(h)!=="svelte-z8la1r"&&(h.innerHTML=f),C=i(t),c(w.$$.fragment,t),G=i(t),j=y(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1qozsrk"&&(j.innerHTML=z),Q=i(t),c(g.$$.fragment,t),W=i(t),B=y(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-2bde4h"&&(B.textContent=N),R=i(t),_=y(t,"P",{"data-svelte-h":!0}),d(_)!=="svelte-6ilppp"&&(_.innerHTML=q),X=i(t),c(I.$$.fragment,t),V=i(t),U=y(t,"DIV",{class:!0,"data-svelte-h":!0}),d(U)!=="svelte-qev6y1"&&(U.innerHTML=x),F=i(t),$=y(t,"P",{"data-svelte-h":!0}),d($)!=="svelte-13wiqqe"&&($.innerHTML=Y),this.h()},h(){mt(U,"class","flex justify-center")},m(t,r){n(t,o,r),n(t,m,r),n(t,h,r),n(t,C,r),J(w,t,r),n(t,G,r),n(t,j,r),n(t,Q,r),J(g,t,r),n(t,W,r),n(t,B,r),n(t,R,r),n(t,_,r),n(t,X,r),J(I,t,r),n(t,V,r),n(t,U,r),n(t,F,r),n(t,$,r),v=!0},p:Be,i(t){v||(M(w.$$.fragment,t),M(g.$$.fragment,t),M(I.$$.fragment,t),v=!0)},o(t){T(w.$$.fragment,t),T(g.$$.fragment,t),T(I.$$.fragment,t),v=!1},d(t){t&&(s(o),s(m),s(h),s(C),s(G),s(j),s(Q),s(W),s(B),s(R),s(_),s(X),s(V),s(U),s(F),s($)),b(w,t),b(g,t),b(I,t)}}}function zt(E){let o,Z,m,h;return o=new It({props:{id:"bnb",option:"8-bit",$$slots:{default:[Et]},$$scope:{ctx:E}}}),m=new It({props:{id:"bnb",option:"4-bit",$$slots:{default:[Vt]},$$scope:{ctx:E}}}),{c(){u(o.$$.fragment),Z=a(),u(m.$$.fragment)},l(f){c(o.$$.fragment,f),Z=i(f),c(m.$$.fragment,f)},m(f,C){J(o,f,C),n(f,Z,C),J(m,f,C),h=!0},p(f,C){const w={};C&2&&(w.$$scope={dirty:C,ctx:f}),o.$set(w);const G={};C&2&&(G.$$scope={dirty:C,ctx:f}),m.$set(G)},i(f){h||(M(o.$$.fragment,f),M(m.$$.fragment,f),h=!0)},o(f){T(o.$$.fragment,f),T(m.$$.fragment,f),h=!1},d(f){f&&s(Z),b(o,f),b(m,f)}}}function Qt(E){let o,Z="Training with 8-bit and 4-bit weights are only supported for training <em>extra</em> parameters.";return{c(){o=p("p"),o.innerHTML=Z},l(m){o=y(m,"P",{"data-svelte-h":!0}),d(o)!=="svelte-of9sym"&&(o.innerHTML=Z)},m(m,h){n(m,o,h)},p:Be,d(m){m&&s(o)}}}function Nt(E){let o,Z='Learn more about the details of 8-bit quantization in this <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blog post</a>!';return{c(){o=p("p"),o.innerHTML=Z},l(m){o=y(m,"P",{"data-svelte-h":!0}),d(o)!=="svelte-1bb05fp"&&(o.innerHTML=Z)},m(m,h){n(m,o,h)},p:Be,d(m){m&&s(o)}}}function qt(E){let o,Z='Learn more about its details in this <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">blog post</a>.';return{c(){o=p("p"),o.innerHTML=Z},l(m){o=y(m,"P",{"data-svelte-h":!0}),d(o)!=="svelte-kpdzjq"&&(o.innerHTML=Z)},m(m,h){n(m,o,h)},p:Be,d(m){m&&s(o)}}}function xt(E){let o,Z,m,h,f,C,w,G='<a href="https://huggingface.co/docs/bitsandbytes/index" rel="nofollow">bitsandbytes</a> is the easiest option for quantizing a model to 8 and 4-bit. 8-bit quantization multiplies outliers in fp16 with non-outliers in int8, converts the non-outlier values back to fp16, and then adds them together to return the weights in fp16. This reduces the degradative effect outlier values have on a model’s performance.',j,z,Q='4-bit quantization compresses a model even further, and it is commonly used with <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> to finetune quantized LLMs.',g,W,B=`This guide demonstrates how quantization can enable running
<a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a>
on less than 16GB of VRAM and even on a free Google
Colab instance.`,N,R,_='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/quant-bnb/comparison.png" alt="comparison image"/>',q,X,I="To use bitsandbytes, make sure you have the following libraries installed:",V,U,x,F,$='Now you can quantize a model by passing a <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a> to <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>. This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',Y,v,t,r,_e,S,yt="Check your memory footprint with the <code>get_memory_footprint</code> method:",Ie,D,$e,P,dt='Quantized models can be loaded from the <a href="/docs/diffusers/pr_10012/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method without needing to specify the <code>quantization_config</code> parameters:',ve,K,We,O,Re,A,Xe,ee,ft="This section explores some of the specific features of 8-bit models, such as outlier thresholds and skipping module conversion.",Fe,te,Ge,se,ut="An “outlier” is a hidden state value greater than a certain threshold, and these values are computed in fp16. While the values are usually normally distributed ([-3.5, 3.5]), this distribution can be very different for large models ([-60, 6] or [6, 60]). 8-bit quantization works well for values ~5, but beyond that, there is a significant performance penalty. A good default threshold value is 6, but a lower threshold may be needed for more unstable models (small models or finetuning).",ke,le,ct='To find the best threshold for your model, we recommend experimenting with the <code>llm_int8_threshold</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ee,ne,Ve,ae,ze,ie,Jt='For some models, you don’t need to quantize every module to 8-bit which can actually cause instability. For example, for diffusion models like <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>, the <code>proj_out</code> module can be skipped using the <code>llm_int8_skip_modules</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Qe,oe,Ne,re,qe,L,xe,me,Mt="This section explores some of the specific features of 4-bit models, such as changing the compute data type, using the Normal Float 4 (NF4) data type, and using nested quantization.",Ye,pe,He,ye,Tt='To speedup computation, you can change the data type from float32 (the default value) to bf16 using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',Ae,de,Le,fe,Se,ue,bt='NF4 is a 4-bit data type from the <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> paper, adapted for weights initialized from a normal distribution. You should use NF4 for training 4-bit base models. This can be configured with the <code>bnb_4bit_quant_type</code> parameter in the <a href="/docs/diffusers/pr_10012/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>:',De,ce,Pe,Je,ht="For inference, the <code>bnb_4bit_quant_type</code> does not have a huge impact on performance. However, to remain consistent with the model weights, you should use the <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> values.",Ke,Me,Oe,Te,wt="Nested quantization is a technique that can save additional memory at no additional performance cost. This feature performs a second quantization of the already quantized weights to save an additional 0.4 bits/parameter.",et,be,tt,he,st,we,Ut="Once quantized, you can dequantize a model to its original precision, but this might result in a small loss of quality. Make sure you have enough GPU RAM to fit the dequantized model.",lt,Ue,nt,Ze,at,Ce,Zt='<li><a href="https://gist.github.com/sayakpaul/c76bd845b48759e11687ac550b99d8b4" rel="nofollow">End-to-end notebook showing Flux.1 Dev inference in a free-tier Colab</a></li> <li><a href="https://gist.github.com/sayakpaul/05afd428bc089b47af7c016e42004527" rel="nofollow">Training</a></li>',it,je,ot,ge,rt;return f=new H({props:{title:"bitsandbytes",local:"bitsandbytes",headingTag:"h1"}}),U=new k({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMjAtVQ==",highlighted:"pip install diffusers transformers accelerate bitsandbytes -U",wrap:!1}}),v=new kt({props:{id:"bnb",options:["8-bit","4-bit"],$$slots:{default:[zt]},$$scope:{ctx:E}}}),r=new pt({props:{warning:!0,$$slots:{default:[Qt]},$$scope:{ctx:E}}}),D=new k({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),K=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUpJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZmbHV4LjEtZGV2LW5mNC1wa2clMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;hf-internal-testing/flux.1-dev-nf4-pkg&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>
)`,wrap:!1}}),O=new H({props:{title:"8-bit (LLM.int8() algorithm)",local:"8-bit-llmint8-algorithm",headingTag:"h2"}}),A=new pt({props:{$$slots:{default:[Nt]},$$scope:{ctx:E}}}),te=new H({props:{title:"Outlier threshold",local:"outlier-threshold",headingTag:"h3"}}),ne=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBsbG1faW50OF90aHJlc2hvbGQlM0QxMCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),ae=new H({props:{title:"Skip module conversion",local:"skip-module-conversion",headingTag:"h3"}}),oe=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFNEM1RyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUyMGxsbV9pbnQ4X3NraXBfbW9kdWxlcyUzRCU1QiUyMnByb2pfb3V0JTIyJTVEJTJDJTBBKSUwQSUwQW1vZGVsXzhiaXQlMjAlM0QlMjBTRDNUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SD3Transformer2DModel, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_skip_modules=[<span class="hljs-string">&quot;proj_out&quot;</span>],
)

model_8bit = SD3Transformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
)`,wrap:!1}}),re=new H({props:{title:"4-bit (QLoRA algorithm)",local:"4-bit-qlora-algorithm",headingTag:"h2"}}),L=new pt({props:{$$slots:{default:[qt]},$$scope:{ctx:E}}}),pe=new H({props:{title:"Compute data type",local:"compute-data-type",headingTag:"h3"}}),de=new k({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),fe=new H({props:{title:"Normal Float 4 (NF4)",local:"normal-float-4-nf4",headingTag:"h3"}}),ce=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBdGV4dF9lbmNvZGVyXzJfNGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBKSUwQSUwQXRyYW5zZm9ybWVyXzRiaXQlMjAlM0QlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Me=new H({props:{title:"Nested quantization",local:"nested-quantization",headingTag:"h3"}}),be=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)`,wrap:!1}}),he=new H({props:{title:"Dequantizing bitsandbytes models",local:"dequantizing-bitsandbytes-models",headingTag:"h2"}}),Ue=new k({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBUcmFuc2Zvcm1lcnNCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQXRleHRfZW5jb2Rlcl8yXzRiaXQlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyXzIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEEpJTBBJTBBdHJhbnNmb3JtZXJfNGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEF0ZXh0X2VuY29kZXJfMl80Yml0LmRlcXVhbnRpemUoKSUwQXRyYW5zZm9ybWVyXzRiaXQuZGVxdWFudGl6ZSgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel

quant_config = TransformersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

text_encoder_2_4bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

transformer_4bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

text_encoder_2_4bit.dequantize()
transformer_4bit.dequantize()`,wrap:!1}}),Ze=new H({props:{title:"Resources",local:"resources",headingTag:"h2"}}),je=new Gt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/bitsandbytes.md"}}),{c(){o=p("meta"),Z=a(),m=p("p"),h=a(),u(f.$$.fragment),C=a(),w=p("p"),w.innerHTML=G,j=a(),z=p("p"),z.innerHTML=Q,g=a(),W=p("p"),W.innerHTML=B,N=a(),R=p("p"),R.innerHTML=_,q=a(),X=p("p"),X.textContent=I,V=a(),u(U.$$.fragment),x=a(),F=p("p"),F.innerHTML=$,Y=a(),u(v.$$.fragment),t=a(),u(r.$$.fragment),_e=a(),S=p("p"),S.innerHTML=yt,Ie=a(),u(D.$$.fragment),$e=a(),P=p("p"),P.innerHTML=dt,ve=a(),u(K.$$.fragment),We=a(),u(O.$$.fragment),Re=a(),u(A.$$.fragment),Xe=a(),ee=p("p"),ee.textContent=ft,Fe=a(),u(te.$$.fragment),Ge=a(),se=p("p"),se.textContent=ut,ke=a(),le=p("p"),le.innerHTML=ct,Ee=a(),u(ne.$$.fragment),Ve=a(),u(ae.$$.fragment),ze=a(),ie=p("p"),ie.innerHTML=Jt,Qe=a(),u(oe.$$.fragment),Ne=a(),u(re.$$.fragment),qe=a(),u(L.$$.fragment),xe=a(),me=p("p"),me.textContent=Mt,Ye=a(),u(pe.$$.fragment),He=a(),ye=p("p"),ye.innerHTML=Tt,Ae=a(),u(de.$$.fragment),Le=a(),u(fe.$$.fragment),Se=a(),ue=p("p"),ue.innerHTML=bt,De=a(),u(ce.$$.fragment),Pe=a(),Je=p("p"),Je.innerHTML=ht,Ke=a(),u(Me.$$.fragment),Oe=a(),Te=p("p"),Te.textContent=wt,et=a(),u(be.$$.fragment),tt=a(),u(he.$$.fragment),st=a(),we=p("p"),we.textContent=Ut,lt=a(),u(Ue.$$.fragment),nt=a(),u(Ze.$$.fragment),at=a(),Ce=p("ul"),Ce.innerHTML=Zt,it=a(),u(je.$$.fragment),ot=a(),ge=p("p"),this.h()},l(e){const l=Xt("svelte-u9bgzb",document.head);o=y(l,"META",{name:!0,content:!0}),l.forEach(s),Z=i(e),m=y(e,"P",{}),_t(m).forEach(s),h=i(e),c(f.$$.fragment,e),C=i(e),w=y(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1m50ob7"&&(w.innerHTML=G),j=i(e),z=y(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-11pyf03"&&(z.innerHTML=Q),g=i(e),W=y(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1erhi5i"&&(W.innerHTML=B),N=i(e),R=y(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-ryfe7d"&&(R.innerHTML=_),q=i(e),X=y(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-gf36q7"&&(X.textContent=I),V=i(e),c(U.$$.fragment,e),x=i(e),F=y(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-js0psj"&&(F.innerHTML=$),Y=i(e),c(v.$$.fragment,e),t=i(e),c(r.$$.fragment,e),_e=i(e),S=y(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-139tok6"&&(S.innerHTML=yt),Ie=i(e),c(D.$$.fragment,e),$e=i(e),P=y(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1sw5q2p"&&(P.innerHTML=dt),ve=i(e),c(K.$$.fragment,e),We=i(e),c(O.$$.fragment,e),Re=i(e),c(A.$$.fragment,e),Xe=i(e),ee=y(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1myadau"&&(ee.textContent=ft),Fe=i(e),c(te.$$.fragment,e),Ge=i(e),se=y(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-ur5rgd"&&(se.textContent=ut),ke=i(e),le=y(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1gvj5wj"&&(le.innerHTML=ct),Ee=i(e),c(ne.$$.fragment,e),Ve=i(e),c(ae.$$.fragment,e),ze=i(e),ie=y(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-rkwz6m"&&(ie.innerHTML=Jt),Qe=i(e),c(oe.$$.fragment,e),Ne=i(e),c(re.$$.fragment,e),qe=i(e),c(L.$$.fragment,e),xe=i(e),me=y(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-7ob7j"&&(me.textContent=Mt),Ye=i(e),c(pe.$$.fragment,e),He=i(e),ye=y(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-i3bhq"&&(ye.innerHTML=Tt),Ae=i(e),c(de.$$.fragment,e),Le=i(e),c(fe.$$.fragment,e),Se=i(e),ue=y(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1jbdjte"&&(ue.innerHTML=bt),De=i(e),c(ce.$$.fragment,e),Pe=i(e),Je=y(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1qoc2ct"&&(Je.innerHTML=ht),Ke=i(e),c(Me.$$.fragment,e),Oe=i(e),Te=y(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-ep1hhf"&&(Te.textContent=wt),et=i(e),c(be.$$.fragment,e),tt=i(e),c(he.$$.fragment,e),st=i(e),we=y(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-lubruw"&&(we.textContent=Ut),lt=i(e),c(Ue.$$.fragment,e),nt=i(e),c(Ze.$$.fragment,e),at=i(e),Ce=y(e,"UL",{"data-svelte-h":!0}),d(Ce)!=="svelte-vejlmz"&&(Ce.innerHTML=Zt),it=i(e),c(je.$$.fragment,e),ot=i(e),ge=y(e,"P",{}),_t(ge).forEach(s),this.h()},h(){mt(o,"name","hf:doc:metadata"),mt(o,"content",Yt)},m(e,l){Ft(document.head,o),n(e,Z,l),n(e,m,l),n(e,h,l),J(f,e,l),n(e,C,l),n(e,w,l),n(e,j,l),n(e,z,l),n(e,g,l),n(e,W,l),n(e,N,l),n(e,R,l),n(e,q,l),n(e,X,l),n(e,V,l),J(U,e,l),n(e,x,l),n(e,F,l),n(e,Y,l),J(v,e,l),n(e,t,l),J(r,e,l),n(e,_e,l),n(e,S,l),n(e,Ie,l),J(D,e,l),n(e,$e,l),n(e,P,l),n(e,ve,l),J(K,e,l),n(e,We,l),J(O,e,l),n(e,Re,l),J(A,e,l),n(e,Xe,l),n(e,ee,l),n(e,Fe,l),J(te,e,l),n(e,Ge,l),n(e,se,l),n(e,ke,l),n(e,le,l),n(e,Ee,l),J(ne,e,l),n(e,Ve,l),J(ae,e,l),n(e,ze,l),n(e,ie,l),n(e,Qe,l),J(oe,e,l),n(e,Ne,l),J(re,e,l),n(e,qe,l),J(L,e,l),n(e,xe,l),n(e,me,l),n(e,Ye,l),J(pe,e,l),n(e,He,l),n(e,ye,l),n(e,Ae,l),J(de,e,l),n(e,Le,l),J(fe,e,l),n(e,Se,l),n(e,ue,l),n(e,De,l),J(ce,e,l),n(e,Pe,l),n(e,Je,l),n(e,Ke,l),J(Me,e,l),n(e,Oe,l),n(e,Te,l),n(e,et,l),J(be,e,l),n(e,tt,l),J(he,e,l),n(e,st,l),n(e,we,l),n(e,lt,l),J(Ue,e,l),n(e,nt,l),J(Ze,e,l),n(e,at,l),n(e,Ce,l),n(e,it,l),J(je,e,l),n(e,ot,l),n(e,ge,l),rt=!0},p(e,[l]){const Ct={};l&2&&(Ct.$$scope={dirty:l,ctx:e}),v.$set(Ct);const jt={};l&2&&(jt.$$scope={dirty:l,ctx:e}),r.$set(jt);const gt={};l&2&&(gt.$$scope={dirty:l,ctx:e}),A.$set(gt);const Bt={};l&2&&(Bt.$$scope={dirty:l,ctx:e}),L.$set(Bt)},i(e){rt||(M(f.$$.fragment,e),M(U.$$.fragment,e),M(v.$$.fragment,e),M(r.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(O.$$.fragment,e),M(A.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(re.$$.fragment,e),M(L.$$.fragment,e),M(pe.$$.fragment,e),M(de.$$.fragment,e),M(fe.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(be.$$.fragment,e),M(he.$$.fragment,e),M(Ue.$$.fragment,e),M(Ze.$$.fragment,e),M(je.$$.fragment,e),rt=!0)},o(e){T(f.$$.fragment,e),T(U.$$.fragment,e),T(v.$$.fragment,e),T(r.$$.fragment,e),T(D.$$.fragment,e),T(K.$$.fragment,e),T(O.$$.fragment,e),T(A.$$.fragment,e),T(te.$$.fragment,e),T(ne.$$.fragment,e),T(ae.$$.fragment,e),T(oe.$$.fragment,e),T(re.$$.fragment,e),T(L.$$.fragment,e),T(pe.$$.fragment,e),T(de.$$.fragment,e),T(fe.$$.fragment,e),T(ce.$$.fragment,e),T(Me.$$.fragment,e),T(be.$$.fragment,e),T(he.$$.fragment,e),T(Ue.$$.fragment,e),T(Ze.$$.fragment,e),T(je.$$.fragment,e),rt=!1},d(e){e&&(s(Z),s(m),s(h),s(C),s(w),s(j),s(z),s(g),s(W),s(N),s(R),s(q),s(X),s(V),s(x),s(F),s(Y),s(t),s(_e),s(S),s(Ie),s($e),s(P),s(ve),s(We),s(Re),s(Xe),s(ee),s(Fe),s(Ge),s(se),s(ke),s(le),s(Ee),s(Ve),s(ze),s(ie),s(Qe),s(Ne),s(qe),s(xe),s(me),s(Ye),s(He),s(ye),s(Ae),s(Le),s(Se),s(ue),s(De),s(Pe),s(Je),s(Ke),s(Oe),s(Te),s(et),s(tt),s(st),s(we),s(lt),s(nt),s(at),s(Ce),s(it),s(ot),s(ge)),s(o),b(f,e),b(U,e),b(v,e),b(r,e),b(D,e),b(K,e),b(O,e),b(A,e),b(te,e),b(ne,e),b(ae,e),b(oe,e),b(re,e),b(L,e),b(pe,e),b(de,e),b(fe,e),b(ce,e),b(Me,e),b(be,e),b(he,e),b(Ue,e),b(Ze,e),b(je,e)}}}const Yt='{"title":"bitsandbytes","local":"bitsandbytes","sections":[{"title":"8-bit (LLM.int8() algorithm)","local":"8-bit-llmint8-algorithm","sections":[{"title":"Outlier threshold","local":"outlier-threshold","sections":[],"depth":3},{"title":"Skip module conversion","local":"skip-module-conversion","sections":[],"depth":3}],"depth":2},{"title":"4-bit (QLoRA algorithm)","local":"4-bit-qlora-algorithm","sections":[{"title":"Compute data type","local":"compute-data-type","sections":[],"depth":3},{"title":"Normal Float 4 (NF4)","local":"normal-float-4-nf4","sections":[],"depth":3},{"title":"Nested quantization","local":"nested-quantization","sections":[],"depth":3}],"depth":2},{"title":"Dequantizing bitsandbytes models","local":"dequantizing-bitsandbytes-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Ht(E){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Wt{constructor(o){super(),Rt(this,o,Ht,xt,$t,{})}}export{Ot as component};
