import{s as Xe,f as Fe,o as Le,n as De}from"../chunks/scheduler.f6b352c8.js";import{S as Ke,i as Oe,g as i,s as n,r as M,A as et,h as o,f as l,c as a,j as Ze,u as c,x as u,k as F,y as tt,a as s,v as m,d as r,t as y,w as d}from"../chunks/index.7f38e934.js";import{T as lt}from"../chunks/Tip.ae532637.js";import{C as J}from"../chunks/CodeBlock.3ee8293b.js";import{H as K,E as st}from"../chunks/getInferenceSnippets.7402b4e4.js";function nt(O){let p,h="Gradio is best suited to the creation of UI clients and MCP servers, but it is also possible to use it as an MCP Client and expose that as a UI.";return{c(){p=i("p"),p.textContent=h},l(w){p=o(w,"P",{"data-svelte-h":!0}),u(p)!=="svelte-1ld6o09"&&(p.textContent=h)},m(w,L){s(w,p,L)},p:De,d(w){w&&l(p)}}}function at(O){let p,h,w,L,b,ee,f,Qe="In the previous section, we explored how to create an MCP Server using Gradio and connect to it using an MCP Client. In this section, we’re going to explore how to use Gradio as an MCP Client to connect to an MCP Server.",te,j,le,g,We="We’ll connect to the MCP server we created in the previous section and use it to answer questions.",se,T,ne,$,Ne="First, we need to install the <code>smolagents</code>, gradio and mcp-client libraries, if we haven’t already:",ae,I,ie,B,Ae="Now, we can import the necessary libraries and create a simple Gradio interface that uses the MCP Client to connect to the MCP Server.",oe,G,pe,v,xe="Next, we’ll connect to the MCP Server and get the tools that we can use to answer questions.",Me,Z,ce,Q,ke="Now that we have the tools, we can create a simple agent that uses them to answer questions. We’ll just use a simple <code>InferenceClientModel</code> and the default model from <code>smolagents</code> for now.",me,W,re,N,Re="Now, we can create a simple Gradio interface that uses the agent to answer questions.",ye,A,de,x,Se="And that’s it! We’ve created a simple Gradio interface that uses the MCP Client to connect to the MCP Server and answer questions.",ue,C,Ve,we,k,Ce,R,He="Here’s the complete example of the MCP Client in Gradio:",je,S,Ue,V,Ye="You’ll notice that we’re closing the MCP Client in the <code>finally</code> block. This is important because the MCP Client is a long-lived object that needs to be closed when the program exits.",Je,H,he,Y,Ee=`To make your server available to others, you can deploy it to Hugging Face Spaces, just like we did in the previous section.
To deploy your Gradio MCP client to Hugging Face Spaces:`,be,E,Pe="<li><p>Create a new Space on Hugging Face:</p> <ul><li>Go to huggingface.co/spaces</li> <li>Click “Create new Space”</li> <li>Choose “Gradio” as the SDK</li> <li>Name your space (e.g., “mcp-client”)</li></ul></li> <li><p>Create a <code>requirements.txt</code> file:</p></li>",fe,P,ge,U,_e="<li>Push your code to the Space:</li>",Te,_,$e,q,Ie,z,qe="In this section, we’ve explored how to use Gradio as an MCP Client to connect to an MCP Server. We’ve also seen how to deploy the MCP Client in Hugging Face Spaces.",Be,X,Ge,D,ve;return b=new K({props:{title:"Gradio as an MCP Client",local:"gradio-as-an-mcp-client",headingTag:"h1"}}),j=new lt({props:{$$slots:{default:[nt]},$$scope:{ctx:O}}}),T=new K({props:{title:"MCP Client in Gradio",local:"mcp-client-in-gradio",headingTag:"h2"}}),I=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjIlMjAlMjJncmFkaW8lNUJtY3AlNUQlMjIlMjBtY3A=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span> <span class="hljs-string">&quot;gradio[mcp]&quot;</span> mcp',wrap:!1}}),G=new J({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWZyb20lMjBtY3AuY2xpZW50LnN0ZGlvJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUyQyUyMFRvb2xDb2xsZWN0aW9uJTBBZnJvbSUyMHNtb2xhZ2VudHMubWNwX2NsaWVudCUyMGltcG9ydCUyME1DUENsaWVudA==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, ToolCollection
<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient`,wrap:!1}}),Z=new J({props:{code:"bWNwX2NsaWVudCUyMCUzRCUyME1DUENsaWVudCglMEElMjAlMjAlMjAlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBNzg2MCUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2UlMjIlN0QlMEEpJTBBdG9vbHMlMjAlM0QlMjBtY3BfY2xpZW50LmdldF90b29scygp",highlighted:`mcp_client = MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>}
)
tools = mcp_client.get_tools()`,wrap:!1}}),W=new J({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKQ==",highlighted:`model = InferenceClientModel()
agent = CodeAgent(tools=[*tools], model=model)`,wrap:!1}}),A=new J({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkNoYXRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RsYW1iZGElMjBtZXNzYWdlJTJDJTIwaGlzdG9yeSUzQSUyMHN0cihhZ2VudC5ydW4obWVzc2FnZSkpJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMm1lc3NhZ2VzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0QlNUIlMjJQcmltZSUyMGZhY3Rvcml6YXRpb24lMjBvZiUyMDY4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJBZ2VudCUyMHdpdGglMjBNQ1AlMjBUb29scyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMGFnZW50JTIwdGhhdCUyMHVzZXMlMjBNQ1AlMjB0b29scyUyMHRvJTIwYW5zd2VyJTIwcXVlc3Rpb25zLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTVEJTJDJTBBKSUwQSUwQWRlbW8ubGF1bmNoKCk=",highlighted:`demo = gr.ChatInterface(
    fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    examples=[<span class="hljs-string">&quot;Prime factorization of 68&quot;</span>],
    title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
    description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>,
    messages=[],
)

demo.launch()`,wrap:!1}}),k=new K({props:{title:"Complete Example",local:"complete-example",headingTag:"h2"}}),S=new J({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWZyb20lMjBtY3AuY2xpZW50LnN0ZGlvJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUyQyUyMFRvb2xDb2xsZWN0aW9uJTBBZnJvbSUyMHNtb2xhZ2VudHMubWNwX2NsaWVudCUyMGltcG9ydCUyME1DUENsaWVudCUwQSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQlMjAlM0QlMjBNQ1BDbGllbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIwVHJ5JTIwdGhpcyUyMHdvcmtpbmclMjBleGFtcGxlJTIwb24lMjB0aGUlMjBodWIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmFiaWRsYWJzLW1jcC10b29scy5oZi5zcGFjZSUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2UlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBNzg2MCUyRmdyYWRpb19hcGklMkZtY3AlMkZzc2UlMjIlN0QlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwdG9vbHMlMjAlM0QlMjBtY3BfY2xpZW50LmdldF90b29scygpJTBBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQSUyMCUyMCUyMCUyMGRlbW8lMjAlM0QlMjBnci5DaGF0SW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuJTNEbGFtYmRhJTIwbWVzc2FnZSUyQyUyMGhpc3RvcnklM0ElMjBzdHIoYWdlbnQucnVuKG1lc3NhZ2UpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJtZXNzYWdlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEJTVCJTIyUHJpbWUlMjBmYWN0b3JpemF0aW9uJTIwb2YlMjA2OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyQWdlbnQlMjB3aXRoJTIwTUNQJTIwVG9vbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBpcyUyMGElMjBzaW1wbGUlMjBhZ2VudCUyMHRoYXQlMjB1c2VzJTIwTUNQJTIwdG9vbHMlMjB0byUyMGFuc3dlciUyMHF1ZXN0aW9ucy4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVtby5sYXVuY2goKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50LmRpc2Nvbm5lY3QoKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

<span class="hljs-keyword">from</span> mcp.client.stdio <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, ToolCollection
<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient


<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(
        <span class="hljs-comment">## Try this working example on the hub:</span>
        <span class="hljs-comment"># {&quot;url&quot;: &quot;https://abidlabs-mcp-tools.hf.space/gradio_api/mcp/sse&quot;}</span>
        {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>}
    )
    tools = mcp_client.get_tools()

    model = InferenceClientModel()
    agent = CodeAgent(tools=[*tools], model=model)

    demo = gr.ChatInterface(
        fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
        examples=[<span class="hljs-string">&quot;Prime factorization of 68&quot;</span>],
        title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
        description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>,
    )

    demo.launch()
<span class="hljs-keyword">finally</span>:
    mcp_client.disconnect()`,wrap:!1}}),H=new K({props:{title:"Deploying to Hugging Face Spaces",local:"deploying-to-hugging-face-spaces",headingTag:"h2"}}),P=new J({props:{code:"Z3JhZGlvJTVCbWNwJTVEJTBBc21vbGFnZW50cyU1Qm1jcCU1RA==",highlighted:`gradio[mcp]
smolagents[mcp]`,wrap:!1}}),_=new J({props:{code:"Z2l0JTIwaW5pdCUwQWdpdCUyMGFkZCUyMHNlcnZlci5weSUyMHJlcXVpcmVtZW50cy50eHQlMEFnaXQlMjBjb21taXQlMjAtbSUyMCUyMkluaXRpYWwlMjBjb21taXQlMjIlMEFnaXQlMjByZW1vdGUlMjBhZGQlMjBvcmlnaW4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGWU9VUl9VU0VSTkFNRSUyRm1jcC1jbGllbnQlMEFnaXQlMjBwdXNoJTIwLXUlMjBvcmlnaW4lMjBtYWlu",highlighted:`git init
git add server.py requirements.txt
git commit -m <span class="hljs-string">&quot;Initial commit&quot;</span>
git remote add origin https://huggingface.co/spaces/YOUR_USERNAME/mcp-client
git push -u origin main`,wrap:!1}}),q=new K({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),X=new st({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/gradio-client.mdx"}}),{c(){p=i("meta"),h=n(),w=i("p"),L=n(),M(b.$$.fragment),ee=n(),f=i("p"),f.textContent=Qe,te=n(),M(j.$$.fragment),le=n(),g=i("p"),g.textContent=We,se=n(),M(T.$$.fragment),ne=n(),$=i("p"),$.innerHTML=Ne,ae=n(),M(I.$$.fragment),ie=n(),B=i("p"),B.textContent=Ae,oe=n(),M(G.$$.fragment),pe=n(),v=i("p"),v.textContent=xe,Me=n(),M(Z.$$.fragment),ce=n(),Q=i("p"),Q.innerHTML=ke,me=n(),M(W.$$.fragment),re=n(),N=i("p"),N.textContent=Re,ye=n(),M(A.$$.fragment),de=n(),x=i("p"),x.textContent=Se,ue=n(),C=i("iframe"),we=n(),M(k.$$.fragment),Ce=n(),R=i("p"),R.textContent=He,je=n(),M(S.$$.fragment),Ue=n(),V=i("p"),V.innerHTML=Ye,Je=n(),M(H.$$.fragment),he=n(),Y=i("p"),Y.textContent=Ee,be=n(),E=i("ol"),E.innerHTML=Pe,fe=n(),M(P.$$.fragment),ge=n(),U=i("ol"),U.innerHTML=_e,Te=n(),M(_.$$.fragment),$e=n(),M(q.$$.fragment),Ie=n(),z=i("p"),z.textContent=qe,Be=n(),M(X.$$.fragment),Ge=n(),D=i("p"),this.h()},l(e){const t=et("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),h=a(e),w=o(e,"P",{}),Ze(w).forEach(l),L=a(e),c(b.$$.fragment,e),ee=a(e),f=o(e,"P",{"data-svelte-h":!0}),u(f)!=="svelte-dztswv"&&(f.textContent=Qe),te=a(e),c(j.$$.fragment,e),le=a(e),g=o(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-682wjj"&&(g.textContent=We),se=a(e),c(T.$$.fragment,e),ne=a(e),$=o(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-zsxhur"&&($.innerHTML=Ne),ae=a(e),c(I.$$.fragment,e),ie=a(e),B=o(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-2tsitc"&&(B.textContent=Ae),oe=a(e),c(G.$$.fragment,e),pe=a(e),v=o(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-d4u1me"&&(v.textContent=xe),Me=a(e),c(Z.$$.fragment,e),ce=a(e),Q=o(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-jz01ce"&&(Q.innerHTML=ke),me=a(e),c(W.$$.fragment,e),re=a(e),N=o(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-ysi4z1"&&(N.textContent=Re),ye=a(e),c(A.$$.fragment,e),de=a(e),x=o(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-1sa2kw9"&&(x.textContent=Se),ue=a(e),C=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ze(C).forEach(l),we=a(e),c(k.$$.fragment,e),Ce=a(e),R=o(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-jkw6n8"&&(R.textContent=He),je=a(e),c(S.$$.fragment,e),Ue=a(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1y1vlqe"&&(V.innerHTML=Ye),Je=a(e),c(H.$$.fragment,e),he=a(e),Y=o(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1kft0up"&&(Y.textContent=Ee),be=a(e),E=o(e,"OL",{"data-svelte-h":!0}),u(E)!=="svelte-1d97e6g"&&(E.innerHTML=Pe),fe=a(e),c(P.$$.fragment,e),ge=a(e),U=o(e,"OL",{start:!0,"data-svelte-h":!0}),u(U)!=="svelte-ok99j"&&(U.innerHTML=_e),Te=a(e),c(_.$$.fragment,e),$e=a(e),c(q.$$.fragment,e),Ie=a(e),z=o(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-b18oph"&&(z.textContent=qe),Be=a(e),c(X.$$.fragment,e),Ge=a(e),D=o(e,"P",{}),Ze(D).forEach(l),this.h()},h(){F(p,"name","hf:doc:metadata"),F(p,"content",it),Fe(C.src,Ve="https://mcp-course-unit2-gradio-client.hf.space")||F(C,"src",Ve),F(C,"frameborder","0"),F(C,"width","850"),F(C,"height","450"),F(U,"start","3")},m(e,t){tt(document.head,p),s(e,h,t),s(e,w,t),s(e,L,t),m(b,e,t),s(e,ee,t),s(e,f,t),s(e,te,t),m(j,e,t),s(e,le,t),s(e,g,t),s(e,se,t),m(T,e,t),s(e,ne,t),s(e,$,t),s(e,ae,t),m(I,e,t),s(e,ie,t),s(e,B,t),s(e,oe,t),m(G,e,t),s(e,pe,t),s(e,v,t),s(e,Me,t),m(Z,e,t),s(e,ce,t),s(e,Q,t),s(e,me,t),m(W,e,t),s(e,re,t),s(e,N,t),s(e,ye,t),m(A,e,t),s(e,de,t),s(e,x,t),s(e,ue,t),s(e,C,t),s(e,we,t),m(k,e,t),s(e,Ce,t),s(e,R,t),s(e,je,t),m(S,e,t),s(e,Ue,t),s(e,V,t),s(e,Je,t),m(H,e,t),s(e,he,t),s(e,Y,t),s(e,be,t),s(e,E,t),s(e,fe,t),m(P,e,t),s(e,ge,t),s(e,U,t),s(e,Te,t),m(_,e,t),s(e,$e,t),m(q,e,t),s(e,Ie,t),s(e,z,t),s(e,Be,t),m(X,e,t),s(e,Ge,t),s(e,D,t),ve=!0},p(e,[t]){const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),j.$set(ze)},i(e){ve||(r(b.$$.fragment,e),r(j.$$.fragment,e),r(T.$$.fragment,e),r(I.$$.fragment,e),r(G.$$.fragment,e),r(Z.$$.fragment,e),r(W.$$.fragment,e),r(A.$$.fragment,e),r(k.$$.fragment,e),r(S.$$.fragment,e),r(H.$$.fragment,e),r(P.$$.fragment,e),r(_.$$.fragment,e),r(q.$$.fragment,e),r(X.$$.fragment,e),ve=!0)},o(e){y(b.$$.fragment,e),y(j.$$.fragment,e),y(T.$$.fragment,e),y(I.$$.fragment,e),y(G.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(A.$$.fragment,e),y(k.$$.fragment,e),y(S.$$.fragment,e),y(H.$$.fragment,e),y(P.$$.fragment,e),y(_.$$.fragment,e),y(q.$$.fragment,e),y(X.$$.fragment,e),ve=!1},d(e){e&&(l(h),l(w),l(L),l(ee),l(f),l(te),l(le),l(g),l(se),l(ne),l($),l(ae),l(ie),l(B),l(oe),l(pe),l(v),l(Me),l(ce),l(Q),l(me),l(re),l(N),l(ye),l(de),l(x),l(ue),l(C),l(we),l(Ce),l(R),l(je),l(Ue),l(V),l(Je),l(he),l(Y),l(be),l(E),l(fe),l(ge),l(U),l(Te),l($e),l(Ie),l(z),l(Be),l(Ge),l(D)),l(p),d(b,e),d(j,e),d(T,e),d(I,e),d(G,e),d(Z,e),d(W,e),d(A,e),d(k,e),d(S,e),d(H,e),d(P,e),d(_,e),d(q,e),d(X,e)}}}const it='{"title":"Gradio as an MCP Client","local":"gradio-as-an-mcp-client","sections":[{"title":"MCP Client in Gradio","local":"mcp-client-in-gradio","sections":[],"depth":2},{"title":"Complete Example","local":"complete-example","sections":[],"depth":2},{"title":"Deploying to Hugging Face Spaces","local":"deploying-to-hugging-face-spaces","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ot(O){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends Ke{constructor(p){super(),Oe(this,p,ot,at,Xe,{})}}export{yt as component};
