import{s as Ol,f as za,o as Zl,n as rt}from"../chunks/scheduler.65852ee5.js";import{S as Ll,i as Dl,g as s,s as n,r as i,A as Bl,h as p,f as a,c as r,j as Gl,u as j,x as o,k as lt,y as Yl,a as l,v as c,d as u,t as d,w as P}from"../chunks/index.aa74147d.js";import{T as nt}from"../chunks/Tip.bb8ccac8.js";import{D as Ql,C as V}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as U,E as Cl}from"../chunks/EditOnGithub.4eda6a96.js";function El(w){let f,m='Because we offer the Serverless Inference API for free, there are rate limits for regular Hugging Face users (~ few hundred requests per hour). For access to higher rate limits, you can <a href="https://huggingface.co/subscribe/pro" rel="nofollow">upgrade to a PRO account</a> for just $9 per month. However, for high-volume, production inference workloads, check out our <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Dedicated Inference Endpoints</a> solution.';return{c(){f=s("p"),f.innerHTML=m},l(H){f=p(H,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1p459xp"&&(f.innerHTML=m)},m(H,A){l(H,f,A)},p:rt,d(H){H&&a(f)}}}function $l(w){let f,m="For this notebook, you’ll need a fine-grained token with <code>Inference &gt; Make calls to the serverless Inference API</code> user permissions, along with read access to <code>meta-llama/Meta-Llama-3-8B-Instruct</code> and <code>HuggingFaceM4/idefics2-8b-chatty</code> repos as we must download their tokenizers to run this notebook.";return{c(){f=s("p"),f.innerHTML=m},l(H){f=p(H,"P",{"data-svelte-h":!0}),o(f)!=="svelte-104pg1n"&&(f.innerHTML=m)},m(H,A){l(H,f,A)},p:rt,d(H){H&&a(f)}}}function _l(w){let f,m='We’ve used the <code>interpreter_login()</code> above to programatically login to the Hub. As an alternative, we could also use other methods like <code>notebook_login()</code> from the <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python Library</a> or <code>login</code> command from the <a href="https://huggingface.co/docs/huggingface_hub/en/guides/cli#huggingface-cli-login" rel="nofollow">Hugging Face CLI tool</a>.';return{c(){f=s("p"),f.innerHTML=m},l(H){f=p(H,"P",{"data-svelte-h":!0}),o(f)!=="svelte-19xjiyi"&&(f.innerHTML=m)},m(H,A){l(H,f,A)},p:rt,d(H){H&&a(f)}}}function en(w){let f,m=`If the requested model is not already loaded into memory at the time of request (which is determined by recent requests for that model), the Serverless Inference API will initially return a 503 response, before it can successfully respond with the prediction. Try again after a few moments to allow the model time to spin up.
You can also check to see which models are loaded and available at any given time using <code>InferenceClient().list_deployed_models()</code>.`;return{c(){f=s("p"),f.innerHTML=m},l(H){f=p(H,"P",{"data-svelte-h":!0}),o(f)!=="svelte-qunjsk"&&(f.innerHTML=m)},m(H,A){l(H,f,A)},p:rt,d(H){H&&a(f)}}}function tn(w){let f,m='In addition to Python, you can also use JavaScript to integrate inference calls inside your JS or node apps. Take a look at <a href="https://huggingface.co/docs/huggingface.js/index" rel="nofollow">huggingface.js</a> to get started.';return{c(){f=s("p"),f.innerHTML=m},l(H){f=p(H,"P",{"data-svelte-h":!0}),o(f)!=="svelte-12t44zr"&&(f.innerHTML=m)},m(H,A){l(H,f,A)},p:rt,d(H){H&&a(f)}}}function an(w){let f,m,H,A,y,st,W,pt,b,Ga='<em>Authored by: <a href="https://huggingface.co/andrewrreed" rel="nofollow">Andrew Reed</a></em>',ot,k,Oa='Hugging Face provides a <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a> as a way for users to quickly test and evaluate thousands of publicly accessible (or your own privately permissioned) machine learning models with simple API calls <strong><em>for free</em></strong>!',ft,S,Za="In this notebook recipe, we’ll demonstrate several different ways you can query the Serverless Inference API while exploring various tasks including:",it,R,La="<li>generating text with open LLMs</li> <li>creating images with stable diffusion</li> <li>reasoning over images with VLMs</li> <li>generating speech from text</li>",jt,K,Da="The goal is to help you get started by covering the basics!",ct,T,ut,v,dt,X,Ba='To begin using the Serverless Inference API, you’ll need a Hugging Face Hub profile: you can <a href="https://huggingface.co/join" rel="nofollow">register</a> if you don’t have one or <a href="https://huggingface.co/login" rel="nofollow">login here</a> if you do.',Pt,J,Ya='Next, you’ll need to create a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>. A token with <code>read</code> or <code>write</code> permissions will work. However, we highly encourage the use of fine-grained tokens.',Ht,M,mt,N,Qa="With those steps out of the way, we can install our required packages and authenticate to the Hub with our User Access Token.",Vt,I,At,g,Ut,q,wt,F,Ca="Now, lets verify we’re properly logged in using <code>whoami()</code> to print out the active username and the organizations your profile belongs to.",Tt,z,Mt,G,qt,O,Ea="The Serverless Inference API exposes models on the Hub with a simple API:",xt,Z,$a="<code>https://api-inference.huggingface.co/models/&lt;MODEL_ID&gt;</code>",ht,L,_a="where <code>&lt;MODEL_ID&gt;</code> corresponds to the name of the model repo on the Hub.",yt,D,el='For example, <a href="https://huggingface.co/codellama/CodeLlama-7b-hf" rel="nofollow">codellama/CodeLlama-7b-hf</a> becomes <a href="https://api-inference.huggingface.co/models/codellama/CodeLlama-7b-hf" rel="nofollow">https://api-inference.huggingface.co/models/codellama/CodeLlama-7b-hf</a>',Wt,B,bt,Y,tl="We can easily call this API with a simple <code>POST</code> request via the <code>requests</code> library.",kt,Q,St,C,al="[&#123;'generated_text': 'A HTTP POST request is used to send data to a web server.\\n\\n# Example\\n```javascript\\npost(\"localhost:3000\", &#123;foo: \"bar\"})\\n  .then(console.log => console.log(\\'success\\'))\\n```\\n\\n'}]\n",Rt,E,ll="Nice! The API responded with a continuation of our input prompt. But you might be wondering… how did the API know what to do with the payload? And how do I as a user know which parameters can be passed for a given model?",Kt,$,nl='Behind the scenes, the inference API will dynamically load the requested model onto shared compute infrastructure to serve predictions. When the model is loaded, the Serverless Inference API will use the specified <code>pipeline_tag</code> from the Model Card (see <a href="https://huggingface.co/codellama/CodeLlama-7b-hf/blob/main/README.md?code=true#L4" rel="nofollow">here</a>) to determine the appropriate inference task. You can reference the corresponding <a href="https://huggingface.co/tasks" rel="nofollow">task</a> or <a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">pipeline</a> documentation to find the allowed arguments.',vt,x,Xt,_,Jt,ee,rl='To send your requests in Python, you can take advantage of the <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_client#huggingface_hub.InferenceClient" rel="nofollow"><code>InferenceClient</code></a>, a convenient utility available in the <code>huggingface_hub</code> Python library that allows you to easily make calls to the Serverless Inference API.',Nt,te,It,ae,sl=`A HTTP POST request is used to send data to a web server.

# Example
\`\`\`javascript
post("localhost:3000", &#123;foo: "bar"})
  .then(console.log => console.log('success'))
\`\`\`
`,gt,le,pl="Notice that with the <code>InferenceClient</code>, we specify just the model ID, and also pass arguments directly in the <code>text_generation()</code> method. We can easily inspect the function signature to see more details about how to use the task and its allowable parameters.",Ft,ne,zt,h,Gt,re,Ot,se,ol="Now that we know how the Serverless Inference API works, let’s take it for a spin and learn a few tricks along the way.",Zt,pe,Lt,oe,fl="Text generation is a very common use case. However, interacting with open LLMs has some subtleties that are important to understand to avoid silent performance degradation. When it comes to text generation, the underlying language model may come in a couple different flavors:",Dt,fe,il='<li><strong>Base models:</strong> refer to plain, pre-trained language models like <a href="https://huggingface.co/codellama/CodeLlama-7b-hf" rel="nofollow">codellama/CodeLlama-7b-hf</a> or <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow">meta-llama/Meta-Llama-3-8B</a>. These models are good at continuing generation from a provided prompt (like we saw in the example above). However, they have not been fine-tuned for conversational use like answering questions.</li> <li><strong>Instruction-tuned models:</strong> are trained in a multi-task manner to follow a broad range of instructions like “Write me a recipe for chocolate cake”. Models like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-8B-Instruct</a> or <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3" rel="nofollow">mistralai/Mistral-7B-Instruct-v0.3</a> are trained in this manner. Instruction-tuned models will produce better responses to instructions than base models. Often, these models are also fine-tuned for multi-turn chat dialogs, making them great for conversational use cases.</li>',Bt,ie,jl='These subtle differences are important to understand because they affect the way in which we should query a particular model. Instruct models are trained with <a href="https://huggingface.co/blog/chat-templates" rel="nofollow">chat templates</a> that are specific to the model, so you need to be careful about the format the model expects and replicate it in your queries.',Yt,je,cl='For example, <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-8B-Instruct</a> uses the following prompt structure to delineate between system, user, and assistant dialog turns:',Qt,ce,Ct,ue,ul='The special tokens, and prompt format vary model to model. To make sure we’re using the correct format, we can rely on a model’s <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat template</a> via it’s tokenizer, as shown below.',Et,de,$t,Pe,dl=`PROMPT:
-----

<|begin_of_text|><|start_header_id|>system<|end_header_id|>

You are an expert prompt engineer with artistic flair.<|eot_id|><|start_header_id|>user<|end_header_id|>

Write a concise prompt for a fun image containing a llama and a cookbook. Only return the prompt.<|eot_id|><|start_header_id|>assistant<|end_header_id|>
`,_t,He,Pl="Notice how the <code>apply_chat_template()</code> method has taken the familiar list of messages and converted them into the properly formated string that our model expects. We can use this formatted string to pass to the Serverless Inference API’s <code>text_generation</code> method.",ea,me,ta,Ve,Hl=`"A whimsical illustration of a llama proudly holding a cookbook, with a sassy expression and a sprinkle of flour on its nose, surrounded by a colorful kitchen backdrop with utensils and ingredients scattered about, as if the llama is about to whip up a culinary masterpiece."
`,aa,Ae,ml="Querying an LLM without adhering to the model’s prompt template <em>will not</em> produce any outright errors! However, it will result in poor quality outputs. Take a look at what happens when we pass the same system and user input, but <strong>without</strong> formatting it according to the chat template.",la,Ue,na,we,Vl=`Do not write the... 1 answer below »

You are an expert prompt engineer with artistic flair. Write a concise prompt for a fun image containing a llama and a cookbook. Only return the prompt. Do not write the image description.

A llama is sitting at a kitchen table, surrounded by cookbooks and utensils, with a cookbook open in front of it. The llama is wearing a chef's hat and holding a spatula. The cookbook is titled "Llama's Favorite Recipes" and has a llama on the cover. The llama is surrounded by a warm, golden light, and the kitchen is filled with the aroma of freshly baked bread. The llama is smiling and looking directly at the viewer, as if inviting them to join in the cooking fun. The image should be colorful, whimsical, and full of texture and detail. The llama should be the main focus of the image, and the cookbook should be prominently displayed. The background should be a warm, earthy color, such as terracotta or sienna. The overall mood of the image should be playful, inviting, and joyful. 1 answer below »

You are an expert prompt engineer with artistic flair. Write a concise prompt for a fun image containing a llama and a
`,ra,Te,Al="Yikes! The LLM hallucinated a non-sensical intro, repeated the prompt unexpectedly, and failed to remain concise. To simplify the prompting process and ensure the proper chat template is being used, the <code>InferenceClient</code> also offers a <code>chat_completion</code> method that abstracts away the <code>chat_template</code> details. This allows you to simply pass a list of messages:",sa,Me,pa,qe,Ul=`"A
 whims
ical
 illustration
 of
 a
 fashion
ably
 dressed
 llama
 proudly
 holding
 a
 worn
,
 vintage
 cookbook
,
 with
 a
 warm
 cup
 of
 tea
 and
 a
 few
 freshly
 baked
 treats
 scattered
 around
,
 set
 against
 a
 cozy
 background
 of
 rustic
 wood
 and
 blo
oming
 flowers
."
`,oa,xe,fa,he,wl="In the example above, we’ve also set <code>stream=True</code> to enable streaming text from the endpoint. To learn about more functionality like this and about best practices when querying LLMs, we recommend reading more on these supporting resources:",ia,ye,Tl='<li><a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">How to generate text: using different decoding methods for language generation with Transformers</a></li> <li><a href="https://huggingface.co/docs/transformers/generation_strategies" rel="nofollow">Text generation strategies</a></li> <li><a href="https://huggingface.co/blog/inference-pro" rel="nofollow">Inference for PROs</a> - particularly the section on <a href="https://huggingface.co/blog/inference-pro#controlling-text-generation" rel="nofollow">controlling text generation</a></li> <li><a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/inference_client#inference" rel="nofollow">Inference Client Docs</a></li>',ja,We,ca,be,Ml='The Serverless Inference API can be used for <a href="https://huggingface.co/tasks" rel="nofollow">many different tasks</a>. Here we’ll use it to generate images with Stable Diffusion.',ua,ke,da,_e,ql,Pa,Se,Ha,Re,xl="The <code>InferenceClient</code> will cache API responses by default. That means if you query the API with the same payload multiple times, you’ll see that the result returned by the API is exactly the same. Take a look:",ma,Ke,Va,et,hl,Aa,ve,yl="To force a different response each time, we can use a HTTP header to have the client ignore the cache and run a new generation: <code>x-use-cache: 0</code>.",Ua,Xe,wa,tt,Wl,Ta,Je,Ma,Ne,bl='Vision language models (VLMs) can take both text and images as input simultaneously and produce text as output. This allows them to tackle many tasks from visual question answering to image captioning. Let’s use the Serverless Inference API to query <a href="https://huggingface.co/blog/idefics2" rel="nofollow">Idefics2</a>, a powerful 8B parameter VLM, and have it write us a poem about our newly generated image.',qa,Ie,kl="We first need to convert our PIL image to a <code>base64</code> encoded string so that we can send it to the model over the network.",xa,ge,ha,Fe,Sl='Then, we need to properly format our text + image prompt using a chat template. See the <a href="https://huggingface.co/HuggingFaceM4/idefics2-8b" rel="nofollow">Idefics2 model card</a> for specific details on prompt formatting.',ya,ze,Wa,Ge,Rl="And then finally call the Serverless API to get a prediction. In our case, a fun limerick about our generated image!",ba,Oe,ka,Ze,Kl=`In the heart of a kitchen, so bright and so clean,
Lived a llama named Lulu, quite the culinary queen.
With a book in her hand, she'd read and she'd cook,
Her recipes were magic, her skills were so nook.
In her world, there was no room for defeat,
For Lulu, the kitchen was where she'd meet.
`,Sa,Le,Ra,De,vl='To finish up, let’s use a transformers-based, text-to-audio model called <a href="https://huggingface.co/suno/bark" rel="nofollow">Bark</a> to generate an audible voiceover for our poem.',Ka,Be,va,Ye,Xa,Qe,Xl=`In the heart of a kitchen, so bright and so clean,
Lived a llama named Lulu, quite the culinary queen.
With a book in her hand, she'd read and she'd cook,
Her recipes were magic, her skills were so nook.
In her world, there was no room for defeat,
For Lulu, the kitchen was where she'd meet.
`,Ja,Ce,Na,Ee,Jl='Thats it! In this notebook, we learned how to use the Serverless Inference API to query a variety of powerful transformer models. We’ve just scratched the surface of what you can do, and recommend checking out <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">the docs</a> to learn more about what’s possible.',Ia,$e,ga,at,Fa;return y=new Ql({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/multiagent_assist_improvements/notebooks/en/enterprise_hub_serverless_inference_api.ipynb"}]}}),W=new U({props:{title:"Serverless Inference API",local:"serverless-inference-api",headingTag:"h1"}}),T=new nt({props:{warning:!1,$$slots:{default:[El]},$$scope:{ctx:w}}}),v=new U({props:{title:"Let’s get started",local:"lets-get-started",headingTag:"h2"}}),M=new nt({props:{warning:!1,$$slots:{default:[$l]},$$scope:{ctx:w}}}),I=new V({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1VJTIwaHVnZ2luZ2ZhY2VfaHViJTIwdHJhbnNmb3JtZXJz",highlighted:"%pip install -U huggingface_hub transformers",wrap:!1}}),g=new V({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwaW50ZXJwcmV0ZXJfbG9naW4lMkMlMjB3aG9hbWklMkMlMjBnZXRfdG9rZW4lMEElMEElMjMlMjBydW5uaW5nJTIwdGhpcyUyMHdpbGwlMjBwcm9tcHQlMjB5b3UlMjB0byUyMGVudGVyJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwY3JlZGVudGlhbHMlMEFpbnRlcnByZXRlcl9sb2dpbigp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login, whoami, get_token

<span class="hljs-comment"># running this will prompt you to enter your Hugging Face credentials</span>
interpreter_login()`,wrap:!1}}),q=new nt({props:{warning:!1,$$slots:{default:[_l]},$$scope:{ctx:w}}}),z=new V({props:{code:"d2hvYW1pKCk=",highlighted:"whoami()",wrap:!1}}),G=new U({props:{title:"Querying the Serverless Inference API",local:"querying-the-serverless-inference-api",headingTag:"h2"}}),B=new U({props:{title:"With an HTTP request",local:"with-an-http-request",headingTag:"h3"}}),Q=new V({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFBUElfVVJMJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGY29kZWxsYW1hJTJGQ29kZUxsYW1hLTdiLWhmJTIyJTBBSEVBREVSUyUyMCUzRCUyMCU3QiUyMkF1dGhvcml6YXRpb24lMjIlM0ElMjBmJTIyQmVhcmVyJTIwJTdCZ2V0X3Rva2VuKCklN0QlMjIlN0QlMEElMEElMEFkZWYlMjBxdWVyeShwYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMucG9zdChBUElfVVJMJTJDJTIwaGVhZGVycyUzREhFQURFUlMlMkMlMjBqc29uJTNEcGF5bG9hZCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZS5qc29uKCklMEElMEElMEFwcmludCglMEElMjAlMjAlMjAlMjBxdWVyeSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXlsb2FkJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyQSUyMEhUVFAlMjBQT1NUJTIwcmVxdWVzdCUyMGlzJTIwdXNlZCUyMHRvJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMC44JTJDJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjA1MCUyQyUyMCUyMnNlZWQlMjIlM0ElMjA0MiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCklMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>API_URL = <span class="hljs-string">&quot;https://api-inference.huggingface.co/models/codellama/CodeLlama-7b-hf&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>HEADERS = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{get_token()}</span>&quot;</span>}


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">query</span>(<span class="hljs-params">payload</span>):
<span class="hljs-meta">... </span>    response = requests.post(API_URL, headers=HEADERS, json=payload)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> response.json()


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    query(
<span class="hljs-meta">... </span>        payload={
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;A HTTP POST request is used to &quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.8</span>, <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">50</span>, <span class="hljs-string">&quot;seed&quot;</span>: <span class="hljs-number">42</span>},
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),x=new nt({props:{warning:!1,$$slots:{default:[en]},$$scope:{ctx:w}}}),_=new U({props:{title:"With the huggingface_hub Python library",local:"with-the-huggingfacehub-python-library",headingTag:"h3"}}),te=new V({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBIVFRQJTIwUE9TVCUyMHJlcXVlc3QlMjBpcyUyMHVzZWQlMjB0byUyMCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyY29kZWxsYW1hJTJGQ29kZUxsYW1hLTdiLWhmJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwc2VlZCUzRDQyJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX2Z1bGxfdGV4dCUzRFRydWUlMkMlMEEpJTBBcHJpbnQocmVzcG9uc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;A HTTP POST request is used to &quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;codellama/CodeLlama-7b-hf&quot;</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.8</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    seed=<span class="hljs-number">42</span>,
<span class="hljs-meta">... </span>    return_full_text=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(response)`,wrap:!1}}),ne=new V({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdGhlJTIwZm9sbG93aW5nJTIwbGluZSUyMHRvJTIwc2VlJTIwdGhlJTIwZnVuY3Rpb24lMjBzaWduYXR1cmUlMEElMjMlMjBoZWxwKGNsaWVudC50ZXh0X2dlbmVyYXRpb24p",highlighted:`<span class="hljs-comment"># uncomment the following line to see the function signature</span>
<span class="hljs-comment"># help(client.text_generation)</span>`,wrap:!1}}),h=new nt({props:{warning:!1,$$slots:{default:[tn]},$$scope:{ctx:w}}}),re=new U({props:{title:"Applications",local:"applications",headingTag:"h2"}}),pe=new U({props:{title:"1. Generating Text with Open LLMs",local:"1-generating-text-with-open-llms",headingTag:"h3"}}),ce=new V({props:{code:"JTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXN5c3RlbSUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlMEElMEElN0IlN0IlMjBzeXN0ZW1fcHJvbXB0JTIwJTdEJTdEJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFdXNlciUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlMEElMEElN0IlN0IlMjB1c2VyX21zZ18xJTIwJTdEJTdEJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUwQSU3QiU3QiUyMG1vZGVsX2Fuc3dlcl8xJTIwJTdEJTdEJTNDJTdDZW90X2lkJTdDJTNF",highlighted:`&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;

{{ system_prompt }}&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;

{{ user_msg_1 }}&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;

{{ model_answer_1 }}&lt;|eot_id|&gt;`,wrap:!1}}),de=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBkZWZpbmUlMjB0aGUlMjBzeXN0ZW0lMjBhbmQlMjB1c2VyJTIwbWVzc2FnZXMlMEFzeXN0ZW1faW5wdXQlMjAlM0QlMjAlMjJZb3UlMjBhcmUlMjBhbiUyMGV4cGVydCUyMHByb21wdCUyMGVuZ2luZWVyJTIwd2l0aCUyMGFydGlzdGljJTIwZmxhaXIuJTIyJTBBdXNlcl9pbnB1dCUyMCUzRCUyMCUyMldyaXRlJTIwYSUyMGNvbmNpc2UlMjBwcm9tcHQlMjBmb3IlMjBhJTIwZnVuJTIwaW1hZ2UlMjBjb250YWluaW5nJTIwYSUyMGxsYW1hJTIwYW5kJTIwYSUyMGNvb2tib29rLiUyME9ubHklMjByZXR1cm4lMjB0aGUlMjBwcm9tcHQuJTIyJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHN5c3RlbV9pbnB1dCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHVzZXJfaW5wdXQlN0QlMkMlMEElNUQlMEElMEElMjMlMjBsb2FkJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbml6ZXIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEElMjMlMjBhcHBseSUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHRvJTIwdGhlJTIwbWVzc2FnZXMlMEFwcm9tcHQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQXByaW50KGYlMjIlNUNuUFJPTVBUJTNBJTVDbi0tLS0tJTVDbiU1Q24lN0Jwcm9tcHQlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the system and user messages</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>system_input = <span class="hljs-string">&quot;You are an expert prompt engineer with artistic flair.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>user_input = <span class="hljs-string">&quot;Write a concise prompt for a fun image containing a llama and a cookbook. Only return the prompt.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_input},
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_input},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># apply the chat template to the messages</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nPROMPT:\\n-----\\n\\n<span class="hljs-subst">{prompt}</span>&quot;</span>)`,wrap:!1}}),me=new V({props:{code:"bGxtX3Jlc3BvbnNlJTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihwcm9tcHQlMkMlMjBtb2RlbCUzRG1vZGVsX2lkJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTAlMkMlMjBzZWVkJTNENDIpJTBBcHJpbnQobGxtX3Jlc3BvbnNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>llm_response = client.text_generation(prompt, model=model_id, max_new_tokens=<span class="hljs-number">250</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(llm_response)`,wrap:!1}}),Ue=new V({props:{code:"b3V0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihzeXN0ZW1faW5wdXQlMjAlMkIlMjAlMjIlMjAlMjIlMjAlMkIlMjB1c2VyX2lucHV0JTJDJTIwbW9kZWwlM0Rtb2RlbF9pZCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjUwJTJDJTIwc2VlZCUzRDQyKSUwQXByaW50KG91dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>out = client.text_generation(system_input + <span class="hljs-string">&quot; &quot;</span> + user_input, model=model_id, max_new_tokens=<span class="hljs-number">250</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(out)`,wrap:!1}}),Me=new V({props:{code:"Zm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtb2RlbCUzRG1vZGVsX2lkJTJDJTIwbWF4X3Rva2VucyUzRDI1MCUyQyUyMHN0cmVhbSUzRFRydWUlMkMlMjBzZWVkJTNENDIpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4uY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, model=model_id, max_tokens=<span class="hljs-number">250</span>, stream=<span class="hljs-literal">True</span>, seed=<span class="hljs-number">42</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),xe=new U({props:{title:"Streaming",local:"streaming",headingTag:"h4"}}),We=new U({props:{title:"2. Creating Images with Stable Diffusion",local:"2-creating-images-with-stable-diffusion",headingTag:"h3"}}),ke=new V({props:{code:"aW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0RsbG1fcmVzcG9uc2UlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHNlZWQlM0Q0MiUyQyUwQSklMEElMEFkaXNwbGF5KGltYWdlLnJlc2l6ZSgoaW1hZ2Uud2lkdGglMjAlMkYlMkYlMjAyJTJDJTIwaW1hZ2UuaGVpZ2h0JTIwJTJGJTJGJTIwMikpKSUwQXByaW50KCUyMlBST01QVCUzQSUyMCUyMiUyQyUyMGxsbV9yZXNwb25zZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    prompt=llm_response,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    seed=<span class="hljs-number">42</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>display(image.resize((image.width // <span class="hljs-number">2</span>, image.height // <span class="hljs-number">2</span>)))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;PROMPT: &quot;</span>, llm_response)`,wrap:!1}}),Se=new U({props:{title:"Caching",local:"caching",headingTag:"h4"}}),Ke=new V({props:{code:"aW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0RsbG1fcmVzcG9uc2UlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHNlZWQlM0Q0MiUyQyUwQSklMEElMEFkaXNwbGF5KGltYWdlLnJlc2l6ZSgoaW1hZ2Uud2lkdGglMjAlMkYlMkYlMjAyJTJDJTIwaW1hZ2UuaGVpZ2h0JTIwJTJGJTJGJTIwMikpKSUwQXByaW50KCUyMlBST01QVCUzQSUyMCUyMiUyQyUyMGxsbV9yZXNwb25zZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    prompt=llm_response,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    seed=<span class="hljs-number">42</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>display(image.resize((image.width // <span class="hljs-number">2</span>, image.height // <span class="hljs-number">2</span>)))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;PROMPT: &quot;</span>, llm_response)`,wrap:!1}}),Xe=new V({props:{code:"JTIzJTIwdHVybiUyMGNhY2hpbmclMjBvZmYlMEFjbGllbnQuaGVhZGVycyU1QiUyMngtdXNlLWNhY2hlJTIyJTVEJTIwJTNEJTIwJTIyMCUyMiUwQSUwQSUyMyUyMGdlbmVyYXRlJTIwYSUyMG5ldyUyMGltYWdlJTIwd2l0aCUyMHRoZSUyMHNhbWUlMjBwcm9tcHQlMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRGxsbV9yZXNwb25zZSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwc2VlZCUzRDQyJTJDJTBBKSUwQSUwQWRpc3BsYXkoaW1hZ2UucmVzaXplKChpbWFnZS53aWR0aCUyMCUyRiUyRiUyMDIlMkMlMjBpbWFnZS5oZWlnaHQlMjAlMkYlMkYlMjAyKSkpJTBBcHJpbnQoJTIyUFJPTVBUJTNBJTIwJTIyJTJDJTIwbGxtX3Jlc3BvbnNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># turn caching off</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.headers[<span class="hljs-string">&quot;x-use-cache&quot;</span>] = <span class="hljs-string">&quot;0&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate a new image with the same prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    prompt=llm_response,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    seed=<span class="hljs-number">42</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>display(image.resize((image.width // <span class="hljs-number">2</span>, image.height // <span class="hljs-number">2</span>)))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;PROMPT: &quot;</span>, llm_response)`,wrap:!1}}),Je=new U({props:{title:"3. Reasoning Over Images with Idefics2",local:"3-reasoning-over-images-with-idefics2",headingTag:"h3"}}),ge=new V({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQSUwQSUwQWRlZiUyMHBpbF9pbWFnZV90b19iYXNlNjQoaW1hZ2UpJTNBJTBBJTIwJTIwJTIwJTIwYnVmZmVyZWQlMjAlM0QlMjBCeXRlc0lPKCklMEElMjAlMjAlMjAlMjBpbWFnZS5zYXZlKGJ1ZmZlcmVkJTJDJTIwZm9ybWF0JTNEJTIySlBFRyUyMiklMEElMjAlMjAlMjAlMjBpbWdfc3RyJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZShidWZmZXJlZC5nZXR2YWx1ZSgpKS5kZWNvZGUoJTIydXRmLTglMjIpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1nX3N0ciUwQSUwQSUwQWltYWdlX2I2NCUyMCUzRCUyMHBpbF9pbWFnZV90b19iYXNlNjQoaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO


<span class="hljs-keyword">def</span> <span class="hljs-title function_">pil_image_to_base64</span>(<span class="hljs-params">image</span>):
    buffered = BytesIO()
    image.save(buffered, <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;JPEG&quot;</span>)
    img_str = base64.b64encode(buffered.getvalue()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    <span class="hljs-keyword">return</span> img_str


image_b64 = pil_image_to_base64(image)`,wrap:!1}}),ze=new V({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEElMjMlMjBsb2FkJTIwdGhlJTIwcHJvY2Vzc29yJTBBdmxtX21vZGVsX2lkJTIwJTNEJTIwJTIySHVnZ2luZ0ZhY2VNNCUyRmlkZWZpY3MyLThiLWNoYXR0eSUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKHZsbV9tb2RlbF9pZCklMEElMEElMjMlMjBkZWZpbmUlMjB0aGUlMjB1c2VyJTIwbWVzc2FnZXMlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJpbWFnZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldyaXRlJTIwYSUyMHNob3J0JTIwbGltZXJpY2slMjBhYm91dCUyMHRoaXMlMjBpbWFnZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEElMEElMjMlMjBhcHBseSUyMHRoZSUyMGNoYXQlMjB0ZW1wbGF0ZSUyMHRvJTIwdGhlJTIwbWVzc2FnZXMlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUpJTBBJTBBJTIzJTIwYWRkJTIwdGhlJTIwYmFzZTY0JTIwZW5jb2RlZCUyMGltYWdlJTIwdG8lMjB0aGUlMjBwcm9tcHQlMEFpbWFnZV9pbnB1dCUyMCUzRCUyMGYlMjJkYXRhJTNBaW1hZ2UlMkZqcGVnJTNCYmFzZTY0JTJDJTdCaW1hZ2VfYjY0JTdEJTIyJTBBaW1hZ2VfaW5wdXQlMjAlM0QlMjBmJTIyISU1QiU1RCglN0JpbWFnZV9pbnB1dCU3RCklMjIlMEFwcm9tcHQlMjAlM0QlMjBwcm9tcHQucmVwbGFjZSglMjIlM0NpbWFnZSUzRSUyMiUyQyUyMGltYWdlX2lucHV0KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-comment"># load the processor</span>
vlm_model_id = <span class="hljs-string">&quot;HuggingFaceM4/idefics2-8b-chatty&quot;</span>
processor = AutoProcessor.from_pretrained(vlm_model_id)

<span class="hljs-comment"># define the user messages</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Write a short limerick about this image.&quot;</span>},
        ],
    },
]

<span class="hljs-comment"># apply the chat template to the messages</span>
prompt = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># add the base64 encoded image to the prompt</span>
image_input = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{image_b64}</span>&quot;</span>
image_input = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image_input}</span>)&quot;</span>
prompt = prompt.replace(<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, image_input)`,wrap:!1}}),Oe=new V({props:{code:"bGltZXJpY2slMjAlM0QlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKHByb21wdCUyQyUyMG1vZGVsJTNEdmxtX21vZGVsX2lkJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMDAlMkMlMjBzZWVkJTNENDIpJTBBcHJpbnQobGltZXJpY2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>limerick = client.text_generation(prompt, model=vlm_model_id, max_new_tokens=<span class="hljs-number">200</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(limerick)`,wrap:!1}}),Le=new U({props:{title:"4. Generating Speech from Text",local:"4-generating-speech-from-text",headingTag:"h3"}}),Be=new V({props:{code:"dHRzX21vZGVsX2lkJTIwJTNEJTIwJTIyc3VubyUyRmJhcmslMjIlMEFzcGVlY2hfb3V0JTIwJTNEJTIwY2xpZW50LnRleHRfdG9fc3BlZWNoKHRleHQlM0RsaW1lcmljayUyQyUyMG1vZGVsJTNEdHRzX21vZGVsX2lkKQ==",highlighted:`tts_model_id = <span class="hljs-string">&quot;suno/bark&quot;</span>
speech_out = client.text_to_speech(text=limerick, model=tts_model_id)`,wrap:!1}}),Ye=new V({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBZGlzcGxheShBdWRpbyhzcGVlY2hfb3V0JTJDJTIwcmF0ZSUzRDI0MDAwKSklMEFwcmludChsaW1lcmljayk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>display(Audio(speech_out, rate=<span class="hljs-number">24000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(limerick)`,wrap:!1}}),Ce=new U({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),$e=new Cl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_hub_serverless_inference_api.md"}}),{c(){f=s("meta"),m=n(),H=s("p"),A=n(),i(y.$$.fragment),st=n(),i(W.$$.fragment),pt=n(),b=s("p"),b.innerHTML=Ga,ot=n(),k=s("p"),k.innerHTML=Oa,ft=n(),S=s("p"),S.textContent=Za,it=n(),R=s("ul"),R.innerHTML=La,jt=n(),K=s("p"),K.textContent=Da,ct=n(),i(T.$$.fragment),ut=n(),i(v.$$.fragment),dt=n(),X=s("p"),X.innerHTML=Ba,Pt=n(),J=s("p"),J.innerHTML=Ya,Ht=n(),i(M.$$.fragment),mt=n(),N=s("p"),N.textContent=Qa,Vt=n(),i(I.$$.fragment),At=n(),i(g.$$.fragment),Ut=n(),i(q.$$.fragment),wt=n(),F=s("p"),F.innerHTML=Ca,Tt=n(),i(z.$$.fragment),Mt=n(),i(G.$$.fragment),qt=n(),O=s("p"),O.textContent=Ea,xt=n(),Z=s("p"),Z.innerHTML=$a,ht=n(),L=s("p"),L.innerHTML=_a,yt=n(),D=s("p"),D.innerHTML=el,Wt=n(),i(B.$$.fragment),bt=n(),Y=s("p"),Y.innerHTML=tl,kt=n(),i(Q.$$.fragment),St=n(),C=s("pre"),C.textContent=al,Rt=n(),E=s("p"),E.textContent=ll,Kt=n(),$=s("p"),$.innerHTML=nl,vt=n(),i(x.$$.fragment),Xt=n(),i(_.$$.fragment),Jt=n(),ee=s("p"),ee.innerHTML=rl,Nt=n(),i(te.$$.fragment),It=n(),ae=s("pre"),ae.textContent=sl,gt=n(),le=s("p"),le.innerHTML=pl,Ft=n(),i(ne.$$.fragment),zt=n(),i(h.$$.fragment),Gt=n(),i(re.$$.fragment),Ot=n(),se=s("p"),se.textContent=ol,Zt=n(),i(pe.$$.fragment),Lt=n(),oe=s("p"),oe.textContent=fl,Dt=n(),fe=s("ul"),fe.innerHTML=il,Bt=n(),ie=s("p"),ie.innerHTML=jl,Yt=n(),je=s("p"),je.innerHTML=cl,Qt=n(),i(ce.$$.fragment),Ct=n(),ue=s("p"),ue.innerHTML=ul,Et=n(),i(de.$$.fragment),$t=n(),Pe=s("pre"),Pe.textContent=dl,_t=n(),He=s("p"),He.innerHTML=Pl,ea=n(),i(me.$$.fragment),ta=n(),Ve=s("pre"),Ve.textContent=Hl,aa=n(),Ae=s("p"),Ae.innerHTML=ml,la=n(),i(Ue.$$.fragment),na=n(),we=s("pre"),we.textContent=Vl,ra=n(),Te=s("p"),Te.innerHTML=Al,sa=n(),i(Me.$$.fragment),pa=n(),qe=s("pre"),qe.textContent=Ul,oa=n(),i(xe.$$.fragment),fa=n(),he=s("p"),he.innerHTML=wl,ia=n(),ye=s("ol"),ye.innerHTML=Tl,ja=n(),i(We.$$.fragment),ca=n(),be=s("p"),be.innerHTML=Ml,ua=n(),i(ke.$$.fragment),da=n(),_e=s("img"),Pa=n(),i(Se.$$.fragment),Ha=n(),Re=s("p"),Re.innerHTML=xl,ma=n(),i(Ke.$$.fragment),Va=n(),et=s("img"),Aa=n(),ve=s("p"),ve.innerHTML=yl,Ua=n(),i(Xe.$$.fragment),wa=n(),tt=s("img"),Ta=n(),i(Je.$$.fragment),Ma=n(),Ne=s("p"),Ne.innerHTML=bl,qa=n(),Ie=s("p"),Ie.innerHTML=kl,xa=n(),i(ge.$$.fragment),ha=n(),Fe=s("p"),Fe.innerHTML=Sl,ya=n(),i(ze.$$.fragment),Wa=n(),Ge=s("p"),Ge.textContent=Rl,ba=n(),i(Oe.$$.fragment),ka=n(),Ze=s("pre"),Ze.textContent=Kl,Sa=n(),i(Le.$$.fragment),Ra=n(),De=s("p"),De.innerHTML=vl,Ka=n(),i(Be.$$.fragment),va=n(),i(Ye.$$.fragment),Xa=n(),Qe=s("pre"),Qe.textContent=Xl,Ja=n(),i(Ce.$$.fragment),Na=n(),Ee=s("p"),Ee.innerHTML=Jl,Ia=n(),i($e.$$.fragment),ga=n(),at=s("p"),this.h()},l(e){const t=Bl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(a),m=r(e),H=p(e,"P",{}),Gl(H).forEach(a),A=r(e),j(y.$$.fragment,e),st=r(e),j(W.$$.fragment,e),pt=r(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-15bmh6z"&&(b.innerHTML=Ga),ot=r(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-x7zjlp"&&(k.innerHTML=Oa),ft=r(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1xtcl9k"&&(S.textContent=Za),it=r(e),R=p(e,"UL",{"data-svelte-h":!0}),o(R)!=="svelte-1papjun"&&(R.innerHTML=La),jt=r(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-4ymecn"&&(K.textContent=Da),ct=r(e),j(T.$$.fragment,e),ut=r(e),j(v.$$.fragment,e),dt=r(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1ub8yv5"&&(X.innerHTML=Ba),Pt=r(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1h1tmjk"&&(J.innerHTML=Ya),Ht=r(e),j(M.$$.fragment,e),mt=r(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-12367wn"&&(N.textContent=Qa),Vt=r(e),j(I.$$.fragment,e),At=r(e),j(g.$$.fragment,e),Ut=r(e),j(q.$$.fragment,e),wt=r(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-s4liks"&&(F.innerHTML=Ca),Tt=r(e),j(z.$$.fragment,e),Mt=r(e),j(G.$$.fragment,e),qt=r(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-8wb1xt"&&(O.textContent=Ea),xt=r(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1668cm0"&&(Z.innerHTML=$a),ht=r(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-o2xcen"&&(L.innerHTML=_a),yt=r(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1dd766h"&&(D.innerHTML=el),Wt=r(e),j(B.$$.fragment,e),bt=r(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-us953"&&(Y.innerHTML=tl),kt=r(e),j(Q.$$.fragment,e),St=r(e),C=p(e,"PRE",{"data-svelte-h":!0}),o(C)!=="svelte-s3pvsx"&&(C.textContent=al),Rt=r(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1tia1j"&&(E.textContent=ll),Kt=r(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1lyvvvg"&&($.innerHTML=nl),vt=r(e),j(x.$$.fragment,e),Xt=r(e),j(_.$$.fragment,e),Jt=r(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-4y1x4j"&&(ee.innerHTML=rl),Nt=r(e),j(te.$$.fragment,e),It=r(e),ae=p(e,"PRE",{"data-svelte-h":!0}),o(ae)!=="svelte-etzqte"&&(ae.textContent=sl),gt=r(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-u7luvz"&&(le.innerHTML=pl),Ft=r(e),j(ne.$$.fragment,e),zt=r(e),j(h.$$.fragment,e),Gt=r(e),j(re.$$.fragment,e),Ot=r(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-kftsh2"&&(se.textContent=ol),Zt=r(e),j(pe.$$.fragment,e),Lt=r(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1cd9gh1"&&(oe.textContent=fl),Dt=r(e),fe=p(e,"UL",{"data-svelte-h":!0}),o(fe)!=="svelte-18z3n7y"&&(fe.innerHTML=il),Bt=r(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1wvmgpl"&&(ie.innerHTML=jl),Yt=r(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-twzcd6"&&(je.innerHTML=cl),Qt=r(e),j(ce.$$.fragment,e),Ct=r(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-ijkuxm"&&(ue.innerHTML=ul),Et=r(e),j(de.$$.fragment,e),$t=r(e),Pe=p(e,"PRE",{"data-svelte-h":!0}),o(Pe)!=="svelte-1tvw8ce"&&(Pe.textContent=dl),_t=r(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-g6tf4t"&&(He.innerHTML=Pl),ea=r(e),j(me.$$.fragment,e),ta=r(e),Ve=p(e,"PRE",{"data-svelte-h":!0}),o(Ve)!=="svelte-hpozp"&&(Ve.textContent=Hl),aa=r(e),Ae=p(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-17f0tdx"&&(Ae.innerHTML=ml),la=r(e),j(Ue.$$.fragment,e),na=r(e),we=p(e,"PRE",{"data-svelte-h":!0}),o(we)!=="svelte-69z7uo"&&(we.textContent=Vl),ra=r(e),Te=p(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-86t83d"&&(Te.innerHTML=Al),sa=r(e),j(Me.$$.fragment,e),pa=r(e),qe=p(e,"PRE",{"data-svelte-h":!0}),o(qe)!=="svelte-1xoi3se"&&(qe.textContent=Ul),oa=r(e),j(xe.$$.fragment,e),fa=r(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-16o1vsf"&&(he.innerHTML=wl),ia=r(e),ye=p(e,"OL",{"data-svelte-h":!0}),o(ye)!=="svelte-138ogku"&&(ye.innerHTML=Tl),ja=r(e),j(We.$$.fragment,e),ca=r(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-k5x6fh"&&(be.innerHTML=Ml),ua=r(e),j(ke.$$.fragment,e),da=r(e),_e=p(e,"IMG",{src:!0}),Pa=r(e),j(Se.$$.fragment,e),Ha=r(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1w2ld7u"&&(Re.innerHTML=xl),ma=r(e),j(Ke.$$.fragment,e),Va=r(e),et=p(e,"IMG",{src:!0}),Aa=r(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1awqz9n"&&(ve.innerHTML=yl),Ua=r(e),j(Xe.$$.fragment,e),wa=r(e),tt=p(e,"IMG",{src:!0}),Ta=r(e),j(Je.$$.fragment,e),Ma=r(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1aizcdr"&&(Ne.innerHTML=bl),qa=r(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1luvhw9"&&(Ie.innerHTML=kl),xa=r(e),j(ge.$$.fragment,e),ha=r(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1nzjr7q"&&(Fe.innerHTML=Sl),ya=r(e),j(ze.$$.fragment,e),Wa=r(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-173jmli"&&(Ge.textContent=Rl),ba=r(e),j(Oe.$$.fragment,e),ka=r(e),Ze=p(e,"PRE",{"data-svelte-h":!0}),o(Ze)!=="svelte-1l5qh7"&&(Ze.textContent=Kl),Sa=r(e),j(Le.$$.fragment,e),Ra=r(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-y5j10u"&&(De.innerHTML=vl),Ka=r(e),j(Be.$$.fragment,e),va=r(e),j(Ye.$$.fragment,e),Xa=r(e),Qe=p(e,"PRE",{"data-svelte-h":!0}),o(Qe)!=="svelte-1l5qh7"&&(Qe.textContent=Xl),Ja=r(e),j(Ce.$$.fragment,e),Na=r(e),Ee=p(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1bb05ww"&&(Ee.innerHTML=Jl),Ia=r(e),j($e.$$.fragment,e),ga=r(e),at=p(e,"P",{}),Gl(at).forEach(a),this.h()},h(){lt(f,"name","hf:doc:metadata"),lt(f,"content",ln),za(_e.src,ql="data:image/jpeg;base64,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")||lt(_e,"src",ql),za(et.src,hl="data:image/jpeg;base64,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")||lt(et,"src",hl),za(tt.src,Wl="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAIAAgADASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDPopM0tM+4EyaKWimAmaKWkxQAUUUUAHNFFFABRzRgUuKAAZ5pKWigLiUZNLRQA+NS7hc4zVy90yW0ijkYEiQZAHb/ACaqQymGQOACRWpqesNfQpHtACgYx9Kl3voTJy5lbYx+9HakNLTKEopaQ4pgH40ZopPrQAZNLSZpaAENFLntRigBKXNJipLSxvtV1CPT9OEJuZEd184kLhRnHHc9KCKlSNOLnLZEeaXPvVVb2NZfInzBchijwycFXHBX0zxVkHNAQnGavF3DPNLRiigsVFaRwijJPShlZGIYYI7VYsADcgnsDilvsfaMjHQZqeb3rAVeaKO3SiqAKKKcp2nNIBtFOONvvTaYBRmjFFAri59KSiloGFIaWjrSASipFidt2B06ilMLhC5GFHHPei4XRF24opccYpMUwCilpKACiipoxHtycZobBshpc0+QLu+WmZOMdqLiE96KPaigYZop8cMkzbY42c9cAUzBB6UroSkr2Cil6UhplBS0lLQIKO1GelFABRRRQAUmKWjtigAxUqW7NGz44Az+tNTbn5gfwNdRYnTl0ObzQVmIyuDkj3qZNrYyq1ORbHKspU+9JU90IxKfKOV/H+tQU07miCiikzTGLRRSZoELRmiigYe9GOKKXPtSYhKTqKDRTGII7i5uLe0s0D3VzIIolbpk9SfYAEn6V0R+H3iVtZltIxb/AGIbNt9J8o5HzYTJJI7dK1fht4euJ77/AISSYILXY8NqrA7jzhpB2wcED2z613OuaqunrGWk2qMswHXAFK587jMwqOs1SlZLQ43VvhbpEenNcf2lfxfZbeR5XEnMjgEhz2GPQYrzu1keWzgkk+80ak/UivU/GOrsnwzuZXYrPqCrbxDvmQ4x+C5P4V5iqhVCjoBgUI6cpc5OUpO4opaMYopnshXQeA8HxxAT/BZzN+qD+tc/W94FGfGDH00+b/0JKTOLMf8AdpHqt3pGnatpV1aTWsLRXIbf8g5Yj73+9059q8HjguLJvsV4skd1EMMkqlXIyQGwfXHWvY/CWsJeQyQbsmFzESe5Fcd8VIXi8RaXetEq25ha384HkuzZCkemAcfU0jxcurulWUejOSzg0Uhpao+nHIzIdynBpGYsxJOSaSigApVGTSVLFKIjyit9aGAFCg5FRd6uXFzHMi4j2kVUpIQU+KMSSqhOAxxmmU5WKsCp5FAM0LjS/s1uS8imQHgD0rN21rR3c1xAFZoxt4y1W7bSUvFdw6btuCFOefX2pKVtzH2nIvfOdoqzdwpBKY135HXcMVWqjZO6uLT49m4bwdvtUYpaBnW6Lp9teAyGQYVcEkdfrWRrKxxzGNXzs4CjsKhtdVmtsojbUKFSo75FVZZ5JseYxbHTNQo63MI05KpdvQhoooqzYKSpEieRsKMn2qZ7J0yDjip54xerMalenTdpMq0VI0LLTCMVSkpbFQqxn8LDPrRSUtBoAFWvsE3kecQNp6DPNSaZEkk5aQjag6Hua03cbvLXkNnPtXJWruLsjzMXjZU58kPmTaVDFa2q5Ul5hliOvsKi1+3bykZLUAA8uOv41FAZFuJA7ggjAUHoKuidlQp5uCwwu41z88lPmPM9tOFdT3ucrSd6mud/nMZFIJPeoa9JO6ufSwlzRTClpB0paZQhzTWOB1H40/tzSwrH9qiaYFoVcFxjPFVBXZwZnXnRw0pwdmRCQAdQR6+lSU7VTamWU2ijyQnUDG4+uKYv3B9KurFKzRw5LjKuIjKNV3ceotFFFZHuhUizOM4PUYP0qOigBzHNN70me1LQAlFGeKKAIJZyhwMcdSag+1Z/5aCo5P3knPTr+NG2u+FKKjqj4fF5lXqVXaTS6WLCXLd+R6irCuHGRWcVxyOtTQSEOuOjcVFWirXR2ZbmtVVFSqu6ZeH1oNIKD61xn1iCkxJIyRQRNLNKwSONOrMeAKK634baU1/4nl1BiPI06PABH3pXHH5Ln/vqkzmxlb2NFz6npGi2baL4asbOdk3WluqOy8LkDnFeO+OPFb6nrMul2r8eZsJz0Gc5r1Xxlq40jSQ7LlJSUJHbI/8ArivnG3mN14qaYtj98NzegzzSR8jc9O+IN1mXw7ow/wCXe3N3J/vYCL/7NXLitzxyD/wncjlV2vYQGNgeSMuD+tYnWmj6fLIpYdPuH4cmlYbWIoIx1pppnoBXT+A4it7rOqkfu7S18gH1dvmI/ABfzrlJ5RDBJJjOxScevtXo8tgPCfwxuI3I+0G3ae4b+9Kw5/LgD2FJnlZtWUaSprqcf8M9YluNengJOCXmyOnLf/XrpfihKkulWJeNji+jbeASEwCOfTJIFcJ8KW8vWbhjjBVVJ7966z4iXfnw6fYrOoEtz5skf8TBBkfhnr+FB4dBXrRS7nLUtJS0z7EO9BNIenHWr40qWSfyoQTsQGRz0DHsKaVzkxGNo4dpVHuUaM1am0y7gUs0e9fVOaq0NWLo4mlWV6buLRTSa2NFtJpZsTiaOAg/OIS3P5UJXMMbjY4aKe77XMmip722e1upVKS+XuOx3QruFV6TR0UK8K0FKLLamPyAWPNOg1Ge2jeONsK5GR9KpZ9aKSRpyJ7ks0zzNukYnHAyc8VFRSjrTKSsIKXvRRQMKKKOaBXEqaCIyuBUeKtWhCOCQff2qKjajoc+Im40247mvZWIidZF9MGi6jXzH67h+VTwylE3Ke1QXLvIHLY6dq83mbep8xUqyk/eZnPGWzUBtWIJBq9HtDLu+6TV+GGMFnOCi9iK1jUcDajiZ0tUYc1hLBCkrAbW6VVxXT3e4puVd6Y6YrmpgwkbK7STnGK6KNVz3PZwWJlWT5izaxIbaWZiQUOBV63BWIM7YZhkk1UsyPscvmf6tHDH39qgM0lxPu6EngelZzpucmjCtQdScjdMCkbsfNjrWXcQs11t569WNWlu5I7UPJjJOF461AxlH+kvxjoD3rnjzRZw4enUjJlCfPmkby4BwCTUNX2dJAWCAfSqcnLZNd1Kbeh7WHrOfu22GUtJS1sdodqcBm3lPoV/rTTUif8AHtce2w/qa0pfGjyc7/3Kfy/MqT/8e8n+6alT/Vr9BUM3+ok/3TU6/dX6VriOh5fDa0qfIWkNLRXMfUiFgvUilGWHyo5+imtTTY4zbCQKu/cQTjnrV+uhUVa7PmcRn8oVHGENu5zf8WCCD6EYoFa2qqDYlj1VlIP44rJFZzhys9TLce8XTcmrNCmkpaSsz0TPYbZMH0oqeeHcrMPvL8w+neq249wfwr0acrxTPz7F0nSryg+448KTSQjBjHfIpOW4xgVNAu6cHsozRUdosrA03UxEIruXBSZpQDTmQrjPevOP0BDCa9K+E9rKml6pdvxFPdBYx67FAJ/Pj8K81r134ZiIeB7by2BYzTGTHZ/MbI/LFJnk5xJqlFd2ZHxYvvI0q3t3jO2ViUkHqBgqfqDkfSvBbNsX04OevXvXunxbnjewgs2x5m4Sp6jGQfz/AKV4hpiD/hIlRxlDKmR6jI4oR8+j0jxskqeMomlJKSaZD5fGOjMG4+tYwrc8ebx42V5GOx9PiMS9gAzbsfjisIGhH0+Wv/ZkO6ikzUcswiUHDMWIVVUZZiegA7k03W7O/wBIt4BdTLBeXDBY7WNQ5TufMY8A47DP1oN6uJp0moyer6FuwsX1bWbDToxlridd3sincx/IV23xj1JbbwpLbqfmuJEiAz+J/lTPhbpW6O88R3C8MDb2uR/APvsPqePwrlPjHq6SS2FgDmUbp39geB/WjqfP5jXVas7bLQofDZDE1xIPvHHPpitbxa0cviqNE62tkiOf9pyXx+WPzql8MLV7q3mCqdrHBP1qTW5YbjxVq81syvEbgIGU5BKoqt+oI/CmGWw5sSn2KlLSU6g+oE+h5z1q/Bq97BKHEuR3GBg1Q5/ClHvRzNHLiMJSr61Fc7ixlg1WDcmI5wMlexrF1TSw99HGkflyHJkIHy4/xrPsLyS2cNG2GQ5FdOuoWmrBFlV45QPvL2/H0rW11fofE1JzwtaUIuzRQsNNhifieONh1YxbjWsJwo2jWGAH/Tv/APWqSPTGiOYryVSfVFP9Kl+zXXa/b8YloujBylJ3k7spTMkyFH1fcp6gwD/Cufv9Ft1Qy219GXHJTZjP0rrfs13j/j+/8grTGtLoj/j8X8YFpaGtGvOjLmg7M87HIpa1dTgggunmuXd2diAsSBc471k8FiQMDPAznFQz7XBYtYmHNawtFFKKR2hS4zVizEW/Mv4ZrVS3gV97IMHoMVhUrKDtY87E45UZWaMiK1lmYAKRnoSOK0F0pfJG5sSA8+lX/MUriNR8vb0qHzjvzmueVeUttDya2Z1ZP3dBYNMtPMDk/KBkgmny29uok8llVCM8UyTcIlIH7tz19/SoJlw5XOCAKnmb3ZzvETk/ekWIn2KoI7VKYiWLgHa/amWyBwu84x096vGQRhSOp6VlLRnPLV3KS2qtLsYhcjKg0r7kEkZ4O3NW54lleK6DYXBDexFQhlnYucEKMD6UXC5mzX80EqRRkFVUZyM5qm9vPc7p8ZyeastCJbiQ8AoAT7irVtLtlBCjYeCvtXRGfKrxWp6dPGRowXIteokmlP8A2dDDEQWkJZj74zTBpZsUj8wZmkHKj+HPaultkjEew9I/5VDc5WVpEGZG7n+EVg60n7pi8ZUs13ObuPLsmXzsPMowkXZfc1TYzzhnbcSTnB71NqRSG6ZokO5zku3r7Vn723btxz611wptxuj18LT5qSlEmMoUYUfnULNubJpXk3NuwAe+KZW0IJanZSoqOvUKBR6UtaG4dqlj5t7n/dU/+PVFU0P+puh/0yH/AKEtXS+NHl5x/uU/l+ZRn/1D/Sp1+6PpUE/+qP1H86sDpWuIeqPN4cXuzfoFFFFc59MaekH9xMno4P5itCsvSWxLMvqoP5GtTtXXD4UfA5lBQxU15lHVW/0A+7KP1rMQbmA9auapJ+5ij9WBqmjbWDdcdqyrbo9/IY2oyfmXbnT5Le0jlcY3E1QrYvtVmuLGCM7QpB4wO3FY5rBX6nt03Jr3hvOQQcEVWljAYsgwO6+n/wBarVRzD5c962pVHF2PKzbAQrU3VWkkUycDNWoI9iZP3jyadFErI7Nywxin9K0xE3flOXIsNGzrPfZD0bawOM0sjl2z2plHNcx9GJXq/wALrmGXwi0MalXgupUl46sW3A/kwryg16F8K74LFqunkjeJkuEH+yyhT+q/rSZ5Wbwbop9mR/GK0Mum2dzEP30JJ+q968T0NGuvF9pbxqWklnjVRn3H9K99+KtuJPDUUu4r5c2N4ONuRivFvhwob4r2iSAEhpMcdwhxQj51Hb/FJ1bX7WO3Vt1nZMkkgPALnKD64Un8anh8G22qR27aV9pi+26ct3aztKzqJBjdG4PGDkY7it4aLH4g+IPiCyuhuslis5JVBxlgCQB9RkH2Nd9Y2FrplnFZWcSwwRLiONeiikdCryjCMYuzR5J8PNFubrxLcXuoWMsP9mRYRJEIHnMSCR64AP50vjnwzrOs+KdMtbG0m8qSHa9zsPlxM7fOzH1AH617HuHHPU4pNww2OSOoFFyJV5yqe0b1MaS1tdC8NJaQ4htLWEJuPZVHJP6mvlrxTrLeIfE11egkQu+2IHsg4H6c19dF43QZAaNuORx+NeaeK/hHo+p34vNJX7Ddlg7xqcRSgdQB/Cx9Rx7UGRleFLePS/AV3dpd/ZVjhLG5VQxU46qD1J6CuVtYxHbIoGDjJ+p5P61p63qUs8n9g/Y5dPtNPYA2cnDSMOjtjgr3GMjv9KI5FUfQZTQcIOo+oop1IKXtSPXCiiigRJCcMR61q6UxGowjszYI9qy7ZVa4RX6McZrpLDT1hnV1JZ+2a6KcvdsfEZ5R5MXzd0dHbn90AexIqX2pkS7IwvfFPrNnnIKRhkGlzRmgZxviu3NpPDCf4135rn67Dx5FldOuQOqlD+hrj6k+zye31VW8wpaQUtI9UVSQcirX2qZyCx6cCqw61IoY9OgrOUU9znrUoT+JF+C6Mcm4DnuDWgiRTjzFyoP3hjNZMIxzWlbu0Y+RiM9q5qkLao8HGYaMHeJbiSABomnHlv1BGMHsRUNzaMhjY4PQEjow7Grke+SHbJwx6MRmkMVxEMYSWPuo4/KsEedpsZTiSGQjcRtPFW3fy2jdhlWAfFRy25LswJaKXgMf4W9DTWBbTwr8SW7bTn0PT9ab1L5dDQ+SXT7gRHKghwO49RWfA4F7sXOxhwD9KnsWEdwvOUkGxqe1kLaPzySXRiAB/EO1T5Gb0KixM08jc4KbTj1qa1tWacKMZBzj0+tMs5jLdvjgOpIB7Grf2qO0h8qNf3hHzE03JpWBM0Iwmz5Tz/y0Oe3pVe7ugY9sY3buoFQGX/iUb1b5nkx74ArLmvRboT1fHyis4xbka0oSqSUYoi1RywEPltvX5unasoo+0NtO0nG7HGa6rRLSG7eO6865+0A/NuizGfUZ9K3m8O2rWf2YJ+787zsf0+ldTxMaXus9+jUjh4+zsea4ora1/TLizu2klSJFf7qxsOB9Kxq64TU4qSPRhNTjzIQdaWilqixKmg/1dz7xf+zLUVIcgZDEH2qoy5Xc48dQdfDypx3ZBMPlA9WH86nrb8S6Vb2KWDw7v3hYkE56Af41iUvbxre9E4smwssPSkpbthRSqrOwVRkntQysrFWGCOopXPZLOnPtvAP7ykf1/pWs5xG30rAVzHKki9VOcetarXcckQ2kkt2xyPrXVSd1Y+PzuhKOI9olozP1Jt10i+gqGid/OvJGHReM0lZ1XeR7OTU3DDXfUkZy0aKRwucUykorI9ZIKZJ93in1HOxSEHtnmi9mjhzCo40XFbvQRZMcDoakNZvmMZMD1rSU5UGqk9TDK17ODpsWijFKKg9YSrmjaw/h3XLbVVVniTMdyijJaI9cDuQQCPpVOjNBlWpKrTcJdT27VLe18V+FpUtZkmguot0MqnIJ6g18+/D6xng+M1tbyIySQPN5ingrhGFei+CdWk8P2mmrNn+y72FDIP8AnhITgP8A7p4z+frVnxT4fh0jxPdatpJLa9r0YsrWID/VH/lrL9AoBz2/Gg+Nejsb/gZ/t994j1ocxXeoGKFv70cShAR7ZzXTSP8A8TC2x0dH/oah0fSYdD0G10u1H7u3iCBv7x7sfqcn8asPCTdWrgcRhgfxH/1qQiufMZbxFP7yKQOn5A/41I0oHlXif6pwA/sOx/CpFQpqLP8Awyxj8wf8DToIBEjxHmMsSo9j2/nQBFKohlL9YJOJB/dPr/jSGNmBhZsSJ80b/wAv8DVlYwsflnlcY59KBGAAvdfumgDl/FHhK38V2SMT9k1O34iuFXJX1U/3kPp+NeT6hp17o0ojvo1CFzGlxEd0TsP4c9Vb/ZbBr6B2jOcc1ynjPwpDrmm3HkXyafdToI2kcAxTDsJFPUjsw+YdvSg68LjamHem3Y8iFLTtQ0vUvDcCprUcShfl+0QzLJG3oePmH4gVBBcw3IYwuHCnBIFUfTUcRTrK8GTUUmaWg2FUMXUIcMWAH1zXY6ZHeNI5E0WFGMmPP9a5bT0330fouW/Ku60uPZaBu7nNXHSNz5DPqiliYwXRD/Lv/wDn4g/78n/GjZff894P+/R/xq1RQeMVdt9/z3g/79H/ABo2X3/PeH/v0f8A4qrVJQMy/EWn3N34aM0lwjG1bfsWLHHQ85PY1wYr1iONbqxu7VuRJGV/MYryjBVipGCDg1B9TkVW8JQCinxRiWVU3Bdxxlugp88DW8pjYg47g8Glc966vYjU4NW7aVYzyoIPWqdPRsGpkiJq6L0W3cSRxV2MqE+XtVGPa0ZO7n0p6OwGBWUtjycSrm3BOHTr81JcyuHDD5Tjg1ktIQMg/dqyty7pskHGMg1ySg07o8edNosxSxCQ7+BIMMvYH1qcpE6Okhw2PLZvUdjVKJtwwCN2e/etBEX7wxyNrD1qJMjmsZMcLQSI24EI+Gx9ankuHNzLbFvnR90JPqOgqzJCcNsHJ9e9V7yykluhPEuWZQWwcYamnd6mMpNkjR41VXj+VJkEgGOmev61WlHnagJGH7rBb2OK0cHbA8mPNVCGx9aiZUMGwDbk5Pt60rsOZEN+/wDokFvFgOqmR8ds1zkhZ5CXOTXQzSRW6vI5GWPJNc7cEyzO0a/KTkc4rqwkG29D0svxdGg26jSOj8O6nfGSOxgaFYlySWXkDvXZQX9tLA8iygxo/ll+2eP8a8qt7me33rG7IWGGx1xWtb6qYPDk1pj5pZcg56dD/SoxGE55XR7FSjGqlOnsy14p+zRXrwpbyRzgg7y+5XU1zhq/qeof2lJDIykOkYRie5HeqFdNGHJBJnZRhyQSYClpO9LWpqFBGVOPSitPRNNfUtRjQKfKQhpG7Aen41FSahFyZE5KMW2anjIERaYD2Vv5LXL9a73xVpsl9pySQKWlt23hR1ZSMED+f4VwXUVz4KalTsc+FknGw+OQxuGXqKSSRpXLNjJ9KbRXXY6wqazP+lH/AHD/ADFQE0kVz5Ds68ttwAfrW9GLcrniZ1VhGg4N6vYd/E/+8f50GoUlLMxxwxP4H0qVsrgkcHoe1TUi1JmuX4ylKjGDdmkFFFFZnrCHpVeVt4C5x7VaSNppRGpxnqfSpZtN2gFGz65rN1YRlaTPn83rrmUE9UZ8FsGbIPIq0BtyKswWZRmORimTxmNxkf8A16hVlKdkzHLcXOVdRl1ITRQe+KK2PpkFQ3TlLWVh1CnH1qaoblXa2lEYBfaSoPQntQTUvyOx6F4j0s6d4d+zRRNIIrEQooH3m27QPxOK2bSO18LW8Wq+Ibz7XrcsKwIFXL9B+6hTr16nueSaq+IYvEGu6Hp994fuZUjngSV44REG5wRhn6fh6VxdpZeKo9Xls9M0+G21fy90+oX9z9quEU+jY2pn0AzSPiup6jrPi6z8PaRDc6ku29nAEVjGwaR3PRB+fJ6VTvfH+mWHifT9DnkjE86E3Egf5IGI+VSfUnj8vWuCHwx1iJ31G/8AEMMdyTmS8my7r9C2Av8AnrW1ovgXQ3tZ7e31O01CS4/4+GaVZWlPvg0Adc3jHSo49Q+2yNavp04iuUcZMYJ+WT3Qgg5+vpWwdTsfMtVF1EWugTb4cES4GflPfivLrv4W6nDfrPa6gLi2MRgeKclmMR/gyeoHUZ5HvWVe+AvLtRa2d/eWTRMJEiLEokg/iUdV/A0CPXP7fsCdRQOzTacf9IiVcuoxuBC9SCORisO88e2kgMWkeVeXBRbi3USDbdx5+dYz/fHPynnp6156fD/iQX66sPELHWFQRmdYgFdBwA4/i+ppP+FdPLnVLpZAxJe4EK7YmY/xBe31GKAOvn+JcMJ+2xgT6PIArzQr+/sJOhE0ZPIz3GP5VzeoeP5IpjOkkS785VmL2V2p7qx5iY/3XG3+dbOh/D+wvJzeOuGA2vMWJdxjoeeePWtfUfDfgvw3p3malNFZWxyBvlChvYKBz9AKB6HkGsX9trF6HstPubO5IBeOQIYgPUE5JHpg4qzAjRxKrFSwHO0YGfpUOr3nhGLxJE3hq8DWksRDIysgR89twHBH8qF1C0eYRJcRvIf4UO4/pTufRZaqcaV76lsUUmRS0z1TR0hCZJX9MKP5/wCFd5Anl28af3VArkdBh3LEP78hP4f5FdnWj0SR+fY2p7XFVJ+f5CUUUVJzh2pKWkoGWLNttxg9xivONatvs2u3sQHAlLD6Hn+tehRNtmQ+hrkvF0PleIvMxxLErfiMj/Ck9j2Mmqcte3cqweH5ptPS9WRTGwyR0IqbTdPt4b1JL1HNvg9V4Jrd020lttHidZRMs3SID7tTypbTaYY5WIkHG0cEH0rncme5LESbcWc1r9jp8MkUmnE7ZASy5yBWEQQea7S90+D7CkYKq6DII71y9zAMFh1pxlc6KE7xsyqj4YelXVYECs88U9ZWUDnpTlC6M8TQ51eJoZ4U5HofpUM9yyMUGOOhp8aGSMM3BNZ8wKzMD1BrKnyylbsedhFCtVcH0NS3vI2GGIVx6962orNG0WO782XzD1w/B5xXH5rt7MH/AIRC3+n/ALNXRSpRTODOMFHDxU4vczdp/wCekn/fRo2n/npJ/wB9mnUV2eyh2PmueXcr3QdYGZJJAR/tGsw3E3eV/wA615huicH0rEI5q404djKc5X3EmfcuXY8c5NQGRj90YHqakmGVH1qM1jUm4uyPpcky2liabq1dddhADkknJPU0UtFYN3PsqdONOKhBWSCiiikWFLSUDpTYG5oWgHVczSvst0bBx1Y+grubOzt7GARW0QRB6d/rXM6Nf/2d4Ue78vf5cpyucZyQP61v3GorBe2dvs3fat2Gz93aM14eKlOc2nseVXlKUmi9XGeLNHigxqFuoTe2JVHQk966O31MT3V/AI9ptGVSc/eyu6srWrsah4Q+17NvmBHC5zjmow7lComiKTcJJo4fPFFJS57V76R6s5qEXJjXGR1wMcn2qptLb2BwCMD9KuNzgHp940wriIHjJrri+VWPjqkZYmp7SQQxnJxjdjP+8KsDAGR0PBz/ACNRLnjBwwzj/CpS67d+PlbhhWMpM9GGGi1YibCEFc7GOMH+E+lL1pk2UDqzZ44PqOx/On5qJW3PSwM5WdOTvYltyVuEIOOcGtXGaxc7SCOoNa0UokRWzyRXm4yDupHmZ1RfOqi2H4xwKjngEy4zgjoakorkjJxd0eLCcqclKL1RkSxtG5VutNqxeHMxqvXsU5OUU2fbYWo6lGMpbsKjuJPJt5JMZKqTTx1qC9OLKXP93n6VRrUdoNnu2jxW/h7wvplpd3UcawQJEZJXCgtjnk/jXmWreN7iz8Qatb+GrVdR1K6ZFWXbmKJVzyx4B6+uK9S1JrWSyjtruCOe2nwjJIoZSO2Qa8g8ZfDHSHeO50tjaRygttiJZSfYE4FI+LerKsls9ywufFWv+HZ7nrt1S9a5CH0WGIrGv6/WqF5pmhai2zT9W8Gi6H+rNp51hJn2fcVz9RXnmsaRHZaRpN/BuK3KypMT/DKjkEe3ylTWTHO0cUsahCJV2sSoJxnPB7UBY9w8JfEbXfCOtRaD40WZ7GUgQXkxDtGD0beOJE9+36V7pJb212oaSKOUEZBIB49jXx74a1m3kjbQNdmY6Nc8JK3zGyl/hlT0HZgOo9xX0P8ACDV7288LyaZfkyyaZJ5EV0uWjni/hKt3x0+mKBHdrZWqjC28QH+4KlKKV27RjGMY7U6igDlbiWLwjfPJMSukXOSG7QSAE7fo3OPfj0rxHXfGtjaag2tahaRax4guQJILe5+a206E8ou3+J9uCfTPrX0fqGn2uq6fPY3sQltp0KSIe4NfJHxF8EX/AIL194Zi81lOS1rdEffX0P8AtDv+dAyvc6zrXjjVR9tniLIpKokaxoi+gCitaw8Pz27guwAzziU/yAH86oeCLBx51/IMKR5aH19a7IUz38vwcHTVSa1BRhQPSnHgZoFNf7rfSmetLSLZ13h6PDW4/ux5/T/69dLXPaGwE8Y7GPA/KuhrSR+cJ3bfmFFFFSMM+lJRWBNFJe6ncJ57oFPC9Rj6U0i4R5t3Y3845rD8bRB1sbpf9pCf1H8jSxaDJM+xbsA+8QqO78J3g63EDjqMx4qXY7sIo0qinzrT1/yOetr65tpFeKV1K9BngVPLql3K+9pPm9QKtP4duY2wZIT+dINBuP8AnpEPzqXG/Q9143DXu5IaupySRgXDbiOOB1qrcTIyFkP4Vak0S4QZ8+P261QNpMbpbdXV3GS46ACodO2ppRxdGpLlg7spHrSoMyAe9ITycVPZgNOM+hoqS5YNnbiZclGUvI0lACgD0qhfRbWEmOG4NaIqK4j82Bl74yK8uhUcJpnyWDxDo11Pp1MftXeWa/8AFGwH/YB/8erg8V39iM+DYh/0yB/Wvag9T0+IHejH5/kZFLTaWus+KI5ziFz7GsTvWtevttyPXisnvVRInuMn/wBWP94VFUsw/d/iKirlr/Efb8Nf7tL1Ciiisj6QBQaKKQCZpaSlpjOgtznwJfD0k/qtbN626+0GT/bb9Y6wrRs+DtST0kH/ALLWtcyZGgP/ANNFH5pXkVl779WeXUXvsmsGxq+vn3j/APRdULlivgC1B6sqD9SasW77b7xE3pt/9FVU1I7fBunR+qJ/6CaiC99fIlLVHLjpTZGwMingcU113KRXtJ2Z3YiLnSlFbtDfMB3n0X+VDdCp9FH86rMGUkMOSMHHelWYHOX5/wBoV1Wvqj5WnU9k3GaLKtkHB5wGH1FPMuAGH3ZP51VV41ZSZhx0AxzSGZy37lD9Tx+tQ4NnTHF30ihbuUCAxNnzRjYB2Hv/ACxU8Tbo1J9KqJAM5DBm/iI6KKuKoVQB0AqJW2R6OWxndzl1FNT20gQ/jUFOQ4YVz1IqUbM6MxpqeHl5GwORSimRAiJQ3XFPryHufGlK6jUknuBVKrl63zYB7VTr08Nfk1PrMpcvYahUtlZNqWqWWnLjNzOsfP8Adzlv/HQahrofAen/ANo+MLdzLsWxQ3OAeXP3QPpyc/h61uzrxtTkoSZ6H4vnFnok1wcbYVL/AJAmsiOwkT4faIZQfNit4t+evKirPxLkSPwpLGx2mZ0jz2ALAEn25rqJbNbvTTbORhkC5A/I0HyR8967ozaYbxJtOl1HQbyTzpYYG2zWsv8Az0jOD+Ixgjg9jXJQ6Z4Ta4VLQ+INTnY4jsxbxwlj2BcFj+Q/Kvoa58OX1sAwjEoJx+7OT+VbWheHUspPtlxGn2g/dUAfL7n3pAch4A+FlnpiLq2u6danUXGYbMLuitF7DnO5/VjmvT1UIoVQAo6ADAFLRQIKKKKACsjxL4b0/wAV6JNpepRb4ZBlWA+aNuzKexFVdB1s6zrevCNs21hcLZp7uq7nP5sB/wABq7rOuwaFAt1eQzfYs4luI13CH/acddvqRnHegDwjUdFufCVwumalGsSL8sFwBiKdexB7H1U8io1YMAQcg+le6+ItU0yw8Nz6hfxRXdmFUrEVDiYsQEAB4OSRXlfxA0TTPDmu6YdOjhtTqKP59lEcKjKAQ6r2B5U44OBTR7mCzJtxpTXlcwM80g6UUtM9xm7o91iKMg/PEcH+n6V2EMyTxh0PB/SvNoZ3t5RJH16EHoRXQafq65Bifax6o1aJqS8z4TMcDUwtVySvB9TraKzYdXiYASgqfUcira3ts/SdPzxSaZwqSZPWLdD7FrCTniKb5SfQ1refD/z1j/76FVb37Jd2rxSTxgEcNuHB9aFozSDWxbtpAkqPnjNWbu5VgOcgVw8GtPayGF5FcKcBgeD+NX01mNsFlY+4OarkuTPmpaSVjVZtxJ9aTpVD+17fHR/yqCfXIkUkDb7saqzMlK70LN7KkakscKoyTXHTTGad5uRvOR9Ks3+oyXp2gkR5yc/xf/WqnispSWx9Zk2BlSTrVFZvZCVYszi5UeuagHWnKxR1YdQc1jUXNFo9jEw56UorqjZoJGKajq6BlPBps0gjjJzz2rxoxfNY+JjTk5qHUypRiVsetd3ozibwvHH/ANM2X8QTXBnk11Xhe7U2clqW+dGLAeoNe5DSx72cUpPCxfb/ACI+9Bqa7i8idl/hPK/Sq5PFdy1R8S1Z2M6+kLSbP7tU8VNcNunc+9RCncy1uRz8RgepqGnyNvbHYU2uSpK8j9AyHDypYW8uruAxn5s4ooorM9sKKKDmmBN9nf0pPs7+lXDS14/1uoYc7LNojL4a1BD3kX+lX52P2TQT6Sp/6Cagt5LQ6RLbS3AikeTccoTxx0wPapnv9OZbVNl0y2xBjKqBkgdTk1nKo5as5XdybHLkTeIz6gf+i6h1dWbw3pqqM/IP/QKm/tXTx9oP2a6/0j/Wn5eeMetV9R1G2udPhtLeCZRHgBpMcDGPXmlGTUrk2d1oYH2eQDoPzoNtJ6D86u0orX63UOvmZntZu4wVH51EdPn/AIZPwPNatFXHHVo7M562Hp1vjRk/YrrsyClGmueZH3ewOBWrikpvMKz6mdPB0YO6RRFoyrtUAD0zSi2lC9uPertFZ/W6h1LTYpfZZP8AZ/OpLeEpOpcAj+tWaRunHWj61UkrMzxEXUpSh3RZprttQt6UyOcSSFcEcZ5pkkodigBBU81lbufK0sNOVVU2irJFLKxYlaZ9lk/vCrlLWixNRKyZ9VSgqcVGJRNpJ/eFdd8MMw+JdShMRdntY280dIwGbj8Sf/Ha58123wxgBh1a943yXIg6chUUH+bGurDVpzlaRy5jP9zZ9WW/iXg+G7gMMg28nHviuq0mBLbTLaGNmdUhRQzEknCjnmuT+Izumkk7N6KoZlA5K7hu/TNdjZXMF3aRz2rq8Ei7kZehFdp4BapaB0ooEFFFFABVHVri5ttKubizi86eJPMWIdXxyVHuQCBV7tXH6T41s5/GWqeGbqVY7qGTfZsxwJ4yOQp7lW3D8PY0AeYXWheMRe6hqvw710XWmajO11JbxTIk0TtyVZX7jpWS3ib4s+GWaXWbO+urLBE0d5bCSJ1PUFlHAx717dqfgDw7q1619JZPb3jctPaTNC7H1O0jJrU0jRItGhaKG8v7hD2u7lpsfTd0oC5852/xEt38KW2lSrJ9lsdXguoYS25vswJYx577WwB7EVq6X4Z1zx9Z6z4+vHmW7D7tOt16SIh+ZR/s7cqPU5rp/jN8PNMl8PXHiTTLOO3vbUh7gQrtWaPOCSBxkdc/WvUtANsfD2mtZosdsbWIxIgwFUqMCgqMnF3R8/xSJNEksZyjDINTxw+aCd2MHHStXxrpMOh+Obq3tFCW15At4Ix0jcsVfHoCRn8TWfa/cb/e/oKxxM5QheJ9ZSxHtaMai6ifZP8Ab/Sg2YPV/wBKs5FH415/1mp3CS5lZkCRzpwl1IB6Hn+dP/0n/n5/NBT8/NS1bxdZfaOR4DDN3cERkXJ63J/BRUZt5G+9Ox/CrFGan63WfUuGEoQ+GCK32TH8f6UC0K9JWH0qznJ60tJYqquppKlCatJXK32ZyOZ3pPsfOd+T6kZq1SUPFVXuxQoUoO8YpFf7Mf7/AOlH2Y/3h+VWciil9Zqdza7K32c/3v0pfsx/vj8qsZFFJ4mp3C7IkSWMYWXA9MUjxvIctJn8KmoqfbTvcyVKClz21K/2Y/3/ANKdHFJFIHjlKMOhFTUVX1ip3NJJSVnsTSXt9MgSS5DAdPkGaiMtz/z2H/fIozRmmsVWX2jkeAwz3giBopGOTKMn2ppt5D1k/SrNFP63W/mCOAw0XdQX3FX7Kf74/Kj7Mw/iH5VazSUvrNTudibWiK32Zv7w/Kj7M394VZop/WancrmZRkjaMjJBzTanuv4PrUFehh5ucLs1hqiH/hJdP/vv/wB8Gj/hJNO/56P/AN8Gsb/hH3/57j/vml/4R897gf8AfNZ/U6Z5/wDtPY2P+Ek0/wDvv/37NB8S6cP45M/7hrH/ALDMbK3nBuRxtpP7BErFvOK5J421X1Kna5n7TEe05LdLmx/wk2nf35P++DQPEtgxwDKf+AVkf8I6P+fg/wDfNKNEEJyJSxPGNtCwdO4VZ4inByaWhqnxNYesv/fFJ/wk+n/9Nf8AvistdAR13ee3P+zS/wDCPp/z8N/3zSeDpmiWIavY0/8AhJ7HHSb/AL4o/wCEosf7s3/fH/16ym0VI8gyk8elOGgJj/Xt/wB80/qVMzhOvKUopao0v+Eosf7s3/fNH/CUWP8Acm/75H+NZ/8Awjqjnz2wf9mj/hH073Df980vqdI15cR2L/8AwlFl/cm/75H+NJ/wlNn/AM85v++R/jVH/hH4/wDnu/8A3yKX/hH4v+e7/kKPqdPsHLiexd/4Siz/AOec3/fI/wAaT/hJ7TGfKm/If41S/sCL/ns/5CmtokSjHmseCelNYSn2M6jrwV2Xl8T2qTq4jl24IYYH+NNfxPbfaHZIZWU4weB2qt/wj8XeZ/yFH/CPw5/1z/kKf1an2M/qlb2ntUtS0PFEBOPs8v5ik/4SuAf8u0v5ism70+O1lVEdmLDvV1dAhIBMz/kKPqtLsVF4iUnFdCz/AMJVB/z7S/8AfQr0v4UwzXMN/q/mSxWk8gjS2JyrMoG6Q+/RfwrywaBbj/lrJ+leufCqwu7TQJpJJ2Nk8rC1jPoD8zfi2fwFVCjCDvFHNj1VjTSmdJ4rthcaQWIzjI/Aiqfw/wBU/tDw+toYnim05vsk27ncygHcD7gg10V1a/arFoD/ABLivNvDl/daL43ewd9lpdq7tER/y2XaOD67R09q1PHPVx0opqOHUMvINOoAKKKKAAgEEHpXgWpeEF1PU7vwyLn7NrFnI93ol6Wx5iFizQs3XIbJB6jOa99ry/x7oby3S3djMbe8tpBNbTDrFJ/gehFAGV4S+Lk2k3R8PeP4ZbG/gOwXjpw47bwP/Qhwa9bstTsNSgWexvbe5iYZDwyBh+lee6Xd+G/ihpx03xFp0K61aLtmgY7ZEP8AfjYclT1/nXOaz+z7GiPN4b1yeCXqsN10PtvXBH5GgDvfiV4j0nRvBOqRX1zF511bSQQwbgXkZlIGB6DOSfauT+HXxS8N2Pw/sbXWNUS2vLGMwtEysWZVPylcDnjA/CvOYfgh43utSEF1DbxRk/NdPch1x64HzH6Yot/DVho+r6jZRmO8FpceUlyyDLEKN2Poc0HRhsO69TkRuaprcvifX7vW5ImhhmCxWsT/AHkhXOCfckk/jWVe6ncafgRojKxzznNXgB6VBdWUV2qiTdx6GiUYyVpI+l+ruFFU6fQzh4nuO8Ef5mlHiec/8sE/M1N/Ydr/ALf50f2LaD+//wB9Vn7Cn2MPY4juRf8ACSXA+byI/pk0n/CTzg/8e8f5mnppVuzsp3FV6c1J/Y9p/cb/AL6puhS/lJp06843uRL4nnY4+zx/maafE9wDjyI/zNPm022i27VIJPrSwaVaSxBmQknqd1L6vS/lEoV/aOF+hF/wk9xn/UR/macvii4PH2eP8zU/9j2X9w/99GoTptss6qqnB6801h6T+yFSFeCu5Cf8JTcf8+0f/fRpP+Epn/594/8Avo1Z/sez/uH/AL6o/saz/uH/AL6qfq9L+Uv2OI7lf/hJ7g/8u8f5mlbxNOpx9nT/AL6NSSaTaouVVsj3pV0m1kUMQ2T70/q9L+UySruo6alsQHxRP/z7p/30aUeKJz/y7p/30am/sWz9H/76pk2j2yRMy7gQM8mj6vS/lNJ0sRFN3Gt4nuFYj7On5mk/4Smb/n3T/vo1IujW7orsz5IycGj+w7X1k/Oj6vS/lFCniGr3I/8AhKZv+fZP++jS/wDCUzf8+yf99Gn/ANh2v96T86P7Ctf70n50vq1L+Ur2WI7kf/CVTf8APsn/AH1QfFM3/Psn/fRqT+wrX1k/Ok/sO19ZPzp/V6X8ovY4nuM/4Sqb/n2T/vo0L4onJx9nT/vo0/8AsO1/2/zpH0i2jG5d+c9zTWGpN25TOsq9ODk3sMPiicHBt4/++jR/wlU3/Psn/fVSx6RaMgZlYk8/eqUaPZD/AJZE/VjQ8PSv8JpTpYiUU7lYeKJj/wAuy/8AfVWYtcvZsbLAkeu7FWIrK2h+5Cg98VNS+r0ux0woVPtSGLPcz7TNEkeOwbJqWkorSMFBWidEY2VgoFFAqiiaGzN1HI4k27GUdM5zn/CoWiMEskbMGKnqB681o6Z/qbke6H+f+NU7rm+n+o/kK2svZ3PApVZvNJRb0sRUvlRuis4b72AVNJT15iiHq9FBJy1Kzyco0YpPdkCKI5pYgThCMZ9CKkph5vrj/gP8qcTgE1NRe+0duXTcsJCUuxFMjsRtQtnpj61KpBHFSbP3kByRtT+lQxnJkP8AtmrqQUY3ODLMZKtiJp9dfuLAceXtxk1HQKK5z6C4mKKcuCeaQgZ4piGscDJpHtWdSwkAIXJXbRJ9xvpWgkQ2Fh/EgH6VvRine58/ntepT5FF2KCtuQN60MQASegpsP8Aqh+P86GxuUHpmsJaHuUG5Qi31SMa7kV9RDsTsUjtWyjhkDKQQRwRWTqGDcsBjpV3TwRZr9T/ADpJ3MqUOSpJdy1nmvVfh9BcWvgm2M0rMsrPLCp/gjLHaB/P8a8qIyCPWvWPh/dz3Pgyx+0IqrGDDCQPvxqdqt+OKGednPwxOyH3B9K8x+IWjTPeJPazGC6OJoZl/hkHH5EdfrXpnP7sD8fyrE8VWizafHKUz5bYJ9AaR4JwejePDFD9k1mUWV8rcrzscdip713um+JYJ4EZ2DIwBVweorhZtGt7tSjLlscEjNYD6Hf2ET/2TeyWkgfeU+8jn3Bp2D1PbU1S2ki8zfj2PWpWvbZM7pkGBnrXhSeIPFdjOHult549pBjiXbg+uTRL8QtSeABdJlFx0ZWICf8AfXf8qOVhoe1ya1YowXzsk+grkfEupwyyyiFshgM5ryafxj4juBJAI4o2kPDICTGPQVUlv/EeqN9nmuPLHQsihS31P+FNRa3BtG/Bpi+LPF9tZ2Nw9nc22WbUoDhoiATtHqfWtvVPFXjrwhq/9jTajp+qMsCzLNJEUYoSQM47/LUnw2037JrFtFF0jVmcnqTjk/rTvifpkll4os9T8zzIb+PyNpPMToM8f7JGfofrQ9zowkIVKsYz2Zk3/jrxpqtu9u95Z2ETjDNaoS+O+CelYttbpbQrEmcDuTkk9yT3JqUU6g+noYSlQ1ggoxQOaWkdImKs6dZpf6hFbSMyo4bJXrwCar1f0Mka5a+5Yf8Ajppx3OTHtrDTa7Fa/s1s7iNUdmDKfvY4xVer+rndeRj0Q/zFUK0qL3jjyWUnhE5O+44fZzDIJFzJ/Car2g/c49GNNkPzmnWn+oz6sf51menb3rkjnC5qKWNFYyAfNkd6ll/1Zpsh4UerD+ddFFLlbPAzaU/rFKMX/VyXpRRRXOfRJHRaPaQy+HbqdlzIsu3n04rnMBS2Bgbjj866bRH2+Gr4ekv9BXMryufXmr+yjwMuX+3Vn/W4dKuWmjS6rbzFJQiocE4z71UrqvBpDJexn/ZOPzqUdua1J08O3B2OVMZhLRHkodpP0pKs6gnl6ndJ6SH/ABqvSe52YWfPRjLukJSqpY4FHWpoJFjbJHPY0mzciZCpweCKYx2jJqeZxI+e9V5BlDTjruRVbjBtdhMOfQfrTWTI5NTNkECm7RXfGnFbHwtfG16uk5aEcB3RD1HB+tTDrVW04Lr3z/8AW/pVquKatJo+xwFX2lCMvIXHFJS0VB2BgbQc856UlLSHrTAKWkpaALunNhp19VH6Gqsxzdzn/b/oKmsWxcMOxT+oqu//AB8Tf75rf/l0jwKS/wCFWfp/kNPSrECBokPoTioKs23+pPsxooP3h5+m8PF+ZRH/AB+XJ/2h/Knvwp+lNUf6TcH/AG/6U5/uN9Kip8bO3AK2Dj6E2eV/651Vg6P/AL5qyD/6AP5VWt/uv/vmtq3wHi5MrYp+jJhRSClrlPqxPpQKKBQAkn3G+hrUj/1K/wC6P5Vlv9xvpWkhxaqf9gfyreh1PmeIVrT+Zlw/6paMZmAPYE0Q/wCqT/dFKh+eRj2AH9a56h9Hh17sV5GJeH/SpMdAa1rZdltGPRRWM58yc/7Tf1rdAwAKETT1k2RXTMlpMy/eCMR9cV7b4ba2Ph7TTaHNsIUSM+oAxXiN7u+wz7fveW2Pyr3TRIrddF06O0Km3SBPLK9CuBg0M8bOH70Ubob95t9s1U1fH9k3QIz8lW8BW3nrjH60SxJNE8TjKOMEUjxTzwfIQwHKnNOvrYwXZJXargOAfQiulj8NKLkM826EHO3GCfY1o6hpcGoQhHG1l+669R/9agdzzma2R4yu0EHqKyJdLi89yYyMjgY6V6BL4UnVGZLhHYdBtxmsWayuLdiJoHQj1Ximm0Jq5yL6bGqlkjxj2oh01gN5TANdN5a/3ajeMZ9vSnzBylrwLEI9ZkwP+WLD9RVP4tadi70bWNx2gvaMpPALDcpx65Uiul8H6eY5J7xhww2L/M1e8XaZFq3hLUreW3M7CF5IlUfMHUEqV980r63NaM/Z1FLseJCndqht5RNBHJ3YZPse4/OpR0pn2UWmrodRSd6UdqQwq9oxxrNp/vH/ANBNUataY23VbUk/x/0NNbo5Mcr4afow1Q51Aj0QfzNUzVrUD/xMJPYAVWq6nxHPlMeXCQXkVZf9a34VLajFunuM1BPxKx/z0qzEMRIPQCszvWsgl/1Z+lNf7yf71Pk/1bfSmMP3kf4n9K6aT/dyPEzGPNjaK/rcloooFc57xuaXJt0G9TPV8/pWEv3B9K1bQ7dHm9y1ZS/dH0rSStFHh5Zriq8vP9WL3rpfBj41G5j/AL0QP5H/AOvXNVu+EX269tzw0TD+RrNHZmkb4WRT16Py9buRj7xB/T/61Z1bfipNmslv7y/1rEpvcrLJc2FgLRRSZpHeLTJPu0+mOflxTjuZV/4UvRjpf9bj2pMjFEv+vb6Cm9q9FH57J6kEPFw4Hct/Mf41aqonE49Czf0q3xXFWXvH2OTyvhkhcUUZJwOworE9cKKKKYhKKM0c4zjk9KpK7ObFYiOHhzMfbzCKfc3TGP1FRtIpnkI6Fsg1AVO9jnI4FPhTb97kd66XGPJynzFOtiHiXibak1TW7Y3qfrVcjySOcof0qVDtcH8Kwj7k0eriakcZhJJLVdCCP/WTH1kNOf7jfSoTMsDsjhs5Jzig3MbK2CenpVThJyvYvCY3DrDRg5q6Razgf9s6gg4Vv940faFK5AJwuKhhuEUFW4Oa0nGThsebgK1Kli23JWsW+hopgkQjhgR9aY1zEg5cfhzXOoSbtY+jliKUVzSkrepKaWqTX6g4VCfqcULfqT8yEfQ1p7Cp2OT+1sHzcvOW2+6fpWgp/wBBz/0y/pWcsiyJlTkVoD/kH+/lf0opaXPNztxn7OUXdGenEa/QVUnuGijlwuQWxn9Ktg4T8Kzbqdha7TGV3dzXPI+hi7R+RVtF33cY7A5NbmBWVpabpXf0GBWrVIiivduRXBfytka75pCI41H8TscAfma9z0my/svR7KwjOfIhSHPrgAE14naWM+p6vp1nbOY7iS5Qo4OCm07mb8FBr3qNFWdFUcck0meHm026qj2RdIJUD3FScUwHLY9s04dTSPJFpiPuklX+6QP0pwOSR6UiR7ZJGz98g/pigBw+8fSlPIweRTVYMWHocGl3DJAPIoApXOj2N3zJAob+8nyn9KzJPCluW+W4kVfQgGt8E7ffFJG4kRXHegCO2to7W3SGJcIg4pxwquWxtHJz6UshOw46jmlz39RQB896mltD4n1qKzdHtRdlomRty4ZQxwfTJNQirviLSE8PeLr/AE9FAjmP2uEj+4xxjHbBBH5VSqlsfW4KSlQjZ9BaWkooOsXNTWTbb+3P+2KrEgDJptlc+Zqduq/dD9fWtKcHJ3XQ87MsVTpUXCT1krJFu+/5CM49x/KoKj1iWSLVJirYBwf0qj9qlIIJFavDyl7yPIwucUqNFUpJ3Whqy2kRmI5+7nrUa8KKc8zZLZ52VXtvNncIh+ue1R7PRtk4bMpQqLnbaZK/KkU1secn0NTTR+VHndu9xVG7YhVIOCDV0EpwaXUWPxqWJhVS+EuVJHBJIMqvHqaoWlw8k6RNyCcZrRuLxkuY7SAgMeWOPuj/ABpKg72kdOIzyHIvYb+fQvxIyWBhbaGYHvWbLDJAgLrx6jkVFdXkq6rGgb5AoyvrVizlZby4s5CXUfMu7ng9qudK6PJwmYVKE5SWvM9SHPFbHhT5/EEeP4Y2J9h0rAlZo5ZIVyWVsD6V3PgnTEt9MN4wzLcHr6KO1Y8lo8zPTx+aRnT9lTV+ZFLxfCfPWcD7pwfbNczXo2sWySEblDI6lWB71wmp2P2CfAOYn5Unt7VDV1crJ8bGK9hL5FQsAMmmrIpbAPNU7m4ySi9O5qurkMD3FdEMO3G7His7UK3JTV0tzYzUbkYx7iqj3pxgDn3qFZGklTc2fmH86I4eW7KxWdUeRwhq2aEjqJnyw6/0pBIv94VXkOZpD/tU09K6lHQ+VbuwlP7neO7Nz+NLb3BU7HOQf0ps/wAtpGv+e1VgeaiMFOLudkMVUw9RSg9jZpruI1LMeBTYWzCpPpVO7m3vsB4H8644UnKfKfWYvHqjhlVW72J4LkyyFSAPSrNZ9kuZc9gKus4UEk4A6060Ep2iRlWIqVcPz1n1eogkQjhl9etOLjnngcf41lx4MgBxzxVhZCMr6cdM1o6bgeHWzF4pptWsWcjZyfc1KB8vHVRkfyNU1cEbcA8YOG/xrX0mzuLmYGKBZFwQS2dq57k/0rGpNRV2bRxEOXlSIYoZZkwkeVZggbsCRwP0qddNnPlqzIu4cEnvVyd0tV2yTLcXOWGIwAkZB4b36nH8s1HuJC5JJAAz3NeZisZJJOB35fBzcr7EUmgtdIC0qo44OBmoG8NTxglJkfjoQRVzceueaek0ifddvzrmjmeJXX8DWWT4aXQwp7K4tFbzYyo9eoP41mMfmNdyl0ko2TKCDxz0rn9Z0Y2pNzbgmA/eX+7/APWr18Dmkar5KmjPEx+UzoRc6eqMQ0UtJXsnhthRRRTESRStG2VNdIjbtOBH/PL+lcuOtdNbHOnr/wBc/wClceKfK011OujUlKPI3otUUrWGfUAyQRliq8+gqtqOk6oYlQWMpweoGa67SdNnt9BYQkR3cwLgsOh7UlhHrv2pFu1QQjO9tynP0xzXFNrm0PbjmOI5eVs4qwYW0LpMCkgchlPUVbW6hY434+tVNSUprN6p/wCepqtmu2nh4uKZg88r03ypKyOi0qaSHxDpEsEwik+1ogkIyAG+U5+oJFe72ziTc46ZwD618yTuwtyMnGQePXIxX01CgEcKpwqgce2K5q1P2crE1sWsVL2lrE6Z+0txxtGPzNS4IyR1OKQkKpNPHSsTEFBy2fWjP7zb2xmnUYyc0ARopWSQ9mIP6Uu0By3cgD/P505WDKGHQ0wP+9KH03CgB/c1HEuxWB6biR+NOZsMgx944/SlOM7T1IzigBpz5nqCKSVSU+XqORT2OBmmq+7d7HFAHj3xR05dO1+DWFl3i9QQSRs2TGyjK49ARn8RXDG+l7BR+FekfF+ytrrSLfVY7ffLaTKjzqcFATjDDuMn8M+9eW124aEZR1RFXGV6aUISsi0t9KDyFNWYrtJTj7p9DWYKWt5UINbFYfOMTSl70uZeZoXj/uwo7nml0dC2pxnH3QT+lVVEk7Kgyx7VpW8kOmk4/eTEc46CpUeSHL1M8ZivrVf2uyF16E/aklxw64z9KyMV0aXcF+m2WLOO2elV59IicFrdyp/uNyPzpQqqK5ZHNKk5PmiVJ5NiAf3lqXT2wj46nrUF4pSVEYdF5qXTvmLr7ZrnxH8GVjqwr/fxTNNo1kiKZ5IrGvEKrgjkGtpQQKr39t58JZPvgcj1riwWJUJcstmejmGGdSHNHdGTp/8Ax+x+xqxF8+tzse3/ANaq1qTHcoSO9WrQE6pcMehGa9mWrPARBcfNq7ewUfpV2P5vEDkdoRmqoTfq8hxxkVPBKsd3e3TdBhB74qZFR0Kt1PjU5XHQNj8q6bRPFS2EQhYhos52Nxt+hrjSSzFj1JyaSqdJSWpCqNHp03iOy1BFW3DM45I9K5HxBevJIsbIVCZxWTYXbWlysgPHQ10l5bR6pZeYn3wK4J3oVFzfCenQgqtJyp6SRyJOTk1YS4VI9vl5Yd6jngeCTaw+lR/hXo2jNJnBTrVKEnbcc772zjFLF/rk+tR1JCf3gPpVNWVjLmcpXZYHLOf9o0u0nj1oBVB8zAc9zTWuoF6OWPooz+tZt6WRooq92NvD/q1H1qvSySNK5dgB2AHYU2qgrIipLmldFw3Ajt1VSN2PyqpSUUQpqJtiMXOvbm2SskXIJo4oeTyewqGa4aU+i+lQ0URpRUubqaVMfVnSVFaRXb9RQaXe+7cGOaaOlLVNJ7nEm1sXbMzXNykSqSSeqjOB9K6d7hI4RbRLMoTghCU3f71Z3hWIGa4nP8CBR+P/AOqrbEsxJ6nmvl8zr2rOEeh9VleCjVoqpPqQrEM5ICjsq9Px9aloo4rypScndnv06caatFBxiiilzUFhmrdrMGBglwVbgZ/lVM0oODkfnTTtqhNJqzMDVrD+z75o1/1bfMh9vSs/Ndb4giFzpCXIHzRkE/Q8GuSr7LL8Q69BSe60Z8HmeGWHxDitnqFLRRXceeFdN4bVr5hCV+WP7x7YrnIonmlSONSzucKB3NelaNpiaXYLCMGQ/NI3qa5MW4qNnudOGg3K/QvgAAAUUtBrzj0jzHXk267dD1fNZ2K2PFAx4hnHsp/SsivXofw0eTX/AIjEUBrq0UjcpuIsj1G4cfyr6ZiOJQCeg/M18yq7pqFkyoj7JRLtfO1thBAOO1eyaR8SdKu3jTUo5NOmPG6Q7oif98dPxArjxT/eWPQwtCo6PtEtDu1+d3z0zipm+6B7gVXhmSZVkhdXjYZDqQQR7EVNEp8pQxyR3rmKHyOUidx1Ck08HOKaBwQec0oYEkenWgCG0VktY1b7yjB/Oms3+lQsOjKw/kf8amVgzuv900wRhI0LH7hzmgCbFRSKTPCw7Eg/QipHbYhY9B1ppU+YGzxtxigAcbkI9aapAww43dfrUgIPSoWjbymAPOcr+eaAOH+KMtxbeFrkpYpc2M8TR3RDbXjPGxx6gHr+FeKJzGpPXAr3f4mRXMngPUWtmZTGu+TaASY/4hz7GvB4wBEgByAowfWu7B9TkxXQfS0gpa7DkNDTx8srjqBUDt++IPJp+nXCQzESHCPwT6VcudLkL+fb4kRh0B6Vi3aWptFXjoU4LgxyZXqK2rW4W4j3Dgjgj0rITT7nef3T/lWhbWz2kTbvvN29KyqqL23NKd09dijqUm67J9qbYzCO5TPQ8Go7w5uGquDjpV+yU4OL6iVXkqKa6M6kUd+Ko2l9HJEBIwDjg5NWvOjPR1/OvnZ0KkJWaPpqdenUimmUb21wxmQY7kCqaXTwSFxg54Oa1i0kocQoGI4+Y4BNdp4cvPDGmpGs8CW90RzLdxgEn2bpj6GvVw1aahaaPGxlKnz3gzhrWHVL/my0e4mY/wAaRHH54x+tXLb4f+KrpNpsUgQnJ86ZR/LNe0W99azoGhlR1PQoQR+lWBLGf4hWjrS6I51Sj1Z49F8LNZ6zzwqP+mQL/wA8VZX4a+WP3z3bH/ZAH9K9aEqD+IUvmx/3x+dS61R9R+xguh5I/gC0UfevFPqSD/SiDw7d6c48iXzY+6uNpr1syR92X86jY256mI/XFZzk5q0jak/ZPmhoeO6loU1ypzbOCecgZwa5G80+6snIngkQD+IqQDX0W62P8Qg/Sqsx0tVIZY2z2UZzV0ZypaLYnEctXV6M+cwc9KDXtOraRoF4rNJp1uB3cqFP5jFeXeIbHSrG7C6ZfLNk/PDu37P+BD+Rrup1lLdHBKHLszGCL6U7FAorYyCigVrWvh3U7uFZkt9sbDIZ2C5FTKajuVGLlsjJorQv9HvdOQPPGuwnG5GyB9az6cZKSuglFxdmFFFFUSA6UtIKUUgOn8LHNrer34/kamrO8MXIhv3hbpKuB9Rz/jWrMnlysvoeK+QzSDjipN9T7fJailhUl0I6KKBXnHrC4pKXvRSAO1JQaWmBYkXzdDuUP9xv5ZriK7d2Eei3LE8bG/liuIr6TI7+zn6nyXEFvax9P1FoorQ0fTW1O/SAZCD5pG9Fr2pSUVdngRi5OyOg8JaTgf2jMvJ4iB/U111RxRpFEsaKFVRgAdhUlePUqOpK7PXpwUI2QUlKaSoLPN/E7BvENzz0Cj9Kyqu6xL52sXT+shqjmvYoq1NHk1nebEjGb+DIOFDE498AVr+USvy9+1U9L0u41PUJBBIE8mEHLjKli3APp0NW5ZXtbgW97E0E3YN0b3U9687F3dRs+vyKvSjh1Sk7Mt6TrGpeH5t2m3b24Jy0J+aJvqh4/EYNehaH8ULWULDrVsbR+nnw5eI/UfeX9frXnCsrDqGz2NHlIBwuD/smuZSseniMso1tbWfdH0HZX1rqNuLiznjnhPAkjYMp/EVIikSyk9GYEfkK8Asbq70q4Fzpt7LazH7xjOA3+8p4b8a7zRPieAVh1+3WIdPtluCU+rp1X6jI+lWpJngYnK61D3krryPRAu2V3/vAfpTbgF7WQAclDiiK4hurZJ7eVJYZF3JIjAqw9QaxtX8YaDoA2ahqUSTAf6hMvJ/3yMn86o89JvRG7jcmCOGHNMtyfIUN95flP4cVwMvxe0hHOzStVeEf8tPKVf0LZrP1P4uxTw7PD9mTJ/HNejasZ9AgOWP5CldGywtZtR5XdnpwxHvdiAvUknAFczqnxC8PaczRpdNfTrwYrNfMwfdvuj868h1PW9S1ps6nfT3Q6+W52RD6IvH55qiocgDPy9gBgD8KTkepQyactart6HWeI/iFqet20tlDClhZyqUdVPmSup4ILdFyPQfjXndof9GXBJUEhSf7ueP0rXlKwxs7uFUDkngCsexdHs4jG25cYB/GuvBO8mcefYWlhqcI011+ZZpVUuwVRkntSVLCHMyCIEvn5QO9ehLRXPm4q7SGywyQvtkUqeuDSx3E0P8Aq5XT/dbFdaNL/tW1SK5AiuAOCDms9tCtreUxzPKWHbgVxxxkGrS3PSlltXm9zYyP7SvT/wAvMn51G080py8rsfc1uDS7IdIpG+rGnrptr2tGP/Amo+uUl0L/ALLxHVoybaEzNGg/iNQXSqt1IqjADYArpYLZIHVo7Vht6darTadbSSM7wSAscnBNTHGQ5rhLK6ttGjnaK3G0qzP8Uyfkahk0RiM286yH+6w2mto4qmzCeW4iKva5DpepfYmaKZN9vJ95f7p9RXpXhnZqGhvu2XMIlZVWVQ3GAcV5O6NG5RwQwOCD2r1D4bsG8Pzqf4bg/wAhUV4JLnRhTk/gkTS+HtClclIZ7GXP37WUp+lMOh6rDzpnjC6UdkuVD/qauynMrn/aNMrC7MfbSTKJj8fQD91rOn3IH95FBP8A47Vd9X+IUBIZNOfHoE/xrVoouP28uhjHX/Hve3sP++V/xph1fx5L1/s9P+AL/wDXrcoxTv5CdaZz5bxrP/rNUtIR/sxKT/6DSjSdcm/4+/El0QeohUJ+tb1FHMyXUkYS+F9PJ33TXF43rczM4/LpXKavphl1q6Om2haBFUHyU+UEDkDFd/fKzQ9CUBzIoOCV+tZSakZYylrbi2hXje+M/gBx+f5VUJuLuaU1zrVnn5GDgggjqDSVf1d4p9XlMDF92Mkc7m71JbaNNIA0x8senU12OrFK8gVKUnaJnAc11em3WravEIYSz+WApVSBgdqSw8PJcSrFDC0znpnmuttPAF8E3+XFEcdM4NcdetGaskdlGk6b1ZxOvWV9Y2yi8Xb5pwo3A9K5yvTL7wleQgmWyZwO+3dWBcaHACQ8BQ+2RRRrqCs0Fag5u6ZyVKK1rrQ5EBaBt4/unrWUyMjFXUhh1BrthUjPZnFOnKG6Gilp2zFG2hTQnTl2HRSNFKsiHDKcg12McqapYpcx48wcMvv6VxmKuadqEunXHmL8yHh0z1FedmOEWIhePxLY9TK8ZLC1LS+F7/5m9S1ZAh1GEXNowOfvL7/0NVmBUkMCCOxr5WUXF2krM+zhOM4qUXoLSUZoqSwpRyeBzSVZtowoM8hCooyM/wA6LX2BtRVytrswtdHFuD80uF/Dqa5IVo6vem/uy658pflQe3rWftPpX2GXUfYUEnu9WfC5pXeIxDlHZaIQV6H4a0v+z9NDuv76bDN6gdhXKeG9OF/qqCQZjiHmMPXHQfnXotPF1b+4jPC07e8xRRRRXCdgVFcSCC2llPRFJqWsnxDOY9LaJfvzMIwP1NC3B6K551O2+4kb1Y1HVw6ZeEkmLk89aT+zLz/nia9qMoqKVzyXCTbdj0H4ZaDu0++v7yIiO8KpEGPVUz8w9OSfyrc1XwqsyPFJbrd2552suSPw/wAKz/hlaSpYXV1LLKUaTy4omYlUC9SB05P8q9ADBELEck4rypyvNs9GCtFI8ZvPBMaMW068mtSOkcn7xP15H51lTaNr9r/y6w3S/wB6CXBP/AWx/OvdbjTbO9Y+bGN/dlODWdL4WjbPlXBUejLmoaT3Oylja9LSMmeGSzX9vnz9OvI8dS0BI/Nciq/9swhsM+w+jHB/I4r2y48M3kQzGY5F9jg1k3ehyeU73NvGY1BJLgEADqTS5Edcc3xC3szzfS/FGqaXutNGv2hiuyVdMBlTjl1H8LfSrEFkmTtPJ+d2Y5Zz6seprK1u8t5r+O80y2RIoHIRlUL54/iP09PWrtpfQ3CB4jz3U8FfYis5p9D08vlCcnOUVGTLohGwEnJJFZWtRC3ure5iJUyny5MDqO1annlSCrEEdCO1ZerE3AtrdSA2/dn0xSjuejif4Tf3epCbq2tly7c+55qzbQ6tqJH2OyZIz/y1m+Vfy6n8q7Pwfoen6pHvsNPjjuY8CYuNxjP+8ex7GvStP8PWdkY5JB5kw7n7ufYVtyo+crZtW+GC5Ty/w98OZL28STUmkuCpBJddsafRe5+tYPjfQ38PeKbmPyWjtLp/MtWx8rDA3AEcZBzx1r6GPCkjmvPviyt3c+DSLe3Wa3EqPO2MtEoOdwH14PpmtqM3CSaPGxDlWTc3dnjnar2kXMdtqcMkozGTtbHUA8ZrPHSlr05RUo2Z5tObhNSXQ9JFhBIQ0N6FPYOMGrps2kRWfy5XUY3Kc5Fc5ot79r09QxzJH8rf0NXH46V4NSk4ysz6+nU9pBTXU0zC8f8AywYfRaNxXqjj/gJrDkmkHSRx9GNVJLqcf8tpP++zUezNLs6jzhjofyNHnrjkfmK497mc9ZpD/wACNRNIzdWY/U0ezC7OvlubXH7wwj/eIrCuJbSN2cS78HOEGBWXSGPzQVzgd61pw1sY1qvs4ORmXEpuLiSU8bmzivQvhnN/oWoQk9HVvzH/ANauKbThjjdXU/D8m11O7hJ4liyPqD/9evTqyi4cqPmEpc/M+p0jHLE+9JSn7x+tJXMcYUUUUAFFFGaACkoooAa4BQhgCCOQa80vb0S3s8Uhla1VyFjjfaMZ/WvRNRuBa6dPOf4EJryrJYknqeTW9CHNe5pTk4u6Om061tUt0nt4AnmLnJ5P0zVwA5rovAsNpqvhVIbmCOVraV4wSOQD8wweo61sTeFLCQ/u3mi9shh+oz+tctRNSaZ6tOScU0UPCeqWOmSSNdBg7DAYLnFdmniTSXwReKP95SP6VyDeD8H93eL+MZH8mqwPAt8QDHfREH/aYf0NQVozqT4g0oAn7bH+R/wrC1zxJpclq8MMSXLOCCSuNv5iqZ8CagRg3cH/AH8b/wCJoHw/uyctewD/AIC7f1FAaHIOVLEqMD0qjeafBeL8/wAj9n716LH8PIv+Wt+T/uQ4/mTV6DwLpEHzSG4mx2Z9o/8AHQKcZOLuglyyVmeAS3UI2+U27I+b2pgmDDINYxZ89Kckk24YzXRzGXKbPme9NZ+OtZkl3JHxxup1rcSzzhHPy4ycCnzIXIa1pf3NhOJbd8eo7N7Guotdetb9At3A0L/3sZH51w8+qSx/u7W12AfxlcmqTz6lcHDNOR6DgVyV8PTrfEte52YfFVKHwvQ9S+zW7jdHdJj3IppggXlr2AD3Yf415laQTLcqHVtxzgGpJEnViBCTzXD/AGYv5j0P7Yn/ACnoE+p6RYrl7kTOP4U+b+XFYOpa7Jqa7ITshHVO5+tc0rzqeYzipJ5GiCPwM9K66GDpUXzbs48Rj61Zcr0RfFyw4NL9oBHWsuOeSVsKAT1pkk7q56Zru5jh5TpNG1iTTNQSccp0kX1XvXqMUqTQpLGwaNwGVh3FeHwTOInl27ieAK6Pwx4xk0pxaX8bNYseGXkxH1HqPasaivqjSGh6hRUdvcQ3dulxbTJNCwyrocg1JnFYFi1xfiW8lutXFtbNxbL8xH941u69rsWkWxVCHu3H7uL/ANmPoBXla6vdR3LTxtL5rMWZ8j5j7irgtbkTfQ6dU1HHDt+dNkfUoInkd2woz9TXS+C9at9eH2a8tVS5AOGAwHxW34i0xFtrWC0jjW5nuY1jZ8bVwdxJ9sKa15jPqdB4ft5LHQrC3cYmSFA/scc/rW+vzL0qhaxGKJELtI/8TnuatWzMN2TkFjj6VkaFpI9pZsfMwp7KSmPXio2kwUUDljipulAhccYryX4ja8L27k0Gyk22kP8Ax/SKfvt18oH0HVvwHrXZ+NfE39gaWsVqVOpXeUt1PIT+9IfZf1OBXjnlLwm4soJZ3Y5LHOST7k1MnY9bK8F7aXtJr3V+ZmzRbmGRjgYHoPT8q1dF8P2up6bNJKGSdZ2UTRnaw+VT+I56GqzqpDvnlulehfC2KKf+3LSeJXjDQuFYZwSpB/8AQRRFnbmsOWipx01OFuvD+r2iMbeeC6QAkeYCjfjjg1mabE0u6eZvMllQMDjAX2Fe4694etre0a7tgUCkb4ycjB7ivGrSP7NJLFjm3nkjx7Bjj9MUppJXRlleIqV6nJUle2xraJq1xoupRX1tkvHw0YPEsfdD/Mehr3C2u4dS06K7tXDwzIJI2HcHkV4QyDzRztUcjFdz8Ndc2TXGgzt8pBuLXPpn94n4E7vxPpShLoVnOFVlXivU9GLHyywGTjOKjMUcsTKyBkkHzKRkEHqMVMMEAg8GkKLsKY+U9q0Pnz588V+Fzofih7CzV2t5V86DKEBFJ+5k8HHt2xWLPZT20vlyxnPXgZBr2P4gW6Wfh6O5maaUW1yjxOq5Manhgx/u47+wrmo7YT26yHaSRlSPStJY/wBjFcxyzoXfunFabPcWN0JFidkPDqB1FdYJFljDpyCM88VFL+7kKgAEe1MDnOc1zVMVGq72sdeCxPsfclt+Q2YVRkq7K4Jx0JqlL3pp3PdjNSV4srt1ptOPWhFMjbV/H2obsKU4xV2yS2t3uZhFGOT1PoPWtxdGt1GA0nvhsVWspvsUZVEUk9SRyaux6kd3zIuPpWaxKh0PExOIVaVk9Bv9lQ9mk/76q1ptpHY36XKM24DByexq7bkTxh1SNgfSrSW6kfNEAayeaQ2aZmsJJrQcetJVAXwtblrW5O3H3HPce9XgwYAggg9xXowkpRUlszyJLlk4vdC0UUVQgpKWkzQAtGaQnisnUNajtlKQkSS+3QUxNpGZ4xvglolmjfNI2Wx6CuLwK9K0/So5IPPvYkmnlO4+YoO0dhVz+yrD/nyt/wDv2K4HndKjJwUW7dT1aWW1JwUm7XMT4ZagItRu9Pc4E6CRP95ev6H9K9NrjhYW9s63FpbQxzxHchVADn0z79PxrrYJkngSaM5R1DCnSxsMU3KKsdHsJUUoskrTsJN8RQ9V/lWXU1rL5U6t2PB+lbkmz2o/CiigTCsXxXq39i+G7y8THnbNkIPd24H+P4Vtc1w3ia4g1e8+zOqyW1uSBnoX7n8On51jWrxox55GlKlKo7I+dpZr2U/u4io9lyaWK21aRhtjm/74rs7jV7OzkeIBpZFOG2jjP1NZd14hlkBClYl/uryx/Guu5kctdCZLlklYl14bPY1JFFchN8ZkGf7ueajffJOzP95mJJr0yx0+O1gRQBgKAv0pJjZ52P7QHQyn8CavWDamZlVrdpEJ5LLjA+tdlqGo2Gm4FxITKRkRxjJx/SueuvEzvkW1sEHrIc/oKYtWRzyRw30krdIkwBjvWKblyxP2w5J9KtGSa5trqVyWcgDAFZy2MzdVCj1Y4pNlJFhJGd1U3QbJxgin6kcSxxg8Kv8AOoVht7Y7mbzJB0C9BUbyPK5dzyaYmtS/pK/PNIcBUTkms24ky59M04MQCASAeo9ajkQt0p9BluGyv3tVmhjmMbdCoJFQt9tjOHLD2Yf41u6J4juNMt0tvLSSFc/JIMEZ64Irp7fXtG1ACO4je3duPnAZPzpXQ9TidO1LUrJy1vcyQE9fLbGfqOhraXxLrsi7X1KXB7gAH+VaWsaHCrt5aLG/UMnAaue8sxkg9RRykORftLK71aV4LctJcyjlmOSfqTWlbfCvXpmG94oh6k//AF6yLK+ayuklGcA/Ng4NeweGPEJv/Ltp3Dsy5ik7t7H3okrCRQ8I+AP+EduBdT3nnSjO1VGADjFaHiW0jutY0CKcE24umZhngsEyufxB/KulnmjtreSeZgsUaF3Y9gBkmsKx0iXX7601y/m/0ZV82ys06Rhhw7nu5HboM1FykjoI2LSAKcBfvH19quoMnNVWRY8Kg+tWN+xM+1QWyULmZWz90H9amzUUbZQHHWiE70Ln+InH0pknkHxHS7sPFsl9dsGs7iCNIJRyIAM5VvTJyc9OfaufgmhHMqb4m67T1H4V6j4stWbUN8iZieMAZGQfUV5/d+E4t5k06Z7NyclAN0ZP+72/CpcLns4HM/Yw9lUV15bmbOkck5aMbU7Cu/8AhNHubXbjHymaKIH/AHVJP864L+yteifyzbW0o7SrNhfqQRmvUvhzYHTdDuYS2+TzNzv/AHmIyTSjFo1zPG0a1FQpM6fWV3aPdD/Yz+teE38f2bxRqCEfK5SZf+BLg/qDXvV2vn6XMB1aI/yrxLxRF5et2VxjiaF4j9VIYfoTVS2ODLJ8mKj56FcqTFtJyyc59jQl1Ppd3batCCHtZBMD/eA4cfipIpYWVVDNz/Cee1NdjIpjc5jIxg+lc6bTPratP2kHB9T3i0kSaBJY23QyqJI29iM1OCDnHauY+H+oC98I2sJP76y/0WQf7vQ/ipU10wTDlh3HIrpR8LOLhJxfQrXUX2iOW2kVTHKhX5lyDkcgivNLG1l0kro+oxmK5iyImOdk6A8FG74HUdRXqrcLn0rlvGtpJqGgQ3FpFJcSWdzHdBIRl2CnDBR3OCeO9c+Ko+1p26jpy5ZHMzaRbTEt8yMepBqq/h887Lg57blrWtbmG9gE0D7kJI5BBUjqCDyCPQ1ZA4r5v6xVg7XOx4alLWxyc+h3oyPLWQezVRfQ73PMVwPpzXd4FLj2raOY1Y9CFhFH4ZNHAjQbrPMNwfwxVmLRrxRtS1YCu1IoxTlmVR9BSwfP8UmzkF0O+brEF+rCrMXh6dj+9lRR7cmumxRisnjqr2EsFSW5RtNPis4yqEknqT3q0Bin4pMVzyqOTuzrjBRVkZmr6et7algQsqDKsen0Nccl5PbtiOZ0PoG4ru7+2a7s3hV9hbofX2rjLuwmtnKTxED1I4P416uX4+VGPK9V2OevlNLFe9zcsh6a7fJ1kVv95RUo8R3Y4KRE/Q/41lG3Q9Cw+jU37Oe0r/p/hXsRzKg900eXPh/GRfuyTNn/AISO5x/q4vyP+NRP4gvGHBjX6LWV5B/56v8AkP8ACj7Mndnb6t/hTeY0OiYo5BjH8UkixPqlzN8sk7HP8I4/QUtjKkNws08JkC/dQnHPqaiWNE+6oH0pa46+OlUXLFWR6+EyKlRfNUfM/wADp08SQH78Mg+mDVhNesX6uy/7y1yGaXk9K8t0Is9Z0YI7aPULSX7lxGT6ZxWjpV8ltN9lkYCKVsxN2DHqv49R+NeeJA7kZ+Ue9XgxEYTcdoHQmt8NTlRnzRPKxtWlFcid2epUd+a4fT/FN3aIsVwn2mMcAlsOB9e/41sJ4v08j54rlD6bAf5GvZjVjLqeapo7i0lEsA5+ZeDU/FcF/wAJlYxfNFHcsw9FA/maoaj441G6hMVsFtlPG8HL/n0FDqxXUHJHUeI/EAtVaws5M3TDEjr/AMsR/wDFHsPxrko48YCnAFc+JXBPztknJ56n1qeGeQHIdh+NeXiueo730OzDYmMFZIun4WQE5ZYef+mj0D4WWy52x2313tn+Veg/bLb/AJ7JR9stf+e6V7dzjued/wDCqLTOdkP/AH9etRPBN0iKizwhVGFG5v8ACuw+2Wv/AD3Sl+22v/PZP1pXA4K4+GqXUrSzeQzt1O5uf0qH/hVVsf4IP++2r0P7ba/890o+22v/AD3Si4Hng+FkCghfKUH+7Kwz+lNb4UWr/eWM/WZ69F+2Wv8Az2Sj7Za/89kouK55z/wqWzxjZEPpK/8AhTT8I7T0T/v83+Fekfbbb/nsv60fbLX/AJ7L+tFx3PNv+FR2non/AH+b/Cj/AIVJa/7H/f5v8K9J+22v/PZf1o+22v8Az3Wi4HnH/Cp4P+meP+urf4U4fCm3/wCmZHp5rf4V6L9ttf8AnslJ9utP+e6/rTuBxj+Bbl02NNCQBgfMf8Kov8MN5JLx5P8A00b/AAr0L7ba4z5y/rR9tte0y/kaLsWh52PhaM8yxf8AfbH+ldFoXg6LSJY5Xn3mL7iKOB9fWui+223/AD1H5Gj7bbf89f8Ax0/4UNthoZ3iOeO30S4RozK9ypt4oVODI7jAUf56A1NoVvLY6NZ2kmFMESxkKc8gYPNY+rTLf+LtFt4WfbbJLdSYBA6BFz+bV0QbYmSeBUM0WxOWXqe1PA3rjtVcqWx6dasKcDJpATDpipVACgDoKqRuxbcemeKsu2yJm9FJpiY54ormArLGrxnqGGawrjwnBI++3naNT/Cw3AfStsBorDHVlj/XFTR/6pP90UAclJ4Rm/5Y3MbjodwIrf0fTF0yy8ncHdm3Ow9atw8q3++386I2JllX+6wx+QoAeihUCDoOK8v+I3h+4itFurKB5RBMJ1VBk7eQ4/Ik/hXpsZIllU+oI/Ef/WpxwW9xQVCbhJSXQ+eY54niEgdTGRndnjFLarf61MtvpsbFCceeVyB/uj+I/pXqOp/DDRL/AFQ3samAO26WBf8AVs3qF6Z/Suk07RrHR4QtrEFPAZzyxrNQVz2a+cznDlpqz6v/ACM7wX4cHhrRjblmaWZ/NkLHJLEdSfWuidtqluw60Z5pM5LIfT9K0PEbbd2NL7XUH7rdD701YlR2ZRjdyR704ooQDHA6Upyy/L1I4NAHnXi6zm8OatJr0Molt9RkSCa3YbdkgB2uCOucYOeelZa+J+PmtSD/AL1d/rs2hXOlT2GvXVpFbyrtkWeZUIPqMngjqDXihkEOoXGnWElxrccLYgubKFpfNQ9NxAwGHQ8152LwaqS50juwk6b92o7HXjxOne3b8xTv+Enh7wSD8q5ptK8ReV5r6VHYRf8APXU7uOAD8Mk1m3lvqENrLNDrWmXcyDItrCCa4L+28DaK5Y5c30OuVTCx05mzuP8AhJrfvHIPwH+NH/CT2/8Azzk/75H+NcZDexTMIwxWXbuMbAqw/A1YyaxeGgnZo6Y4enJXTOr/AOEmtv7kn/fI/wAaP+Eltz/DJ/3zXKA0tL2MOwfVYeZ1X/CSW/pJ/wB80f8ACR25/wCen/fNcr+NGcd6XsodhfVId3951X/CR2//AE0/75preIbYjBDkehUVy+fejd701Sj0QfVId395vSajpsn37cH/ALZiq7zaU3SBh9AR/WsnJozVqKQLCxXV/eaDNpvaJ/1/xphNj2jf/P41S3e9GfeqH9WX8z+8tn7H2RqT/Rf7pqrmjNO4/qy/mf3lndbDov6U4TQr0BH4VUyaTJp87Ilgact2/vLv2iL/AGvypPtEf+1+VU6Mmn7Rmbyyg+/3lv7QnvR9oT3/ACqpzRmmqjD+y8P5lsTp7/lR56e9VM+9BNHtJC/szD+f3lrz0HrTxcxcfeqjQaHJvcqOAoJaHVf2zqP/AD9P+Q/woGs6kP8Al6b/AL5X/CqOaSvpOVH58qk/5maP9t6l2um/75X/AApP7b1P/n6b/vlf8KoUuaOVF+0qfzMv/wBuan/z9t/3yv8AhR/buqf8/R/74X/CqFHFHKg9pU/mZof27qn/AD9n/vhf8KT+3dV/5+z/AN8L/hVCijlXYXtKn8zL41zVMf8AH43/AHwv+FH9uap/z9t/3wv+FZ+aXNHKiva1P5mXv7a1Q/8AL23/AHwv+FL/AG1qf/P23/fK/wCFZ+aXOKOVB7Wp/My9/bep/wDP23/fC/4Uv9t6p/z9t/3yv+FUM0maOVC9rU/mZof25qn/AD9n/vlf8KDrmqf8/bf98L/hVDNIfWnyoXtan8zND+3NU/5/G/75X/Ck/tvVP+fxv++V/wAKz8jNLkYpcqD2tT+Zmt4Uv5LvxLqwu3aS4EcOxiOPLwfT/aJrtExJx271xPgyFWj1O+JAaa5MWfRUAX+efzrtYjhQFrlnue/RvyK5aDDdtFP4PFVV4znrT2k2IXx07VJoXFxxx0qThhg9KrKxVBu6gc05ZcjIoAujBFOrMv8AVrTRtJnv7xylvAu5yBk+gAHcknArk9X8WanqOnXNpZ6HPbGaNoxPNfwRMmR1ADEg0xHeGSNB8zov1YCoTeWaMSbq3BPXMq/414e2g6QABc6ZoykDlrjXFJP1wlNXQfB5OZYfDaeuNRZ/5R0m0h2Z7mt5aM2VuoCT6SL/AI1IrI7blZWyMcHNeHf8I58PWzuudNQ/9MYJZP5AU0+F/AYOYdWliPrFbXSfyNLniuocrPd8e1NkXchXOM14jFpOi2w/0Lx7qdmw6f6RcKB+DCrsEviGIgaZ8TLO5PZLtonz+YzTUovZhZo9ffqpx0NUtW1bT9FtftupXUdtCDt3OfvE9AB1J9hXD22vfEDT0zqGn6PqcB4FxDcfZ9voTnIx9BXNT6h4o1TX5biKLTp76GIyfaIpsizh4UrCsgChyTy5yeePSgVjstU8bagY1ays7bS7aT/V3etOUaT3SBfnb8cVzl1qNxd5/tLWdYu1P8CzR6Tbn/vo+YRWVHpPiKW4a4XTrKOdx+8udQuXuZW+uCo/AgirsGgeJRyfEEFkD1FjZRx/qFB/WuSeYYaG80bRw9V9B1jYWnmGTTdG0lZP+esOnXOpy/8Afxwq5/GtSePWWQfa7zXBEBwm610+Mfhv3VmyeDpLv/kI+Jdbu/UNdMB+WTTIvAHhuFtzxTyv3Mly2T+RFc8s3wy2u/kaLCVGK1rpcDmR5dKSX+/c6wJZB/36iz/49VS8v9FC7bjXbFv9lbW8uB+ckoX9K2YvDHh6IYXTIWH+0Wf+ZNWYtK0a3YeXpVmh9RbLn+VZPO6f2YM0WBn3PN9Vu9BAjn027Ml1G4ISKwht0Yd8lGLnj1zToNXhcsk/+jyLg7XyMg9xkCvVkRI/9XGif7qgV5L8RZPM8YOM52W0S/8AoR/rSw+MjjqvJy203udNJTwy3ui1/aNp/wA/EX/fQpf7RtP+fmL/AL6ri6K9H6jHubfW32O0/tG0/wCfmL/vqk/tK0/5+Y/++q4yko+ow7h9bl2O0/tOz/5+Y/8Avql/tOz/AOfmP864qnRgNIqnoSAaPqMO4njJJXsdn/adn/z8x/nR/adn/wA/Mf51B/wjdgSSDKFHff8A/WpB4csSdoMuf9/oPfitf7MXc4P7ch/KT/2nZ/8APzH+dH9qWf8Az8x/nUB8P6er9Zig4Zt3f8qVvDtmDlfNYf3d/X6Gj+zY9xf23HsTf2nZ/wDPzH+dJ/all/z8x/nUSaDp7PnbIUPT5+hrlZ0EdzLGv3VcgfnUyy+Md2b0M09s2oo7D+1LL/n5j/OkOqWX/PzH+dcZRxUfUodzq+ty7Haf2pZf8/Mf50f2pZf8/Mf51xdFP6lDuH1uXY7P+1bL/n5j/Oj+1LP/AJ+ErjKu2emz3cLzJt2J1yeT9KUsHTirtieNkldo6qC+triTy45AzYzxT5ZxGgJUjnFUtO0d7VfPYr5hXgH+GpvImnb76uo4J6VxyhBS916HnVcdVlJ8rshkkpWHzMkBj19altp2mGCQPT3qK5bbthkClFHaq4UPgqGVR0ppJo5YYipB3TNL+0tQH8K/980v9p6h/dX/AL5qx9huz/y7S/8AfJpw0+8P/LtL/wB81H1yr/MfQf2dhP8An2vuKo1PUP7q/wDfNH9p3/8AdX/vmrg0y9P/AC7PThpd8f8Al2b9KX12p/MH9nYT/n2vuKX9qX/91fyo/tTUP7i/981d/sq9/wCeB/MUh0q+H/LA/mKPrtT+YP7Nwn/PtFP+1b/+4v8A3zR/al//AHF/75qw1jdqcG3l/Bc0n2K6PS3l/wC+DT+u1f5g/s7Cf8+19xX/ALVv/wC6v/fNL/al/wD3V/75qx/Z92eltJ/3zS/2def8+0n/AHzR9dqfzB/ZuE/59r7ir/amof3V/wC+aP7Uv/7q/wDfNWfsF2OttL/3zSfYLr/n2l/75NH12r/MH9m4T/n2iv8A2pf/AN1f++aP7U1D+6v/AHzVkWF3/wA+0v8A3yaPsF3/AM+0v/fNH12p/MH9m4T/AJ9oq/2nqH9xfyo/tPUP7q/lVr+z7v8A595P++aDYXY/5dpf++af12p/MDy3Cf8APtFX+09Q/ur+VIdT1Hso/Kp3gmj+/E6/VSKjPSmsZVfUX9m4T/n2jovh7Jcyyamk5/0ZZVlCY6Owyf5A/jXokbgjd2rz7wMxa21BI+XNzyew+Uf4V3kQwqrnhR+delFtxVzxKqiptRWhcXkZPFO2g4yO+ahDZOe1OEgXk9BVEE7DcMU6q8EpdSzDAPI+lSPMqjNAjnPiKqv4C1BHGVaSAEf9tUrNTQNHi+5pdmMesKn+Yq/8QH3eA78/7UJ/8ipQa8HOqk4uHK7bnoYKKad0UEjsYGIh06Fcd0iVf6VOJyo+W3A/ECmwwq7OWz1qfyYx6/nXiOpd6s9DliItxPjiP/x6nCe4P8IH/AqjZgo2oCR/ERzii3l84kqCEA70mna47E3mTY7fnVW5CyMI5ooZFIyQ6A/zq3VS5GblR/sVMJO5LSMLXdPg03R7i905RZzR7WxCMI/zAYZPun8qlu7doNd0SMTyskskpkUkAPtTcuQAM4PNSeK/+RXux6mMfnItP1DnxLoQ9Bcn/wAcA/rXo0sRVdLl5nb3vyMJ04c17djRnndZCitjABzikjE0oz5jbfXOP6UOgku2Hbj+VWGYJx+lcN0kkkdPQFjQdRk+/NOG3kDHFUJ3LtkuyovB296I/wDV/LcEL6dKfsna9wsaOeKz2YmTqSSR1q1A5ZDk7h2OMVUPMy/UfzFTFWumNGga8a8YB7vxfqTryEdY+voi17LjNeLXk32rUr64/wCetzIw+m4gfoK9bI4/vZS7IylBTaizI+yy+g/Ol+yS+351o4oxX03MV9XiZ32SX0H50fZJfb860fpRj2p8wfV4md9jl9vzpBC0cyBvUVpY9qrTj9+n1H86E9TKvRjGDaO7cYAVQM9h6UzYVARD8x5ZqlcBjjv2qNHy21uG/nXej417jwqKmwYx0xUBTy2CjlD0Hdf/AK1TsQgzjnsPWoGYg8YMjfpQAhAD8H5u/oa4q4tGku5zuA/eN/Ou2Vedo5/vH1NcrIP9JuP+ujfzrCu/dPXyiKlUafYofYT/AHx+VH2A/wB/9KvDtRXLzM+i9hDsUv7PP/PT9KX7B/t/pV2ijmY/YQ7Fa30rz50iEuNxxkiuotdOj0z/AFUjmMj5lbnLeorADFSCOCOhrdsJZLmKMGXMnbPeubE8zW+h5+NpOMbx2J5JmJ2n7h4Jx0pF8u2LICeSOPSrcUfm7yV2yqNrL6iqjqTKyYyx4FcGmx5NiCZY/MGcAVWnUCELFzzSyRHcu3JLdvekaOSOZYVwW61orCOz/tOX+4tKNSk/uLWWH55NK0wUZrz/AGdz7NpGoNRk7otO/tCT+4tY4uhxzUqzg9RzTdBrdEpxL0mqyRn/AFan8aj/ALakH/LFfzNUZ5k2EntVE3kQPU/lQqa7D0Nz+25P+eK/99Gj+25P+eK/mawvtsXqfyo+2Rep/Kn7Ndgsjd/tqT/niv5mk/tqX/nin5msQ3sPqfypPtkX94/lR7Ndh2Nz+2pf+eKfmaX+25f+eKfmaw/tkX94/lR9th/vfpR7NdhWNz+25f8Anin5ml/tuT/niv5msL7bD/e/Sl+2Q/3/ANDR7Ndg0Nwa2/8AzxX/AL6NPXWiT80OPo1YQu4T/wAtB+NShgwyCCKXs12HY6OG/guvkzgn+Fu9Y2uWSWqm6jG2P+JR2NVgSDkcEVe1ScS6DulI2uyLIT6bgCaKcLVIpdSKj5YOR0fhe3Sz0G0KoEd4w7+pY8kmt+FsJuY8msvTtsturhgYgAEweCK0kQthmr6I+Vbu7lpWpJRvTbnGetN6D2piPIZG3IBGOnPJoAnyQMA0AbiMmowSzHPSpF/WgDA+IB/4obUAOxiP/kVKlqn8QJkXwVqC713ExDbnn/WLVouqnlgPrXz2eLWHzPQwWzAIq5wMZqjqEoV0QlwCMnb/AFrQzXP319vuyY9wVPkbI64rx8PFymehCLb0EPlhuLopnsVIqa2uljcoLlAvqW4NZs17klACT7DFMijaQ5eUxnPIA4Fd7p3j7x0Rpt6M62N1dAVYN7ioJebxP9w1DpaCK3KiQvk556ipn5vF9kNec0oyaRhJWdjL8Wf8i+6/37iBfzlWn3vPivRh6Q3Lfogpnir5tOs4/wC/f24/J8/0qW4GfF2lj+7Z3B/8ejFdNLSkv+3vyMJb/cX1/wCPyT6/0FR3BH2kBmYJtydtTxg/aJWxxn+gqveOyTK69QtY0n75stQ8u2AHEhz6k1HJFGFR0QqST1+lVjfkn/WMfoD/AIVLDJJdyhdxwvJJB4rd6K5STWpqKoVAB1AxVTb/AKQvsR/P/wCtVwDjvUQiAk3Z5zXIpWuTcS+uBa2FzctwIonf8gTXjlrbj7JCXJ3FAW+p5r07xhN5HhHUyDy8Plj6sQv9a88AwoA7DFe/kkLU5y8yqKvNkX2dPel+zp7/AJ1LS17R08qIfs6e/wCdH2dPf86mophyog+zp/tfnVO8hWOaLGeT/WtOqOofehPv/hVQ3MMSl7NnYuMtwcHsahYCQZ6MvUU5sp945T17rSNjI5xJ2I7ivSPgnuNZiCBnc54B9KAuwYBy7dWp3CgkfeP3getLgAdeO59aAG4wAB0HeubaFGvLndniU9DXTAZByMLjgVz7qBdXDAdZDXPiPhPayT+M/Qj+zJ6H86Ps8fofzqWjj1rhufVcqIvs6eh/Ok8iP0P51MaKYWRF5EfofzqzYFLW6WQLnsfpUVT2nN1EP9qpqfCyZUozXK+pvSN5bRXI6ZCt9DUV1Hsv4j2LVYBWe12N0IwR0pJIzIULH7hBBryec8iplNVP3LMzooQ2oMhHEbM3+H86rlgsl1dnomVT61oMvk3M9xnl1xjHSs26jE9mturFFByxHUmtIyTepz/2biL2cTYx7VUupMYFP+1HHQVUnbfKKqhTfNqfRS03AMSM81JFOwZQSSKlayZYgQ3zHtUCxNHPsYciulyhJM4PbqUkos0lRJFYMMiqj2cG8/J+tW7dsZ+lMf7xrzW7M70VfsUH90/nR9hh9G/OrFHaldjK5sYfRvzpPsEPq351aop3Yir/AGfF/tfnR/Z0OM7n/OrgGaazZ4HSldgUvsEXq350v2CL+8/51apcUXY7FFtPGPkkI+oqFTLZygN90+nQ1qVTv1HlKe+aab6gy2pyMjpU+oEf8I1Kp6vhB9S2B/Oqlud0CH2q1qZ2+GpH7xsrj6hgaI/HH1M638OXodtZqtvbRQrwsagflWrASy9KwtOnNzZQy/xSBWIPaugt1LIAvUnr7V7x8sPVWbkr9BTzE/U4+gq5GFHygfU1MqIWOF57nFAGUzKiszkKqjLE8YHrWDpmk3njaP8AtG9vLmy0JyfstpbOY5LlOnmSOOQp7KMcdatazIfEslx4f0gnYwMd/frylup+8in+KQjjHQZ5rsrS1isrOC1gXbFDGsaD0UDApiZzDfDPwaybW0KBv9pnct+e7Nc54o8Cz6JpFxqnhrULtTaoZm0+5lM0UijkhS3zKcZxzXfa5p97qemPbWGrT6XcE5W4hRXI9iGHT6YNeSa34A+KMySxQ+MPt0DgqUad4SwPYjGOfrUTpxmrSVyoScXdM1/DHiC28R6LFe22VI+SWNuqOOo/+vU91pfmyNJGwG45Knpn1rkvhZcLHpN5pTW4iubKc+cwOd5OR+m3H4V3MrXCsPKVGXHO44xXxuIg6GIlGGiPaoVHyqSKKaZJG25JAp9RVj7EnLSAOx5LEcmnB7wkbkiHrgmnbrovgLFt9SxrKU6kt2b88r3HRxxxKWVQuepxTlCufMBzkYpxUPHtkA5HOKFRUXaowKxbv6kN3MbxEN8mjRf3r9T/AN8o5qZ/m8Y2w/556c5/ORf8Ki1b95r+hw9g00v5Jj/2apY+fGMh/uacg/ORv8K61pTXo/zMnuakjpEu5iFGepqlLcWUjBmkyfbNX3VXGGAI9xTBFEq4WNAPQKK5YNLVmqKn2u2iQbVY8Z+6eauKFIDBcEiqlzdtbPtVFIx+lWkZvLBfGe+Kud7Jjkna5l+I/ENr4a0s3tykkmTtjjjHLN9egHvXH6N4p8b+LZ2OgaDbm3U4MkgOxfYuSBn2FL468YxRBtHt4oZpJfkIkAIyfrwB7mp/Cnwj8XwKl2PEi6QJPnCWkrOefZSF/U172W4GnKnz1Ya+Z52KryjK0WWfFll40j8NMNX0S2+zJLHJNcWM/mbEU5OU649xmuWVg6hlIIIyCO9fQ2haZfadpn2XU9Wk1WXJzNLCqEj0IHX8a8V8aeHF8K+J2trddunXime1XtGc/PGPYEgj2NexTowpR5aasjXAYpufJPqYlLSUtUewJQKD1oFAC1S1DpCf9urtU78fLF/viqhuY4j+EzrGfb8iAF27Ht7moyEt1Ct8wbjGOc1IzLGu/GWPHHU03yyA00jAPjqeiivTPgGKeF8wsNw6en0pilid23Hqn9aYjNId23GOfLI6j1FSHa6hlPToe4oEPDAru7Vz7f62TIwd7fzrbVd02Xwp7Ad/esaX/Xy/75/nWGI+E9vI/wCNL0G0UlFcJ9WFFFKqs7bUVmPoBmmDdhKfbhzcIIxl88CpVsLx+VtpT/wGrFnY3UV5G0tvIig9SKmppFkxqwcrXRox3EUiCOUGOQeo/pTvJJ+5LGfxxVq6tkktFcgH5R1xxWYbdkGVLD6Ma8Z2Om7HTQTnIxkH0bNVWt5Qf9W1PLSr/wAtG/HFN82btIfyFCbQm0yY2zFA0bbgearxgm7VWGOeQa1AAvA4HWoptgw5xuXoa9dU7I8h15uDTLPB78YqlcMDOCP7tNaZuTmqry4kOa5vq8kceHSp1OaTNO2OT+FI/wB80lm2SD7Ur/fP1rglpKx7kXfYbWnoFnb3+sQ291kxsCcA4yQOlZlT2jyRXcMkGfNVwVx61VO3MriqpuDSdj0dPDujqMfYIj9ST/WntoOklcf2fCPwNNi1QlRvgZWxyM9DUgvZJWCQwM7HoK9f2cex8y6tS/xP7zzrV1ig1O4it1CRhyAoPQCqFWNQWZNQnFwhSXedynqOarCvHn8TPpaXwIcKKSlqDUKqah/qV/3qt1U1D/Ur/vU1uJklpzbJ9Kuakhk8L3CA4JGAT/vCqVkc2q/U1p3Qz4fkHuP/AEKhu0l6kSV42NrwvfLfaek+3Y4Ox1/usOorsbEKV5znOBXlvhK/FpdXljM4UyMJYSxADDABA9wR+tei2lwV2sGHuK92MuaKZ8zVhyTcToFGOgGTTpYEuLd7dtwSRSrFGKkA9cEcis5L/uwAp66kqjeGAHcNxiqMy/DFZaPp6xwxx21rCvCqMAVYguY7mJZYnDoehBri9b1Rr5GgXBjPB9CPSuOmuNV0aUzaZfzQ4HzKCCp+oPB/nVEnres6fc6lYNDZ6ncadP1SeAKxB9wRgivGPFum/EbS0l+1+NYzZgEl0YxNt9wF4/Os3Uvih4lUiJhZz/NgOUdOT67WwaoQW+t+N79Y9VulWzU7pIrdNqcdieprGtWhSV5s0p03N2Rs/CmzaLSb+8YswuJ8LIwwXCjr+ZNd1MrSOB53loOuOpqnpdvFb6dFbwqI4kTaqrxgZNTCyZyxj8sDdtG/JNfI1XLE15Sjuz2acFCKTAW8CkbruRsf3paI2sYJC6zrvIwcyZp/9lXB6ywAeyE/1p39kuBlrlAB6R//AF63+oVmtf0K9pDuOW7t3bCzRk+zVNVJrQwyOhl3YTdwMevvVpDlFPqBXn1qXs5co9HqjJuMSeMLJf8AnlZyN/30yj/2Wprb5vFd+3920gX82kNRJ8/jGU/887FB+bt/hU1j83iDV29BAn/jhP8AWtZaRt/dX5kf5mqaqLdmRiFC8HB+bmn30jRWUrp94DisizSSacvGdir1J7+1Z04JxcmbwhdORLqD5ucHgAYq7G5kiI9sA1kX25LoeYSScA1Jp8hN5ySflPU1vKC9mmuhpyOUb9jx7xtaRx+I9rS7d5CuxGcc4z9K9p8I+AtY0/T4JNG8f3RsWUMiJAksWPYMSBXm/wAQtEmkvXu4E3kfeUdcda6TwPp/g2WK3ng1q8spiAZYP7RMO1u4IGD1r6fA1FOjFo8DExamz3K1jlito0nnM8qjDSlQu4+uBwK8/wDjHaq/h/TLzHz29+qg/wCy6spH8vyruY9Q0+LTxcfbYPsqL/rmmBXA9WJrzL4keK9L1zw7ZWunTed5t+GVgMBljBJYeoyQAe9drM6F/axt3PPh2paaKdUH1IUlBopAFVr37kf/AF0FWar3f3Y/+ugqo/EjHEfw5eh1SbWYyt91eFJ/nTB/pLbyP3KngH+I+p9qV8vnGPl6L2akVt+XTr/Eh9a9Q/P2SSIJAOcMPun0quCwckACQcMn973qVp1VQeSx4CjqTULFlIJAad+AB2H+FADtyldqjcTyc9qxXGJHHUBjz+NbBzCA+7czH5l9T7VjynMrnBGWPB7c1z4j4T28j/jv0G9KKSg1xH1YtdtpEUMOiwzQwhmZMuV4YnvzXEV3Hhe5aHR1wOQxAJGc5NM4Mxf7tepXluYWJzbqf9+Y0iXCKwK28A/7amtO5vLKcnzIod2eTgiqh+wk8JH+Z/wps8dNdhwuopRtkgU59HBqO8tESMMgK7v4Sanja1jcFQg+gJpupS+YEKdDzXHiYR9m31PQwVWbrRjfQxpoSSeOKreXgkHg5q++SuRVZx82cV5aZ77SHSTrGnJ+YjgVmzXDTSZJ4HQVFNITJnPYU62t5LqUIoIXPzN6V9CrRjzM+elJJXZo2Nm90qu27DHCKOprUbRLOPImTcwHzBcnb9TVjTz5Eo8tPmClU9j0Bpt3J+8MSnKIcZH8R7mvGqV5yldPQ8+dVt3K32COAebbsWjXqD1Wqr/fb61djlMbbv4cEEeoqgxG9sdKyabV2enl+IlN8kjU0vQrvVWzGNkPeVun4etdrpmgWelgMi+ZN3kfr+HpS6JPEdOghUgMkYytbEMTTybR+J9K9Wjh4wSfU5cVi51JOKdkMjgMrbVXJ+lalvbJAvAG49TUkcSxLtUf/XqSuk4TL1XQNO1lMXcAL4wJV4YfjXn+t+Cb7TFee1P2q3HJwPnUe47/AIV6pUckiopLEAVjVoQqbo6aGKqUXo9Ox4OKcKt6uix6xeKgAUStgDtzVQV4slZtH0sJc0UwqpqH+pX/AHqt1T1H/Ur/AL1C3G9h1h/x7D6mtW4/5AL/AFH/AKEKyrH/AI9h9TWtP/yAW/3h/wChVM90Iwbi2S5i2OORyp7qfUV1eja+LhAHfbOg2Sp6H1+hrmxVe5R4j9qt22zxjPs4H8JHcV3YatyPlezODG4b2seaO6PSDfZQkMobtzkVTNzPJJieRCoOfl4rj7XWbe+K+U5jnxuVW4JHt61LLezKwYykN0FetyngXZu32qw2pZMFmxxtrldU1V7gEEhV7Ivf61HdXoXJklXd7nFc3d6iJGKWvzser9QPp61XLYVypqsql9inL5BwD05r2+x0220+1RIIwMIMnua8NazlSB5SpAAySepr35eYV/3R/Kvn88bXIvU9DA21KdiP3Sj/AGB/M1YR1WRAepkwP0qGzGIl/wB0VFe+Z9lm8lT5wOYyOoPHSvIws1Gsmz0XG8bGZP4nuYprqMMuY5j5fy9QDjaazpvEmpzXIc7RAU2PGOmD1P1p/wDYNwzMzMxLHJJ6k09dAf8AikcfjXtvF019o29nS7G5pc5udNWVmLN5JUk9eC1aCf6tfoKz9OgFrZtACSUTk+5JNaK8KB7V8/iZc1RtGbRk2vPizUT/AHbaAfq5qXSzu1bWm/6eEX8ok/xqOyH/ABU2qn/pnAP0al0dx9t1gnvekflGlVPZ+i/QyW5f1AZspPp/Wq2nY+zt0zu5q3I2UYMV2kY5FZcktjbAmS/jh9QZQKiEW4ctjeM4qNmyHU2El0iryR6VLpdu4leR0IXbgZHWqX/CQeG7Jy51SB5PUPvP6ZqOTx5o4/1K3lwe3l27Y/NsV0+xryjyQg/uFLF04x5bm1d6VBdxFGJB7N6VxninwnY2ejzXkhjkfeiKPLAOWYDr+Jq5J4/kfP2TR5GHQNPOqfoM1i6vrmq65bLb3AtbeFZFkxEpdsr05PH6V2YPB4uE4uWi6mEoe1j7quVItG02LLPEBCnzYkc7B74JxUZmN9dm62lYlQRwLjGEHfHbJ/TFR/ZRIwa4llnI5Akb5R+A4qzX0bfYWDwLpS557hS0lLUnqBRRRQIQ1XvDhEPo4qwTVa9/1H0INOOjM6yvBo6h8g7hkr345Bpp5YMpG/17GobfUbe6CmOQb8fMp4NSsViw45B/h9T7V6aaauj4CcJQk1JCZEZLkb524ApwXygXf5pW/wA4FMEZ/wBYx/eHv2A9KR5VTc7naVGCWPCimTr0Hcq2eDIep9KxpuLiTnPzn+dOn1UyP5NmrMzHG7HJPsKsw6HqrQq7WU4B6s6bf51xYmrBJJs93KISozdSemhRordTQYkX99M5f0QYxVK70poRuhYyD+6eDXIqsH1Pbp4+hUnyRZn12+noLbToo8Y2puP1rioVY3CArxuGR+NejwaNeXlvvjj2B1GC5wMUe0jcjM6c7R7HOOSWJ9TTc4rph4PuG+9e2yn6k04eCZyOL+3J+hq+eJ5tmjBQjirDndbe61rSeDtSjj+RoZcf3Wwf1rNltZrVnguI2jfHRhXPL3k4s6IySlGcd0ZzHP41BJ7CkjkO8oe3SiTOeOleU1Z2Po4yUlcyPIaeRccLgZNbVmgiTauAB0rOiSGIYkvrdP8AdJb+QqQ3unw/8vc8h/6ZxY/ma92rg8RVXKkfC1cdRa1kblvIY5A3pzUJOW9TWJJrcS8RQSOfWWT+gqlcandXIKs4RP7kY2j/AOvSpZJNv35HBUzGC0grmxqGpQW0LqHDyf3V5/M1DZOZbVJD1bJP51zsx/d10Om8WEP+7RmWFp4ejFQ7npZFWnWrycux3entyhHdBXRafdTJuCyGuW05/wB1C3qores3xIfcVcdYplz0k15m6t7OP4/0pft02PvD8qpq3FPBpklg3k5/jx9BULyO/ViT703NFAHmGsHOsXh/6at/OqVWdSO7U7o+srfzqtXgz+Jn1dJWgvQWqeo/6lf96rlVL9SYAR2apW5bFsf+PZfqa15/+QC3+8P/AEKsmzBW2XIweTWtcf8AIvn/AHh/6FUz3EZHakchVLMcADJPpSjpVe+VXtHR2Kq3BI9M1tBc0kiKkuWLZlJZpLHuKEKzGRMHBUE549KifSYi5f8AebjyTvNdZLZIWGwdqiNgSGIHsK+hVkrHyUm22zkE0iOa4wY8+7Ek/rW3Fp0MCYSMDA9K1Lex2MXZMH3FWkst2WYYB6U7oVmcpqiY025OOiGvXITm3jI6FB/KuEm0veGTarRsMEHuKrjS54kCpe30aAYCpdyAAegGa83McDLF8vLK1jpw2IVG91ud9CHSMDYTxQySEkqCufXmuAawmPXUdRP/AG9v/jTDpufvXV831u5P8a81ZFUv8aOv+0Y9j0Axyf3lH1FNLogzJcRL9cCvPjpNs331lf8A35nb+ZoGi6eP+XSI/Vc/zrRZI+s/wE8yXSJ3b6vpsORJqdknrmVf8arv4s0CP72sWZP+zID/ACrkV0y0X7tpEPpGKsRacznEVuT/ALqVayOm95sh5hLpE6XRb221LUdRvrOUS27eVGJACAWUHIGfTIrhNZmvG8SavDFf3UUQuf8AVwylATtXnitePTNZsZJH02ee0ErbpE8sOhb1wRwaks/D1ws0k84lnnlcvJJIBlmPetsLl/sK0pSs42siKuK9pBJaM5pNLe55k86b3klZv5mrcXh+FeWhiH0UV2MWkPj58KParA0uBRlstivTVlsjkakzkF0yOIgIg/AU2Sz8twcYGOc12otYUIKoAfXFQXcKOoUgYPFVzicDz7b5F5LCeh+dfoev61LU+ooI9VkjKruRRgjrg1DWctz6TANugriYpaKWoO0TFLRTkR5GCojMx6BRk0CG0Vv2HgzW9QwVtDCh/jnOz9Ov6V1WnfDS3jIfUrtpiP8AlnCNo/PrUuaRz1MTTh1PNTVe7BMBwM8ivX7/AOHej3MZ+yGW0lxwQ29T9Qf8a4bWPBuraOGd4PPgH/LWH5hj3HUURmmTDE06i5b2OHyQcjgjuKv2usXFuw8z96o4+bqPoafLapJ1GD6iqclnInI+Ye1bxm1sc1fCRmveVzfGuWogMgJ3f88++afpWlS69IZ72Ux2qniNOM/59a5bBB6V1+k3/kxRk52MozjtSxFefJocmHyyCb5NztPD2k6bpo+029uqu+QrEZKjp1PrWvNcFiTn8M1z9hqGy2CqDLGuSGjGSPqOtLLrluAQHJI7Ywa+RrwrTqNyuz0adKMdOousvEsO7gSZxkd65yVicmn3t48sucNtJJwaqNMuMZ/Ou6hCUIWZ6eFoQgua2rHW9v5+oQKq5dnA+tdB4h1GaO6NpmSMKAGAJAP/ANat7QdJ8OCwt5p0Ml0VDMzswwfYCrOs6d4dubZiBIJQPlMbEnP416EI2hqzzKmZ0XX1Wi0PO/MJ53H86TzHHR2H41GymN2XBBBxg0Zoue3ZNE32+7hG6O6mQjushFTrrN7PIguZ3mA4Bc5I/GqLEY5qASBZlUc/NVXOevSpuLui35mLhiemTU5O5vaqrffb6mpIXx16V509XcVJ6WOdooor9APyEQ0tFFAEU54Ue9dLZrstIV9EH8q5xIWur2G3T78jBR9ScV6yngq1Cgfa5uBj7orws4i5qMUfS5BVhRcpT8inpb5sovbI/WtyGTBVhTrbw3FbRCNbl2AJILKKtrpIQY84/wDfNc8JxUEmzpqe9Uco7MnjkBUEHrUyvVJ4xbAAyZz2xSLcr/ep8yGqc30NDIoJAqtHOrng/pVnYHBG7Gfak5IOSUXqeVXLbrqVvVyf1qKu3fwTas5b7bNyc42ik/4Qi1/5/J/++RXlPD1Gz3Y4+gla5xNIeRg9K7f/AIQm1/5/Jv8AvkUh8FWg63c/5Cl9XqD+v0O5xPTpV+fnQP8AgQ/9CropPCemxDL3so/Kop9L0z7IbYXNwVz94KPXPesp0+Xdr7xrGU3tf7jjBVa9yIkfYXRJFd1HUqDk10zaPaeaqRyTMCcAkgf0rXTwLazQkT3UylhjCEcfjiumhRk5KUdTKvjKTg4u+phQussIlX7rqCD7VMkXygV08HhGxgiSJJrjaoAGSO34VaTw5Zpj97Kce4/wr1zwNDmYbJHYBunerq2cOPun863holsgOx5M+5H+FMbTYYjueQqg9TipdxowzYQMc7T+dN/s63PVM/jW0YbFeWnOP94VBI9gv3Wlf/dIqXNLqWoN9DK/sq1yTsJ9s9KeunWo48lT9atfarX/AJ5Tn3BGKdHcWh5MU4B70vaLuV7GXYrCwtR/y7p+VOFrbjpDH/3yK0om0yRtpaQH/a4q9HY6fJypY/R6fNchwa6GEsUa/dRR+FKwwpxXQf2Pa9jJn/epP7KtBwVf/vqmLQ58nikNdINJssY2N/30aX+x7L/nkf8Avs0rgcsT8pqPduiz6iurbR7EAjyj/wB9Gqx0ixUbRDx/vmspV4x3NFTk9jl2kwAc1TurgKFPXkV2DaPYEYMGR/vH/GozoWmMRm1BxyMsf8aj67TK+rzPI9YfzPEE2CAEjUEeuf8A9VQojyMFjVnY9lGTXsSeFdHaVpjplvvbG5mXJOPrWjb6ZaWq4ghiiH/TNAtV7dSV0j0aGIVGmoW1PJrPwlrN4Ay2hjU/xTHZ+nWt20+HcjYN3fovqsSZ/U16H5KDkk0ojjH/AOuodVjljJvbQ5iz8D6Jb4Mkck7f9NH4/IYrobSws7IYtbWGEf7CAVPiMUhmgTrKg+rCocr9TnnUnLdk4oLY6mqpvrUHH2mIH/fFNmKyfOD5sePuo2RU7mXK+pMbkE4jBcjuOg/Go2uVTIaaNT6HpVOeV2jPlvhB/dHT61T5Rc/wHqFGQfx7VaijSNNMra14T0rVsyeX9kuD/wAtYhwT7jof51yT/D3VRcGNZbZou0hYj9K7b7YkQ27hFnjDHIP41YjnGQFYKSOAeVNXzSWx0RqVYKyehwL/AA5v15Z4ZP8AdqjqOhXGkIhMbeXjBOOhr1ZLnnDgqffofxqWRI7iJo5o1dGGCrDINZyrSatJEU69anUU73PHrK4S3uBI6swHZWwc0txe3FzxNKZB23AE/n1rqta8Eld8+lEEdTAxx+Rrj57e6tWK3FpcRkHBzGSPzFZ8rlqj2aeLw1R3m0n5gGPTNXdN0q41W5EcCZxyzdhWYLiHPMig+h4r0TwtGtp4be7GN0mWBHfsKI023Zl4rExp0r02rsr3CeTKY1Odny5U0y3Mv2gCNwrNxlqe6kknuagZCGzW8KKT1Z8vHBv2nM2czrFjd2V3I05yXYtuHQ571meew6Ma7XVx9u0dt4zJD39Qa8+kO1iKnktKx9Hh8S5Rs+hYaZ2ONxpYBm4Qf7QqoHK9K0tGhNzqcKnkA7m+gptWQ6lXRtlhvvH60AkdKsSQgu2D3NNEA964XSkzhWZUV3OcopM0ua+9PzQMUdKQyKvVgPxqvJN5hCJnnipbSLjBy2Oj8D2P9oeKIpSMx24Mp/Dp+texr0rlvBWg/wBj6SHmXFzcYd8/wjsK6csF+lfO42t7Spp0PoMJScIa9SdTx1oZgB1qnLeLGMDlvSs65vXb/WNhT2HSvMqV4w9T0qdNsmv5d0mEIb6HpVPa2cs34CjdkfL09qQvtHzfpXFUxs3pHQ7oxshwO3kEigXBH8TA/U1A0rMM/dHamgkmuWVST1bLUE9S6L2QdJmH1NOF/c9p2P5VSppwDmkq1TpJidKHYvNf3GOZ2qjdaokf+vu9vsz/ANKxtS1VGkFtHM6IP9ZInJ/3R71QL2CjEVkXb+/NIWJ/Liu+jg61aPNKTsT7Nv4ImlP4htFyEMkh/wBlazZ9duJf9TbFR6uaSLT7i5b5U2r+QrXi0eCFAW3M/c54rupZXTT11McTOVGN2w8P2d5qYNxJOkSxuAV2klu/Wu6BGODXNaHKqG4hGBtI4FbSyn8K9CNKFL3Ynmuo6nvMt5I70eYM4zk+1VZC7rw34VQiuCly8MnyM4+QnvTBEt/rYgYxwuhcdflJxWNPqs85y7HP4ACqt5E9vMyspBPOT3qoWbPU/nXNKTb1O+nSildF17uXHzH8RTPtLY+8c/Squ84wP50nmsBx+lQa2LX2jrknPejz2J+Vjn61U8xwvTp61GSzHLEY9u9IEXDcEN9/IPrUkd6yH5XI/wB1sVSVQDwQPxyalV1wMZzU7FWOk03WZFws8m5PUnkV0ySLIgPUEZBrhdPFxK+Fizn+ICuluNRh0uyDTOCQuFUHljW1Jt6HHiIxWpdFyqTPEeq1MLlO7YrjrDVLm8u5ZCn32yTjgD0rYM6jBZgPqa2kraMwhrqbXmKwyGBFV3PJFVolZmypx75qxJLFboZJZEX3auGtDodNJgsTP7D1NSlFiXKruauavPFttbSfeeTH8KJgH8TWNeePLlgRbW6x+78mueMYx1OpUqkjsrq5mjjI8xIyRwzdBWFd+KbK1BT7RNJIOMriuHvdbvL98zzu3sDgVR830x+VXzs2jhktzsLjxvcMMW0W33ds1mT+J9TuG3Gcqf8AZGKwvM9WNAk5/wDr1LbZvGlBbI0pNVvpRh7qUj3c1XaeQ8lyfrVfzVPfNJvHvSL5UTiZweuant9RurVw9vNJEw7qcD8qoiSnCTnNAml1OvsfF7sVW+i3np50XDfiO9dFBcwXiGW3lDepXg/8CFeZLJ05rofD0u69QOj9OHU9PrVxm0c9SjFK60OsMKNn5FGeMg8N9fSnxQRqNiR7M9dg4qdFZjkqT/tLx+dR3d5a6em66nSNeyDqfwrb2isc/M9iaJdg25Mh9B0qVporOIyXEqRKPVuK5a58UzTt5WmQED/now/pVD7DcXbmW8d5W6kyH5R+H+NRqzNtG5deLEdzFplu07/3yMKKqedNcM0lxIjyHrs6D2qmBAuIldpW6eVAP69KuIMLt2JGV/gU5I+vvXVhFyzOHHe9SGSW8Mg/eRRv/vKDW1AiRaHFGqhV7AdAKxblitu5HXFXINRim06NVOCgwQfXFb4yahFNkZVCUm36AyConRaheQs2TTcivn3mbvoj6RUUSNArxSxnGHQiuBm0uQuSGXGe9dyxwDzXNPlmPBrfD4qpXbsjjxM3h7NPcpaf4buNQuhCkiDuzYOFHrXeaV4dsdIjIjUyysPnkf8AoOwrM8MssV1KCMM64BNdTuzXYr/aOKeKnVW+hH5EKjCxRgeyis7ULa2MMkjQR/KOPlxzWixOOOtU7yB57YxIRkkdfrSa0MrHhwc+tG4+p/Ouu/4RSAH+Jv8AgVTxeHbOM5NtuP8Atc19A8VA8dYKp1Rx0FvLcybIY2kY+gzXX+HtHXT7qO7ukSWVDlUPIX39zWnFaLEu2OMIPQDFTrC/90/lXPUxLkrI6aeE5dWdnZahDdRblOCOqnqKjluWckJwvrWDYW85LlQw+QgGoV117WQw6hbuhHHmIMg/UV4uL50v3Z6NCKv7xuZxTWII55B9ar2+oWl0MwXEb+27n8qsV4kuZPU9BW6EZOBhR+VRP5iyDjOasHFNYgDOeKjmKISNx57dqXpVG81mytAQZA7/AN1eawLnX7y6JWFfKQ+nU1vSwtWs/dQ+ZLRHR3epW1khM0gB7KOSfwrm7zXbi9YxwK0cZ4wPvGq8GmXN0++XcAerNXSaZpUUBGxCzd2xzXr0Mup0tZ6s2jTsrzMvT/D15dYeRfKT/a6/lXRW2g29sOQXf1ateCBwuMECpmAUc16UVfQ4sRjOTRGcLYL0GBUM6kDirskgHAqpId1bwVjwsTiXUVjFknlsL8XCDKtww9fauhsdShvEGxsN3U9azZYlkUqygg+tVU0xhIDA+D2B/wAaqcIyMKVdw0OrV++abcQRXcW2Rc46EdQfaqEUeowRglfMH51IuoNGcSwsDWHL2OxVE9xjx3UCmOWFb23HQ/xCqbpo83Enn2rn1XIFaQ1G3bneUb3FI1xDMMExSD3wamUU90awnJfCzIbRrWfi21a3Ps+BS/8ACM3rH93e2zD2er8llZS/etl5/u1WfSbE5xGw+hrN04m6q1CEeFL3vc2+PXcaevhpUH+k6nAg7gH/ABNN/sm0/wCmn50/+y7JEyyD6s+KnkihqrU7jvsGhW3+s1DzPZSD/LNOGpaPbcW1tJM/Ylf8arNDp0J6wf8AfWajOoWEP3XBPoiUKMV0Heb6lptU1G4GLeCO2Q9zyf8AP4VB9j8x/MuGaeT1c8VF/a27iG1kb0LcCmm5vpupWIeijJpOTS7DjS5ty68iW8fzOI17AcVmy3RmkyoIUdM1IunyStubcT3ZzVyOxij5J3NWfOjqjRZpWkzz26TQS7GIwVblSR/KrX21SPKvIvLYjG7HB+hrJSQwcxtgd1PSrUF7HOPLBXPeN+QfpVuMai1OWpTqUne2g690LT7u2IjjCtncJEGT+NcZf+G7qB/kDMD0OMV2qR7H/wBGlMMn/PJ+QfpU4v41by7+HyWPG/8AhP49q5alCUdjeji7aM8nmtpIXKyKyn3GKhK4r2OfStPu03G2jlDd+v61nzeDtKlP+pKj0U4xWJ1rER6nlZOO9NyfUV6TL4AsGJMc8qemeazZfAcQcot8u70IxRctVoM4kfUU7d+NdgfALqCRdrx7GnJ4DnDANMuPX0oK9tA43k9Ac1PFbyStgAk13S+E9N09PNvrtQo/vHbmoX1zSLE+VpVibiQdG24H+NFm9iHXitjN0rwzczkO6FE9W4zXRi50nQ1/eyrJOB9yMZNYU17q+oHFxcC2iP8Ayzj6/kP60lva28LgRwGaX1lGf/Hf8auNNs56la5oTa/qup5TT4Ps8R/5aHrj61Q+x2qSNJd3D3c/UhTkZ9zVqdSgBv7pYV7Rk8n6KKpvq0EHFlZ7iOkk/wDRRXVSw05bI4quJhDdmhD9qkjxbQJBEOrkcfXJ4qvLPYxcT3Ml7J/cjOEH/Aun5VkXN5eXpzcTO47L0Ufh0qAJIeik/hXfTwUVrJnnVMdLaCOohZ5o8K0cUR/gt+M/Vup/SrEcO1cImAOwFc5ai6hcNGrqfWuisdUmACzxZ/2hwa1dPkXuo5XU5377HSWzyxlCp5GOlcrcmWzu2TcyOp9a9DhljmXKkfSsLxF4eOokTwlklUdV7/UVwYun7aHKenl1aOGnzbpnOprE6cOqv79Kf/bn/TDn/erOl0rUbdiCyPj+9kVELS6By4UfQ5ryP7Nm3sfQLH4Z9TTk1iWRCixqueM5ya07cDyEDAZ2jrWDDbkEFhk1opMwAGTiumjSWFTv1PNx2IhWsodDTUxxMGHBHIx1rQg1SJsLISp9TXNSXSxj1aqplupz8reWvrV2qVXdaI44J9DuTdQd5o/++hUL39pGMtcIB9a49bdv4ppG/wCBYqZLZMg7NxPrzWvs31ZsoSZfVGOKnjhLEelRK5xVuFs4zVTm0d3sEWotP3YyRV2LTo1+9zSW8nAHt+VXA9cNSrO5PIkKkKIuFGBWVrEcMiDzEVvqK1DJxWJq8hO3ntToNyka0oJysznLjTbZ2JUYPrVb7NdQ/wCpu5VHs5FaLvz1qFmwa73Ti90djwlN7IrCfV04F7KR7kH+lRyfb7jiaeVx9f8ACrmaerkdDUrD0k78qJ+pR7lKHSiTluB3PetGCyihA2rz696VJPepkfmtVpsWqEYF60tVdxu6VtxCONQFxWLbyhV4PNXFuB0zVWbOHEczZp+ZUEslVxOPUYpHkyMgitYI8bFxaQ1ySahanlqiY/lW1zyZBirNooaQVT3c1e0/Jkz6VFSVo3HSV5JGynQVJtVhyoP1qJWwBTw1ee53Z6sYkUtnbup3Qofwrkb+3g89gFIAPauzkb5D9K4e+kK3UgJ71dOTfU9LA0IVL3Vyq9tt+5PIv41H5MoPF1Ic+9SeYTS76152dcsvp7oh+zSN1nk/Opo7EFPmdjTg2auwgbOeahzZmsFFMrJYxcfLu+tXIbLP3Ih+VWIiAegrUgKbRxXJWrOKHKlGPQoxaaT98/lVyOyiiGQoz71bBHamSNwa5fauTFszKuJ9srDnGarNOPWobmTEjc96qtIc5zzXfCGh6EKasWJZs96pyNk9SCOhB6UjSEHrxUTNk1qo2L9mrWL8GsyRAR3iGaL++B8w+o7/AIVsw3Kzwb4nS6tzxgnke2f6GuWJ96aivFL5tvK8MvqnQ/UdDVp2PNxGXJ609DrIUkhYtps+w/xW8vQ1ft9biMghvENtN6P90/Q1zEGtEAJqMOMdJ4gcD6jqK2A8d1bjeEurdujDkj8e9Zzoxn6nmS9pRfLI6IEEbgQQe4qOVokTfMUVR3cgAVy0lpf28TNpF+wTvG/OPz6VgzWt9dzEXt3JK4PKjLkfh0FckqEo7m0akWdZe+LdNtAREzXDjsg4/OueufFOrX5KWwW3Q9Ni5b86hWxgtiN6oresh3N+Q6VaO+JAQWiT+/L8g/AU1TRXMZ39lz3DGa9kJPUtO/8ATrVyC2TBS3V5cddo2IPqatQ2kk2HWFpB1Ek+VX8F6n8cVox6ergfaXMoHRMbUH0Uf1zXRChKW+xz1cVGOiMyGEMSF3Tnulv8qj6uf6Zq4llcmPaHS1Q/wwDk/Vjz+WK0/kVQBgAdBiml/euuFKMTiqV5zMsaLbgklcsepJyT+NH9m2y/8slrSL+9QOa2Umck11KRsoV5EYpvkqOigfhVpjUROKu5jJEewAUoUA0E80Bjmk2JGrYgbea0QazrHITNXg1eZWm+Y9ShG0bhJHHIMMit9RWfqFpbC2ciGPPsKvk1Uv8Am2f6ZrNSdztoJe0Vzjp4lDHblfpVZkc8bzj61Zlfk81CW5rotc9yWGpyWqGJAAwzyamC03figSYNGpl9TjctxquBxzVhABjiqiSYFTo9S0bexUT/2Q==")||lt(tt,"src",Wl)},m(e,t){Yl(document.head,f),l(e,m,t),l(e,H,t),l(e,A,t),c(y,e,t),l(e,st,t),c(W,e,t),l(e,pt,t),l(e,b,t),l(e,ot,t),l(e,k,t),l(e,ft,t),l(e,S,t),l(e,it,t),l(e,R,t),l(e,jt,t),l(e,K,t),l(e,ct,t),c(T,e,t),l(e,ut,t),c(v,e,t),l(e,dt,t),l(e,X,t),l(e,Pt,t),l(e,J,t),l(e,Ht,t),c(M,e,t),l(e,mt,t),l(e,N,t),l(e,Vt,t),c(I,e,t),l(e,At,t),c(g,e,t),l(e,Ut,t),c(q,e,t),l(e,wt,t),l(e,F,t),l(e,Tt,t),c(z,e,t),l(e,Mt,t),c(G,e,t),l(e,qt,t),l(e,O,t),l(e,xt,t),l(e,Z,t),l(e,ht,t),l(e,L,t),l(e,yt,t),l(e,D,t),l(e,Wt,t),c(B,e,t),l(e,bt,t),l(e,Y,t),l(e,kt,t),c(Q,e,t),l(e,St,t),l(e,C,t),l(e,Rt,t),l(e,E,t),l(e,Kt,t),l(e,$,t),l(e,vt,t),c(x,e,t),l(e,Xt,t),c(_,e,t),l(e,Jt,t),l(e,ee,t),l(e,Nt,t),c(te,e,t),l(e,It,t),l(e,ae,t),l(e,gt,t),l(e,le,t),l(e,Ft,t),c(ne,e,t),l(e,zt,t),c(h,e,t),l(e,Gt,t),c(re,e,t),l(e,Ot,t),l(e,se,t),l(e,Zt,t),c(pe,e,t),l(e,Lt,t),l(e,oe,t),l(e,Dt,t),l(e,fe,t),l(e,Bt,t),l(e,ie,t),l(e,Yt,t),l(e,je,t),l(e,Qt,t),c(ce,e,t),l(e,Ct,t),l(e,ue,t),l(e,Et,t),c(de,e,t),l(e,$t,t),l(e,Pe,t),l(e,_t,t),l(e,He,t),l(e,ea,t),c(me,e,t),l(e,ta,t),l(e,Ve,t),l(e,aa,t),l(e,Ae,t),l(e,la,t),c(Ue,e,t),l(e,na,t),l(e,we,t),l(e,ra,t),l(e,Te,t),l(e,sa,t),c(Me,e,t),l(e,pa,t),l(e,qe,t),l(e,oa,t),c(xe,e,t),l(e,fa,t),l(e,he,t),l(e,ia,t),l(e,ye,t),l(e,ja,t),c(We,e,t),l(e,ca,t),l(e,be,t),l(e,ua,t),c(ke,e,t),l(e,da,t),l(e,_e,t),l(e,Pa,t),c(Se,e,t),l(e,Ha,t),l(e,Re,t),l(e,ma,t),c(Ke,e,t),l(e,Va,t),l(e,et,t),l(e,Aa,t),l(e,ve,t),l(e,Ua,t),c(Xe,e,t),l(e,wa,t),l(e,tt,t),l(e,Ta,t),c(Je,e,t),l(e,Ma,t),l(e,Ne,t),l(e,qa,t),l(e,Ie,t),l(e,xa,t),c(ge,e,t),l(e,ha,t),l(e,Fe,t),l(e,ya,t),c(ze,e,t),l(e,Wa,t),l(e,Ge,t),l(e,ba,t),c(Oe,e,t),l(e,ka,t),l(e,Ze,t),l(e,Sa,t),c(Le,e,t),l(e,Ra,t),l(e,De,t),l(e,Ka,t),c(Be,e,t),l(e,va,t),c(Ye,e,t),l(e,Xa,t),l(e,Qe,t),l(e,Ja,t),c(Ce,e,t),l(e,Na,t),l(e,Ee,t),l(e,Ia,t),c($e,e,t),l(e,ga,t),l(e,at,t),Fa=!0},p(e,[t]){const Nl={};t&2&&(Nl.$$scope={dirty:t,ctx:e}),T.$set(Nl);const Il={};t&2&&(Il.$$scope={dirty:t,ctx:e}),M.$set(Il);const gl={};t&2&&(gl.$$scope={dirty:t,ctx:e}),q.$set(gl);const Fl={};t&2&&(Fl.$$scope={dirty:t,ctx:e}),x.$set(Fl);const zl={};t&2&&(zl.$$scope={dirty:t,ctx:e}),h.$set(zl)},i(e){Fa||(u(y.$$.fragment,e),u(W.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u(M.$$.fragment,e),u(I.$$.fragment,e),u(g.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(G.$$.fragment,e),u(B.$$.fragment,e),u(Q.$$.fragment,e),u(x.$$.fragment,e),u(_.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(h.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(Ue.$$.fragment,e),u(Me.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u(ke.$$.fragment,e),u(Se.$$.fragment,e),u(Ke.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(ge.$$.fragment,e),u(ze.$$.fragment,e),u(Oe.$$.fragment,e),u(Le.$$.fragment,e),u(Be.$$.fragment,e),u(Ye.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),Fa=!0)},o(e){d(y.$$.fragment,e),d(W.$$.fragment,e),d(T.$$.fragment,e),d(v.$$.fragment,e),d(M.$$.fragment,e),d(I.$$.fragment,e),d(g.$$.fragment,e),d(q.$$.fragment,e),d(z.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(Q.$$.fragment,e),d(x.$$.fragment,e),d(_.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(h.$$.fragment,e),d(re.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(Ue.$$.fragment,e),d(Me.$$.fragment,e),d(xe.$$.fragment,e),d(We.$$.fragment,e),d(ke.$$.fragment,e),d(Se.$$.fragment,e),d(Ke.$$.fragment,e),d(Xe.$$.fragment,e),d(Je.$$.fragment,e),d(ge.$$.fragment,e),d(ze.$$.fragment,e),d(Oe.$$.fragment,e),d(Le.$$.fragment,e),d(Be.$$.fragment,e),d(Ye.$$.fragment,e),d(Ce.$$.fragment,e),d($e.$$.fragment,e),Fa=!1},d(e){e&&(a(m),a(H),a(A),a(st),a(pt),a(b),a(ot),a(k),a(ft),a(S),a(it),a(R),a(jt),a(K),a(ct),a(ut),a(dt),a(X),a(Pt),a(J),a(Ht),a(mt),a(N),a(Vt),a(At),a(Ut),a(wt),a(F),a(Tt),a(Mt),a(qt),a(O),a(xt),a(Z),a(ht),a(L),a(yt),a(D),a(Wt),a(bt),a(Y),a(kt),a(St),a(C),a(Rt),a(E),a(Kt),a($),a(vt),a(Xt),a(Jt),a(ee),a(Nt),a(It),a(ae),a(gt),a(le),a(Ft),a(zt),a(Gt),a(Ot),a(se),a(Zt),a(Lt),a(oe),a(Dt),a(fe),a(Bt),a(ie),a(Yt),a(je),a(Qt),a(Ct),a(ue),a(Et),a($t),a(Pe),a(_t),a(He),a(ea),a(ta),a(Ve),a(aa),a(Ae),a(la),a(na),a(we),a(ra),a(Te),a(sa),a(pa),a(qe),a(oa),a(fa),a(he),a(ia),a(ye),a(ja),a(ca),a(be),a(ua),a(da),a(_e),a(Pa),a(Ha),a(Re),a(ma),a(Va),a(et),a(Aa),a(ve),a(Ua),a(wa),a(tt),a(Ta),a(Ma),a(Ne),a(qa),a(Ie),a(xa),a(ha),a(Fe),a(ya),a(Wa),a(Ge),a(ba),a(ka),a(Ze),a(Sa),a(Ra),a(De),a(Ka),a(va),a(Xa),a(Qe),a(Ja),a(Na),a(Ee),a(Ia),a(ga),a(at)),a(f),P(y,e),P(W,e),P(T,e),P(v,e),P(M,e),P(I,e),P(g,e),P(q,e),P(z,e),P(G,e),P(B,e),P(Q,e),P(x,e),P(_,e),P(te,e),P(ne,e),P(h,e),P(re,e),P(pe,e),P(ce,e),P(de,e),P(me,e),P(Ue,e),P(Me,e),P(xe,e),P(We,e),P(ke,e),P(Se,e),P(Ke,e),P(Xe,e),P(Je,e),P(ge,e),P(ze,e),P(Oe,e),P(Le,e),P(Be,e),P(Ye,e),P(Ce,e),P($e,e)}}}const ln='{"title":"Serverless Inference API","local":"serverless-inference-api","sections":[{"title":"Let’s get started","local":"lets-get-started","sections":[],"depth":2},{"title":"Querying the Serverless Inference API","local":"querying-the-serverless-inference-api","sections":[{"title":"With an HTTP request","local":"with-an-http-request","sections":[],"depth":3},{"title":"With the huggingface_hub Python library","local":"with-the-huggingfacehub-python-library","sections":[],"depth":3}],"depth":2},{"title":"Applications","local":"applications","sections":[{"title":"1. Generating Text with Open LLMs","local":"1-generating-text-with-open-llms","sections":[{"title":"Streaming","local":"streaming","sections":[],"depth":4}],"depth":3},{"title":"2. Creating Images with Stable Diffusion","local":"2-creating-images-with-stable-diffusion","sections":[{"title":"Caching","local":"caching","sections":[],"depth":4}],"depth":3},{"title":"3. Reasoning Over Images with Idefics2","local":"3-reasoning-over-images-with-idefics2","sections":[],"depth":3},{"title":"4. Generating Speech from Text","local":"4-generating-speech-from-text","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function nn(w){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jn extends Ll{constructor(f){super(),Dl(this,f,nn,an,Ol,{})}}export{jn as component};
