import{s as re,n as me,o as ue}from"../chunks/scheduler.7da89386.js";import{S as pe,i as fe,g as s,s as i,r as j,A as de,h as o,f as t,c as n,j as ne,u as W,x as m,k as se,y as he,a as l,v as B,d as Z,t as x,w as I}from"../chunks/index.20910acc.js";import{C as oe}from"../chunks/CodeBlock.cde23137.js";import{H as L,E as ce}from"../chunks/EditOnGithub.ba36cbd0.js";function ge(P){let r,R,G,E,u,$,p,q=`🤗 Optimum Habana was designed with one goal in mind: <strong>making training and evaluation straightforward for any 🤗 Transformers user while leveraging the complete power of Gaudi processors</strong>.
There are two main classes one needs to know:`,H,f,K='<li><a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer" rel="nofollow"><code>GaudiTrainer</code></a>: the trainer class that takes care of compiling (lazy or eager mode) and distributing the model to run on HPUs, and of performing training and evaluation.</li> <li><a href="https://huggingface.co/docs/optimum/habana/package_reference/gaudi_config" rel="nofollow"><code>GaudiConfig</code></a>: the class that enables to configure Habana Mixed Precision and to decide whether optimized operators and optimizers should be used or not.</li>',X,d,O=`The <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer" rel="nofollow"><code>GaudiTrainer</code></a> is very similar to the <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">🤗 Transformers Trainer</a>, and adapting a script using the Trainer to make it work with Gaudi will mostly consist in simply swapping the <code>Trainer</code> class for the <code>GaudiTrainer</code> one.
That is how most of the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">example scripts</a> were adapted from their <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch" rel="nofollow">original counterparts</a>.`,k,h,V,c,ee='where <code>gaudi_config_name</code> is the name of a model from the <a href="https://huggingface.co/Habana" rel="nofollow">Hub</a> (Gaudi configurations are stored in model repositories) or a path to a local Gaudi configuration file (you can see <a href="./package_reference/gaudi_config">here</a> how to write your own).',S,g,Q,M,ae=`🤗 Optimum Habana also features HPU-optimized support for the 🤗 Diffusers library.
Thus, you can easily deploy Stable Diffusion on Gaudi for performing text-to-image generation.`,C,b,te="Here is how to use it and the differences with the 🤗 Diffusers library:",Y,w,v,T,z,J,le="Here are examples for various modalities and tasks that can be used out of the box:",A,y,ie='<li>Text<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/text-classification" rel="nofollow">text classification</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/question-answering" rel="nofollow">question answering</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/language-modeling" rel="nofollow">language modeling</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/text-generation" rel="nofollow">text generation</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/summarization" rel="nofollow">summarization</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/translation" rel="nofollow">translation</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/protein-folding" rel="nofollow">protein folding</a></li></ul></li> <li>Images<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/image-classification" rel="nofollow">image classification</a></li></ul></li> <li>Audio<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/audio-classification" rel="nofollow">audio classification</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/speech-recognition" rel="nofollow">speech recognition</a></li></ul></li> <li>Text and images<ul><li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/stable-diffusion" rel="nofollow">text-to-image generation</a>,</li> <li><a href="https://github.com/huggingface/optimum-habana/tree/main/examples/contrastive-image-text" rel="nofollow">contrastive image-text training</a>.</li></ul></li>',D,U,F,_,N;return u=new L({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),h=new oe({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMkMlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIzJTIwRGVmaW5lJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMlMEEtJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyQiUyMHRyYWluaW5nX2FyZ3MlMjAlM0QlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzKCUwQSUyQiUyMCUyMCUyMHVzZV9oYWJhbmElM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwdXNlX2xhenlfbW9kZSUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjBnYXVkaV9jb25maWdfbmFtZSUzRGdhdWRpX2NvbmZpZ19uYW1lJTJDJTBBJTIwJTIwLi4uJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBvdXIlMjBUcmFpbmVyJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBHYXVkaVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMEElMjAlMjAlMjAlMjAuLi4lMjAlMjMlMjBvdGhlciUyMGFyZ3VtZW50cyUwQSk=",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.habana import GaudiTrainer, GaudiTrainingArguments</span>

# Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = GaudiTrainingArguments(</span>
<span class="hljs-addition">+   use_habana=True,</span>
<span class="hljs-addition">+   use_lazy_mode=True,</span>
<span class="hljs-addition">+   gaudi_config_name=gaudi_config_name,</span>
  ...
)

# Initialize our Trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = GaudiTrainer(</span>
    model=model,
    args=training_args,
    train_dataset=train_dataset
    ... # other arguments
)`,wrap:!1}}),g=new L({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),w=new oe({props:{code:"LSUyMGZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBERElNU2NoZWR1bGVyJTJDJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmEuZGlmZnVzZXJzJTIwaW1wb3J0JTIwR2F1ZGlERElNU2NoZWR1bGVyJTJDJTIwR2F1ZGlTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQS0lMjBzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQSUyQiUyMHNjaGVkdWxlciUyMCUzRCUyMEdhdWRpRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEEtJTIwcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTJCJTIwcGlwZWxpbmUlMjAlM0QlMjBHYXVkaVN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTBBJTJCJTIwJTIwJTIwdXNlX2hhYmFuYSUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjB1c2VfaHB1X2dyYXBocyUzRFRydWUlMkMlMEElMkIlMjAlMjAlMjBnYXVkaV9jb25maWclM0QlMjJIYWJhbmElMkZzdGFibGUtZGlmZnVzaW9uJTIyJTJDJTBBKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlNUIlMjJBbiUyMGltYWdlJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBpbiUyMFBpY2Fzc28lMjBzdHlsZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRDE2JTJDJTBBJTJCJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDQlMkMlMEEp",highlighted:`<span class="hljs-deletion">- from diffusers import DDIMScheduler, StableDiffusionPipeline</span>
<span class="hljs-addition">+ from optimum.habana.diffusers import GaudiDDIMScheduler, GaudiStableDiffusionPipeline</span>


model_name = &quot;runwayml/stable-diffusion-v1-5&quot;

<span class="hljs-deletion">- scheduler = DDIMScheduler.from_pretrained(model_name, subfolder=&quot;scheduler&quot;)</span>
<span class="hljs-addition">+ scheduler = GaudiDDIMScheduler.from_pretrained(model_name, subfolder=&quot;scheduler&quot;)</span>

<span class="hljs-deletion">- pipeline = StableDiffusionPipeline.from_pretrained(</span>
<span class="hljs-addition">+ pipeline = GaudiStableDiffusionPipeline.from_pretrained(</span>
    model_name,
    scheduler=scheduler,
<span class="hljs-addition">+   use_habana=True,</span>
<span class="hljs-addition">+   use_hpu_graphs=True,</span>
<span class="hljs-addition">+   gaudi_config=&quot;Habana/stable-diffusion&quot;,</span>
)

outputs = pipeline(
    [&quot;An image of a squirrel in Picasso style&quot;],
    num_images_per_prompt=16,
<span class="hljs-addition">+   batch_size=4,</span>
)`,wrap:!1}}),T=new L({props:{title:"Ready-to-Use Examples",local:"ready-to-use-examples",headingTag:"h2"}}),U=new ce({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/quickstart.mdx"}}),{c(){r=s("meta"),R=i(),G=s("p"),E=i(),j(u.$$.fragment),$=i(),p=s("p"),p.innerHTML=q,H=i(),f=s("ul"),f.innerHTML=K,X=i(),d=s("p"),d.innerHTML=O,k=i(),j(h.$$.fragment),V=i(),c=s("p"),c.innerHTML=ee,S=i(),j(g.$$.fragment),Q=i(),M=s("p"),M.textContent=ae,C=i(),b=s("p"),b.textContent=te,Y=i(),j(w.$$.fragment),v=i(),j(T.$$.fragment),z=i(),J=s("p"),J.textContent=le,A=i(),y=s("ul"),y.innerHTML=ie,D=i(),j(U.$$.fragment),F=i(),_=s("p"),this.h()},l(e){const a=de("svelte-u9bgzb",document.head);r=o(a,"META",{name:!0,content:!0}),a.forEach(t),R=n(e),G=o(e,"P",{}),ne(G).forEach(t),E=n(e),W(u.$$.fragment,e),$=n(e),p=o(e,"P",{"data-svelte-h":!0}),m(p)!=="svelte-e8hfpw"&&(p.innerHTML=q),H=n(e),f=o(e,"UL",{"data-svelte-h":!0}),m(f)!=="svelte-1w7hiz"&&(f.innerHTML=K),X=n(e),d=o(e,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lkuqj"&&(d.innerHTML=O),k=n(e),W(h.$$.fragment,e),V=n(e),c=o(e,"P",{"data-svelte-h":!0}),m(c)!=="svelte-jrct53"&&(c.innerHTML=ee),S=n(e),W(g.$$.fragment,e),Q=n(e),M=o(e,"P",{"data-svelte-h":!0}),m(M)!=="svelte-1ae8t87"&&(M.textContent=ae),C=n(e),b=o(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-2jvm77"&&(b.textContent=te),Y=n(e),W(w.$$.fragment,e),v=n(e),W(T.$$.fragment,e),z=n(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-iafmur"&&(J.textContent=le),A=n(e),y=o(e,"UL",{"data-svelte-h":!0}),m(y)!=="svelte-bx3b0y"&&(y.innerHTML=ie),D=n(e),W(U.$$.fragment,e),F=n(e),_=o(e,"P",{}),ne(_).forEach(t),this.h()},h(){se(r,"name","hf:doc:metadata"),se(r,"content",Me)},m(e,a){he(document.head,r),l(e,R,a),l(e,G,a),l(e,E,a),B(u,e,a),l(e,$,a),l(e,p,a),l(e,H,a),l(e,f,a),l(e,X,a),l(e,d,a),l(e,k,a),B(h,e,a),l(e,V,a),l(e,c,a),l(e,S,a),B(g,e,a),l(e,Q,a),l(e,M,a),l(e,C,a),l(e,b,a),l(e,Y,a),B(w,e,a),l(e,v,a),B(T,e,a),l(e,z,a),l(e,J,a),l(e,A,a),l(e,y,a),l(e,D,a),B(U,e,a),l(e,F,a),l(e,_,a),N=!0},p:me,i(e){N||(Z(u.$$.fragment,e),Z(h.$$.fragment,e),Z(g.$$.fragment,e),Z(w.$$.fragment,e),Z(T.$$.fragment,e),Z(U.$$.fragment,e),N=!0)},o(e){x(u.$$.fragment,e),x(h.$$.fragment,e),x(g.$$.fragment,e),x(w.$$.fragment,e),x(T.$$.fragment,e),x(U.$$.fragment,e),N=!1},d(e){e&&(t(R),t(G),t(E),t($),t(p),t(H),t(f),t(X),t(d),t(k),t(V),t(c),t(S),t(Q),t(M),t(C),t(b),t(Y),t(v),t(z),t(J),t(A),t(y),t(D),t(F),t(_)),t(r),I(u,e),I(h,e),I(g,e),I(w,e),I(T,e),I(U,e)}}}const Me='{"title":"Quickstart","local":"quickstart","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[],"depth":2},{"title":"Ready-to-Use Examples","local":"ready-to-use-examples","sections":[],"depth":2}],"depth":1}';function be(P){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends pe{constructor(r){super(),fe(this,r,be,ge,re,{})}}export{Ue as component};
