import{s as fs,n as Ts,o as Js}from"../chunks/scheduler.6062bdaf.js";import{S as ds,i as Us,g as o,s as n,r as m,A as us,h as p,f as a,c as l,j as ys,u as r,x as M,k as Ms,y as js,a as e,v as i,d as c,t as w,w as h}from"../chunks/index.4bca734e.js";import{C as ns}from"../chunks/CodeBlock.fa01571c.js";import{H as R,E as gs}from"../chunks/EditOnGithub.74ab2baa.js";function bs(ls){let y,G,W,S,f,F,T,os="The <code>optimum.fx.optimization</code> module provides a set of torch.fx graph transformations, along with classes and functions to write your own transformations and compose them.",Q,J,X,d,ps="In 🤗 Optimum, there are two kinds of transformations: reversible and non-reversible transformations.",E,U,N,u,ms='The most basic case of transformations is non-reversible transformations. Those transformations cannot be reversed, meaning that after applying them to a graph module, there is no way to get the original model back. To implement such transformations in 🤗 Optimum, it is very easy: you just need to subclass <a href="/docs/optimum/pr_2021/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation">Transformation</a> and implement the <a href="/docs/optimum/pr_2021/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform">transform()</a> method.',A,j,rs="For instance, the following transformation changes all the multiplications to additions:",H,g,V,b,is="After implementing it, your transformation can be used as a regular function:",Y,C,q,I,L,$,cs='A reversible transformation implements both the transformation and its reverse, allowing to retrieve the original model from the transformed one. To implement such transformation, you need to subclass <a href="/docs/optimum/pr_2021/en/torch_fx/package_reference/optimization#optimum.fx.optimization.ReversibleTransformation">ReversibleTransformation</a> and implement the <a href="/docs/optimum/pr_2021/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform">transform()</a> and <a href="/docs/optimum/pr_2021/en/torch_fx/package_reference/optimization#optimum.fx.optimization.ReversibleTransformation.reverse">reverse()</a> methods.',P,v,ws="For instance, the following transformation is reversible:",K,k,D,Z,O,_,hs='As applying multiple transformations in chain is needed more often that not, <a href="/docs/optimum/pr_2021/en/torch_fx/package_reference/optimization#optimum.fx.optimization.compose">compose()</a> is provided. It is an utility function that allows you to create a transformation by chaining multiple other transformations.',ss,B,ts,z,as,x,es;return f=new R({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),J=new R({props:{title:"The transformation guide",local:"the-transformation-guide",headingTag:"h2"}}),U=new R({props:{title:"Write a non-reversible transformation",local:"write-a-non-reversible-transformation",headingTag:"h3"}}),g=new ns({props:{code:"aW1wb3J0JTIwb3BlcmF0b3IlMEFmcm9tJTIwb3B0aW11bS5meC5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBUcmFuc2Zvcm1hdGlvbiUwQSUwQWNsYXNzJTIwQ2hhbmdlTXVsVG9BZGQoVHJhbnNmb3JtYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdHJhbnNmb3JtKHNlbGYlMkMlMjBncmFwaF9tb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwbm9kZSUyMGluJTIwZ3JhcGhfbW9kdWxlLmdyYXBoLm5vZGVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub2RlLm9wJTIwJTNEJTNEJTIwJTIyY2FsbF9mdW5jdGlvbiUyMiUyMGFuZCUyMG5vZGUudGFyZ2V0JTIwJTNEJTNEJTIwb3BlcmF0b3IubXVsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS50YXJnZXQlMjAlM0QlMjBvcGVyYXRvci5hZGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBncmFwaF9tb2R1bGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> operator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> Transformation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">ChangeMulToAdd</span>(<span class="hljs-title class_ inherited__">Transformation</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                node.target = operator.add
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module`,wrap:!1}}),C=new ns({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMudXRpbHMuZnglMjBpbXBvcnQlMjBzeW1ib2xpY190cmFjZSUwQSUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0cmFjZWQlMjAlM0QlMjBzeW1ib2xpY190cmFjZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGlucHV0X25hbWVzJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSklMEElMEF0cmFuc2Zvcm1hdGlvbiUyMCUzRCUyMENoYW5nZU11bFRvQWRkKCklMEF0cmFuc2Zvcm1lZF9tb2RlbCUyMCUzRCUyMHRyYW5zZm9ybWF0aW9uKHRyYWNlZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.utils.fx <span class="hljs-keyword">import</span> symbolic_trace

<span class="hljs-meta">&gt;&gt;&gt; </span>model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>traced = symbolic_trace(
<span class="hljs-meta">... </span>    model,
<span class="hljs-meta">... </span>    input_names=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transformation = ChangeMulToAdd()
<span class="hljs-meta">&gt;&gt;&gt; </span>transformed_model = transformation(traced)`,wrap:!1}}),I=new R({props:{title:"Write a reversible transformation",local:"write-a-reversible-transformation",headingTag:"h3"}}),k=new ns({props:{code:"aW1wb3J0JTIwb3BlcmF0b3IlMEFmcm9tJTIwb3B0aW11bS5meC5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBSZXZlcnNpYmxlVHJhbnNmb3JtYXRpb24lMEElMEFjbGFzcyUyME11bFRvTXVsVGltZXNUd28oUmV2ZXJzaWJsZVRyYW5zZm9ybWF0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRyYW5zZm9ybShzZWxmJTJDJTIwZ3JhcGhfbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMG5vZGUlMjBpbiUyMGdyYXBoX21vZHVsZS5ncmFwaC5ub2RlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm9kZS5vcCUyMCUzRCUzRCUyMCUyMmNhbGxfZnVuY3Rpb24lMjIlMjBhbmQlMjBub2RlLnRhcmdldCUyMCUzRCUzRCUyMG9wZXJhdG9yLm11bCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMkMlMjB5JTIwJTNEJTIwbm9kZS5hcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS5hcmdzJTIwJTNEJTIwKDIlMjAqJTIweCUyQyUyMHkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZ3JhcGhfbW9kdWxlJTBBJTIwJTIwJTIwJTIwZGVmJTIwcmV2ZXJzZShzZWxmJTJDJTIwZ3JhcGhfbW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMG5vZGUlMjBpbiUyMGdyYXBoX21vZHVsZS5ncmFwaC5ub2RlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbm9kZS5vcCUyMCUzRCUzRCUyMCUyMmNhbGxfZnVuY3Rpb24lMjIlMjBhbmQlMjBub2RlLnRhcmdldCUyMCUzRCUzRCUyMG9wZXJhdG9yLm11bCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMkMlMjB5JTIwJTNEJTIwbm9kZS5hcmdzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9kZS5hcmdzJTIwJTNEJTIwKHglMjAlMkYlMjAyJTJDJTIweSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBncmFwaF9tb2R1bGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> operator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> ReversibleTransformation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MulToMulTimesTwo</span>(<span class="hljs-title class_ inherited__">ReversibleTransformation</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                x, y = node.args
<span class="hljs-meta">... </span>                node.args = (<span class="hljs-number">2</span> * x, y)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse</span>(<span class="hljs-params">self, graph_module</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> node <span class="hljs-keyword">in</span> graph_module.graph.nodes:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> node.op == <span class="hljs-string">&quot;call_function&quot;</span> <span class="hljs-keyword">and</span> node.target == operator.mul:
<span class="hljs-meta">... </span>                x, y = node.args
<span class="hljs-meta">... </span>                node.args = (x / <span class="hljs-number">2</span>, y)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> graph_module`,wrap:!1}}),Z=new R({props:{title:"Composing transformations together",local:"composing-transformations-together",headingTag:"h3"}}),B=new ns({props:{code:"ZnJvbSUyMG9wdGltdW0uZngub3B0aW1pemF0aW9uJTIwaW1wb3J0JTIwY29tcG9zZSUwQWNvbXBvc2l0aW9uJTIwJTNEJTIwY29tcG9zZShNdWxUb011bFRpbWVzVHdvKCklMkMlMjBDaGFuZ2VNdWxUb0FkZCgpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.fx.optimization <span class="hljs-keyword">import</span> compose
<span class="hljs-meta">&gt;&gt;&gt; </span>composition = compose(MulToMulTimesTwo(), ChangeMulToAdd())`,wrap:!1}}),z=new gs({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/torch_fx/usage_guides/optimization.mdx"}}),{c(){y=o("meta"),G=n(),W=o("p"),S=n(),m(f.$$.fragment),F=n(),T=o("p"),T.innerHTML=os,Q=n(),m(J.$$.fragment),X=n(),d=o("p"),d.textContent=ps,E=n(),m(U.$$.fragment),N=n(),u=o("p"),u.innerHTML=ms,A=n(),j=o("p"),j.textContent=rs,H=n(),m(g.$$.fragment),V=n(),b=o("p"),b.textContent=is,Y=n(),m(C.$$.fragment),q=n(),m(I.$$.fragment),L=n(),$=o("p"),$.innerHTML=cs,P=n(),v=o("p"),v.textContent=ws,K=n(),m(k.$$.fragment),D=n(),m(Z.$$.fragment),O=n(),_=o("p"),_.innerHTML=hs,ss=n(),m(B.$$.fragment),ts=n(),m(z.$$.fragment),as=n(),x=o("p"),this.h()},l(s){const t=us("svelte-u9bgzb",document.head);y=p(t,"META",{name:!0,content:!0}),t.forEach(a),G=l(s),W=p(s,"P",{}),ys(W).forEach(a),S=l(s),r(f.$$.fragment,s),F=l(s),T=p(s,"P",{"data-svelte-h":!0}),M(T)!=="svelte-pyegu9"&&(T.innerHTML=os),Q=l(s),r(J.$$.fragment,s),X=l(s),d=p(s,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1u0ybww"&&(d.textContent=ps),E=l(s),r(U.$$.fragment,s),N=l(s),u=p(s,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1w51tdt"&&(u.innerHTML=ms),A=l(s),j=p(s,"P",{"data-svelte-h":!0}),M(j)!=="svelte-16d1zd5"&&(j.textContent=rs),H=l(s),r(g.$$.fragment,s),V=l(s),b=p(s,"P",{"data-svelte-h":!0}),M(b)!=="svelte-4h2eh7"&&(b.textContent=is),Y=l(s),r(C.$$.fragment,s),q=l(s),r(I.$$.fragment,s),L=l(s),$=p(s,"P",{"data-svelte-h":!0}),M($)!=="svelte-dofhup"&&($.innerHTML=cs),P=l(s),v=p(s,"P",{"data-svelte-h":!0}),M(v)!=="svelte-84g68q"&&(v.textContent=ws),K=l(s),r(k.$$.fragment,s),D=l(s),r(Z.$$.fragment,s),O=l(s),_=p(s,"P",{"data-svelte-h":!0}),M(_)!=="svelte-9q1yf7"&&(_.innerHTML=hs),ss=l(s),r(B.$$.fragment,s),ts=l(s),r(z.$$.fragment,s),as=l(s),x=p(s,"P",{}),ys(x).forEach(a),this.h()},h(){Ms(y,"name","hf:doc:metadata"),Ms(y,"content",Cs)},m(s,t){js(document.head,y),e(s,G,t),e(s,W,t),e(s,S,t),i(f,s,t),e(s,F,t),e(s,T,t),e(s,Q,t),i(J,s,t),e(s,X,t),e(s,d,t),e(s,E,t),i(U,s,t),e(s,N,t),e(s,u,t),e(s,A,t),e(s,j,t),e(s,H,t),i(g,s,t),e(s,V,t),e(s,b,t),e(s,Y,t),i(C,s,t),e(s,q,t),i(I,s,t),e(s,L,t),e(s,$,t),e(s,P,t),e(s,v,t),e(s,K,t),i(k,s,t),e(s,D,t),i(Z,s,t),e(s,O,t),e(s,_,t),e(s,ss,t),i(B,s,t),e(s,ts,t),i(z,s,t),e(s,as,t),e(s,x,t),es=!0},p:Ts,i(s){es||(c(f.$$.fragment,s),c(J.$$.fragment,s),c(U.$$.fragment,s),c(g.$$.fragment,s),c(C.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(Z.$$.fragment,s),c(B.$$.fragment,s),c(z.$$.fragment,s),es=!0)},o(s){w(f.$$.fragment,s),w(J.$$.fragment,s),w(U.$$.fragment,s),w(g.$$.fragment,s),w(C.$$.fragment,s),w(I.$$.fragment,s),w(k.$$.fragment,s),w(Z.$$.fragment,s),w(B.$$.fragment,s),w(z.$$.fragment,s),es=!1},d(s){s&&(a(G),a(W),a(S),a(F),a(T),a(Q),a(X),a(d),a(E),a(N),a(u),a(A),a(j),a(H),a(V),a(b),a(Y),a(q),a(L),a($),a(P),a(v),a(K),a(D),a(O),a(_),a(ss),a(ts),a(as),a(x)),a(y),h(f,s),h(J,s),h(U,s),h(g,s),h(C,s),h(I,s),h(k,s),h(Z,s),h(B,s),h(z,s)}}}const Cs='{"title":"Optimization","local":"optimization","sections":[{"title":"The transformation guide","local":"the-transformation-guide","sections":[{"title":"Write a non-reversible transformation","local":"write-a-non-reversible-transformation","sections":[],"depth":3},{"title":"Write a reversible transformation","local":"write-a-reversible-transformation","sections":[],"depth":3},{"title":"Composing transformations together","local":"composing-transformations-together","sections":[],"depth":3}],"depth":2}],"depth":1}';function Is(ls){return Js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends ds{constructor(y){super(),Us(this,y,Is,bs,fs,{})}}export{_s as component};
