import{s as Ya,o as Va,n as R}from"../chunks/scheduler.37c15a92.js";import{S as Ha,i as Na,g as h,s,r,A as Fa,h as f,f as l,c as n,j as za,u as o,x as y,k as Ra,y as Ea,a,v as p,d as c,t as m,w as d,m as Qa,n as Sa}from"../chunks/index.7cb9c9b8.js";import{T as C}from"../chunks/Tip.d10b3fc9.js";import{Y as Aa}from"../chunks/Youtube.8666c400.js";import{C as T}from"../chunks/CodeBlock.abae2786.js";import{C as La}from"../chunks/CourseFloatingBanner.df82c153.js";import{Q as ct}from"../chunks/Question.7e41e492.js";import{H as v,E as qa}from"../chunks/getInferenceSnippets.c47ae3ea.js";function Pa(j){let i,b='🏗️ <strong>Training from Scratch</strong>: This section builds on the previous content. For comprehensive guidance on PyTorch training loops and best practices, check out the <a href="https://huggingface.co/docs/transformers/main/en/training#train-in-native-pytorch" rel="nofollow">🤗 Transformers training documentation</a> and the <a href="https://huggingface.co/learn/cookbook/en/fine_tuning_code_llm_on_single_gpu#model" rel="nofollow">custom training cookbook</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-11sv2tl"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function Ka(j){let i,b="💡 <strong>Modern Optimization Tips</strong>: For even better performance, you can try:",u,M,J="<li><strong>AdamW with weight decay</strong>: <code>AdamW(model.parameters(), lr=5e-5, weight_decay=0.01)</code></li> <li><strong>8-bit Adam</strong>: Use <code>bitsandbytes</code> for memory-efficient optimization</li> <li><strong>Different learning rates</strong>: Lower learning rates (1e-5 to 3e-5) often work better for large models</li>",$,g,k='🚀 <strong>Optimization Resources</strong>: Learn more about optimizers and training strategies in the <a href="https://huggingface.co/docs/transformers/main/en/performance#optimizer" rel="nofollow">🤗 Transformers optimization guide</a>.';return{c(){i=h("p"),i.innerHTML=b,u=s(),M=h("ul"),M.innerHTML=J,$=s(),g=h("p"),g.innerHTML=k},l(w){i=f(w,"P",{"data-svelte-h":!0}),y(i)!=="svelte-o5kaes"&&(i.innerHTML=b),u=n(w),M=f(w,"UL",{"data-svelte-h":!0}),y(M)!=="svelte-1qym9yd"&&(M.innerHTML=J),$=n(w),g=f(w,"P",{"data-svelte-h":!0}),y(g)!=="svelte-x7tnyo"&&(g.innerHTML=k)},m(w,U){a(w,i,U),a(w,u,U),a(w,M,U),a(w,$,U),a(w,g,U)},p:R,d(w){w&&(l(i),l(u),l(M),l($),l(g))}}}function Da(j){let i,b="💡 <strong>Modern Training Optimizations</strong>: To make your training loop even more efficient, consider:",u,M,J="<li><strong>Gradient Clipping</strong>: Add <code>torch.nn.utils.clip_grad_norm_(model.parameters(), max_norm=1.0)</code> before <code>optimizer.step()</code></li> <li><strong>Mixed Precision</strong>: Use <code>torch.cuda.amp.autocast()</code> and <code>GradScaler</code> for faster training</li> <li><strong>Gradient Accumulation</strong>: Accumulate gradients over multiple batches to simulate larger batch sizes</li> <li><strong>Checkpointing</strong>: Save model checkpoints periodically to resume training if interrupted</li>",$,g,k='🔧 <strong>Implementation Guide</strong>: For detailed examples of these optimizations, see the <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_one" rel="nofollow">🤗 Transformers efficient training guide</a> and the <a href="https://huggingface.co/docs/transformers/main/en/optimizers" rel="nofollow">range of optimizers</a>.';return{c(){i=h("p"),i.innerHTML=b,u=s(),M=h("ul"),M.innerHTML=J,$=s(),g=h("p"),g.innerHTML=k},l(w){i=f(w,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1dozp7f"&&(i.innerHTML=b),u=n(w),M=f(w,"UL",{"data-svelte-h":!0}),y(M)!=="svelte-ujbxeo"&&(M.innerHTML=J),$=n(w),g=f(w,"P",{"data-svelte-h":!0}),y(g)!=="svelte-elu395"&&(g.innerHTML=k)},m(w,U){a(w,i,U),a(w,u,U),a(w,M,U),a(w,$,U),a(w,g,U)},p:R,d(w){w&&(l(i),l(u),l(M),l($),l(g))}}}function Oa(j){let i,b='📊 <strong>Evaluation Best Practices</strong>: For more sophisticated evaluation strategies and metrics, explore the <a href="https://huggingface.co/docs/evaluate/" rel="nofollow">🤗 Evaluate documentation</a> and the <a href="https://github.com/huggingface/evaluation-guidebook" rel="nofollow">comprehensive evaluation cookbook</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-n1do1t"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function es(j){let i,b="✏️ <strong>Try it out!</strong> Modify the previous training loop to fine-tune your model on the SST-2 dataset.";return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-14jbd71"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function ts(j){let i,b='⚡ <strong>Accelerate Deep Dive</strong>: Learn everything about distributed training, mixed precision, and hardware optimization in the <a href="https://huggingface.co/docs/accelerate/" rel="nofollow">🤗 Accelerate documentation</a> and explore practical examples in the <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">transformers documentation</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-mw1zvv"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function ls(j){let i;return{c(){i=Qa('⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},l(b){i=Sa(b,'⚠️ In order to benefit from the speed-up offered by Cloud TPUs, we recommend padding your samples to a fixed length with the `padding="max_length"` and `max_length` arguments of the tokenizer.')},m(b,u){a(b,i,u)},d(b){b&&l(i)}}}function as(j){let i,b='🌐 <strong>Distributed Training</strong>: For comprehensive coverage of multi-GPU and multi-node training, check out the <a href="https://huggingface.co/docs/transformers/main/en/perf_train_gpu_many" rel="nofollow">🤗 Transformers distributed training guide</a> and the <a href="https://huggingface.co/docs/transformers/main/en/accelerate" rel="nofollow">scaling training cookbook</a>.';return{c(){i=h("p"),i.innerHTML=b},l(u){i=f(u,"P",{"data-svelte-h":!0}),y(i)!=="svelte-lrep30"&&(i.innerHTML=b)},m(u,M){a(u,i,M)},p:R,d(u){u&&l(i)}}}function ss(j){let i,b="💡 <strong>Key Takeaways:</strong>",u,M,J="<li>Manual training loops give you complete control but require understanding of the proper sequence: forward → backward → optimizer step → scheduler step → zero gradients</li> <li>AdamW with weight decay is the recommended optimizer for transformer models</li> <li>Always use <code>model.eval()</code> and <code>torch.no_grad()</code> during evaluation for correct behavior and efficiency</li> <li>🤗 Accelerate makes distributed training accessible with minimal code changes</li> <li>Device management (moving tensors to GPU/CPU) is crucial for PyTorch operations</li> <li>Modern techniques like mixed precision, gradient accumulation, and gradient clipping can significantly improve training efficiency</li>";return{c(){i=h("p"),i.innerHTML=b,u=s(),M=h("ul"),M.innerHTML=J},l($){i=f($,"P",{"data-svelte-h":!0}),y(i)!=="svelte-l314m0"&&(i.innerHTML=b),u=n($),M=f($,"UL",{"data-svelte-h":!0}),y(M)!=="svelte-w3ba9j"&&(M.innerHTML=J)},m($,g){a($,i,g),a($,u,g),a($,M,g)},p:R,d($){$&&(l(i),l(u),l(M))}}}function ns(j){let i,b,u,M,J,$,g,k,w,U,A,Sl="Now we’ll see how to achieve the same results as we did in the last section without using the <code>Trainer</code> class, implementing a training loop from scratch with modern PyTorch best practices. Again, we assume you have done the data processing in section 2. Here is a short summary covering everything you will need:",dt,_,ut,Y,ht,V,ft,H,Ll="Before actually writing our training loop, we will need to define a few objects. The first ones are the dataloaders we will use to iterate over batches. But before we can define those dataloaders, we need to apply a bit of postprocessing to our <code>tokenized_datasets</code>, to take care of some things that the <code>Trainer</code> did for us automatically. Specifically, we need to:",yt,N,ql="<li>Remove the columns corresponding to values the model does not expect (like the <code>sentence1</code> and <code>sentence2</code> columns).</li> <li>Rename the column <code>label</code> to <code>labels</code> (because the model expects the argument to be named <code>labels</code>).</li> <li>Set the format of the datasets so they return PyTorch tensors instead of lists.</li>",Mt,F,Pl="Our <code>tokenized_datasets</code> has one method for each of those steps:",wt,E,bt,Q,Kl="We can then check that the result only has columns that our model will accept:",gt,S,$t,L,Dl="Now that this is done, we can easily define our dataloaders:",Tt,q,jt,P,Ol="To quickly check there is no mistake in the data processing, we can inspect a batch like this:",Jt,K,Ut,D,vt,O,ea="Note that the actual shapes will probably be slightly different for you since we set <code>shuffle=True</code> for the training dataloader and we are padding to the maximum length inside the batch.",kt,ee,ta="Now that we’re completely finished with data preprocessing (a satisfying yet elusive goal for any ML practitioner), let’s turn to the model. We instantiate it exactly as we did in the previous section:",Ct,te,_t,le,la="To make sure that everything will go smoothly during training, we pass our batch to this model:",Zt,ae,Bt,se,Wt,ne,aa="All 🤗 Transformers models will return the loss when <code>labels</code> are provided, and we also get the logits (two for each input in our batch, so a tensor of size 8 x 2).",Gt,ie,sa='We’re almost ready to write our training loop! We’re just missing two things: an optimizer and a learning rate scheduler. Since we are trying to replicate what the <code>Trainer</code> was doing by hand, we will use the same defaults. The optimizer used by the <code>Trainer</code> is <code>AdamW</code>, which is the same as Adam, but with a twist for weight decay regularization (see <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> by Ilya Loshchilov and Frank Hutter):',xt,re,It,Z,Xt,oe,na="Finally, the learning rate scheduler used by default is just a linear decay from the maximum value (5e-5) to 0. To properly define it, we need to know the number of training steps we will take, which is the number of epochs we want to run multiplied by the number of training batches (which is the length of our training dataloader). The <code>Trainer</code> uses three epochs by default, so we will follow that:",zt,pe,Rt,ce,At,me,Yt,de,ia="One last thing: we will want to use the GPU if we have access to one (on a CPU, training might take several hours instead of a couple of minutes). To do this, we define a <code>device</code> we will put our model and our batches on:",Vt,ue,Ht,he,Nt,fe,ra="We are now ready to train! To get some sense of when training will be finished, we add a progress bar over our number of training steps, using the <code>tqdm</code> library:",Ft,ye,Et,B,Qt,Me,oa="You can see that the core of the training loop looks a lot like the one in the introduction. We didn’t ask for any reporting, so this training loop will not tell us anything about how the model fares. We need to add an evaluation loop for that.",St,we,Lt,be,pa="As we did earlier, we will use a metric provided by the 🤗 Evaluate library. We’ve already seen the <code>metric.compute()</code> method, but metrics can actually accumulate batches for us as we go over the prediction loop with the method <code>add_batch()</code>. Once we have accumulated all the batches, we can get the final result with <code>metric.compute()</code>. Here’s how to implement all of this in an evaluation loop:",qt,W,Pt,ge,Kt,$e,Dt,Te,ca="Again, your results will be slightly different because of the randomness in the model head initialization and the data shuffling, but they should be in the same ballpark.",Ot,G,el,je,tl,Je,ll,Ue,ma='The training loop we defined earlier works fine on a single CPU or GPU. But using the <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> library, with just a few adjustments we can enable distributed training on multiple GPUs or TPUs. 🤗 Accelerate handles the complexity of distributed training, mixed precision, and device placement automatically. Starting from the creation of the training and validation dataloaders, here is what our manual training loop looks like:',al,x,sl,ve,nl,ke,da="The first line to add is the import line. The second line instantiates an <code>Accelerator</code> object that will look at the environment and initialize the proper distributed setup. 🤗 Accelerate handles the device placement for you, so you can remove the lines that put the model on the device (or, if you prefer, change them to use <code>accelerator.device</code> instead of <code>device</code>).",il,Ce,ua="Then the main bulk of the work is done in the line that sends the dataloaders, the model, and the optimizer to <code>accelerator.prepare()</code>. This will wrap those objects in the proper container to make sure your distributed training works as intended. The remaining changes to make are removing the line that puts the batch on the <code>device</code> (again, if you want to keep this you can just change it to use <code>accelerator.device</code>) and replacing <code>loss.backward()</code> with <code>accelerator.backward(loss)</code>.",rl,I,ol,_e,ha="If you’d like to copy and paste it to play around, here’s what the complete training loop looks like with 🤗 Accelerate:",pl,Ze,cl,Be,fa="Putting this in a <code>train.py</code> script will make that script runnable on any kind of distributed setup. To try it out in your distributed setup, run the command:",ml,We,dl,Ge,ya="which will prompt you to answer a few questions and dump your answers in a configuration file used by this command:",ul,xe,hl,Ie,Ma="which will launch the distributed training.",fl,Xe,wa="If you want to try this in a Notebook (for instance, to test it with TPUs on Colab), just paste the code in a <code>training_function()</code> and run a last cell with:",yl,ze,Ml,Re,ba='You can find more examples in the <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a>.',wl,X,bl,Ae,gl,Ye,ga="Now that you’ve learned how to implement training from scratch, here are some additional considerations for production use:",$l,Ve,$a="<strong>Model Evaluation</strong>: Always evaluate your model on multiple metrics, not just accuracy. Use the 🤗 Evaluate library for comprehensive evaluation. And, you can use accelerator also with evaluation loop.",Tl,He,Ta="<strong>Hyperparameter Tuning</strong>: Consider using libraries like Optuna or Ray Tune for systematic hyperparameter optimization.",jl,Ne,ja="<strong>Model Monitoring</strong>: Track training metrics, learning curves, and validation performance throughout training.",Jl,Fe,Ja="<strong>Model Sharing</strong>: Once trained, share your model on the Hugging Face Hub to make it available to the community.",Ul,Ee,Ua="<strong>Efficiency</strong>: For large models, consider techniques like gradient checkpointing, parameter-efficient fine-tuning (LoRA, AdaLoRA), or quantization methods.",vl,Qe,va="This concludes our deep dive into fine-tuning with custom training loops. The skills you’ve learned here will serve you well when you need full control over the training process or want to implement custom training logic that goes beyond what the <code>Trainer</code> API offers.",kl,Se,Cl,Le,ka="Test your understanding of custom training loops and advanced training techniques:",_l,qe,Zl,Pe,Bl,Ke,Wl,De,Gl,Oe,xl,et,Il,tt,Xl,lt,zl,at,Rl,st,Al,nt,Yl,it,Vl,rt,Hl,ot,Nl,z,Fl,pt,El,mt,Ql;return J=new v({props:{title:"A full training loop",local:"a-full-training",headingTag:"h1"}}),g=new La({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"}]}}),w=new Aa({props:{id:"Dh9CL8fyG80"}}),_=new C({props:{$$slots:{default:[Pa]},$$scope:{ctx:j}}}),Y=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),V=new v({props:{title:"Prepare for training",local:"prepare-for-training",headingTag:"h3"}}),E=new T({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),S=new T({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),q=new T({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),K=new T({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),D=new T({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),te=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),ae=new T({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),se=new T({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),re=new T({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),Z=new C({props:{$$slots:{default:[Ka]},$$scope:{ctx:j}}}),pe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),ce=new T({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),me=new v({props:{title:"The training loop",local:"the-training-loop",headingTag:"h3"}}),ue=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),he=new T({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),ye=new T({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),B=new C({props:{$$slots:{default:[Da]},$$scope:{ctx:j}}}),we=new v({props:{title:"The evaluation loop",local:"the-evaluation-loop",headingTag:"h3"}}),W=new C({props:{$$slots:{default:[Oa]},$$scope:{ctx:j}}}),ge=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobGVuKGV2YWxfZGF0YWxvYWRlcikpKSUwQSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEpJTBBJTBBbWV0cmljLmNvbXB1dGUoKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(eval_dataloader)))

model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])
    progress_bar.update(<span class="hljs-number">1</span>)

metric.compute()`,wrap:!1}}),$e=new T({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),G=new C({props:{$$slots:{default:[es]},$$scope:{ctx:j}}}),je=new v({props:{title:"Supercharge your training loop with 🤗 Accelerate",local:"supercharge-your-training-loop-with-accelerate",headingTag:"h3"}}),Je=new Aa({props:{id:"s7dy8QRgjJ0"}}),x=new C({props:{$$slots:{default:[ts]},$$scope:{ctx:j}}}),ve=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),I=new C({props:{$$slots:{default:[ls]},$$scope:{ctx:j}}}),Ze=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),We=new T({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),xe=new T({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),ze=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),X=new C({props:{$$slots:{default:[as]},$$scope:{ctx:j}}}),Ae=new v({props:{title:"Next Steps and Best Practices",local:"next-steps-and-best-practices",headingTag:"h3"}}),Se=new v({props:{title:"Section Quiz",local:"section-quiz",headingTag:"h2"}}),qe=new v({props:{title:"1. What is the main difference between Adam and AdamW optimizers?",local:"1-what-is-the-main-difference-between-adam-and-adamw-optimizers",headingTag:"h3"}}),Pe=new ct({props:{choices:[{text:"AdamW uses a different learning rate schedule.",explain:"Learning rate scheduling is separate from the optimizer choice."},{text:"AdamW includes decoupled weight decay regularization.",explain:"Correct! AdamW separates weight decay from the gradient-based parameter updates, leading to better regularization.",correct:!0},{text:"AdamW only works with transformer models.",explain:"AdamW can be used with any model architecture, not just transformers."},{text:"AdamW requires less memory than Adam.",explain:"Both optimizers have similar memory requirements."}]}}),Ke=new v({props:{title:"2. In a training loop, what is the correct order of operations?",local:"2-in-a-training-loop-what-is-the-correct-order-of-operations",headingTag:"h3"}}),De=new ct({props:{choices:[{text:"Forward pass → Backward pass → Optimizer step → Zero gradients",explain:"Close, but you should zero gradients before the next forward pass to avoid accumulating old gradients."},{text:"Forward pass → Backward pass → Optimizer step → Scheduler step → Zero gradients",explain:"Correct! This is the proper order: compute loss, compute gradients, update parameters, update learning rate, then clear gradients.",correct:!0},{text:"Zero gradients → Forward pass → Optimizer step → Backward pass",explain:"The backward pass must come after the forward pass to compute gradients from the loss."},{text:"Forward pass → Zero gradients → Backward pass → Optimizer step",explain:"Zeroing gradients before backward pass would eliminate the gradients you just computed."}]}}),Oe=new v({props:{title:"3. What does the 🤗 Accelerate library primarily help with?",local:"3-what-does-the--accelerate-library-primarily-help-with",headingTag:"h3"}}),et=new ct({props:{choices:[{text:"Making your models train faster by optimizing the forward pass.",explain:"Accelerate doesn't optimize the model architecture itself."},{text:"Automatically selecting the best hyperparameters.",explain:"Accelerate doesn't do hyperparameter optimization."},{text:"Enabling distributed training across multiple GPUs/TPUs with minimal code changes.",explain:"Correct! Accelerate handles distributed training complexity, allowing your code to run on single or multiple devices seamlessly.",correct:!0},{text:"Converting models to different frameworks like TensorFlow.",explain:"Accelerate works within PyTorch and doesn't convert between frameworks."}]}}),tt=new v({props:{title:"4. Why do we move batches to the device in a training loop?",local:"4-why-do-we-move-batches-to-the-device-in-a-training-loop",headingTag:"h3"}}),lt=new ct({props:{choices:[{text:"To make the training faster.",explain:"While it can affect speed, the main reason is compatibility."},{text:"Because the model and data must be on the same device (CPU/GPU) for computation.",explain:"Correct! PyTorch requires tensors to be on the same device for operations to work.",correct:!0},{text:"To save memory.",explain:"Moving to device doesn't inherently save memory."},{text:"It's required by the DataLoader.",explain:"DataLoader doesn't require specific device placement."}]}}),at=new v({props:{title:"5. What does model.eval() do before evaluation?",local:"5-what-does-modeleval-do-before-evaluation",headingTag:"h3"}}),st=new ct({props:{choices:[{text:"It freezes the model parameters so they can't be updated.",explain:"model.eval() doesn't freeze parameters - that would be done by setting requires_grad=False."},{text:"It changes the behavior of layers like dropout and batch normalization for inference.",explain:"Correct! eval() mode disables dropout and uses running statistics for batch norm instead of computing them from the current batch.",correct:!0},{text:"It enables gradient computation for evaluation metrics.",explain:"Actually, we typically use torch.no_grad() during evaluation to disable gradient computation."},{text:"It automatically calculates evaluation metrics.",explain:"model.eval() only changes layer behavior - you still need to implement metric calculation separately."}]}}),nt=new v({props:{title:"6. What is the purpose of torch.no_grad() during evaluation?",local:"6-what-is-the-purpose-of-torchnograd-during-evaluation",headingTag:"h3"}}),it=new ct({props:{choices:[{text:"To prevent the model from making predictions.",explain:"torch.no_grad() doesn't prevent predictions, just gradient computation."},{text:"To save memory and speed up computation by disabling gradient tracking.",explain:"Correct! Since we don't need gradients for evaluation, disabling them saves memory and computation.",correct:!0},{text:"To enable evaluation mode for the model.",explain:"Evaluation mode is enabled with model.eval(), not torch.no_grad()."},{text:"To ensure consistent results across runs.",explain:"Reproducibility is handled by setting random seeds, not torch.no_grad()."}]}}),rt=new v({props:{title:"7. What changes when you use 🤗 Accelerate in your training loop?",local:"7-what-changes-when-you-use--accelerate-in-your-training-loop",headingTag:"h3"}}),ot=new ct({props:{choices:[{text:"You must rewrite your entire training loop from scratch.",explain:"Accelerate requires minimal changes to existing PyTorch code."},{text:"You wrap key objects with accelerator.prepare() and use accelerator.backward() instead of loss.backward().",explain:"Correct! These are the main changes - prepare your objects and use accelerator.backward() for proper distributed training.",correct:!0},{text:"You need to specify the number of GPUs in your code.",explain:"Accelerate automatically detects available hardware."},{text:"You must use a different optimizer and scheduler.",explain:"You can use the same optimizers and schedulers with Accelerate."}]}}),z=new C({props:{$$slots:{default:[ss]},$$scope:{ctx:j}}}),pt=new qa({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter3/4.mdx"}}),{c(){i=h("meta"),b=s(),u=h("p"),M=s(),r(J.$$.fragment),$=s(),r(g.$$.fragment),k=s(),r(w.$$.fragment),U=s(),A=h("p"),A.innerHTML=Sl,dt=s(),r(_.$$.fragment),ut=s(),r(Y.$$.fragment),ht=s(),r(V.$$.fragment),ft=s(),H=h("p"),H.innerHTML=Ll,yt=s(),N=h("ul"),N.innerHTML=ql,Mt=s(),F=h("p"),F.innerHTML=Pl,wt=s(),r(E.$$.fragment),bt=s(),Q=h("p"),Q.textContent=Kl,gt=s(),r(S.$$.fragment),$t=s(),L=h("p"),L.textContent=Dl,Tt=s(),r(q.$$.fragment),jt=s(),P=h("p"),P.textContent=Ol,Jt=s(),r(K.$$.fragment),Ut=s(),r(D.$$.fragment),vt=s(),O=h("p"),O.innerHTML=ea,kt=s(),ee=h("p"),ee.textContent=ta,Ct=s(),r(te.$$.fragment),_t=s(),le=h("p"),le.textContent=la,Zt=s(),r(ae.$$.fragment),Bt=s(),r(se.$$.fragment),Wt=s(),ne=h("p"),ne.innerHTML=aa,Gt=s(),ie=h("p"),ie.innerHTML=sa,xt=s(),r(re.$$.fragment),It=s(),r(Z.$$.fragment),Xt=s(),oe=h("p"),oe.innerHTML=na,zt=s(),r(pe.$$.fragment),Rt=s(),r(ce.$$.fragment),At=s(),r(me.$$.fragment),Yt=s(),de=h("p"),de.innerHTML=ia,Vt=s(),r(ue.$$.fragment),Ht=s(),r(he.$$.fragment),Nt=s(),fe=h("p"),fe.innerHTML=ra,Ft=s(),r(ye.$$.fragment),Et=s(),r(B.$$.fragment),Qt=s(),Me=h("p"),Me.textContent=oa,St=s(),r(we.$$.fragment),Lt=s(),be=h("p"),be.innerHTML=pa,qt=s(),r(W.$$.fragment),Pt=s(),r(ge.$$.fragment),Kt=s(),r($e.$$.fragment),Dt=s(),Te=h("p"),Te.textContent=ca,Ot=s(),r(G.$$.fragment),el=s(),r(je.$$.fragment),tl=s(),r(Je.$$.fragment),ll=s(),Ue=h("p"),Ue.innerHTML=ma,al=s(),r(x.$$.fragment),sl=s(),r(ve.$$.fragment),nl=s(),ke=h("p"),ke.innerHTML=da,il=s(),Ce=h("p"),Ce.innerHTML=ua,rl=s(),r(I.$$.fragment),ol=s(),_e=h("p"),_e.textContent=ha,pl=s(),r(Ze.$$.fragment),cl=s(),Be=h("p"),Be.innerHTML=fa,ml=s(),r(We.$$.fragment),dl=s(),Ge=h("p"),Ge.textContent=ya,ul=s(),r(xe.$$.fragment),hl=s(),Ie=h("p"),Ie.textContent=Ma,fl=s(),Xe=h("p"),Xe.innerHTML=wa,yl=s(),r(ze.$$.fragment),Ml=s(),Re=h("p"),Re.innerHTML=ba,wl=s(),r(X.$$.fragment),bl=s(),r(Ae.$$.fragment),gl=s(),Ye=h("p"),Ye.textContent=ga,$l=s(),Ve=h("p"),Ve.innerHTML=$a,Tl=s(),He=h("p"),He.innerHTML=Ta,jl=s(),Ne=h("p"),Ne.innerHTML=ja,Jl=s(),Fe=h("p"),Fe.innerHTML=Ja,Ul=s(),Ee=h("p"),Ee.innerHTML=Ua,vl=s(),Qe=h("p"),Qe.innerHTML=va,kl=s(),r(Se.$$.fragment),Cl=s(),Le=h("p"),Le.textContent=ka,_l=s(),r(qe.$$.fragment),Zl=s(),r(Pe.$$.fragment),Bl=s(),r(Ke.$$.fragment),Wl=s(),r(De.$$.fragment),Gl=s(),r(Oe.$$.fragment),xl=s(),r(et.$$.fragment),Il=s(),r(tt.$$.fragment),Xl=s(),r(lt.$$.fragment),zl=s(),r(at.$$.fragment),Rl=s(),r(st.$$.fragment),Al=s(),r(nt.$$.fragment),Yl=s(),r(it.$$.fragment),Vl=s(),r(rt.$$.fragment),Hl=s(),r(ot.$$.fragment),Nl=s(),r(z.$$.fragment),Fl=s(),r(pt.$$.fragment),El=s(),mt=h("p"),this.h()},l(e){const t=Fa("svelte-u9bgzb",document.head);i=f(t,"META",{name:!0,content:!0}),t.forEach(l),b=n(e),u=f(e,"P",{}),za(u).forEach(l),M=n(e),o(J.$$.fragment,e),$=n(e),o(g.$$.fragment,e),k=n(e),o(w.$$.fragment,e),U=n(e),A=f(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-57kt9p"&&(A.innerHTML=Sl),dt=n(e),o(_.$$.fragment,e),ut=n(e),o(Y.$$.fragment,e),ht=n(e),o(V.$$.fragment,e),ft=n(e),H=f(e,"P",{"data-svelte-h":!0}),y(H)!=="svelte-ci9pg7"&&(H.innerHTML=Ll),yt=n(e),N=f(e,"UL",{"data-svelte-h":!0}),y(N)!=="svelte-pk4vyx"&&(N.innerHTML=ql),Mt=n(e),F=f(e,"P",{"data-svelte-h":!0}),y(F)!=="svelte-ey27a0"&&(F.innerHTML=Pl),wt=n(e),o(E.$$.fragment,e),bt=n(e),Q=f(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-trxw7x"&&(Q.textContent=Kl),gt=n(e),o(S.$$.fragment,e),$t=n(e),L=f(e,"P",{"data-svelte-h":!0}),y(L)!=="svelte-11c0vnt"&&(L.textContent=Dl),Tt=n(e),o(q.$$.fragment,e),jt=n(e),P=f(e,"P",{"data-svelte-h":!0}),y(P)!=="svelte-11wtmu1"&&(P.textContent=Ol),Jt=n(e),o(K.$$.fragment,e),Ut=n(e),o(D.$$.fragment,e),vt=n(e),O=f(e,"P",{"data-svelte-h":!0}),y(O)!=="svelte-q4m5oq"&&(O.innerHTML=ea),kt=n(e),ee=f(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-xq9k1z"&&(ee.textContent=ta),Ct=n(e),o(te.$$.fragment,e),_t=n(e),le=f(e,"P",{"data-svelte-h":!0}),y(le)!=="svelte-1cfpt2v"&&(le.textContent=la),Zt=n(e),o(ae.$$.fragment,e),Bt=n(e),o(se.$$.fragment,e),Wt=n(e),ne=f(e,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-ynwaiq"&&(ne.innerHTML=aa),Gt=n(e),ie=f(e,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-1my9rg2"&&(ie.innerHTML=sa),xt=n(e),o(re.$$.fragment,e),It=n(e),o(Z.$$.fragment,e),Xt=n(e),oe=f(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-12ciodg"&&(oe.innerHTML=na),zt=n(e),o(pe.$$.fragment,e),Rt=n(e),o(ce.$$.fragment,e),At=n(e),o(me.$$.fragment,e),Yt=n(e),de=f(e,"P",{"data-svelte-h":!0}),y(de)!=="svelte-1331u4o"&&(de.innerHTML=ia),Vt=n(e),o(ue.$$.fragment,e),Ht=n(e),o(he.$$.fragment,e),Nt=n(e),fe=f(e,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-s26r6i"&&(fe.innerHTML=ra),Ft=n(e),o(ye.$$.fragment,e),Et=n(e),o(B.$$.fragment,e),Qt=n(e),Me=f(e,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-mcninq"&&(Me.textContent=oa),St=n(e),o(we.$$.fragment,e),Lt=n(e),be=f(e,"P",{"data-svelte-h":!0}),y(be)!=="svelte-1sbu2u1"&&(be.innerHTML=pa),qt=n(e),o(W.$$.fragment,e),Pt=n(e),o(ge.$$.fragment,e),Kt=n(e),o($e.$$.fragment,e),Dt=n(e),Te=f(e,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-14qz8qy"&&(Te.textContent=ca),Ot=n(e),o(G.$$.fragment,e),el=n(e),o(je.$$.fragment,e),tl=n(e),o(Je.$$.fragment,e),ll=n(e),Ue=f(e,"P",{"data-svelte-h":!0}),y(Ue)!=="svelte-lpq30y"&&(Ue.innerHTML=ma),al=n(e),o(x.$$.fragment,e),sl=n(e),o(ve.$$.fragment,e),nl=n(e),ke=f(e,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-1q9wsp0"&&(ke.innerHTML=da),il=n(e),Ce=f(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-15cl91a"&&(Ce.innerHTML=ua),rl=n(e),o(I.$$.fragment,e),ol=n(e),_e=f(e,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-1g09gg4"&&(_e.textContent=ha),pl=n(e),o(Ze.$$.fragment,e),cl=n(e),Be=f(e,"P",{"data-svelte-h":!0}),y(Be)!=="svelte-1476nx"&&(Be.innerHTML=fa),ml=n(e),o(We.$$.fragment,e),dl=n(e),Ge=f(e,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-qyc3dl"&&(Ge.textContent=ya),ul=n(e),o(xe.$$.fragment,e),hl=n(e),Ie=f(e,"P",{"data-svelte-h":!0}),y(Ie)!=="svelte-1dc7y78"&&(Ie.textContent=Ma),fl=n(e),Xe=f(e,"P",{"data-svelte-h":!0}),y(Xe)!=="svelte-529dmx"&&(Xe.innerHTML=wa),yl=n(e),o(ze.$$.fragment,e),Ml=n(e),Re=f(e,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-py198"&&(Re.innerHTML=ba),wl=n(e),o(X.$$.fragment,e),bl=n(e),o(Ae.$$.fragment,e),gl=n(e),Ye=f(e,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-ww0xia"&&(Ye.textContent=ga),$l=n(e),Ve=f(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-1c4qzut"&&(Ve.innerHTML=$a),Tl=n(e),He=f(e,"P",{"data-svelte-h":!0}),y(He)!=="svelte-ljahbj"&&(He.innerHTML=Ta),jl=n(e),Ne=f(e,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-j1czxl"&&(Ne.innerHTML=ja),Jl=n(e),Fe=f(e,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-1vozwss"&&(Fe.innerHTML=Ja),Ul=n(e),Ee=f(e,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-quu3pr"&&(Ee.innerHTML=Ua),vl=n(e),Qe=f(e,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-l3wmo4"&&(Qe.innerHTML=va),kl=n(e),o(Se.$$.fragment,e),Cl=n(e),Le=f(e,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-ehgujc"&&(Le.textContent=ka),_l=n(e),o(qe.$$.fragment,e),Zl=n(e),o(Pe.$$.fragment,e),Bl=n(e),o(Ke.$$.fragment,e),Wl=n(e),o(De.$$.fragment,e),Gl=n(e),o(Oe.$$.fragment,e),xl=n(e),o(et.$$.fragment,e),Il=n(e),o(tt.$$.fragment,e),Xl=n(e),o(lt.$$.fragment,e),zl=n(e),o(at.$$.fragment,e),Rl=n(e),o(st.$$.fragment,e),Al=n(e),o(nt.$$.fragment,e),Yl=n(e),o(it.$$.fragment,e),Vl=n(e),o(rt.$$.fragment,e),Hl=n(e),o(ot.$$.fragment,e),Nl=n(e),o(z.$$.fragment,e),Fl=n(e),o(pt.$$.fragment,e),El=n(e),mt=f(e,"P",{}),za(mt).forEach(l),this.h()},h(){Ra(i,"name","hf:doc:metadata"),Ra(i,"content",is)},m(e,t){Ea(document.head,i),a(e,b,t),a(e,u,t),a(e,M,t),p(J,e,t),a(e,$,t),p(g,e,t),a(e,k,t),p(w,e,t),a(e,U,t),a(e,A,t),a(e,dt,t),p(_,e,t),a(e,ut,t),p(Y,e,t),a(e,ht,t),p(V,e,t),a(e,ft,t),a(e,H,t),a(e,yt,t),a(e,N,t),a(e,Mt,t),a(e,F,t),a(e,wt,t),p(E,e,t),a(e,bt,t),a(e,Q,t),a(e,gt,t),p(S,e,t),a(e,$t,t),a(e,L,t),a(e,Tt,t),p(q,e,t),a(e,jt,t),a(e,P,t),a(e,Jt,t),p(K,e,t),a(e,Ut,t),p(D,e,t),a(e,vt,t),a(e,O,t),a(e,kt,t),a(e,ee,t),a(e,Ct,t),p(te,e,t),a(e,_t,t),a(e,le,t),a(e,Zt,t),p(ae,e,t),a(e,Bt,t),p(se,e,t),a(e,Wt,t),a(e,ne,t),a(e,Gt,t),a(e,ie,t),a(e,xt,t),p(re,e,t),a(e,It,t),p(Z,e,t),a(e,Xt,t),a(e,oe,t),a(e,zt,t),p(pe,e,t),a(e,Rt,t),p(ce,e,t),a(e,At,t),p(me,e,t),a(e,Yt,t),a(e,de,t),a(e,Vt,t),p(ue,e,t),a(e,Ht,t),p(he,e,t),a(e,Nt,t),a(e,fe,t),a(e,Ft,t),p(ye,e,t),a(e,Et,t),p(B,e,t),a(e,Qt,t),a(e,Me,t),a(e,St,t),p(we,e,t),a(e,Lt,t),a(e,be,t),a(e,qt,t),p(W,e,t),a(e,Pt,t),p(ge,e,t),a(e,Kt,t),p($e,e,t),a(e,Dt,t),a(e,Te,t),a(e,Ot,t),p(G,e,t),a(e,el,t),p(je,e,t),a(e,tl,t),p(Je,e,t),a(e,ll,t),a(e,Ue,t),a(e,al,t),p(x,e,t),a(e,sl,t),p(ve,e,t),a(e,nl,t),a(e,ke,t),a(e,il,t),a(e,Ce,t),a(e,rl,t),p(I,e,t),a(e,ol,t),a(e,_e,t),a(e,pl,t),p(Ze,e,t),a(e,cl,t),a(e,Be,t),a(e,ml,t),p(We,e,t),a(e,dl,t),a(e,Ge,t),a(e,ul,t),p(xe,e,t),a(e,hl,t),a(e,Ie,t),a(e,fl,t),a(e,Xe,t),a(e,yl,t),p(ze,e,t),a(e,Ml,t),a(e,Re,t),a(e,wl,t),p(X,e,t),a(e,bl,t),p(Ae,e,t),a(e,gl,t),a(e,Ye,t),a(e,$l,t),a(e,Ve,t),a(e,Tl,t),a(e,He,t),a(e,jl,t),a(e,Ne,t),a(e,Jl,t),a(e,Fe,t),a(e,Ul,t),a(e,Ee,t),a(e,vl,t),a(e,Qe,t),a(e,kl,t),p(Se,e,t),a(e,Cl,t),a(e,Le,t),a(e,_l,t),p(qe,e,t),a(e,Zl,t),p(Pe,e,t),a(e,Bl,t),p(Ke,e,t),a(e,Wl,t),p(De,e,t),a(e,Gl,t),p(Oe,e,t),a(e,xl,t),p(et,e,t),a(e,Il,t),p(tt,e,t),a(e,Xl,t),p(lt,e,t),a(e,zl,t),p(at,e,t),a(e,Rl,t),p(st,e,t),a(e,Al,t),p(nt,e,t),a(e,Yl,t),p(it,e,t),a(e,Vl,t),p(rt,e,t),a(e,Hl,t),p(ot,e,t),a(e,Nl,t),p(z,e,t),a(e,Fl,t),p(pt,e,t),a(e,El,t),a(e,mt,t),Ql=!0},p(e,[t]){const Ca={};t&2&&(Ca.$$scope={dirty:t,ctx:e}),_.$set(Ca);const _a={};t&2&&(_a.$$scope={dirty:t,ctx:e}),Z.$set(_a);const Za={};t&2&&(Za.$$scope={dirty:t,ctx:e}),B.$set(Za);const Ba={};t&2&&(Ba.$$scope={dirty:t,ctx:e}),W.$set(Ba);const Wa={};t&2&&(Wa.$$scope={dirty:t,ctx:e}),G.$set(Wa);const Ga={};t&2&&(Ga.$$scope={dirty:t,ctx:e}),x.$set(Ga);const xa={};t&2&&(xa.$$scope={dirty:t,ctx:e}),I.$set(xa);const Ia={};t&2&&(Ia.$$scope={dirty:t,ctx:e}),X.$set(Ia);const Xa={};t&2&&(Xa.$$scope={dirty:t,ctx:e}),z.$set(Xa)},i(e){Ql||(c(J.$$.fragment,e),c(g.$$.fragment,e),c(w.$$.fragment,e),c(_.$$.fragment,e),c(Y.$$.fragment,e),c(V.$$.fragment,e),c(E.$$.fragment,e),c(S.$$.fragment,e),c(q.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(se.$$.fragment,e),c(re.$$.fragment,e),c(Z.$$.fragment,e),c(pe.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(B.$$.fragment,e),c(we.$$.fragment,e),c(W.$$.fragment,e),c(ge.$$.fragment,e),c($e.$$.fragment,e),c(G.$$.fragment,e),c(je.$$.fragment,e),c(Je.$$.fragment,e),c(x.$$.fragment,e),c(ve.$$.fragment,e),c(I.$$.fragment,e),c(Ze.$$.fragment,e),c(We.$$.fragment,e),c(xe.$$.fragment,e),c(ze.$$.fragment,e),c(X.$$.fragment,e),c(Ae.$$.fragment,e),c(Se.$$.fragment,e),c(qe.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(De.$$.fragment,e),c(Oe.$$.fragment,e),c(et.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(at.$$.fragment,e),c(st.$$.fragment,e),c(nt.$$.fragment,e),c(it.$$.fragment,e),c(rt.$$.fragment,e),c(ot.$$.fragment,e),c(z.$$.fragment,e),c(pt.$$.fragment,e),Ql=!0)},o(e){m(J.$$.fragment,e),m(g.$$.fragment,e),m(w.$$.fragment,e),m(_.$$.fragment,e),m(Y.$$.fragment,e),m(V.$$.fragment,e),m(E.$$.fragment,e),m(S.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(se.$$.fragment,e),m(re.$$.fragment,e),m(Z.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(ye.$$.fragment,e),m(B.$$.fragment,e),m(we.$$.fragment,e),m(W.$$.fragment,e),m(ge.$$.fragment,e),m($e.$$.fragment,e),m(G.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(x.$$.fragment,e),m(ve.$$.fragment,e),m(I.$$.fragment,e),m(Ze.$$.fragment,e),m(We.$$.fragment,e),m(xe.$$.fragment,e),m(ze.$$.fragment,e),m(X.$$.fragment,e),m(Ae.$$.fragment,e),m(Se.$$.fragment,e),m(qe.$$.fragment,e),m(Pe.$$.fragment,e),m(Ke.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(st.$$.fragment,e),m(nt.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(z.$$.fragment,e),m(pt.$$.fragment,e),Ql=!1},d(e){e&&(l(b),l(u),l(M),l($),l(k),l(U),l(A),l(dt),l(ut),l(ht),l(ft),l(H),l(yt),l(N),l(Mt),l(F),l(wt),l(bt),l(Q),l(gt),l($t),l(L),l(Tt),l(jt),l(P),l(Jt),l(Ut),l(vt),l(O),l(kt),l(ee),l(Ct),l(_t),l(le),l(Zt),l(Bt),l(Wt),l(ne),l(Gt),l(ie),l(xt),l(It),l(Xt),l(oe),l(zt),l(Rt),l(At),l(Yt),l(de),l(Vt),l(Ht),l(Nt),l(fe),l(Ft),l(Et),l(Qt),l(Me),l(St),l(Lt),l(be),l(qt),l(Pt),l(Kt),l(Dt),l(Te),l(Ot),l(el),l(tl),l(ll),l(Ue),l(al),l(sl),l(nl),l(ke),l(il),l(Ce),l(rl),l(ol),l(_e),l(pl),l(cl),l(Be),l(ml),l(dl),l(Ge),l(ul),l(hl),l(Ie),l(fl),l(Xe),l(yl),l(Ml),l(Re),l(wl),l(bl),l(gl),l(Ye),l($l),l(Ve),l(Tl),l(He),l(jl),l(Ne),l(Jl),l(Fe),l(Ul),l(Ee),l(vl),l(Qe),l(kl),l(Cl),l(Le),l(_l),l(Zl),l(Bl),l(Wl),l(Gl),l(xl),l(Il),l(Xl),l(zl),l(Rl),l(Al),l(Yl),l(Vl),l(Hl),l(Nl),l(Fl),l(El),l(mt)),l(i),d(J,e),d(g,e),d(w,e),d(_,e),d(Y,e),d(V,e),d(E,e),d(S,e),d(q,e),d(K,e),d(D,e),d(te,e),d(ae,e),d(se,e),d(re,e),d(Z,e),d(pe,e),d(ce,e),d(me,e),d(ue,e),d(he,e),d(ye,e),d(B,e),d(we,e),d(W,e),d(ge,e),d($e,e),d(G,e),d(je,e),d(Je,e),d(x,e),d(ve,e),d(I,e),d(Ze,e),d(We,e),d(xe,e),d(ze,e),d(X,e),d(Ae,e),d(Se,e),d(qe,e),d(Pe,e),d(Ke,e),d(De,e),d(Oe,e),d(et,e),d(tt,e),d(lt,e),d(at,e),d(st,e),d(nt,e),d(it,e),d(rt,e),d(ot,e),d(z,e),d(pt,e)}}}const is='{"title":"A full training loop","local":"a-full-training","sections":[{"title":"Prepare for training","local":"prepare-for-training","sections":[],"depth":3},{"title":"The training loop","local":"the-training-loop","sections":[],"depth":3},{"title":"The evaluation loop","local":"the-evaluation-loop","sections":[],"depth":3},{"title":"Supercharge your training loop with 🤗 Accelerate","local":"supercharge-your-training-loop-with-accelerate","sections":[],"depth":3},{"title":"Next Steps and Best Practices","local":"next-steps-and-best-practices","sections":[],"depth":3},{"title":"Section Quiz","local":"section-quiz","sections":[{"title":"1. What is the main difference between Adam and AdamW optimizers?","local":"1-what-is-the-main-difference-between-adam-and-adamw-optimizers","sections":[],"depth":3},{"title":"2. In a training loop, what is the correct order of operations?","local":"2-in-a-training-loop-what-is-the-correct-order-of-operations","sections":[],"depth":3},{"title":"3. What does the 🤗 Accelerate library primarily help with?","local":"3-what-does-the--accelerate-library-primarily-help-with","sections":[],"depth":3},{"title":"4. Why do we move batches to the device in a training loop?","local":"4-why-do-we-move-batches-to-the-device-in-a-training-loop","sections":[],"depth":3},{"title":"5. What does model.eval() do before evaluation?","local":"5-what-does-modeleval-do-before-evaluation","sections":[],"depth":3},{"title":"6. What is the purpose of torch.no_grad() during evaluation?","local":"6-what-is-the-purpose-of-torchnograd-during-evaluation","sections":[],"depth":3},{"title":"7. What changes when you use 🤗 Accelerate in your training loop?","local":"7-what-changes-when-you-use--accelerate-in-your-training-loop","sections":[],"depth":3}],"depth":2}],"depth":1}';function rs(j){return Va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends Ha{constructor(i){super(),Na(this,i,rs,ns,Ya,{})}}export{ys as component};
