import{s as P,n as K,o as O}from"../chunks/scheduler.7da89386.js";import{S as ee,i as te,g as o,s as n,r as x,A as ae,h as p,f as a,c as l,j as A,u as S,x as b,k as N,y as se,a as s,v as W,d as I,t as k,w as $}from"../chunks/index.20910acc.js";import{C as ne}from"../chunks/CodeBlock.cde23137.js";import{H as q,E as le}from"../chunks/EditOnGithub.ba36cbd0.js";function ie(z){let i,T,U,G,r,_,d,E='LDM3D was proposed in <a href="https://huggingface.co/papers/2305.10853" rel="nofollow">LDM3D: Latent Diffusion Model for 3D</a> by Gabriela Ben Melech Stan, Diana Wofk, Scottie Fox, Alex Redden, Will Saxton, Jean Yu, Estelle Aflalo, Shao-Yen Tseng, Fabio Nonato, Matthias Muller, and Vasudev Lal. LDM3D generates an image and a depth map from a given text prompt unlike the existing text-to-image diffusion models such as <a href="./stable_diffusion">Stable Diffusion</a> which only generates an image. With almost the same number of parameters, LDM3D achieves to create a latent space that can compress both the RGB images and the depth maps.',j,u,X="The abstract from the paper is:",Z,h,F='<em>This research paper proposes a Latent Diffusion Model for 3D (LDM3D) that generates both image and depth map data from a given text prompt, allowing users to generate RGBD images from text prompts. The LDM3D model is fine-tuned on a dataset of tuples containing an RGB image, depth map and caption, and validated through extensive experiments. We also develop an application called DepthFusion, which uses the generated RGB images and depth maps to create immersive and interactive 360-degree-view experiences using TouchDesigner. This technology has the potential to transform a wide range of industries, from entertainment and gaming to architecture and design. Overall, this paper presents a significant contribution to the field of generative AI and computer vision, and showcases the potential of LDM3D and DepthFusion to revolutionize content creation and digital experiences. A short video summarizing the approach can be found at <a href="https://t.ly/tdi2" rel="nofollow">this url</a>.</em>',J,m,C,c,Y="To generate RGB and depth images with Stable Diffusion LDM3D on Gaudi, you need to instantiate two instances:",B,M,L='<li>A pipeline with <code>GaudiStableDiffusionLDM3DPipeline</code>. This pipeline supports <em>text-to-(rgb, depth) generation</em>.</li> <li>A scheduler with <a href="https://huggingface.co/docs/optimum/habana/package_reference/stable_diffusion_pipeline#optimum.habana.diffusers.GaudiDDIMScheduler" rel="nofollow"><code>GaudiDDIMScheduler</code></a>. This scheduler has been optimized for Gaudi.</li>',v,f,Q=`When initializing the pipeline, you have to specify <code>use_habana=True</code> to deploy it on HPUs.
Furthermore, to get the fastest possible generations you should enable <strong>HPU graphs</strong> with <code>use_hpu_graphs=True</code>.
Finally, you will need to specify a <a href="https://huggingface.co/docs/optimum/habana/package_reference/gaudi_config" rel="nofollow">Gaudi configuration</a> which can be downloaded from the Hugging Face Hub.`,D,g,V,y,R,w,H;return r=new q({props:{title:"Text-to-(RGB, depth)",local:"text-to-rgb-depth",headingTag:"h1"}}),m=new q({props:{title:"How to generate RGB and depth images?",local:"how-to-generate-rgb-and-depth-images",headingTag:"h2"}}),g=new ne({props:{code:"ZnJvbSUyMG9wdGltdW0uaGFiYW5hLmRpZmZ1c2VycyUyMGltcG9ydCUyMEdhdWRpRERJTVNjaGVkdWxlciUyQyUyMEdhdWRpU3RhYmxlRGlmZnVzaW9uTERNM0RQaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLmhhYmFuYS51dGlscyUyMGltcG9ydCUyMHNldF9zZWVkJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkludGVsJTJGbGRtM2QtNGMlMjIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBHYXVkaURESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBJTBBc2V0X3NlZWQoNDIpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBHYXVkaVN0YWJsZURpZmZ1c2lvbkxETTNEUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjB1c2VfaGFiYW5hJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9ocHVfZ3JhcGhzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdhdWRpX2NvbmZpZyUzRCUyMkhhYmFuYSUyRnN0YWJsZS1kaWZmdXNpb24lMjIlMkMlMEEpJTBBb3V0cHV0cyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCU1QiUyMkhpZ2glMjBxdWFsaXR5JTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwaW4lMjBzcGFjZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRDElMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEMSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIycGlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q1LjAlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0ROb25lJTBBKSUwQSUwQSUwQXJnYl9pbWFnZSUyQyUyMGRlcHRoX2ltYWdlJTIwJTNEJTIwb3V0cHV0cy5yZ2IlMkMlMjBvdXRwdXRzLmRlcHRoJTBBcmdiX2ltYWdlJTVCMCU1RC5zYXZlKCUyMmFzdHJvbmF1dF9sZG0zZF9yZ2IucG5nJTIyKSUwQWRlcHRoX2ltYWdlJTVCMCU1RC5zYXZlKCUyMmFzdHJvbmF1dF9sZG0zZF9kZXB0aC5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.habana.diffusers <span class="hljs-keyword">import</span> GaudiDDIMScheduler, GaudiStableDiffusionLDM3DPipeline
<span class="hljs-keyword">from</span> optimum.habana.utils <span class="hljs-keyword">import</span> set_seed

model_name = <span class="hljs-string">&quot;Intel/ldm3d-4c&quot;</span>

scheduler = GaudiDDIMScheduler.from_pretrained(model_name, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

set_seed(<span class="hljs-number">42</span>)

pipeline = GaudiStableDiffusionLDM3DPipeline.from_pretrained(
    model_name,
    scheduler=scheduler,
    use_habana=<span class="hljs-literal">True</span>,
    use_hpu_graphs=<span class="hljs-literal">True</span>,
    gaudi_config=<span class="hljs-string">&quot;Habana/stable-diffusion&quot;</span>,
)
outputs = pipeline(
    prompt=[<span class="hljs-string">&quot;High quality photo of an astronaut riding a horse in space&quot;</span>],
    num_images_per_prompt=<span class="hljs-number">1</span>,
    batch_size=<span class="hljs-number">1</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    num_inference_steps=<span class="hljs-number">40</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
    negative_prompt=<span class="hljs-literal">None</span>
)


rgb_image, depth_image = outputs.rgb, outputs.depth
rgb_image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_ldm3d_rgb.png&quot;</span>)
depth_image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;astronaut_ldm3d_depth.png&quot;</span>)`,wrap:!1}}),y=new le({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/tutorials/stable_diffusion_ldm3d.mdx"}}),{c(){i=o("meta"),T=n(),U=o("p"),G=n(),x(r.$$.fragment),_=n(),d=o("p"),d.innerHTML=E,j=n(),u=o("p"),u.textContent=X,Z=n(),h=o("p"),h.innerHTML=F,J=n(),x(m.$$.fragment),C=n(),c=o("p"),c.textContent=Y,B=n(),M=o("ul"),M.innerHTML=L,v=n(),f=o("p"),f.innerHTML=Q,D=n(),x(g.$$.fragment),V=n(),x(y.$$.fragment),R=n(),w=o("p"),this.h()},l(e){const t=ae("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(a),T=l(e),U=p(e,"P",{}),A(U).forEach(a),G=l(e),S(r.$$.fragment,e),_=l(e),d=p(e,"P",{"data-svelte-h":!0}),b(d)!=="svelte-z0fax6"&&(d.innerHTML=E),j=l(e),u=p(e,"P",{"data-svelte-h":!0}),b(u)!=="svelte-1cwsb16"&&(u.textContent=X),Z=l(e),h=p(e,"P",{"data-svelte-h":!0}),b(h)!=="svelte-llz6tv"&&(h.innerHTML=F),J=l(e),S(m.$$.fragment,e),C=l(e),c=p(e,"P",{"data-svelte-h":!0}),b(c)!=="svelte-g71uum"&&(c.textContent=Y),B=l(e),M=p(e,"UL",{"data-svelte-h":!0}),b(M)!=="svelte-jajico"&&(M.innerHTML=L),v=l(e),f=p(e,"P",{"data-svelte-h":!0}),b(f)!=="svelte-eukdw1"&&(f.innerHTML=Q),D=l(e),S(g.$$.fragment,e),V=l(e),S(y.$$.fragment,e),R=l(e),w=p(e,"P",{}),A(w).forEach(a),this.h()},h(){N(i,"name","hf:doc:metadata"),N(i,"content",oe)},m(e,t){se(document.head,i),s(e,T,t),s(e,U,t),s(e,G,t),W(r,e,t),s(e,_,t),s(e,d,t),s(e,j,t),s(e,u,t),s(e,Z,t),s(e,h,t),s(e,J,t),W(m,e,t),s(e,C,t),s(e,c,t),s(e,B,t),s(e,M,t),s(e,v,t),s(e,f,t),s(e,D,t),W(g,e,t),s(e,V,t),W(y,e,t),s(e,R,t),s(e,w,t),H=!0},p:K,i(e){H||(I(r.$$.fragment,e),I(m.$$.fragment,e),I(g.$$.fragment,e),I(y.$$.fragment,e),H=!0)},o(e){k(r.$$.fragment,e),k(m.$$.fragment,e),k(g.$$.fragment,e),k(y.$$.fragment,e),H=!1},d(e){e&&(a(T),a(U),a(G),a(_),a(d),a(j),a(u),a(Z),a(h),a(J),a(C),a(c),a(B),a(M),a(v),a(f),a(D),a(V),a(R),a(w)),a(i),$(r,e),$(m,e),$(g,e),$(y,e)}}}const oe='{"title":"Text-to-(RGB, depth)","local":"text-to-rgb-depth","sections":[{"title":"How to generate RGB and depth images?","local":"how-to-generate-rgb-and-depth-images","sections":[],"depth":2}],"depth":1}';function pe(z){return O(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class me extends ee{constructor(i){super(),te(this,i,pe,ie,P,{})}}export{me as component};
