import{s as Qt,o as zt,n as Dt}from"../chunks/scheduler.8c3d61f6.js";import{S as Et,i as Ot,g as s,s as o,r,A as Kt,h as a,f as l,c as i,j as Vt,u as f,x as p,k as qt,y as el,a as n,v as d,d as u,t as m,w as c}from"../chunks/index.da70eac4.js";import{T as tl}from"../chunks/Tip.1d9b8c37.js";import{C as w}from"../chunks/CodeBlock.00a903b3.js";import{H as M,E as ll}from"../chunks/EditOnGithub.1e64e623.js";function nl(be){let h,v='You can also run the <code>diffusers</code> Python codebase on Apple Silicon Macs using the <code>mps</code> accelerator built into PyTorch. This approach is explained in depth in <a href="mps">the mps guide</a>, but it is not compatible with native apps.';return{c(){h=s("p"),h.innerHTML=v},l(y){h=a(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1gipn5x"&&(h.innerHTML=v)},m(y,ye){n(y,h,ye)},p:Dt,d(y){y&&l(h)}}}function ol(be){let h,v,y,ye,g,we,U,yt='<a href="https://developer.apple.com/documentation/coreml" rel="nofollow">Core ML</a> is the model format and machine learning library supported by Apple frameworks. If you are interested in running Stable Diffusion models inside your macOS or iOS/iPadOS apps, this guide will show you how to convert existing PyTorch checkpoints into the Core ML format and use them for inference with Python or Swift.',ve,C,Mt="Core ML models can leverage all the compute engines available in Apple devices: the CPU, the GPU, and the Apple Neural Engine (or ANE, a tensor-optimized accelerator available in Apple Silicon Macs and modern iPhones/iPads). Depending on the model and the device it’s running on, Core ML can mix and match compute engines too, so some portions of the model may run on the CPU while others run on GPU, for example.",ge,b,Ue,T,Ce,$,bt="Stable Diffusion weights (or checkpoints) are stored in the PyTorch format, so you need to convert them to the Core ML format before we can use them inside native apps.",Te,J,wt='Thankfully, Apple engineers developed <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">a conversion tool</a> based on <code>diffusers</code> to convert the PyTorch checkpoints to Core ML.',$e,j,vt="Before you convert a model, though, take a moment to explore the Hugging Face Hub – chances are the model you’re interested in is already available in Core ML format:",Je,k,gt='<li>the <a href="https://huggingface.co/apple" rel="nofollow">Apple</a> organization includes Stable Diffusion versions 1.4, 1.5, 2.0 base, and 2.1 base</li> <li><a href="https://huggingface.co/coreml-community" rel="nofollow">coreml community</a> includes custom finetuned models</li> <li>use this <a href="https://huggingface.co/models?pipeline_tag=text-to-image&amp;library=coreml&amp;p=2&amp;sort=likes" rel="nofollow">filter</a> to return all available Core ML checkpoints</li>',je,G,Ut='If you can’t find the model you’re interested in, we recommend you follow the instructions for <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow">Converting Models to Core ML</a> by Apple.',ke,L,Ge,_,Ct="Stable Diffusion models can be converted to different Core ML variants intended for different purposes:",Le,x,Tt='<li><p>The type of attention blocks used. The attention operation is used to “pay attention” to the relationship between different areas in the image representations and to understand how the image and text representations are related. Attention is compute- and memory-intensive, so different implementations exist that consider the hardware characteristics of different devices. For Core ML Stable Diffusion models, there are two attention variants:</p> <ul><li><code>split_einsum</code> (<a href="https://machinelearning.apple.com/research/neural-engine-transformers" rel="nofollow">introduced by Apple</a>) is optimized for ANE devices, which is available in modern iPhones, iPads and M-series computers.</li> <li>The “original” attention (the base implementation used in <code>diffusers</code>) is only compatible with CPU/GPU and not ANE. It can be <em>faster</em> to run your model on CPU + GPU using <code>original</code> attention than ANE. See <a href="https://huggingface.co/blog/fast-mac-diffusers#performance-benchmarks" rel="nofollow">this performance benchmark</a> as well as some <a href="https://github.com/huggingface/swift-coreml-diffusers/issues/31" rel="nofollow">additional measures provided by the community</a> for additional details.</li></ul></li> <li><p>The supported inference framework.</p> <ul><li><code>packages</code> are suitable for Python inference. This can be used to test converted Core ML models before attempting to integrate them inside native apps, or if you want to explore Core ML performance but don’t need to support native apps. For example, an application with a web UI could perfectly use a Python Core ML backend.</li> <li><code>compiled</code> models are required for Swift code. The <code>compiled</code> models in the Hub split the large UNet model weights into several files for compatibility with iOS and iPadOS devices. This corresponds to the <a href="https://github.com/apple/ml-stable-diffusion#-converting-models-to-core-ml" rel="nofollow"><code>--chunk-unet</code> conversion option</a>. If you want to support native apps, then you need to select the <code>compiled</code> variant.</li></ul></li>',_e,Z,$t='The official Core ML Stable Diffusion <a href="https://huggingface.co/apple/coreml-stable-diffusion-v1-4/tree/main" rel="nofollow">models</a> include these variants, but the community ones may vary:',xe,B,Ze,X,Jt="You can download and use the variant you need as shown below.",Be,N,Xe,W,jt="Install the following libraries to run Core ML inference in Python:",Ne,S,We,P,Se,I,kt="To run inference in Python, use one of the versions stored in the <code>packages</code> folders because the <code>compiled</code> ones are only compatible with Swift. You may choose whether you want to use <code>original</code> or <code>split_einsum</code> attention.",Pe,Y,Gt="This is how you’d download the <code>original</code> attention variant from the Hub to a directory called <code>models</code>:",Ie,H,Ye,F,He,R,Lt="Once you have downloaded a snapshot of the model, you can test it using Apple’s Python script.",Fe,A,Re,V,_t="Pass the path of the downloaded checkpoint with <code>-i</code> flag to the script. <code>--compute-unit</code> indicates the hardware you want to allow for inference. It must be one of the following options: <code>ALL</code>, <code>CPU_AND_GPU</code>, <code>CPU_ONLY</code>, <code>CPU_AND_NE</code>. You may also provide an optional output path, and a seed for reproducibility.",Ae,q,xt="The inference script assumes you’re using the original version of the Stable Diffusion model, <code>CompVis/stable-diffusion-v1-4</code>. If you use another model, you <em>have</em> to specify its Hub id in the inference command line, using the <code>--model-version</code> option. This works for models already supported and custom models you trained or fine-tuned yourself.",Ve,Q,Zt='For example, if you want to use <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>:',qe,z,Qe,D,ze,E,Bt="Running inference in Swift is slightly faster than in Python because the models are already compiled in the <code>mlmodelc</code> format. This is noticeable on app startup when the model is loaded but shouldn’t be noticeable if you run several generations afterward.",De,O,Ee,K,Xt="To run inference in Swift on your Mac, you need one of the <code>compiled</code> checkpoint versions. We recommend you download them locally using Python code similar to the previous example, but with one of the <code>compiled</code> variants:",Oe,ee,Ke,te,et,le,Nt="To run inference, please clone Apple’s repo:",tt,ne,lt,oe,Wt='And then use Apple’s command line tool, <a href="https://www.swift.org/package-manager/#" rel="nofollow">Swift Package Manager</a>:',nt,ie,ot,se,St="You have to specify in <code>--resource-path</code> one of the checkpoints downloaded in the previous step, so please make sure it contains compiled Core ML bundles with the extension <code>.mlmodelc</code>. The <code>--compute-units</code> has to be one of these values: <code>all</code>, <code>cpuOnly</code>, <code>cpuAndGPU</code>, <code>cpuAndNeuralEngine</code>.",it,ae,Pt='For more details, please refer to the <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">instructions in Apple’s repo</a>.',st,pe,at,re,It="The Core ML models and inference code don’t support many of the features, options, and flexibility of 🧨 Diffusers. These are some of the limitations to keep in mind:",pt,fe,Yt="<li>Core ML models are only suitable for inference. They can’t be used for training or fine-tuning.</li> <li>Only two schedulers have been ported to Swift, the default one used by Stable Diffusion and <code>DPMSolverMultistepScheduler</code>, which we ported to Swift from our <code>diffusers</code> implementation. We recommend you use <code>DPMSolverMultistepScheduler</code>, since it produces the same quality in about half the steps.</li> <li>Negative prompts, classifier-free guidance scale, and image-to-image tasks are available in the inference code. Advanced features such as depth guidance, ControlNet, and latent upscalers are not available yet.</li>",rt,de,Ht='Apple’s <a href="https://github.com/apple/ml-stable-diffusion" rel="nofollow">conversion and inference repo</a> and our own <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">swift-coreml-diffusers</a> repos are intended as technology demonstrators to enable other developers to build upon.',ft,ue,Ft="If you feel strongly about any missing features, please feel free to open a feature request or, better yet, a contribution PR 🙂.",dt,me,ut,ce,Rt='One easy way to run Stable Diffusion on your own Apple hardware is to use <a href="https://github.com/huggingface/swift-coreml-diffusers" rel="nofollow">our open-source Swift repo</a>, based on <code>diffusers</code> and Apple’s conversion and inference repo. You can study the code, compile it with <a href="https://developer.apple.com/xcode/" rel="nofollow">Xcode</a> and adapt it for your own needs. For your convenience, there’s also a <a href="https://apps.apple.com/app/diffusers/id1666309574" rel="nofollow">standalone Mac app in the App Store</a>, so you can play with it without having to deal with the code or IDE. If you are a developer and have determined that Core ML is the best solution to build your Stable Diffusion app, then you can use the rest of this guide to get started with your project. We can’t wait to see what you’ll build 🙂.',mt,he,ct,Me,ht;return g=new M({props:{title:"How to run Stable Diffusion with Core ML",local:"how-to-run-stable-diffusion-with-core-ml",headingTag:"h1"}}),b=new tl({props:{$$slots:{default:[nl]},$$scope:{ctx:be}}}),T=new M({props:{title:"Stable Diffusion Core ML Checkpoints",local:"stable-diffusion-core-ml-checkpoints",headingTag:"h2"}}),L=new M({props:{title:"Selecting the Core ML Variant to Use",local:"selecting-the-core-ml-variant-to-use",headingTag:"h2"}}),B=new w({props:{code:"Y29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG9yaWdpbmFsJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29tcGlsZWQlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBwYWNrYWdlcyUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNwbGl0X2VpbnN1bSUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbXBpbGVkJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcGFja2FnZXM=",highlighted:`coreml-stable-<span class="hljs-keyword">diffusion-v1-4
</span>├── README.md
├── <span class="hljs-keyword">original
</span>│   ├── compiled
│   └── packages
└── split_einsum
    ├── compiled
    └── packages`,wrap:!1}}),N=new M({props:{title:"Core ML Inference in Python",local:"core-ml-inference-in-python",headingTag:"h2"}}),S=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiUwQXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`pip install huggingface_hub
pip install git+https://github.com/apple/ml-stable-diffusion`,wrap:!1}}),P=new M({props:{title:"Download the Model Checkpoints",local:"download-the-model-checkpoints",headingTag:"h3"}}),H=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRnBhY2thZ2VzJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/packages&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),F=new M({props:{title:"Inference",local:"python-inference",headingTag:"h3"}}),A=new w({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTRfb3JpZ2luYWxfcGFja2FnZXMlMjAtbyUyMCUzQyUyRnBhdGglMkZ0byUyRm91dHB1dCUyRmltYWdlJTNFJTIwLS1jb21wdXRlLXVuaXQlMjBDUFVfQU5EX0dQVSUyMC0tc2VlZCUyMDkz",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; -i models/coreml-stable-diffusion-v1-4_original_packages -o &lt;/path/to/output/image&gt; --compute-unit CPU_AND_GPU --seed 93",wrap:!1}}),z=new w({props:{code:"cHl0aG9uJTIwLW0lMjBweXRob25fY29yZW1sX3N0YWJsZV9kaWZmdXNpb24ucGlwZWxpbmUlMjAtLXByb21wdCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMjAtLWNvbXB1dGUtdW5pdCUyMEFMTCUyMC1vJTIwb3V0cHV0JTIwLS1zZWVkJTIwOTMlMjAtaSUyMG1vZGVscyUyRmNvcmVtbC1zdGFibGUtZGlmZnVzaW9uLXYxLTVfb3JpZ2luYWxfcGFja2FnZXMlMjAtLW1vZGVsLXZlcnNpb24lMjBzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:"python -m python_coreml_stable_diffusion.pipeline --prompt &quot;a photo of an astronaut riding a horse on mars&quot; --compute-unit ALL -o output --seed 93 -i models/coreml-stable-diffusion-v1-5_original_packages --model-version stable-diffusion-v1-5/stable-diffusion-v1-5",wrap:!1}}),D=new M({props:{title:"Core ML inference in Swift",local:"core-ml-inference-in-swift",headingTag:"h2"}}),O=new M({props:{title:"Download",local:"download",headingTag:"h3"}}),ee=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmFwcGxlJTJGY29yZW1sLXN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQXZhcmlhbnQlMjAlM0QlMjAlMjJvcmlnaW5hbCUyRmNvbXBpbGVkJTIyJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMFBhdGgoJTIyLiUyRm1vZGVscyUyMiklMjAlMkYlMjAocmVwb19pZC5zcGxpdCglMjIlMkYlMjIpJTVCLTElNUQlMjAlMkIlMjAlMjJfJTIyJTIwJTJCJTIwdmFyaWFudC5yZXBsYWNlKCUyMiUyRiUyMiUyQyUyMCUyMl8lMjIpKSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlMkMlMjBhbGxvd19wYXR0ZXJucyUzRGYlMjIlN0J2YXJpYW50JTdEJTJGKiUyMiUyQyUyMGxvY2FsX2RpciUzRG1vZGVsX3BhdGglMkMlMjBsb2NhbF9kaXJfdXNlX3N5bWxpbmtzJTNERmFsc2UpJTBBcHJpbnQoZiUyMk1vZGVsJTIwZG93bmxvYWRlZCUyMGF0JTIwJTdCbW9kZWxfcGF0aCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path

repo_id = <span class="hljs-string">&quot;apple/coreml-stable-diffusion-v1-4&quot;</span>
variant = <span class="hljs-string">&quot;original/compiled&quot;</span>

model_path = Path(<span class="hljs-string">&quot;./models&quot;</span>) / (repo_id.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>] + <span class="hljs-string">&quot;_&quot;</span> + variant.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>))
snapshot_download(repo_id, allow_patterns=<span class="hljs-string">f&quot;<span class="hljs-subst">{variant}</span>/*&quot;</span>, local_dir=model_path, local_dir_use_symlinks=<span class="hljs-literal">False</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model downloaded at <span class="hljs-subst">{model_path}</span>&quot;</span>)`,wrap:!1}}),te=new M({props:{title:"Inference",local:"swift-inference",headingTag:"h3"}}),ne=new w({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhcHBsZSUyRm1sLXN0YWJsZS1kaWZmdXNpb24lMEFjZCUyMG1sLXN0YWJsZS1kaWZmdXNpb24=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/apple/ml-stable-diffusion
<span class="hljs-built_in">cd</span> ml-stable-diffusion`,wrap:!1}}),ie=new w({props:{code:"c3dpZnQlMjBydW4lMjBTdGFibGVEaWZmdXNpb25TYW1wbGUlMjAtLXJlc291cmNlLXBhdGglMjBtb2RlbHMlMkZjb3JlbWwtc3RhYmxlLWRpZmZ1c2lvbi12MS00X29yaWdpbmFsX2NvbXBpbGVkJTIwLS1jb21wdXRlLXVuaXRzJTIwYWxsJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMg==",highlighted:'swift run StableDiffusionSample --resource-path models/coreml-stable-diffusion-v1-4_original_compiled --compute-units all <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>',wrap:!1}}),pe=new M({props:{title:"Supported Diffusers Features",local:"supported-diffusers-features",headingTag:"h2"}}),me=new M({props:{title:"Native Diffusers Swift app",local:"native-diffusers-swift-app",headingTag:"h2"}}),he=new ll({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/coreml.md"}}),{c(){h=s("meta"),v=o(),y=s("p"),ye=o(),r(g.$$.fragment),we=o(),U=s("p"),U.innerHTML=yt,ve=o(),C=s("p"),C.textContent=Mt,ge=o(),r(b.$$.fragment),Ue=o(),r(T.$$.fragment),Ce=o(),$=s("p"),$.textContent=bt,Te=o(),J=s("p"),J.innerHTML=wt,$e=o(),j=s("p"),j.textContent=vt,Je=o(),k=s("ul"),k.innerHTML=gt,je=o(),G=s("p"),G.innerHTML=Ut,ke=o(),r(L.$$.fragment),Ge=o(),_=s("p"),_.textContent=Ct,Le=o(),x=s("ul"),x.innerHTML=Tt,_e=o(),Z=s("p"),Z.innerHTML=$t,xe=o(),r(B.$$.fragment),Ze=o(),X=s("p"),X.textContent=Jt,Be=o(),r(N.$$.fragment),Xe=o(),W=s("p"),W.textContent=jt,Ne=o(),r(S.$$.fragment),We=o(),r(P.$$.fragment),Se=o(),I=s("p"),I.innerHTML=kt,Pe=o(),Y=s("p"),Y.innerHTML=Gt,Ie=o(),r(H.$$.fragment),Ye=o(),r(F.$$.fragment),He=o(),R=s("p"),R.textContent=Lt,Fe=o(),r(A.$$.fragment),Re=o(),V=s("p"),V.innerHTML=_t,Ae=o(),q=s("p"),q.innerHTML=xt,Ve=o(),Q=s("p"),Q.innerHTML=Zt,qe=o(),r(z.$$.fragment),Qe=o(),r(D.$$.fragment),ze=o(),E=s("p"),E.innerHTML=Bt,De=o(),r(O.$$.fragment),Ee=o(),K=s("p"),K.innerHTML=Xt,Oe=o(),r(ee.$$.fragment),Ke=o(),r(te.$$.fragment),et=o(),le=s("p"),le.textContent=Nt,tt=o(),r(ne.$$.fragment),lt=o(),oe=s("p"),oe.innerHTML=Wt,nt=o(),r(ie.$$.fragment),ot=o(),se=s("p"),se.innerHTML=St,it=o(),ae=s("p"),ae.innerHTML=Pt,st=o(),r(pe.$$.fragment),at=o(),re=s("p"),re.textContent=It,pt=o(),fe=s("ul"),fe.innerHTML=Yt,rt=o(),de=s("p"),de.innerHTML=Ht,ft=o(),ue=s("p"),ue.textContent=Ft,dt=o(),r(me.$$.fragment),ut=o(),ce=s("p"),ce.innerHTML=Rt,mt=o(),r(he.$$.fragment),ct=o(),Me=s("p"),this.h()},l(e){const t=Kt("svelte-u9bgzb",document.head);h=a(t,"META",{name:!0,content:!0}),t.forEach(l),v=i(e),y=a(e,"P",{}),Vt(y).forEach(l),ye=i(e),f(g.$$.fragment,e),we=i(e),U=a(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-qaabbu"&&(U.innerHTML=yt),ve=i(e),C=a(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1orjtw1"&&(C.textContent=Mt),ge=i(e),f(b.$$.fragment,e),Ue=i(e),f(T.$$.fragment,e),Ce=i(e),$=a(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-17hueww"&&($.textContent=bt),Te=i(e),J=a(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-x5a2v2"&&(J.innerHTML=wt),$e=i(e),j=a(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-4w8fdi"&&(j.textContent=vt),Je=i(e),k=a(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-1lfif8r"&&(k.innerHTML=gt),je=i(e),G=a(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-eg00q0"&&(G.innerHTML=Ut),ke=i(e),f(L.$$.fragment,e),Ge=i(e),_=a(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1tgahft"&&(_.textContent=Ct),Le=i(e),x=a(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-1mnjc4n"&&(x.innerHTML=Tt),_e=i(e),Z=a(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1uzdjfm"&&(Z.innerHTML=$t),xe=i(e),f(B.$$.fragment,e),Ze=i(e),X=a(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1xkemdi"&&(X.textContent=Jt),Be=i(e),f(N.$$.fragment,e),Xe=i(e),W=a(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-19xoujm"&&(W.textContent=jt),Ne=i(e),f(S.$$.fragment,e),We=i(e),f(P.$$.fragment,e),Se=i(e),I=a(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1k484f2"&&(I.innerHTML=kt),Pe=i(e),Y=a(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1vn0h7b"&&(Y.innerHTML=Gt),Ie=i(e),f(H.$$.fragment,e),Ye=i(e),f(F.$$.fragment,e),He=i(e),R=a(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-83ivzw"&&(R.textContent=Lt),Fe=i(e),f(A.$$.fragment,e),Re=i(e),V=a(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-hcctjd"&&(V.innerHTML=_t),Ae=i(e),q=a(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-hhlwnj"&&(q.innerHTML=xt),Ve=i(e),Q=a(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-hoaw7z"&&(Q.innerHTML=Zt),qe=i(e),f(z.$$.fragment,e),Qe=i(e),f(D.$$.fragment,e),ze=i(e),E=a(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1j3moem"&&(E.innerHTML=Bt),De=i(e),f(O.$$.fragment,e),Ee=i(e),K=a(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1u2q3bb"&&(K.innerHTML=Xt),Oe=i(e),f(ee.$$.fragment,e),Ke=i(e),f(te.$$.fragment,e),et=i(e),le=a(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1a6a1za"&&(le.textContent=Nt),tt=i(e),f(ne.$$.fragment,e),lt=i(e),oe=a(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1sx1rnz"&&(oe.innerHTML=Wt),nt=i(e),f(ie.$$.fragment,e),ot=i(e),se=a(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-12c7wn6"&&(se.innerHTML=St),it=i(e),ae=a(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-14s5isr"&&(ae.innerHTML=Pt),st=i(e),f(pe.$$.fragment,e),at=i(e),re=a(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-q86h2"&&(re.textContent=It),pt=i(e),fe=a(e,"UL",{"data-svelte-h":!0}),p(fe)!=="svelte-1jpknop"&&(fe.innerHTML=Yt),rt=i(e),de=a(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-5goosl"&&(de.innerHTML=Ht),ft=i(e),ue=a(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-fa2zni"&&(ue.textContent=Ft),dt=i(e),f(me.$$.fragment,e),ut=i(e),ce=a(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-m342fh"&&(ce.innerHTML=Rt),mt=i(e),f(he.$$.fragment,e),ct=i(e),Me=a(e,"P",{}),Vt(Me).forEach(l),this.h()},h(){qt(h,"name","hf:doc:metadata"),qt(h,"content",il)},m(e,t){el(document.head,h),n(e,v,t),n(e,y,t),n(e,ye,t),d(g,e,t),n(e,we,t),n(e,U,t),n(e,ve,t),n(e,C,t),n(e,ge,t),d(b,e,t),n(e,Ue,t),d(T,e,t),n(e,Ce,t),n(e,$,t),n(e,Te,t),n(e,J,t),n(e,$e,t),n(e,j,t),n(e,Je,t),n(e,k,t),n(e,je,t),n(e,G,t),n(e,ke,t),d(L,e,t),n(e,Ge,t),n(e,_,t),n(e,Le,t),n(e,x,t),n(e,_e,t),n(e,Z,t),n(e,xe,t),d(B,e,t),n(e,Ze,t),n(e,X,t),n(e,Be,t),d(N,e,t),n(e,Xe,t),n(e,W,t),n(e,Ne,t),d(S,e,t),n(e,We,t),d(P,e,t),n(e,Se,t),n(e,I,t),n(e,Pe,t),n(e,Y,t),n(e,Ie,t),d(H,e,t),n(e,Ye,t),d(F,e,t),n(e,He,t),n(e,R,t),n(e,Fe,t),d(A,e,t),n(e,Re,t),n(e,V,t),n(e,Ae,t),n(e,q,t),n(e,Ve,t),n(e,Q,t),n(e,qe,t),d(z,e,t),n(e,Qe,t),d(D,e,t),n(e,ze,t),n(e,E,t),n(e,De,t),d(O,e,t),n(e,Ee,t),n(e,K,t),n(e,Oe,t),d(ee,e,t),n(e,Ke,t),d(te,e,t),n(e,et,t),n(e,le,t),n(e,tt,t),d(ne,e,t),n(e,lt,t),n(e,oe,t),n(e,nt,t),d(ie,e,t),n(e,ot,t),n(e,se,t),n(e,it,t),n(e,ae,t),n(e,st,t),d(pe,e,t),n(e,at,t),n(e,re,t),n(e,pt,t),n(e,fe,t),n(e,rt,t),n(e,de,t),n(e,ft,t),n(e,ue,t),n(e,dt,t),d(me,e,t),n(e,ut,t),n(e,ce,t),n(e,mt,t),d(he,e,t),n(e,ct,t),n(e,Me,t),ht=!0},p(e,[t]){const At={};t&2&&(At.$$scope={dirty:t,ctx:e}),b.$set(At)},i(e){ht||(u(g.$$.fragment,e),u(b.$$.fragment,e),u(T.$$.fragment,e),u(L.$$.fragment,e),u(B.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(H.$$.fragment,e),u(F.$$.fragment,e),u(A.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),ht=!0)},o(e){m(g.$$.fragment,e),m(b.$$.fragment,e),m(T.$$.fragment,e),m(L.$$.fragment,e),m(B.$$.fragment,e),m(N.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),m(H.$$.fragment,e),m(F.$$.fragment,e),m(A.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(he.$$.fragment,e),ht=!1},d(e){e&&(l(v),l(y),l(ye),l(we),l(U),l(ve),l(C),l(ge),l(Ue),l(Ce),l($),l(Te),l(J),l($e),l(j),l(Je),l(k),l(je),l(G),l(ke),l(Ge),l(_),l(Le),l(x),l(_e),l(Z),l(xe),l(Ze),l(X),l(Be),l(Xe),l(W),l(Ne),l(We),l(Se),l(I),l(Pe),l(Y),l(Ie),l(Ye),l(He),l(R),l(Fe),l(Re),l(V),l(Ae),l(q),l(Ve),l(Q),l(qe),l(Qe),l(ze),l(E),l(De),l(Ee),l(K),l(Oe),l(Ke),l(et),l(le),l(tt),l(lt),l(oe),l(nt),l(ot),l(se),l(it),l(ae),l(st),l(at),l(re),l(pt),l(fe),l(rt),l(de),l(ft),l(ue),l(dt),l(ut),l(ce),l(mt),l(ct),l(Me)),l(h),c(g,e),c(b,e),c(T,e),c(L,e),c(B,e),c(N,e),c(S,e),c(P,e),c(H,e),c(F,e),c(A,e),c(z,e),c(D,e),c(O,e),c(ee,e),c(te,e),c(ne,e),c(ie,e),c(pe,e),c(me,e),c(he,e)}}}const il='{"title":"How to run Stable Diffusion with Core ML","local":"how-to-run-stable-diffusion-with-core-ml","sections":[{"title":"Stable Diffusion Core ML Checkpoints","local":"stable-diffusion-core-ml-checkpoints","sections":[],"depth":2},{"title":"Selecting the Core ML Variant to Use","local":"selecting-the-core-ml-variant-to-use","sections":[],"depth":2},{"title":"Core ML Inference in Python","local":"core-ml-inference-in-python","sections":[{"title":"Download the Model Checkpoints","local":"download-the-model-checkpoints","sections":[],"depth":3},{"title":"Inference","local":"python-inference","sections":[],"depth":3}],"depth":2},{"title":"Core ML inference in Swift","local":"core-ml-inference-in-swift","sections":[{"title":"Download","local":"download","sections":[],"depth":3},{"title":"Inference","local":"swift-inference","sections":[],"depth":3}],"depth":2},{"title":"Supported Diffusers Features","local":"supported-diffusers-features","sections":[],"depth":2},{"title":"Native Diffusers Swift app","local":"native-diffusers-swift-app","sections":[],"depth":2}],"depth":1}';function sl(be){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends Et{constructor(h){super(),Ot(this,h,sl,ol,Qt,{})}}export{ul as component};
