import{s as NU,n as BU,o as GU}from"../chunks/scheduler.71ff668b.js";import{S as vU,i as YU,g as M,s as T,r as i,A as _U,h as s,f as J,c as e,j as bU,u as a,x as n,k as $U,y as WU,a as t,v as y,d as p,t as g,w as z}from"../chunks/index.e0973da1.js";import{C as m}from"../chunks/CodeBlock.0c9622a3.js";import{C as HU}from"../chunks/CourseFloatingBanner.69eb4e28.js";import{H as o,E as ZU}from"../chunks/getInferenceSnippets.25cce923.js";function qU(yU){let V,zl,pl,ml,c,ol,R,Vl,O,pU='<a href="../1_instruction_tuning/README.md">インストラクションチューニングの章</a> では、教師あり微調整によるモデルの微調整について学びました。このセクションでは、SFTのためのインストラクションデータセットの生成方法を探ります。基本的なプロンプトを使用してインストラクションチューニングデータセットを作成する方法や、論文から得られたより洗練された技術を使用する方法を探ります。インストラクションチューニングデータセットは、SelfInstructやMagpieのような方法を使用して、インコンテキスト学習のためのシードデータを使用して作成できます。さらに、EvolInstructを通じたインストラクションの進化についても探ります。最後に、distilabelパイプラインを使用してインストラクションチューニングのためのデータセットを生成する方法を探ります。',cl,u,Rl,F,gU="合成データは一見複雑に見えますが、モデルから知識を抽出するための効果的なプロンプトを作成することに簡略化できます。つまり、特定のタスクのためのデータを生成する方法と考えることができます。課題は、データが多様で代表的であることを保証しながら、効果的にプロンプトを作成することです。幸いなことに、多くの論文がこの問題を探求しており、このコースではいくつかの有用なものを探ります。まずは、手動でプロンプトを作成して合成データを生成する方法を探ります。",Ol,Q,ul,r,zU='基本的な例から始めましょう。<a href="https://huggingface.co/HuggingFaceTB/SmolLM2-1.7B-Instruct" rel="nofollow">HuggingFaceTB/SmolLM2-1.7B-Instruct</a>モデルを<code>distilabel</code>ライブラリの<code>transformers</code>統合を使用してロードします。<code>TextGeneration</code>クラスを使用して合成<code>プロンプト</code>を生成し、それを使用して<code>completion</code>を生成します。',Fl,E,mU="次に、<code>distilabel</code>ライブラリを使用してモデルをロードします。",Ql,C,rl,I,oU=`!!! note
Distilabelは<code>llm</code>をメモリにロードするため、ノートブックで作業する場合は、メモリの問題を避けるために使用後に<code>gen.unload()</code>する必要があります。`,El,f,VU="次に、<code>llm</code>を使用してインストラクションチューニングのための<code>プロンプト</code>を生成します。",Cl,d,Il,j,cU="最後に、同じ<code>プロンプト</code>を入力として使用して<code>completion</code>を生成します。",fl,D,dl,x,RU="素晴らしい！合成<code>プロンプト</code>と対応する<code>completion</code>を生成できました。このシンプルなアプローチをスケールアップして、より多くのデータを生成することができますが、データの品質はそれほど高くなく、コースやドメインのニュアンスを考慮していません。さらに、現在のコードを再実行すると、データがそれほど多様でないことがわかります。幸いなことに、この問題を解決する方法があります。",jl,k,Dl,S,OU='SelfInstructは、シードデータセットに基づいて新しいインストラクションを生成するプロンプトです。このシードデータは単一のインストラクションやコンテキストの一部である場合があります。プロセスは、初期のシードデータのプールから始まります。言語モデルは、インコンテキスト学習を使用してこのシードデータに基づいて新しいインストラクションを生成するようにプロンプトされます。このプロンプトは<a href="https://github.com/argilla-io/distilabel/blob/main/src/distilabel/steps/tasks/templates/self-instruct.jinja2" rel="nofollow">distilabelで実装されています</a>が、簡略化されたバージョンは以下の通りです：',xl,h,kl,w,uU='これを使用するには、<code>llm</code>を<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/selfinstruct/" rel="nofollow">SelfInstructクラス</a>に渡す必要があります。<a href="#prompt-to-data">プロンプトからデータセクション</a>のテキストをコンテキストとして使用し、新しいインストラクションを生成してみましょう。',Sl,b,hl,$,FU="生成されたインストラクションはすでにかなり良くなっており、実際のコンテンツやドメインに適しています。しかし、プロンプトを進化させることでさらに良くすることができます。",wl,N,bl,B,QU='EvolInstructは、入力インストラクションを進化させて、同じインストラクションのより良いバージョンにするプロンプト技術です。このより良いバージョンは、一連の基準に従って定義され、元のインストラクションに制約、深化、具体化、推論、または複雑化を追加します。このプロセスは、元のインストラクションのさまざまな進化を作成するために複数回繰り返すことができ、理想的には元のインストラクションのより良いバージョンに導きます。このプロンプトは<a href="https://github.com/argilla-io/distilabel/tree/main/src/distilabel/steps/tasks/evol_instruct" rel="nofollow">distilabelで実装されています</a>が、簡略化されたバージョンは以下の通りです：',$l,G,Nl,v,rU='これを使用するには、<code>llm</code>を<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/evolinstruct/" rel="nofollow">EvolInstructクラス</a>に渡す必要があります。<a href="#selfinstruct">SelfInstructセクション</a>の合成プロンプトを入力として使用し、それをより良いバージョンに進化させてみましょう。この例では、1世代だけ進化させます。',Bl,Y,Gl,_,EU="インストラクションはより複雑になりましたが、元の意味を失っています。したがって、進化させることは両刃の剣であり、生成するデータの品質に注意する必要があります。",vl,W,Yl,H,CU='Magpieは、言語モデルの自己回帰的要因と、インストラクションチューニングプロセス中に使用されていた<a href="../1_instruction_tuning/chat_templates.md">チャットテンプレート</a>に依存する技術です。覚えているかもしれませんが、チャットテンプレートは、システム、ユーザー、アシスタントの役割を明確に示す形式で会話を構造化します。インストラクションチューニングフェーズ中に、言語モデルはこの形式を再現するように最適化されており、Magpieはそれを利用します。チャットテンプレートに基づいた事前クエリプロンプトから始めますが、ユーザーメッセージインジケーター、例：&lt;|im_end|&gt;ユーザー\\nの前で停止し、その後、言語モデルを使用してユーザープロンプトを生成し、アシスタントインジケーター、例：&lt;|im_end|&gt;まで生成します。このアプローチにより、多くのデータを非常に効率的に生成でき、マルチターンの会話にもスケールアップできます。この生成されたデータは、使用されたモデルのインストラクションチューニングフェーズのトレーニングデータを再現すると仮定されています。',_l,Z,IU="このシナリオでは、プロンプトテンプレートはチャットテンプレート形式に基づいているため、モデルごとに異なります。しかし、プロセスをステップバイステップで簡略化して説明できます。",Wl,q,Hl,L,fU='distilabelで使用するには、<code>llm</code>を<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/magpie/" rel="nofollow">Magpieクラス</a>に渡す必要があります。',Zl,A,ql,X,dU="すぐに<code>プロンプト</code>と<code>completion</code>を含むデータセットが得られます。ドメインに特化したパフォーマンスを向上させるために、<code>system_prompt</code>に追加のコンテキストを挿入できます。LLMが特定のドメインデータを生成するために、システムプロンプトでユーザーのクエリがどのようなものかを説明することが役立ちます。これは、ユーザープロンプトを生成する前の事前クエリプロンプトで使用され、LLMがそのドメインのユーザークエリを生成するようにバイアスをかけます。",Ll,P,Al,K,jU="システムプロンプトに追加のコンテキストを渡すことは、一般的に言語モデルが最適化されていないため、カスタマイズには他の技術ほど効果的ではないことが多いです。",Xl,ll,Pl,Ul,DU='これまで見てきたクラスはすべて、パイプラインで使用できるスタンドアロンのクラスです。これは良いスタートですが、<code>Pipeline</code>クラスを使用してデータセットを生成することでさらに良くすることができます。<code>TextGeneration</code>ステップを使用してインストラクションチューニングのための合成データセットを生成します。パイプラインは、データをロードするための<code>LoadDataFromDicts</code>ステップ、<code>プロンプト</code>を生成するための<code>TextGeneration</code>ステップ、およびそのプロンプトの<code>completion</code>を生成するためのステップで構成されます。ステップを接続し、<code>&gt;&gt;</code>演算子を使用してデータをパイプラインに流します。distilabelの<a href="https://distilabel.argilla.io/dev/components-gallery/tasks/textgeneration/#input-output-columns" rel="nofollow">ドキュメント</a>には、ステップの入力および出力列に関する情報が記載されています。データがパイプラインを正しく流れるようにするために、<code>output_mappings</code>パラメータを使用して出力列を次のステップの入力列にマッピングします。',Kl,Jl,lU,tl,xU="このパイプラインの背後には多くのクールな機能があります。生成結果を自動的にキャッシュするため、生成ステップを再実行する必要がありません。フォールトトレランスが組み込まれており、生成ステップが失敗してもパイプラインは実行を続けます。また、すべての生成ステップを並行して実行するため、生成が高速です。<code>draw</code>メソッドを使用してパイプラインを視覚化することもできます。ここでは、データがパイプラインをどのように流れ、<code>output_mappings</code>が出力列を次のステップの入力列にどのようにマッピングするかを確認できます。",UU,Tl,kU='<img src="./images/pipeline.png" alt="Pipeline"/>',JU,el,tU,Ml,SU="<li>多様なシードデータを確保して、さまざまなシナリオをカバーする</li> <li>生成されたデータが多様で高品質であることを定期的に評価する</li> <li>データの品質を向上させるために（システム）プロンプトを繰り返し改善する</li>",TU,sl,eU,nl,hU=`👨🏽‍💻 コード - <a href="../../../notebooks/ja/6_synthetic_datasets/instruction_sft_dataset.ipynb">演習ノートブック</a>でインストラクションチューニングのためのデータセットを生成する
🧑‍🏫 学ぶ - <a href="./preference_datasets.md">preference datasetsの生成</a>について学ぶ`,MU,il,sU,al,wU='<li><a href="https://distilabel.argilla.io/latest/" rel="nofollow">Distilabel Documentation</a></li> <li><a href="https://arxiv.org/abs/2212.10560" rel="nofollow">Self-instruct</a></li> <li><a href="https://arxiv.org/abs/2304.12244" rel="nofollow">Evol-Instruct</a></li> <li><a href="https://arxiv.org/abs/2406.08464" rel="nofollow">Magpie</a></li>',nU,yl,iU,gl,aU;return c=new o({props:{title:"インストラクションデータセットの生成",local:"インストラクションデータセットの生成",headingTag:"h1"}}),R=new HU({props:{chapter:10,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/smol-course/blob/main/notebooks/ja/6_synthetic_datasets/instruction_sft_dataset.ipynb"}]}}),u=new o({props:{title:"プロンプトからデータへ",local:"プロンプトからデータへ",headingTag:"h2"}}),Q=new o({props:{title:"基本的なプロンプト",local:"基本的なプロンプト",headingTag:"h3"}}),C=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwubGxtcyUyMGltcG9ydCUyMFRyYW5zZm9ybWVyc0xMTSUwQWZyb20lMjBkaXN0aWxhYmVsLnN0ZXBzLnRhc2tzJTIwaW1wb3J0JTIwVGV4dEdlbmVyYXRpb24lMEElMEFsbG0lMjAlM0QlMjBUcmFuc2Zvcm1lcnNMTE0obW9kZWwlM0QlMjJIdWdnaW5nRmFjZVRCJTJGU21vbExNMi0xLjdCLUluc3RydWN0JTIyKSUwQWdlbiUyMCUzRCUyMFRleHRHZW5lcmF0aW9uKGxsbSUzRGxsbSklMEFnZW4ubG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> TransformersLLM
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> TextGeneration

llm = TransformersLLM(model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
gen = TextGeneration(llm=llm)
gen.load()`,wrap:!1}}),d=new m({props:{code:"bmV4dChnZW4ucHJvY2VzcyglNUIlN0IlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMkh1Z2dpbmclMjBGYWNlJUUzJTgxJUFFJUU1JUIwJThGJUU4JUE2JThGJUU2JUE4JUExQUklRTMlODMlQTIlRTMlODMlODclRTMlODMlQUIlRTMlODElQUIlRTklOTYlQTIlRTMlODElOTklRTMlODIlOEJTbW9sLUNvdXJzZSVFMyU4MSVBQiVFMyU4MSVBNCVFMyU4MSU4NCVFMyU4MSVBNiVFMyU4MSVBRSVFOCVCMyVBQSVFNSU5NSU4RiVFMyU4MiU5MiVFNyU5NCU5RiVFNiU4OCU5MCVFMyU4MSU5NyVFMyU4MSVBNiVFMyU4MSU4RiVFMyU4MSVBMCVFMyU4MSU5NSVFMyU4MSU4NCVFMyU4MCU4MiUyMiU3RCU1RCkpJTBBJTIzJTIwU21vbC1Db3Vyc2UlRTMlODElQUUlRTclOUIlQUUlRTclOUElODQlRTMlODElQUYlRTQlQkQlOTUlRTMlODElQTclRTMlODElOTklRTMlODElOEIlRUYlQkMlOUY=",highlighted:`<span class="hljs-built_in">next</span>(gen.process([{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Hugging Faceの小規模AIモデルに関するSmol-Courseについての質問を生成してください。&quot;</span>}]))
<span class="hljs-comment"># Smol-Courseの目的は何ですか？</span>`,wrap:!1}}),D=new m({props:{code:"bmV4dChnZW4ucHJvY2VzcyglNUIlN0IlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMCUyMlNtb2wtQ291cnNlJUUzJTgxJUFFJUU3JTlCJUFFJUU3JTlBJTg0JUUzJTgxJUFGJUU0JUJEJTk1JUUzJTgxJUE3JUUzJTgxJTk5JUUzJTgxJThCJUVGJUJDJTlGJTIyJTdEJTVEKSklMEElMjMlMjBTbW9sLUNvdXJzZSVFMyU4MSVBRiVFMyU4MiVCMyVFMyU4MyVCMyVFMyU4MyU5NCVFMyU4MyVBNSVFMyU4MyVCQyVFMyU4MiVCRiVFMyU4MiVCNSVFMyU4MiVBNCVFMyU4MiVBOCVFMyU4MyVCMyVFMyU4MiVCOSVFMyU4MSVBRSVFNiVBNiU4MiVFNSVCRiVCNSVFMyU4MiU5MiVFNSVBRCVBNiVFMyU4MSVCNiVFMyU4MSU5RiVFMyU4MiU4MSVFMyU4MSVBRSVFMyU4MyU5NyVFMyU4MyVBOSVFMyU4MyU4MyVFMyU4MyU4OCVFMyU4MyU5NSVFMyU4MiVBOSVFMyU4MyVCQyVFMyU4MyVBMCVFMyU4MSVBNyVFMyU4MSU5OSVFMyU4MCU4Mg==",highlighted:`<span class="hljs-built_in">next</span>(gen.process([{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Smol-Courseの目的は何ですか？&quot;</span>}]))
<span class="hljs-comment"># Smol-Courseはコンピュータサイエンスの概念を学ぶためのプラットフォームです。</span>`,wrap:!1}}),k=new o({props:{title:"SelfInstruct",local:"selfinstruct",headingTag:"h3"}}),h=new m({props:{code:"JTIzJTIwJUUzJTgyJUJGJUUzJTgyJUI5JUUzJTgyJUFGJUUzJTgxJUFFJUU4JUFBJUFDJUU2JTk4JThFJTBBJUU0JUI4JThFJUUzJTgxJTg4JUUzJTgyJTg5JUUzJTgyJThDJUUzJTgxJTlGQUklRTMlODIlQTIlRTMlODMlOTclRTMlODMlQUElRTMlODIlQjElRTMlODMlQkMlRTMlODIlQjclRTMlODMlQTclRTMlODMlQjMlRTMlODElOEMlRTUlOEYlOTclRTMlODElOTElRTUlOEYlOTYlRTMlODIlOEIlRTMlODElOTMlRTMlODElQTglRTMlODElOEMlRTMlODElQTclRTMlODElOEQlRTMlODIlOEIlN0IlN0IlMjBudW1faW5zdHJ1Y3Rpb25zJTIwJTdEJTdEJUUzJTgxJUFFJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJUUzJTgyJUFGJUUzJTgyJUE4JUUzJTgzJUFBJUUzJTgyJTkyJUU5JTk2JThCJUU3JTk5JUJBJUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJUUzJTgzJUEyJUUzJTgzJTg3JUUzJTgzJUFCJUUzJTgxJUFFJUUzJTgzJTg2JUUzJTgyJUFEJUUzJTgyJUI5JUUzJTgzJTg4JUU4JTgzJUJEJUU1JThBJTlCJUU1JTg2JTg1JUUzJTgxJUE3JUU1JThCJTk1JUU4JUE5JTlFJUUzJTgxJUE4JUU4JUE4JTgwJUU4JUFBJTlFJUU2JUE3JThCJUU5JTgwJUEwJUUzJTgxJUFFJUU1JUE0JTlBJUU2JUE3JTk4JUU2JTgwJUE3JUUzJTgyJTkyJUU1JUJDJUI3JUU4JUFBJUJGJUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJTBBJTBBJTIzJTIwJUUzJTgyJUIzJUUzJTgzJUIzJUUzJTgzJTg2JUUzJTgyJUFEJUUzJTgyJUI5JUUzJTgzJTg4JTBBJTdCJTdCJTIwaW5wdXQlMjAlN0QlN0QlMEElMEElMjMlMjAlRTUlODclQkElRTUlOEElOUI=",highlighted:`<span class="language-xml"># タスクの説明
与えられたAIアプリケーションが受け取ることができる</span><span class="hljs-template-variable">{{ <span class="hljs-name">num_instructions</span> }}</span><span class="language-xml">のユーザークエリを開発してください。モデルのテキスト能力内で動詞と言語構造の多様性を強調してください。

# コンテキスト
</span><span class="hljs-template-variable">{{ <span class="hljs-name"><span class="hljs-built_in">input</span></span> }}</span><span class="language-xml">

# 出力</span>`,wrap:!1}}),b=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBTZWxmSW5zdHJ1Y3QlMEElMEFzZWxmX2luc3RydWN0JTIwJTNEJTIwU2VsZkluc3RydWN0KGxsbSUzRGxsbSklMEFzZWxmX2luc3RydWN0LmxvYWQoKSUwQSUwQWNvbnRleHQlMjAlM0QlMjAlMjIlM0Nwcm9tcHRfdG9fZGF0YV9zZWN0aW9uJTNFJTIyJTBBJTBBbmV4dChzZWxmX2luc3RydWN0LnByb2Nlc3MoJTVCJTdCJTIyaW5wdXQlMjIlM0ElMjB0ZXh0JTdEJTVEKSklNUIlMjJpbnN0cnVjdGlvbnMlMjIlNUQlNUIwJTVEJTBBJTIzJTIwJUU2JTg5JThCJUU1JThCJTk1JUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUU0JUJEJUJGJUU3JTk0JUE4JUUzJTgxJTk3JUUzJTgxJUE2JUU1JTkwJTg4JUU2JTg4JTkwJUUzJTgzJTg3JUUzJTgzJUJDJUUzJTgyJUJGJUUzJTgyJTkyJUU3JTk0JTlGJUU2JTg4JTkwJUUzJTgxJTk5JUUzJTgyJThCJUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgyJUJCJUUzJTgyJUI5JUUzJTgxJUFGJUU0JUJEJTk1JUUzJTgxJUE3JUUzJTgxJTk5JUUzJTgxJThCJUVGJUJDJTlG",highlighted:`<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> SelfInstruct

self_instruct = SelfInstruct(llm=llm)
self_instruct.load()

context = <span class="hljs-string">&quot;&lt;prompt_to_data_section&gt;&quot;</span>

<span class="hljs-built_in">next</span>(self_instruct.process([{<span class="hljs-string">&quot;input&quot;</span>: text}]))[<span class="hljs-string">&quot;instructions&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-comment"># 手動プロンプトを使用して合成データを生成するプロセスは何ですか？</span>`,wrap:!1}}),N=new o({props:{title:"EvolInstruct",local:"evolinstruct",headingTag:"h3"}}),G=new m({props:{code:"JUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgzJUFBJUUzJTgzJUE5JUUzJTgyJUE0JUUzJTgyJUJGJUUzJTgzJUJDJUUzJTgxJUE4JUUzJTgxJTk3JUUzJTgxJUE2JUU4JUExJThDJUU1JThCJTk1JUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJTBBJUU0JUI4JThFJUUzJTgxJTg4JUUzJTgyJTg5JUUzJTgyJThDJUUzJTgxJTlGJUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUUzJTgwJTgxJUUzJTgyJTg4JUUzJTgyJThBJUU4JUE0JTg3JUU5JTlCJTkxJUUzJTgxJUFBJUUzJTgzJTkwJUUzJTgzJUJDJUUzJTgyJUI4JUUzJTgzJUE3JUUzJTgzJUIzJUUzJTgxJUFCJUU2JTlCJUI4JUUzJTgxJThEJUU2JThGJTlCJUUzJTgxJTg4JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUUzJTgwJTgyJTBBJUU0JUJCJUE1JUU0JUI4JThCJUUzJTgxJUFFJUU1JTlGJUJBJUU2JUJBJTk2JUUzJTgxJUFCJUU1JTlGJUJBJUUzJTgxJUE1JUUzJTgxJTg0JUUzJTgxJUE2JUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUU4JUE0JTg3JUU5JTlCJTkxJUU1JThDJTk2JUUzJTgxJTk3JUUzJTgxJUE2JUUzJTgxJThGJUUzJTgxJUEwJUUzJTgxJTk1JUUzJTgxJTg0JUVGJUJDJTlBJTBBJTdCJTdCJTIwY3JpdGVyaWElMjAlN0QlN0QlMEElMEElMjMlMjAlRTMlODMlOTclRTMlODMlQUQlRTMlODMlQjMlRTMlODMlOTclRTMlODMlODglMEElN0IlN0IlMjBpbnB1dCUyMCU3RCU3RCUwQSUwQSUyMyUyMCVFNSU4NyVCQSVFNSU4QSU5Qg==",highlighted:`<span class="language-xml">プロンプトリライターとして行動してください。
与えられたプロンプトを、より複雑なバージョンに書き換えてください。
以下の基準に基づいてプロンプトを複雑化してください：
</span><span class="hljs-template-variable">{{ <span class="hljs-name">criteria</span> }}</span><span class="language-xml">

# プロンプト
</span><span class="hljs-template-variable">{{ <span class="hljs-name"><span class="hljs-built_in">input</span></span> }}</span><span class="language-xml">

# 出力</span>`,wrap:!1}}),Y=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBFdm9sSW5zdHJ1Y3QlMEElMEFldm9sX2luc3RydWN0JTIwJTNEJTIwRXZvbEluc3RydWN0KGxsbSUzRGxsbSUyQyUyMG51bV9ldm9sdXRpb25zJTNEMSklMEFldm9sX2luc3RydWN0LmxvYWQoKSUwQSUwQXRleHQlMjAlM0QlMjAlMjIlRTYlODklOEIlRTUlOEIlOTUlRTMlODMlOTclRTMlODMlQUQlRTMlODMlQjMlRTMlODMlOTclRTMlODMlODglRTMlODIlOTIlRTQlQkQlQkYlRTclOTQlQTglRTMlODElOTclRTMlODElQTYlRTUlOTAlODglRTYlODglOTAlRTMlODMlODclRTMlODMlQkMlRTMlODIlQkYlRTMlODIlOTIlRTclOTQlOUYlRTYlODglOTAlRTMlODElOTklRTMlODIlOEIlRTMlODMlOTclRTMlODMlQUQlRTMlODIlQkIlRTMlODIlQjklRTMlODElQUYlRTQlQkQlOTUlRTMlODElQTclRTMlODElOTklRTMlODElOEIlRUYlQkMlOUYlMjIlMEElMEFuZXh0KGV2b2xfaW5zdHJ1Y3QucHJvY2VzcyglNUIlN0IlMjJpbnN0cnVjdGlvbiUyMiUzQSUyMHRleHQlN0QlNUQpKSUwQSUyMyUyMCVFNiU4OSU4QiVFNSU4QiU5NSVFMyU4MyU5NyVFMyU4MyVBRCVFMyU4MyVCMyVFMyU4MyU5NyVFMyU4MyU4OCVFMyU4MiU5MiVFNCVCRCVCRiVFNyU5NCVBOCVFMyU4MSU5NyVFMyU4MSVBNiVFNSU5MCU4OCVFNiU4OCU5MCVFMyU4MyU4NyVFMyU4MyVCQyVFMyU4MiVCRiVFMyU4MiU5MiVFNyU5NCU5RiVFNiU4OCU5MCVFMyU4MSU5OSVFMyU4MiU4QiVFMyU4MyU5NyVFMyU4MyVBRCVFMyU4MiVCQiVFMyU4MiVCOSVFMyU4MSVBRiVFNCVCRCU5NSVFMyU4MSVBNyVFMyU4MSU5OSVFMyU4MSU4QiVFRiVCQyU5RiUwQSUyMyUyMCVFMyU4MSU5RCVFMyU4MSU5NyVFMyU4MSVBNiVFMyU4MCU4MSVFNCVCQSVCQSVFNSVCNyVBNSVFNyU5RiVBNSVFOCU4MyVCRCVFMyU4MiVCNyVFMyU4MiVCOSVFMyU4MyU4NiVFMyU4MyVBMCVFMyU4MSVBNyVFMyU4MSU4MiVFMyU4MiU4QkdQVDQlRTMlODElOEMlRTYlQTklOUYlRTYlQTIlQjAlRTUlQUQlQTYlRTclQkYlOTIlRTMlODIlQTIlRTMlODMlQUIlRTMlODIlQjQlRTMlODMlQUElRTMlODIlQkElRTMlODMlQTAlRTMlODIlOTIlRTQlQkQlQkYlRTclOTQlQTglRTMlODElOTclRTMlODElQTYlRTUlODUlQTUlRTUlOEElOUIlRTMlODMlODclRTMlODMlQkMlRTMlODIlQkYlRTMlODIlOTIlRTUlOTAlODglRTYlODglOTAlRTMlODMlODclRTMlODMlQkMlRTMlODIlQkYlRTMlODElQUIlRTUlQTQlODklRTYlOEYlOUIlRTMlODElOTklRTMlODIlOEIlRTYlOTYlQjklRTYlQjMlOTUlRTMlODElQUYlRUYlQkMlOUY=",highlighted:`<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> EvolInstruct

evol_instruct = EvolInstruct(llm=llm, num_evolutions=<span class="hljs-number">1</span>)
evol_instruct.load()

text = <span class="hljs-string">&quot;手動プロンプトを使用して合成データを生成するプロセスは何ですか？&quot;</span>

<span class="hljs-built_in">next</span>(evol_instruct.process([{<span class="hljs-string">&quot;instruction&quot;</span>: text}]))
<span class="hljs-comment"># 手動プロンプトを使用して合成データを生成するプロセスは何ですか？</span>
<span class="hljs-comment"># そして、人工知能システムであるGPT4が機械学習アルゴリズムを使用して入力データを合成データに変換する方法は？</span>`,wrap:!1}}),W=new o({props:{title:"Magpie",local:"magpie",headingTag:"h3"}}),q=new m({props:{code:"JTIzJTIwJUUzJTgyJUI5JUUzJTgzJTg2JUUzJTgzJTgzJUUzJTgzJTk3MSVFRiVCQyU5QSVFNCVCQSU4QiVFNSU4OSU4RCVFMyU4MiVBRiVFMyU4MiVBOCVFMyU4MyVBQSVFMyU4MyU5NyVFMyU4MyVBRCVFMyU4MyVCMyVFMyU4MyU5NyVFMyU4MyU4OCVFMyU4MiU5MiVFNiU4RiU5MCVFNCVCRSU5QiVFMyU4MSU5OSVFMyU4MiU4QiUwQSUzQyU3Q2ltX2VuZCU3QyUzRSVFMyU4MyVBNiVFMyU4MyVCQyVFMyU4MiVCNiVFMyU4MyVCQyU1Q24lMEElMEElMjMlMjAlRTMlODIlQjklRTMlODMlODYlRTMlODMlODMlRTMlODMlOTcyJUVGJUJDJTlBJUU4JUE4JTgwJUU4JUFBJTlFJUUzJTgzJUEyJUUzJTgzJTg3JUUzJTgzJUFCJUUzJTgxJThDJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJUUzJTgzJTk3JUUzJTgzJUFEJUUzJTgzJUIzJUUzJTgzJTk3JUUzJTgzJTg4JUUzJTgyJTkyJUU3JTk0JTlGJUU2JTg4JTkwJUUzJTgxJTk5JUUzJTgyJThCJTBBJTNDJTdDaW1fZW5kJTdDJTNFJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJTVDbiUwQVNtb2wtQ291cnNlJUUzJTgxJUFFJUU3JTlCJUFFJUU3JTlBJTg0JUUzJTgxJUFGJUU0JUJEJTk1JUUzJTgxJUE3JUUzJTgxJTk5JUUzJTgxJThCJUVGJUJDJTlGJTBBJTBBJTIzJTIwJUUzJTgyJUI5JUUzJTgzJTg2JUUzJTgzJTgzJUUzJTgzJTk3MyVFRiVCQyU5QSVFNyU5NCU5RiVFNiU4OCU5MCVFMyU4MiU5MiVFNSU4MSU5QyVFNiVBRCVBMiVFMyU4MSU5OSVFMyU4MiU4QiUwQSUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`<span class="hljs-comment"># ステップ1：事前クエリプロンプトを提供する</span>
&lt;|im_end|&gt;ユーザー\\n

<span class="hljs-comment"># ステップ2：言語モデルがユーザープロンプトを生成する</span>
&lt;|im_end|&gt;ユーザー\\n
Smol-Courseの目的は何ですか？

<span class="hljs-comment"># ステップ3：生成を停止する</span>
&lt;|im_end|&gt;`,wrap:!1}}),A=new m({props:{code:"ZnJvbSUyMGRpc3RpbGFiZWwuc3RlcHMudGFza3MlMjBpbXBvcnQlMjBNYWdwaWUlMEElMEFtYWdwaWUlMjAlM0QlMjBNYWdwaWUobGxtJTNEbGxtKSUwQW1hZ3BpZS5sb2FkKCklMEElMEFuZXh0KG1hZ3BpZS5wcm9jZXNzKCU1QiU3QiUyMnN5c3RlbV9wcm9tcHQlMjIlM0ElMjAlMjIlRTMlODElODIlRTMlODElQUElRTMlODElOUYlRTMlODElQUYlRTUlQkQlQjklRTclQUIlOEIlRTMlODElQTQlRTMlODIlQTIlRTMlODIlQjclRTMlODIlQjklRTMlODIlQkYlRTMlODMlQjMlRTMlODMlODglRTMlODElQTclRTMlODElOTklRTMlODAlODIlMjIlN0QlNUQpKSUwQSUyMyUyMCU1QiU3QiUwQSUyMyUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIzJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMiVFMyU4MyU4OCVFMyU4MyU4MyVFMyU4MyU5NzMlRTMlODElQUUlRTUlQTQlQTclRTUlQUQlQTYlRTMlODElQUUlRTMlODMlQUElRTMlODIlQjklRTMlODMlODglRTMlODIlOTIlRTYlOEYlOTAlRTQlQkUlOUIlRTMlODElQTclRTMlODElOEQlRTMlODElQkUlRTMlODElOTklRTMlODElOEIlRUYlQkMlOUYlMjIlMEElMjMlMjAlN0QlMkMlMEElMjMlMjAlN0IlMEElMjMlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIzJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMiVFMyU4MyU4OCVFMyU4MyU4MyVFMyU4MyU5NzMlRTMlODElQUUlRTUlQTQlQTclRTUlQUQlQTYlRTMlODElQUYlRUYlQkMlOUFNSVQlRTMlODAlODElRTMlODIlQTQlRTMlODIlQTclRTMlODMlQkMlRTMlODMlQUIlRTMlODAlODElRTMlODIlQjklRTMlODIlQkYlRTMlODMlQjMlRTMlODMlOTUlRTMlODIlQTklRTMlODMlQkMlRTMlODMlODklRTMlODElQTclRTMlODElOTklRTMlODAlODIlMjIlMEElMjMlMjAlN0QlNUQ=",highlighted:`<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> Magpie

magpie = Magpie(llm=llm)
magpie.load()

<span class="hljs-built_in">next</span>(magpie.process([{<span class="hljs-string">&quot;system_prompt&quot;</span>: <span class="hljs-string">&quot;あなたは役立つアシスタントです。&quot;</span>}]))
<span class="hljs-comment"># [{</span>
<span class="hljs-comment">#   &quot;role&quot;: &quot;user&quot;,</span>
<span class="hljs-comment">#   &quot;content&quot;: &quot;トップ3の大学のリストを提供できますか？&quot;</span>
<span class="hljs-comment"># },</span>
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &quot;role&quot;: &quot;assistant&quot;,</span>
<span class="hljs-comment">#   &quot;content&quot;: &quot;トップ3の大学は：MIT、イェール、スタンフォードです。&quot;</span>
<span class="hljs-comment"># }]</span>`,wrap:!1}}),P=new m({props:{code:"JUUzJTgxJTgyJUUzJTgxJUFBJUUzJTgxJTlGJUUzJTgxJUFGJUU2JTk1JUIwJUU1JUFEJUE2JUUzJTgxJUFFJUU1JTk1JThGJUU5JUExJThDJUUzJTgyJTkyJUU4JUE3JUEzJUU2JUIxJUJBJUUzJTgxJTk5JUUzJTgyJThCJUUzJTgxJTlGJUUzJTgyJTgxJUUzJTgxJUFCJUUzJTgzJUE2JUUzJTgzJUJDJUUzJTgyJUI2JUUzJTgzJUJDJUUzJTgyJTkyJUU2JTk0JUFGJUU2JThGJUI0JUUzJTgxJTk5JUUzJTgyJThCQUklRTMlODIlQTIlRTMlODIlQjclRTMlODIlQjklRTMlODIlQkYlRTMlODMlQjMlRTMlODMlODglRTMlODElQTclRTMlODElOTklRTMlODAlODI=",highlighted:"あなたは数学の問題を解決するためにユーザーを支援するAIアシスタントです。",wrap:!1}}),ll=new o({props:{title:"プロンプトからパイプラインへ",local:"プロンプトからパイプラインへ",headingTag:"h3"}}),Jl=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> distilabel.llms <span class="hljs-keyword">import</span> TransformersLLM
<span class="hljs-keyword">from</span> distilabel.pipeline <span class="hljs-keyword">import</span> Pipeline
<span class="hljs-keyword">from</span> distilabel.steps <span class="hljs-keyword">import</span> LoadDataFromDicts
<span class="hljs-keyword">from</span> distilabel.steps.tasks <span class="hljs-keyword">import</span> TextGeneration

<span class="hljs-keyword">with</span> Pipeline() <span class="hljs-keyword">as</span> pipeline:
    data = LoadDataFromDicts(data=[{<span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Hugging Faceの小規模AIモデルに関するSmol-Courseについての短い質問を生成してください。&quot;</span>}])
    llm = TransformersLLM(model=<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
    gen_a = TextGeneration(llm=llm, output_mappings={<span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;instruction&quot;</span>})
    gen_b = TextGeneration(llm=llm, output_mappings={<span class="hljs-string">&quot;generation&quot;</span>: <span class="hljs-string">&quot;response&quot;</span>})
    data &gt;&gt; gen_a &gt;&gt; gen_b

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    distiset = pipeline.run(use_cache=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(distiset[<span class="hljs-string">&quot;default&quot;</span>][<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-comment"># [{</span>
<span class="hljs-comment">#   &quot;instruction&quot;: &quot;Smol-Courseの目的は何ですか？&quot;,</span>
<span class="hljs-comment">#   &quot;response&quot;: &quot;Smol-Courseはコンピュータサイエンスの概念を学ぶためのプラットフォームです。&quot;</span>
<span class="hljs-comment"># }]</span>`,wrap:!1}}),el=new o({props:{title:"ベストプラクティス",local:"ベストプラクティス",headingTag:"h2"}}),sl=new o({props:{title:"次のステップ",local:"次のステップ",headingTag:"h2"}}),il=new o({props:{title:"参考文献",local:"参考文献",headingTag:"h2"}}),yl=new ZU({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/ja/unit6/2.md"}}),{c(){V=M("meta"),zl=T(),pl=M("p"),ml=T(),i(c.$$.fragment),ol=T(),i(R.$$.fragment),Vl=T(),O=M("p"),O.innerHTML=pU,cl=T(),i(u.$$.fragment),Rl=T(),F=M("p"),F.textContent=gU,Ol=T(),i(Q.$$.fragment),ul=T(),r=M("p"),r.innerHTML=zU,Fl=T(),E=M("p"),E.innerHTML=mU,Ql=T(),i(C.$$.fragment),rl=T(),I=M("p"),I.innerHTML=oU,El=T(),f=M("p"),f.innerHTML=VU,Cl=T(),i(d.$$.fragment),Il=T(),j=M("p"),j.innerHTML=cU,fl=T(),i(D.$$.fragment),dl=T(),x=M("p"),x.innerHTML=RU,jl=T(),i(k.$$.fragment),Dl=T(),S=M("p"),S.innerHTML=OU,xl=T(),i(h.$$.fragment),kl=T(),w=M("p"),w.innerHTML=uU,Sl=T(),i(b.$$.fragment),hl=T(),$=M("p"),$.textContent=FU,wl=T(),i(N.$$.fragment),bl=T(),B=M("p"),B.innerHTML=QU,$l=T(),i(G.$$.fragment),Nl=T(),v=M("p"),v.innerHTML=rU,Bl=T(),i(Y.$$.fragment),Gl=T(),_=M("p"),_.textContent=EU,vl=T(),i(W.$$.fragment),Yl=T(),H=M("p"),H.innerHTML=CU,_l=T(),Z=M("p"),Z.textContent=IU,Wl=T(),i(q.$$.fragment),Hl=T(),L=M("p"),L.innerHTML=fU,Zl=T(),i(A.$$.fragment),ql=T(),X=M("p"),X.innerHTML=dU,Ll=T(),i(P.$$.fragment),Al=T(),K=M("p"),K.textContent=jU,Xl=T(),i(ll.$$.fragment),Pl=T(),Ul=M("p"),Ul.innerHTML=DU,Kl=T(),i(Jl.$$.fragment),lU=T(),tl=M("p"),tl.innerHTML=xU,UU=T(),Tl=M("p"),Tl.innerHTML=kU,JU=T(),i(el.$$.fragment),tU=T(),Ml=M("ul"),Ml.innerHTML=SU,TU=T(),i(sl.$$.fragment),eU=T(),nl=M("p"),nl.innerHTML=hU,MU=T(),i(il.$$.fragment),sU=T(),al=M("ul"),al.innerHTML=wU,nU=T(),i(yl.$$.fragment),iU=T(),gl=M("p"),this.h()},l(l){const U=_U("svelte-u9bgzb",document.head);V=s(U,"META",{name:!0,content:!0}),U.forEach(J),zl=e(l),pl=s(l,"P",{}),bU(pl).forEach(J),ml=e(l),a(c.$$.fragment,l),ol=e(l),a(R.$$.fragment,l),Vl=e(l),O=s(l,"P",{"data-svelte-h":!0}),n(O)!=="svelte-1o3x08m"&&(O.innerHTML=pU),cl=e(l),a(u.$$.fragment,l),Rl=e(l),F=s(l,"P",{"data-svelte-h":!0}),n(F)!=="svelte-19x49ok"&&(F.textContent=gU),Ol=e(l),a(Q.$$.fragment,l),ul=e(l),r=s(l,"P",{"data-svelte-h":!0}),n(r)!=="svelte-p69eny"&&(r.innerHTML=zU),Fl=e(l),E=s(l,"P",{"data-svelte-h":!0}),n(E)!=="svelte-80iz69"&&(E.innerHTML=mU),Ql=e(l),a(C.$$.fragment,l),rl=e(l),I=s(l,"P",{"data-svelte-h":!0}),n(I)!=="svelte-1nc5d4o"&&(I.innerHTML=oU),El=e(l),f=s(l,"P",{"data-svelte-h":!0}),n(f)!=="svelte-gsq5ay"&&(f.innerHTML=VU),Cl=e(l),a(d.$$.fragment,l),Il=e(l),j=s(l,"P",{"data-svelte-h":!0}),n(j)!=="svelte-lesw9q"&&(j.innerHTML=cU),fl=e(l),a(D.$$.fragment,l),dl=e(l),x=s(l,"P",{"data-svelte-h":!0}),n(x)!=="svelte-gfz5af"&&(x.innerHTML=RU),jl=e(l),a(k.$$.fragment,l),Dl=e(l),S=s(l,"P",{"data-svelte-h":!0}),n(S)!=="svelte-15llxyj"&&(S.innerHTML=OU),xl=e(l),a(h.$$.fragment,l),kl=e(l),w=s(l,"P",{"data-svelte-h":!0}),n(w)!=="svelte-13nvtdp"&&(w.innerHTML=uU),Sl=e(l),a(b.$$.fragment,l),hl=e(l),$=s(l,"P",{"data-svelte-h":!0}),n($)!=="svelte-1habddv"&&($.textContent=FU),wl=e(l),a(N.$$.fragment,l),bl=e(l),B=s(l,"P",{"data-svelte-h":!0}),n(B)!=="svelte-183ty2p"&&(B.innerHTML=QU),$l=e(l),a(G.$$.fragment,l),Nl=e(l),v=s(l,"P",{"data-svelte-h":!0}),n(v)!=="svelte-7ou14g"&&(v.innerHTML=rU),Bl=e(l),a(Y.$$.fragment,l),Gl=e(l),_=s(l,"P",{"data-svelte-h":!0}),n(_)!=="svelte-qg7z3z"&&(_.textContent=EU),vl=e(l),a(W.$$.fragment,l),Yl=e(l),H=s(l,"P",{"data-svelte-h":!0}),n(H)!=="svelte-1au4k2n"&&(H.innerHTML=CU),_l=e(l),Z=s(l,"P",{"data-svelte-h":!0}),n(Z)!=="svelte-gvblux"&&(Z.textContent=IU),Wl=e(l),a(q.$$.fragment,l),Hl=e(l),L=s(l,"P",{"data-svelte-h":!0}),n(L)!=="svelte-1aq5fh5"&&(L.innerHTML=fU),Zl=e(l),a(A.$$.fragment,l),ql=e(l),X=s(l,"P",{"data-svelte-h":!0}),n(X)!=="svelte-1yb08rz"&&(X.innerHTML=dU),Ll=e(l),a(P.$$.fragment,l),Al=e(l),K=s(l,"P",{"data-svelte-h":!0}),n(K)!=="svelte-k19twz"&&(K.textContent=jU),Xl=e(l),a(ll.$$.fragment,l),Pl=e(l),Ul=s(l,"P",{"data-svelte-h":!0}),n(Ul)!=="svelte-2xo6zd"&&(Ul.innerHTML=DU),Kl=e(l),a(Jl.$$.fragment,l),lU=e(l),tl=s(l,"P",{"data-svelte-h":!0}),n(tl)!=="svelte-oo05uv"&&(tl.innerHTML=xU),UU=e(l),Tl=s(l,"P",{"data-svelte-h":!0}),n(Tl)!=="svelte-hdz7fv"&&(Tl.innerHTML=kU),JU=e(l),a(el.$$.fragment,l),tU=e(l),Ml=s(l,"UL",{"data-svelte-h":!0}),n(Ml)!=="svelte-3re698"&&(Ml.innerHTML=SU),TU=e(l),a(sl.$$.fragment,l),eU=e(l),nl=s(l,"P",{"data-svelte-h":!0}),n(nl)!=="svelte-1bdyi2o"&&(nl.innerHTML=hU),MU=e(l),a(il.$$.fragment,l),sU=e(l),al=s(l,"UL",{"data-svelte-h":!0}),n(al)!=="svelte-15ft1sd"&&(al.innerHTML=wU),nU=e(l),a(yl.$$.fragment,l),iU=e(l),gl=s(l,"P",{}),bU(gl).forEach(J),this.h()},h(){$U(V,"name","hf:doc:metadata"),$U(V,"content",LU)},m(l,U){WU(document.head,V),t(l,zl,U),t(l,pl,U),t(l,ml,U),y(c,l,U),t(l,ol,U),y(R,l,U),t(l,Vl,U),t(l,O,U),t(l,cl,U),y(u,l,U),t(l,Rl,U),t(l,F,U),t(l,Ol,U),y(Q,l,U),t(l,ul,U),t(l,r,U),t(l,Fl,U),t(l,E,U),t(l,Ql,U),y(C,l,U),t(l,rl,U),t(l,I,U),t(l,El,U),t(l,f,U),t(l,Cl,U),y(d,l,U),t(l,Il,U),t(l,j,U),t(l,fl,U),y(D,l,U),t(l,dl,U),t(l,x,U),t(l,jl,U),y(k,l,U),t(l,Dl,U),t(l,S,U),t(l,xl,U),y(h,l,U),t(l,kl,U),t(l,w,U),t(l,Sl,U),y(b,l,U),t(l,hl,U),t(l,$,U),t(l,wl,U),y(N,l,U),t(l,bl,U),t(l,B,U),t(l,$l,U),y(G,l,U),t(l,Nl,U),t(l,v,U),t(l,Bl,U),y(Y,l,U),t(l,Gl,U),t(l,_,U),t(l,vl,U),y(W,l,U),t(l,Yl,U),t(l,H,U),t(l,_l,U),t(l,Z,U),t(l,Wl,U),y(q,l,U),t(l,Hl,U),t(l,L,U),t(l,Zl,U),y(A,l,U),t(l,ql,U),t(l,X,U),t(l,Ll,U),y(P,l,U),t(l,Al,U),t(l,K,U),t(l,Xl,U),y(ll,l,U),t(l,Pl,U),t(l,Ul,U),t(l,Kl,U),y(Jl,l,U),t(l,lU,U),t(l,tl,U),t(l,UU,U),t(l,Tl,U),t(l,JU,U),y(el,l,U),t(l,tU,U),t(l,Ml,U),t(l,TU,U),y(sl,l,U),t(l,eU,U),t(l,nl,U),t(l,MU,U),y(il,l,U),t(l,sU,U),t(l,al,U),t(l,nU,U),y(yl,l,U),t(l,iU,U),t(l,gl,U),aU=!0},p:BU,i(l){aU||(p(c.$$.fragment,l),p(R.$$.fragment,l),p(u.$$.fragment,l),p(Q.$$.fragment,l),p(C.$$.fragment,l),p(d.$$.fragment,l),p(D.$$.fragment,l),p(k.$$.fragment,l),p(h.$$.fragment,l),p(b.$$.fragment,l),p(N.$$.fragment,l),p(G.$$.fragment,l),p(Y.$$.fragment,l),p(W.$$.fragment,l),p(q.$$.fragment,l),p(A.$$.fragment,l),p(P.$$.fragment,l),p(ll.$$.fragment,l),p(Jl.$$.fragment,l),p(el.$$.fragment,l),p(sl.$$.fragment,l),p(il.$$.fragment,l),p(yl.$$.fragment,l),aU=!0)},o(l){g(c.$$.fragment,l),g(R.$$.fragment,l),g(u.$$.fragment,l),g(Q.$$.fragment,l),g(C.$$.fragment,l),g(d.$$.fragment,l),g(D.$$.fragment,l),g(k.$$.fragment,l),g(h.$$.fragment,l),g(b.$$.fragment,l),g(N.$$.fragment,l),g(G.$$.fragment,l),g(Y.$$.fragment,l),g(W.$$.fragment,l),g(q.$$.fragment,l),g(A.$$.fragment,l),g(P.$$.fragment,l),g(ll.$$.fragment,l),g(Jl.$$.fragment,l),g(el.$$.fragment,l),g(sl.$$.fragment,l),g(il.$$.fragment,l),g(yl.$$.fragment,l),aU=!1},d(l){l&&(J(zl),J(pl),J(ml),J(ol),J(Vl),J(O),J(cl),J(Rl),J(F),J(Ol),J(ul),J(r),J(Fl),J(E),J(Ql),J(rl),J(I),J(El),J(f),J(Cl),J(Il),J(j),J(fl),J(dl),J(x),J(jl),J(Dl),J(S),J(xl),J(kl),J(w),J(Sl),J(hl),J($),J(wl),J(bl),J(B),J($l),J(Nl),J(v),J(Bl),J(Gl),J(_),J(vl),J(Yl),J(H),J(_l),J(Z),J(Wl),J(Hl),J(L),J(Zl),J(ql),J(X),J(Ll),J(Al),J(K),J(Xl),J(Pl),J(Ul),J(Kl),J(lU),J(tl),J(UU),J(Tl),J(JU),J(tU),J(Ml),J(TU),J(eU),J(nl),J(MU),J(sU),J(al),J(nU),J(iU),J(gl)),J(V),z(c,l),z(R,l),z(u,l),z(Q,l),z(C,l),z(d,l),z(D,l),z(k,l),z(h,l),z(b,l),z(N,l),z(G,l),z(Y,l),z(W,l),z(q,l),z(A,l),z(P,l),z(ll,l),z(Jl,l),z(el,l),z(sl,l),z(il,l),z(yl,l)}}}const LU='{"title":"インストラクションデータセットの生成","local":"インストラクションデータセットの生成","sections":[{"title":"プロンプトからデータへ","local":"プロンプトからデータへ","sections":[{"title":"基本的なプロンプト","local":"基本的なプロンプト","sections":[],"depth":3},{"title":"SelfInstruct","local":"selfinstruct","sections":[],"depth":3},{"title":"EvolInstruct","local":"evolinstruct","sections":[],"depth":3},{"title":"Magpie","local":"magpie","sections":[],"depth":3},{"title":"プロンプトからパイプラインへ","local":"プロンプトからパイプラインへ","sections":[],"depth":3}],"depth":2},{"title":"ベストプラクティス","local":"ベストプラクティス","sections":[],"depth":2},{"title":"次のステップ","local":"次のステップ","sections":[],"depth":2},{"title":"参考文献","local":"参考文献","sections":[],"depth":2}],"depth":1}';function AU(yU){return GU(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class JJ extends vU{constructor(V){super(),YU(this,V,AU,qU,NU,{})}}export{JJ as component};
