import{s as Vi,n as Wi,o as Xi}from"../chunks/scheduler.0219f8bd.js";import{S as Yi,i as Zi,g as o,s as a,r as m,A as ts,h as i,f as l,c as d,j as u,u as f,x as s,k as n,y as es,a as r,v as p,d as h,t as c,w as T}from"../chunks/index.f61edf3b.js";import{H as y,E as ls}from"../chunks/EditOnGithub.48fa589f.js";function rs(mo){let v,ml,nl,fl,_,pl,F,hl,b,fo="Helper module for mathematical processing.",cl,x,po=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Tl,$,ho='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.permute_data"><code>.permute_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.bankers_round"><code>.bankers_round(x)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',yl,vl,_l,P,Fl,A,bl,C,co='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',xl,H,To="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",$l,Pl,Al,L,Cl,M,Hl,w,yo="Helper method to permute a <code>AnyTypedArray</code> directly",Ll,g,vo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The permuted array and the new shape.',Ml,E,_o="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",wl,gl,El,R,Rl,z,zl,k,Fo="Compute the softmax of an array of numbers.",kl,O,bo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The softmax array.',Ol,K,xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",Kl,jl,Bl,j,Dl,B,Ul,D,$o="Calculates the logarithm of the softmax function for the input array.",Il,U,Po='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The resulting log_softmax array.',ql,I,Ao="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Nl,Sl,Gl,q,Jl,N,Ql,S,Co="Calculates the dot product of two arrays.",Vl,G,Ho='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',Wl,J,Lo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",Xl,Yl,Zl,Q,tr,V,er,W,Mo="Computes the cosine similarity between two arrays.",lr,X,wo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',rr,Y,go="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",ar,dr,or,Z,ir,tt,sr,et,Eo="Calculates the magnitude of a given array.",nr,lt,Ro='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',ur,rt,zo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",mr,fr,pr,at,hr,dt,cr,ot,ko="Returns the value and index of the minimum element in an array.",Tr,it,Oo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',yr,st,Ko="<li><code>Error</code> If array is empty.</li>",vr,nt,jo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",_r,Fr,br,ut,xr,mt,$r,ft,Bo="Returns the value and index of the maximum element in an array.",Pr,pt,Do='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',Ar,ht,Uo="<li><code>Error</code> If array is empty.</li>",Cr,ct,Io="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>AnyTypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Hr,Lr,Mr,Tt,wr,yt,gr,vt,qo="Performs median filter on the provided data. Padding is done by mirroring the data.",Er,_t,No='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Rr,Ft,So="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",zr,kr,Or,bt,Kr,xt,jr,$t,Go="Helper function to round a number to a given number of decimals",Br,Pt,Jo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Dr,At,Qo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",Ur,Ir,qr,Ct,Nr,Ht,Sr,Lt,Vo=`Helper function to round a number to the nearest integer, with ties rounded to the nearest even number.
Also known as “bankers’ rounding”. This is the default rounding mode in python. For example:
1.5 rounds to 2 and 2.5 rounds to 2.`,Gr,Mt,Wo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Jr,wt,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>x</td><td><code>number</code></td><td><p>The number to round</p></td></tr></tbody>",Qr,Vr,Wr,gt,Xr,Et,Yr,Rt,Yo="Implementation of Radix-4 FFT.",Zr,zt,Zo=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,ta,kt,ti='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',ea,Ot,ei='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',la,ra,aa,Kt,da,jt,oa,Bt,li="<strong>Throws</strong>:",ia,Dt,ri="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",sa,Ut,ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",na,ua,ma,It,fa,qt,pa,Nt,di="Create a complex number array with size <code>2 * size</code>",ha,St,oi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',ca,Ta,ya,Gt,va,Jt,_a,Qt,ii="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Fa,Vt,si='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',ba,Wt,ni="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",xa,$a,Pa,Xt,Aa,Yt,Ca,Zt,ui="Convert a real-valued input array to a complex-valued output array.",Ha,te,mi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',La,ee,fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Ma,wa,ga,le,Ea,re,Ra,ae,pi="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",za,de,hi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ka,oe,ci="<li><code>Error</code> Input and output buffers must be different.</li>",Oa,ie,Ti="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Ka,ja,Ba,se,Da,ne,Ua,ue,yi=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,Ia,me,vi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',qa,fe,_i="<li><code>Error</code> If the input and output buffers are the same.</li>",Na,pe,Fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",Sa,Ga,Ja,he,Qa,ce,Va,Te,bi=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,Wa,ye,xi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',Xa,ve,$i="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",Ya,_e,Pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Za,td,ed,Fe,ld,be,rd,xe,Ai="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",ad,$e,Ci='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',dd,Pe,Hi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",od,id,sd,Ae,nd,Ce,ud,He,Li="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",md,Le,Mi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',fd,Me,wi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",pd,hd,cd,we,Td,ge,yd,Ee,gi="Performs radix-4 transformation on input data of length 8",vd,Re,Ei='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',_d,ze,Ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",Fd,bd,xd,ke,$d,Oe,Pd,Ke,zi="Real input radix-4 implementation",Ad,je,ki='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Cd,Be,Oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Hd,Ld,Md,De,wd,Ue,gd,Ie,Ki="Performs a single real input radix-2 transformation on the provided data",Ed,qe,ji='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Rd,Ne,Bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",zd,kd,Od,Se,Kd,Ge,jd,Je,Di=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,Bd,Qe,Ui='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Dd,Ve,Ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",Ud,Id,qd,We,Nd,Xe,Sd,Ye,qi=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,Gd,Ze,Ni='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',Jd,tl,Si='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',Qd,Vd,Wd,el,Xd,ll,Yd,rl,Gi="Constructs a new NP2FFT object.",Zd,al,Ji="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",to,eo,lo,dl,ro,ol,ao,il,Qi='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',oo,io,so,sl,no,ul,uo;return F=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),A=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathspermutedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> T </code>",local:"utilsmathssoftmaxarr--code-t-code",headingTag:"h2"}}),B=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> T </code>",local:"utilsmathslogsoftmaxarr--code-t-code",headingTag:"h2"}}),N=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),dt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),mt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> * </code>",local:"utilsmathsmaxarr--code--code",headingTag:"h2"}}),yt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),xt=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.bankers_round(x) ⇒ <code> number </code>",local:"utilsmathsbankersroundx--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),jt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),qt=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Jt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),re=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),ne=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),ce=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),be=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),Oe=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Ue=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),Xe=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),ll=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),ol=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),sl=new ls({props:{source:"https://github.com/xenova/transformers.js/blob/main/docs/source/api/utils/maths.md"}}),{c(){v=o("meta"),ml=a(),nl=o("p"),fl=a(),_=o("a"),pl=a(),m(F.$$.fragment),hl=a(),b=o("p"),b.textContent=fo,cl=a(),x=o("p"),x.textContent=po,Tl=a(),$=o("ul"),$.innerHTML=ho,yl=a(),vl=o("hr"),_l=a(),P=o("a"),Fl=a(),m(A.$$.fragment),bl=a(),C=o("p"),C.innerHTML=co,xl=a(),H=o("table"),H.innerHTML=To,$l=a(),Pl=o("hr"),Al=a(),L=o("a"),Cl=a(),m(M.$$.fragment),Hl=a(),w=o("p"),w.innerHTML=yo,Ll=a(),g=o("p"),g.innerHTML=vo,Ml=a(),E=o("table"),E.innerHTML=_o,wl=a(),gl=o("hr"),El=a(),R=o("a"),Rl=a(),m(z.$$.fragment),zl=a(),k=o("p"),k.textContent=Fo,kl=a(),O=o("p"),O.innerHTML=bo,Ol=a(),K=o("table"),K.innerHTML=xo,Kl=a(),jl=o("hr"),Bl=a(),j=o("a"),Dl=a(),m(B.$$.fragment),Ul=a(),D=o("p"),D.textContent=$o,Il=a(),U=o("p"),U.innerHTML=Po,ql=a(),I=o("table"),I.innerHTML=Ao,Nl=a(),Sl=o("hr"),Gl=a(),q=o("a"),Jl=a(),m(N.$$.fragment),Ql=a(),S=o("p"),S.textContent=Co,Vl=a(),G=o("p"),G.innerHTML=Ho,Wl=a(),J=o("table"),J.innerHTML=Lo,Xl=a(),Yl=o("hr"),Zl=a(),Q=o("a"),tr=a(),m(V.$$.fragment),er=a(),W=o("p"),W.textContent=Mo,lr=a(),X=o("p"),X.innerHTML=wo,rr=a(),Y=o("table"),Y.innerHTML=go,ar=a(),dr=o("hr"),or=a(),Z=o("a"),ir=a(),m(tt.$$.fragment),sr=a(),et=o("p"),et.textContent=Eo,nr=a(),lt=o("p"),lt.innerHTML=Ro,ur=a(),rt=o("table"),rt.innerHTML=zo,mr=a(),fr=o("hr"),pr=a(),at=o("a"),hr=a(),m(dt.$$.fragment),cr=a(),ot=o("p"),ot.textContent=ko,Tr=a(),it=o("p"),it.innerHTML=Oo,yr=a(),st=o("ul"),st.innerHTML=Ko,vr=a(),nt=o("table"),nt.innerHTML=jo,_r=a(),Fr=o("hr"),br=a(),ut=o("a"),xr=a(),m(mt.$$.fragment),$r=a(),ft=o("p"),ft.textContent=Bo,Pr=a(),pt=o("p"),pt.innerHTML=Do,Ar=a(),ht=o("ul"),ht.innerHTML=Uo,Cr=a(),ct=o("table"),ct.innerHTML=Io,Hr=a(),Lr=o("hr"),Mr=a(),Tt=o("a"),wr=a(),m(yt.$$.fragment),gr=a(),vt=o("p"),vt.textContent=qo,Er=a(),_t=o("p"),_t.innerHTML=No,Rr=a(),Ft=o("table"),Ft.innerHTML=So,zr=a(),kr=o("hr"),Or=a(),bt=o("a"),Kr=a(),m(xt.$$.fragment),jr=a(),$t=o("p"),$t.textContent=Go,Br=a(),Pt=o("p"),Pt.innerHTML=Jo,Dr=a(),At=o("table"),At.innerHTML=Qo,Ur=a(),Ir=o("hr"),qr=a(),Ct=o("a"),Nr=a(),m(Ht.$$.fragment),Sr=a(),Lt=o("p"),Lt.textContent=Vo,Gr=a(),Mt=o("p"),Mt.innerHTML=Wo,Jr=a(),wt=o("table"),wt.innerHTML=Xo,Qr=a(),Vr=o("hr"),Wr=a(),gt=o("a"),Xr=a(),m(Et.$$.fragment),Yr=a(),Rt=o("p"),Rt.textContent=Yo,Zr=a(),zt=o("p"),zt.innerHTML=Zo,ta=a(),kt=o("p"),kt.innerHTML=ti,ea=a(),Ot=o("ul"),Ot.innerHTML=ei,la=a(),ra=o("hr"),aa=a(),Kt=o("a"),da=a(),m(jt.$$.fragment),oa=a(),Bt=o("p"),Bt.innerHTML=li,ia=a(),Dt=o("ul"),Dt.innerHTML=ri,sa=a(),Ut=o("table"),Ut.innerHTML=ai,na=a(),ua=o("hr"),ma=a(),It=o("a"),fa=a(),m(qt.$$.fragment),pa=a(),Nt=o("p"),Nt.innerHTML=di,ha=a(),St=o("p"),St.innerHTML=oi,ca=a(),Ta=o("hr"),ya=a(),Gt=o("a"),va=a(),m(Jt.$$.fragment),_a=a(),Qt=o("p"),Qt.textContent=ii,Fa=a(),Vt=o("p"),Vt.innerHTML=si,ba=a(),Wt=o("table"),Wt.innerHTML=ni,xa=a(),$a=o("hr"),Pa=a(),Xt=o("a"),Aa=a(),m(Yt.$$.fragment),Ca=a(),Zt=o("p"),Zt.textContent=ui,Ha=a(),te=o("p"),te.innerHTML=mi,La=a(),ee=o("table"),ee.innerHTML=fi,Ma=a(),wa=o("hr"),ga=a(),le=o("a"),Ea=a(),m(re.$$.fragment),Ra=a(),ae=o("p"),ae.textContent=pi,za=a(),de=o("p"),de.innerHTML=hi,ka=a(),oe=o("ul"),oe.innerHTML=ci,Oa=a(),ie=o("table"),ie.innerHTML=Ti,Ka=a(),ja=o("hr"),Ba=a(),se=o("a"),Da=a(),m(ne.$$.fragment),Ua=a(),ue=o("p"),ue.textContent=yi,Ia=a(),me=o("p"),me.innerHTML=vi,qa=a(),fe=o("ul"),fe.innerHTML=_i,Na=a(),pe=o("table"),pe.innerHTML=Fi,Sa=a(),Ga=o("hr"),Ja=a(),he=o("a"),Qa=a(),m(ce.$$.fragment),Va=a(),Te=o("p"),Te.innerHTML=bi,Wa=a(),ye=o("p"),ye.innerHTML=xi,Xa=a(),ve=o("ul"),ve.innerHTML=$i,Ya=a(),_e=o("table"),_e.innerHTML=Pi,Za=a(),td=o("hr"),ed=a(),Fe=o("a"),ld=a(),m(be.$$.fragment),rd=a(),xe=o("p"),xe.textContent=Ai,ad=a(),$e=o("p"),$e.innerHTML=Ci,dd=a(),Pe=o("table"),Pe.innerHTML=Hi,od=a(),id=o("hr"),sd=a(),Ae=o("a"),nd=a(),m(Ce.$$.fragment),ud=a(),He=o("p"),He.textContent=Li,md=a(),Le=o("p"),Le.innerHTML=Mi,fd=a(),Me=o("table"),Me.innerHTML=wi,pd=a(),hd=o("hr"),cd=a(),we=o("a"),Td=a(),m(ge.$$.fragment),yd=a(),Ee=o("p"),Ee.textContent=gi,vd=a(),Re=o("p"),Re.innerHTML=Ei,_d=a(),ze=o("table"),ze.innerHTML=Ri,Fd=a(),bd=o("hr"),xd=a(),ke=o("a"),$d=a(),m(Oe.$$.fragment),Pd=a(),Ke=o("p"),Ke.textContent=zi,Ad=a(),je=o("p"),je.innerHTML=ki,Cd=a(),Be=o("table"),Be.innerHTML=Oi,Hd=a(),Ld=o("hr"),Md=a(),De=o("a"),wd=a(),m(Ue.$$.fragment),gd=a(),Ie=o("p"),Ie.textContent=Ki,Ed=a(),qe=o("p"),qe.innerHTML=ji,Rd=a(),Ne=o("table"),Ne.innerHTML=Bi,zd=a(),kd=o("hr"),Od=a(),Se=o("a"),Kd=a(),m(Ge.$$.fragment),jd=a(),Je=o("p"),Je.textContent=Di,Bd=a(),Qe=o("p"),Qe.innerHTML=Ui,Dd=a(),Ve=o("table"),Ve.innerHTML=Ii,Ud=a(),Id=o("hr"),qd=a(),We=o("a"),Nd=a(),m(Xe.$$.fragment),Sd=a(),Ye=o("p"),Ye.textContent=qi,Gd=a(),Ze=o("p"),Ze.innerHTML=Ni,Jd=a(),tl=o("p"),tl.innerHTML=Si,Qd=a(),Vd=o("hr"),Wd=a(),el=o("a"),Xd=a(),m(ll.$$.fragment),Yd=a(),rl=o("p"),rl.textContent=Gi,Zd=a(),al=o("table"),al.innerHTML=Ji,to=a(),eo=o("hr"),lo=a(),dl=o("a"),ro=a(),m(ol.$$.fragment),ao=a(),il=o("p"),il.innerHTML=Qi,oo=a(),io=o("hr"),so=a(),m(sl.$$.fragment),no=a(),ul=o("p"),this.h()},l(t){const e=ts("svelte-u9bgzb",document.head);v=i(e,"META",{name:!0,content:!0}),e.forEach(l),ml=d(t),nl=i(t,"P",{}),u(nl).forEach(l),fl=d(t),_=i(t,"A",{id:!0,class:!0}),u(_).forEach(l),pl=d(t),f(F.$$.fragment,t),hl=d(t),b=i(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1d3zgi"&&(b.textContent=fo),cl=d(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-il3kl8"&&(x.textContent=po),Tl=d(t),$=i(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-1nbgya6"&&($.innerHTML=ho),yl=d(t),vl=i(t,"HR",{}),_l=d(t),P=i(t,"A",{id:!0,class:!0}),u(P).forEach(l),Fl=d(t),f(A.$$.fragment,t),bl=d(t),C=i(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-z8esp"&&(C.innerHTML=co),xl=d(t),H=i(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=To),$l=d(t),Pl=i(t,"HR",{}),Al=d(t),L=i(t,"A",{id:!0,class:!0}),u(L).forEach(l),Cl=d(t),f(M.$$.fragment,t),Hl=d(t),w=i(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-1b1asvx"&&(w.innerHTML=yo),Ll=d(t),g=i(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-pth1sg"&&(g.innerHTML=vo),Ml=d(t),E=i(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=_o),wl=d(t),gl=i(t,"HR",{}),El=d(t),R=i(t,"A",{id:!0,class:!0}),u(R).forEach(l),Rl=d(t),f(z.$$.fragment,t),zl=d(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=Fo),kl=d(t),O=i(t,"P",{"data-svelte-h":!0}),s(O)!=="svelte-xvvopf"&&(O.innerHTML=bo),Ol=d(t),K=i(t,"TABLE",{"data-svelte-h":!0}),s(K)!=="svelte-adoxzf"&&(K.innerHTML=xo),Kl=d(t),jl=i(t,"HR",{}),Bl=d(t),j=i(t,"A",{id:!0,class:!0}),u(j).forEach(l),Dl=d(t),f(B.$$.fragment,t),Ul=d(t),D=i(t,"P",{"data-svelte-h":!0}),s(D)!=="svelte-5479oq"&&(D.textContent=$o),Il=d(t),U=i(t,"P",{"data-svelte-h":!0}),s(U)!=="svelte-m9boyl"&&(U.innerHTML=Po),ql=d(t),I=i(t,"TABLE",{"data-svelte-h":!0}),s(I)!=="svelte-5wetzk"&&(I.innerHTML=Ao),Nl=d(t),Sl=i(t,"HR",{}),Gl=d(t),q=i(t,"A",{id:!0,class:!0}),u(q).forEach(l),Jl=d(t),f(N.$$.fragment,t),Ql=d(t),S=i(t,"P",{"data-svelte-h":!0}),s(S)!=="svelte-1kaf4lx"&&(S.textContent=Co),Vl=d(t),G=i(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=Ho),Wl=d(t),J=i(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Lo),Xl=d(t),Yl=i(t,"HR",{}),Zl=d(t),Q=i(t,"A",{id:!0,class:!0}),u(Q).forEach(l),tr=d(t),f(V.$$.fragment,t),er=d(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-6quqqj"&&(W.textContent=Mo),lr=d(t),X=i(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-1y45k06"&&(X.innerHTML=wo),rr=d(t),Y=i(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-nyqk4k"&&(Y.innerHTML=go),ar=d(t),dr=i(t,"HR",{}),or=d(t),Z=i(t,"A",{id:!0,class:!0}),u(Z).forEach(l),ir=d(t),f(tt.$$.fragment,t),sr=d(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-132v21g"&&(et.textContent=Eo),nr=d(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-odriss"&&(lt.innerHTML=Ro),ur=d(t),rt=i(t,"TABLE",{"data-svelte-h":!0}),s(rt)!=="svelte-nbo00i"&&(rt.innerHTML=zo),mr=d(t),fr=i(t,"HR",{}),pr=d(t),at=i(t,"A",{id:!0,class:!0}),u(at).forEach(l),hr=d(t),f(dt.$$.fragment,t),cr=d(t),ot=i(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-67h0u1"&&(ot.textContent=ko),Tr=d(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-cs0f6n"&&(it.innerHTML=Oo),yr=d(t),st=i(t,"UL",{"data-svelte-h":!0}),s(st)!=="svelte-jusv8t"&&(st.innerHTML=Ko),vr=d(t),nt=i(t,"TABLE",{"data-svelte-h":!0}),s(nt)!=="svelte-mtkj0x"&&(nt.innerHTML=jo),_r=d(t),Fr=i(t,"HR",{}),br=d(t),ut=i(t,"A",{id:!0,class:!0}),u(ut).forEach(l),xr=d(t),f(mt.$$.fragment,t),$r=d(t),ft=i(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-9vv4b"&&(ft.textContent=Bo),Pr=d(t),pt=i(t,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-1ixuuwb"&&(pt.innerHTML=Do),Ar=d(t),ht=i(t,"UL",{"data-svelte-h":!0}),s(ht)!=="svelte-jusv8t"&&(ht.innerHTML=Uo),Cr=d(t),ct=i(t,"TABLE",{"data-svelte-h":!0}),s(ct)!=="svelte-oriydz"&&(ct.innerHTML=Io),Hr=d(t),Lr=i(t,"HR",{}),Mr=d(t),Tt=i(t,"A",{id:!0,class:!0}),u(Tt).forEach(l),wr=d(t),f(yt.$$.fragment,t),gr=d(t),vt=i(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-xb1vdd"&&(vt.textContent=qo),Er=d(t),_t=i(t,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-z8esp"&&(_t.innerHTML=No),Rr=d(t),Ft=i(t,"TABLE",{"data-svelte-h":!0}),s(Ft)!=="svelte-pk7ooi"&&(Ft.innerHTML=So),zr=d(t),kr=i(t,"HR",{}),Or=d(t),bt=i(t,"A",{id:!0,class:!0}),u(bt).forEach(l),Kr=d(t),f(xt.$$.fragment,t),jr=d(t),$t=i(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-11aka64"&&($t.textContent=Go),Br=d(t),Pt=i(t,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-jttckh"&&(Pt.innerHTML=Jo),Dr=d(t),At=i(t,"TABLE",{"data-svelte-h":!0}),s(At)!=="svelte-c6gnt1"&&(At.innerHTML=Qo),Ur=d(t),Ir=i(t,"HR",{}),qr=d(t),Ct=i(t,"A",{id:!0,class:!0}),u(Ct).forEach(l),Nr=d(t),f(Ht.$$.fragment,t),Sr=d(t),Lt=i(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-1xjiy33"&&(Lt.textContent=Vo),Gr=d(t),Mt=i(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=Wo),Jr=d(t),wt=i(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-1uj9e15"&&(wt.innerHTML=Xo),Qr=d(t),Vr=i(t,"HR",{}),Wr=d(t),gt=i(t,"A",{id:!0,class:!0}),u(gt).forEach(l),Xr=d(t),f(Et.$$.fragment,t),Yr=d(t),Rt=i(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-16m1u76"&&(Rt.textContent=Yo),Zr=d(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-698ey0"&&(zt.innerHTML=Zo),ta=d(t),kt=i(t,"P",{"data-svelte-h":!0}),s(kt)!=="svelte-tjke50"&&(kt.innerHTML=ti),ea=d(t),Ot=i(t,"UL",{"data-svelte-h":!0}),s(Ot)!=="svelte-19h6qj3"&&(Ot.innerHTML=ei),la=d(t),ra=i(t,"HR",{}),aa=d(t),Kt=i(t,"A",{id:!0,class:!0}),u(Kt).forEach(l),da=d(t),f(jt.$$.fragment,t),oa=d(t),Bt=i(t,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-1fz4yns"&&(Bt.innerHTML=li),ia=d(t),Dt=i(t,"UL",{"data-svelte-h":!0}),s(Dt)!=="svelte-ph0ovr"&&(Dt.innerHTML=ri),sa=d(t),Ut=i(t,"TABLE",{"data-svelte-h":!0}),s(Ut)!=="svelte-a5vdxc"&&(Ut.innerHTML=ai),na=d(t),ua=i(t,"HR",{}),ma=d(t),It=i(t,"A",{id:!0,class:!0}),u(It).forEach(l),fa=d(t),f(qt.$$.fragment,t),pa=d(t),Nt=i(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1rrw4ya"&&(Nt.innerHTML=di),ha=d(t),St=i(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1gdnoew"&&(St.innerHTML=oi),ca=d(t),Ta=i(t,"HR",{}),ya=d(t),Gt=i(t,"A",{id:!0,class:!0}),u(Gt).forEach(l),va=d(t),f(Jt.$$.fragment,t),_a=d(t),Qt=i(t,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-1693r4v"&&(Qt.textContent=ii),Fa=d(t),Vt=i(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-33y4ax"&&(Vt.innerHTML=si),ba=d(t),Wt=i(t,"TABLE",{"data-svelte-h":!0}),s(Wt)!=="svelte-1td0xj2"&&(Wt.innerHTML=ni),xa=d(t),$a=i(t,"HR",{}),Pa=d(t),Xt=i(t,"A",{id:!0,class:!0}),u(Xt).forEach(l),Aa=d(t),f(Yt.$$.fragment,t),Ca=d(t),Zt=i(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-rsnsrd"&&(Zt.textContent=ui),Ha=d(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1xayhm7"&&(te.innerHTML=mi),La=d(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1up5toh"&&(ee.innerHTML=fi),Ma=d(t),wa=i(t,"HR",{}),ga=d(t),le=i(t,"A",{id:!0,class:!0}),u(le).forEach(l),Ea=d(t),f(re.$$.fragment,t),Ra=d(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-846pp1"&&(ae.textContent=pi),za=d(t),de=i(t,"P",{"data-svelte-h":!0}),s(de)!=="svelte-1t2xajz"&&(de.innerHTML=hi),ka=d(t),oe=i(t,"UL",{"data-svelte-h":!0}),s(oe)!=="svelte-173tqd8"&&(oe.innerHTML=ci),Oa=d(t),ie=i(t,"TABLE",{"data-svelte-h":!0}),s(ie)!=="svelte-1buvx7j"&&(ie.innerHTML=Ti),Ka=d(t),ja=i(t,"HR",{}),Ba=d(t),se=i(t,"A",{id:!0,class:!0}),u(se).forEach(l),Da=d(t),f(ne.$$.fragment,t),Ua=d(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-ozshoc"&&(ue.textContent=yi),Ia=d(t),me=i(t,"P",{"data-svelte-h":!0}),s(me)!=="svelte-1t2xajz"&&(me.innerHTML=vi),qa=d(t),fe=i(t,"UL",{"data-svelte-h":!0}),s(fe)!=="svelte-1ap3720"&&(fe.innerHTML=_i),Na=d(t),pe=i(t,"TABLE",{"data-svelte-h":!0}),s(pe)!=="svelte-lghmn6"&&(pe.innerHTML=Fi),Sa=d(t),Ga=i(t,"HR",{}),Ja=d(t),he=i(t,"A",{id:!0,class:!0}),u(he).forEach(l),Qa=d(t),f(ce.$$.fragment,t),Va=d(t),Te=i(t,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-ijignt"&&(Te.innerHTML=bi),Wa=d(t),ye=i(t,"P",{"data-svelte-h":!0}),s(ye)!=="svelte-1t2xajz"&&(ye.innerHTML=xi),Xa=d(t),ve=i(t,"UL",{"data-svelte-h":!0}),s(ve)!=="svelte-1bp21xg"&&(ve.innerHTML=$i),Ya=d(t),_e=i(t,"TABLE",{"data-svelte-h":!0}),s(_e)!=="svelte-edt5vq"&&(_e.innerHTML=Pi),Za=d(t),td=i(t,"HR",{}),ed=d(t),Fe=i(t,"A",{id:!0,class:!0}),u(Fe).forEach(l),ld=d(t),f(be.$$.fragment,t),rd=d(t),xe=i(t,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-3r4wxn"&&(xe.textContent=Ai),ad=d(t),$e=i(t,"P",{"data-svelte-h":!0}),s($e)!=="svelte-1dkdszr"&&($e.innerHTML=Ci),dd=d(t),Pe=i(t,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-15z8087"&&(Pe.innerHTML=Hi),od=d(t),id=i(t,"HR",{}),sd=d(t),Ae=i(t,"A",{id:!0,class:!0}),u(Ae).forEach(l),nd=d(t),f(Ce.$$.fragment,t),ud=d(t),He=i(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-1jz5wqp"&&(He.textContent=Li),md=d(t),Le=i(t,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-1dkdszr"&&(Le.innerHTML=Mi),fd=d(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-fx5ob"&&(Me.innerHTML=wi),pd=d(t),hd=i(t,"HR",{}),cd=d(t),we=i(t,"A",{id:!0,class:!0}),u(we).forEach(l),Td=d(t),f(ge.$$.fragment,t),yd=d(t),Ee=i(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1baynqa"&&(Ee.textContent=gi),vd=d(t),Re=i(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=Ei),_d=d(t),ze=i(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-szv30n"&&(ze.innerHTML=Ri),Fd=d(t),bd=i(t,"HR",{}),xd=d(t),ke=i(t,"A",{id:!0,class:!0}),u(ke).forEach(l),$d=d(t),f(Oe.$$.fragment,t),Pd=d(t),Ke=i(t,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-1gll44b"&&(Ke.textContent=zi),Ad=d(t),je=i(t,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1dkdszr"&&(je.innerHTML=ki),Cd=d(t),Be=i(t,"TABLE",{"data-svelte-h":!0}),s(Be)!=="svelte-159qhrx"&&(Be.innerHTML=Oi),Hd=d(t),Ld=i(t,"HR",{}),Md=d(t),De=i(t,"A",{id:!0,class:!0}),u(De).forEach(l),wd=d(t),f(Ue.$$.fragment,t),gd=d(t),Ie=i(t,"P",{"data-svelte-h":!0}),s(Ie)!=="svelte-1upf1p8"&&(Ie.textContent=Ki),Ed=d(t),qe=i(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1dkdszr"&&(qe.innerHTML=ji),Rd=d(t),Ne=i(t,"TABLE",{"data-svelte-h":!0}),s(Ne)!=="svelte-18nciet"&&(Ne.innerHTML=Bi),zd=d(t),kd=i(t,"HR",{}),Od=d(t),Se=i(t,"A",{id:!0,class:!0}),u(Se).forEach(l),Kd=d(t),f(Ge.$$.fragment,t),jd=d(t),Je=i(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-8fqhv2"&&(Je.textContent=Di),Bd=d(t),Qe=i(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=Ui),Dd=d(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-pf887e"&&(Ve.innerHTML=Ii),Ud=d(t),Id=i(t,"HR",{}),qd=d(t),We=i(t,"A",{id:!0,class:!0}),u(We).forEach(l),Nd=d(t),f(Xe.$$.fragment,t),Sd=d(t),Ye=i(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-yw51a0"&&(Ye.textContent=qi),Gd=d(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1gw6hta"&&(Ze.innerHTML=Ni),Jd=d(t),tl=i(t,"P",{"data-svelte-h":!0}),s(tl)!=="svelte-tjke50"&&(tl.innerHTML=Si),Qd=d(t),Vd=i(t,"HR",{}),Wd=d(t),el=i(t,"A",{id:!0,class:!0}),u(el).forEach(l),Xd=d(t),f(ll.$$.fragment,t),Yd=d(t),rl=i(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-lvoqsi"&&(rl.textContent=Gi),Zd=d(t),al=i(t,"TABLE",{"data-svelte-h":!0}),s(al)!=="svelte-1gtay08"&&(al.innerHTML=Ji),to=d(t),eo=i(t,"HR",{}),lo=d(t),dl=i(t,"A",{id:!0,class:!0}),u(dl).forEach(l),ro=d(t),f(ol.$$.fragment,t),ao=d(t),il=i(t,"P",{"data-svelte-h":!0}),s(il)!=="svelte-9rr3v5"&&(il.innerHTML=Qi),oo=d(t),io=i(t,"HR",{}),so=d(t),f(sl.$$.fragment,t),no=d(t),ul=i(t,"P",{}),u(ul).forEach(l),this.h()},h(){n(v,"name","hf:doc:metadata"),n(v,"content",as),n(_,"id","module_utils/maths"),n(_,"class","group"),n(P,"id","module_utils/maths.interpolate_data"),n(P,"class","group"),n(L,"id","module_utils/maths.permute_data"),n(L,"class","group"),n(R,"id","module_utils/maths.softmax"),n(R,"class","group"),n(j,"id","module_utils/maths.log_softmax"),n(j,"class","group"),n(q,"id","module_utils/maths.dot"),n(q,"class","group"),n(Q,"id","module_utils/maths.cos_sim"),n(Q,"class","group"),n(Z,"id","module_utils/maths.magnitude"),n(Z,"class","group"),n(at,"id","module_utils/maths.min"),n(at,"class","group"),n(ut,"id","module_utils/maths.max"),n(ut,"class","group"),n(Tt,"id","module_utils/maths.medianFilter"),n(Tt,"class","group"),n(bt,"id","module_utils/maths.round"),n(bt,"class","group"),n(Ct,"id","module_utils/maths.bankers_round"),n(Ct,"class","group"),n(gt,"id","module_utils/maths..P2FFT"),n(gt,"class","group"),n(Kt,"id","new_module_utils/maths..P2FFT_new"),n(Kt,"class","group"),n(It,"id","module_utils/maths..P2FFT+createComplexArray"),n(It,"class","group"),n(Gt,"id","module_utils/maths..P2FFT+fromComplexArray"),n(Gt,"class","group"),n(Xt,"id","module_utils/maths..P2FFT+toComplexArray"),n(Xt,"class","group"),n(le,"id","module_utils/maths..P2FFT+transform"),n(le,"class","group"),n(se,"id","module_utils/maths..P2FFT+realTransform"),n(se,"class","group"),n(he,"id","module_utils/maths..P2FFT+inverseTransform"),n(he,"class","group"),n(Fe,"id","module_utils/maths..P2FFT+_transform4"),n(Fe,"class","group"),n(Ae,"id","module_utils/maths..P2FFT+_singleTransform2"),n(Ae,"class","group"),n(we,"id","module_utils/maths..P2FFT+_singleTransform4"),n(we,"class","group"),n(ke,"id","module_utils/maths..P2FFT+_realTransform4"),n(ke,"class","group"),n(De,"id","module_utils/maths..P2FFT+_singleRealTransform2"),n(De,"class","group"),n(Se,"id","module_utils/maths..P2FFT+_singleRealTransform4"),n(Se,"class","group"),n(We,"id","module_utils/maths..NP2FFT"),n(We,"class","group"),n(el,"id","new_module_utils/maths..NP2FFT_new"),n(el,"class","group"),n(dl,"id","module_utils/maths..AnyTypedArray"),n(dl,"class","group")},m(t,e){es(document.head,v),r(t,ml,e),r(t,nl,e),r(t,fl,e),r(t,_,e),r(t,pl,e),p(F,t,e),r(t,hl,e),r(t,b,e),r(t,cl,e),r(t,x,e),r(t,Tl,e),r(t,$,e),r(t,yl,e),r(t,vl,e),r(t,_l,e),r(t,P,e),r(t,Fl,e),p(A,t,e),r(t,bl,e),r(t,C,e),r(t,xl,e),r(t,H,e),r(t,$l,e),r(t,Pl,e),r(t,Al,e),r(t,L,e),r(t,Cl,e),p(M,t,e),r(t,Hl,e),r(t,w,e),r(t,Ll,e),r(t,g,e),r(t,Ml,e),r(t,E,e),r(t,wl,e),r(t,gl,e),r(t,El,e),r(t,R,e),r(t,Rl,e),p(z,t,e),r(t,zl,e),r(t,k,e),r(t,kl,e),r(t,O,e),r(t,Ol,e),r(t,K,e),r(t,Kl,e),r(t,jl,e),r(t,Bl,e),r(t,j,e),r(t,Dl,e),p(B,t,e),r(t,Ul,e),r(t,D,e),r(t,Il,e),r(t,U,e),r(t,ql,e),r(t,I,e),r(t,Nl,e),r(t,Sl,e),r(t,Gl,e),r(t,q,e),r(t,Jl,e),p(N,t,e),r(t,Ql,e),r(t,S,e),r(t,Vl,e),r(t,G,e),r(t,Wl,e),r(t,J,e),r(t,Xl,e),r(t,Yl,e),r(t,Zl,e),r(t,Q,e),r(t,tr,e),p(V,t,e),r(t,er,e),r(t,W,e),r(t,lr,e),r(t,X,e),r(t,rr,e),r(t,Y,e),r(t,ar,e),r(t,dr,e),r(t,or,e),r(t,Z,e),r(t,ir,e),p(tt,t,e),r(t,sr,e),r(t,et,e),r(t,nr,e),r(t,lt,e),r(t,ur,e),r(t,rt,e),r(t,mr,e),r(t,fr,e),r(t,pr,e),r(t,at,e),r(t,hr,e),p(dt,t,e),r(t,cr,e),r(t,ot,e),r(t,Tr,e),r(t,it,e),r(t,yr,e),r(t,st,e),r(t,vr,e),r(t,nt,e),r(t,_r,e),r(t,Fr,e),r(t,br,e),r(t,ut,e),r(t,xr,e),p(mt,t,e),r(t,$r,e),r(t,ft,e),r(t,Pr,e),r(t,pt,e),r(t,Ar,e),r(t,ht,e),r(t,Cr,e),r(t,ct,e),r(t,Hr,e),r(t,Lr,e),r(t,Mr,e),r(t,Tt,e),r(t,wr,e),p(yt,t,e),r(t,gr,e),r(t,vt,e),r(t,Er,e),r(t,_t,e),r(t,Rr,e),r(t,Ft,e),r(t,zr,e),r(t,kr,e),r(t,Or,e),r(t,bt,e),r(t,Kr,e),p(xt,t,e),r(t,jr,e),r(t,$t,e),r(t,Br,e),r(t,Pt,e),r(t,Dr,e),r(t,At,e),r(t,Ur,e),r(t,Ir,e),r(t,qr,e),r(t,Ct,e),r(t,Nr,e),p(Ht,t,e),r(t,Sr,e),r(t,Lt,e),r(t,Gr,e),r(t,Mt,e),r(t,Jr,e),r(t,wt,e),r(t,Qr,e),r(t,Vr,e),r(t,Wr,e),r(t,gt,e),r(t,Xr,e),p(Et,t,e),r(t,Yr,e),r(t,Rt,e),r(t,Zr,e),r(t,zt,e),r(t,ta,e),r(t,kt,e),r(t,ea,e),r(t,Ot,e),r(t,la,e),r(t,ra,e),r(t,aa,e),r(t,Kt,e),r(t,da,e),p(jt,t,e),r(t,oa,e),r(t,Bt,e),r(t,ia,e),r(t,Dt,e),r(t,sa,e),r(t,Ut,e),r(t,na,e),r(t,ua,e),r(t,ma,e),r(t,It,e),r(t,fa,e),p(qt,t,e),r(t,pa,e),r(t,Nt,e),r(t,ha,e),r(t,St,e),r(t,ca,e),r(t,Ta,e),r(t,ya,e),r(t,Gt,e),r(t,va,e),p(Jt,t,e),r(t,_a,e),r(t,Qt,e),r(t,Fa,e),r(t,Vt,e),r(t,ba,e),r(t,Wt,e),r(t,xa,e),r(t,$a,e),r(t,Pa,e),r(t,Xt,e),r(t,Aa,e),p(Yt,t,e),r(t,Ca,e),r(t,Zt,e),r(t,Ha,e),r(t,te,e),r(t,La,e),r(t,ee,e),r(t,Ma,e),r(t,wa,e),r(t,ga,e),r(t,le,e),r(t,Ea,e),p(re,t,e),r(t,Ra,e),r(t,ae,e),r(t,za,e),r(t,de,e),r(t,ka,e),r(t,oe,e),r(t,Oa,e),r(t,ie,e),r(t,Ka,e),r(t,ja,e),r(t,Ba,e),r(t,se,e),r(t,Da,e),p(ne,t,e),r(t,Ua,e),r(t,ue,e),r(t,Ia,e),r(t,me,e),r(t,qa,e),r(t,fe,e),r(t,Na,e),r(t,pe,e),r(t,Sa,e),r(t,Ga,e),r(t,Ja,e),r(t,he,e),r(t,Qa,e),p(ce,t,e),r(t,Va,e),r(t,Te,e),r(t,Wa,e),r(t,ye,e),r(t,Xa,e),r(t,ve,e),r(t,Ya,e),r(t,_e,e),r(t,Za,e),r(t,td,e),r(t,ed,e),r(t,Fe,e),r(t,ld,e),p(be,t,e),r(t,rd,e),r(t,xe,e),r(t,ad,e),r(t,$e,e),r(t,dd,e),r(t,Pe,e),r(t,od,e),r(t,id,e),r(t,sd,e),r(t,Ae,e),r(t,nd,e),p(Ce,t,e),r(t,ud,e),r(t,He,e),r(t,md,e),r(t,Le,e),r(t,fd,e),r(t,Me,e),r(t,pd,e),r(t,hd,e),r(t,cd,e),r(t,we,e),r(t,Td,e),p(ge,t,e),r(t,yd,e),r(t,Ee,e),r(t,vd,e),r(t,Re,e),r(t,_d,e),r(t,ze,e),r(t,Fd,e),r(t,bd,e),r(t,xd,e),r(t,ke,e),r(t,$d,e),p(Oe,t,e),r(t,Pd,e),r(t,Ke,e),r(t,Ad,e),r(t,je,e),r(t,Cd,e),r(t,Be,e),r(t,Hd,e),r(t,Ld,e),r(t,Md,e),r(t,De,e),r(t,wd,e),p(Ue,t,e),r(t,gd,e),r(t,Ie,e),r(t,Ed,e),r(t,qe,e),r(t,Rd,e),r(t,Ne,e),r(t,zd,e),r(t,kd,e),r(t,Od,e),r(t,Se,e),r(t,Kd,e),p(Ge,t,e),r(t,jd,e),r(t,Je,e),r(t,Bd,e),r(t,Qe,e),r(t,Dd,e),r(t,Ve,e),r(t,Ud,e),r(t,Id,e),r(t,qd,e),r(t,We,e),r(t,Nd,e),p(Xe,t,e),r(t,Sd,e),r(t,Ye,e),r(t,Gd,e),r(t,Ze,e),r(t,Jd,e),r(t,tl,e),r(t,Qd,e),r(t,Vd,e),r(t,Wd,e),r(t,el,e),r(t,Xd,e),p(ll,t,e),r(t,Yd,e),r(t,rl,e),r(t,Zd,e),r(t,al,e),r(t,to,e),r(t,eo,e),r(t,lo,e),r(t,dl,e),r(t,ro,e),p(ol,t,e),r(t,ao,e),r(t,il,e),r(t,oo,e),r(t,io,e),r(t,so,e),p(sl,t,e),r(t,no,e),r(t,ul,e),uo=!0},p:Wi,i(t){uo||(h(F.$$.fragment,t),h(A.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(B.$$.fragment,t),h(N.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(dt.$$.fragment,t),h(mt.$$.fragment,t),h(yt.$$.fragment,t),h(xt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(jt.$$.fragment,t),h(qt.$$.fragment,t),h(Jt.$$.fragment,t),h(Yt.$$.fragment,t),h(re.$$.fragment,t),h(ne.$$.fragment,t),h(ce.$$.fragment,t),h(be.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Oe.$$.fragment,t),h(Ue.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(ol.$$.fragment,t),h(sl.$$.fragment,t),uo=!0)},o(t){c(F.$$.fragment,t),c(A.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(B.$$.fragment,t),c(N.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(dt.$$.fragment,t),c(mt.$$.fragment,t),c(yt.$$.fragment,t),c(xt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(jt.$$.fragment,t),c(qt.$$.fragment,t),c(Jt.$$.fragment,t),c(Yt.$$.fragment,t),c(re.$$.fragment,t),c(ne.$$.fragment,t),c(ce.$$.fragment,t),c(be.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Oe.$$.fragment,t),c(Ue.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(ol.$$.fragment,t),c(sl.$$.fragment,t),uo=!1},d(t){t&&(l(ml),l(nl),l(fl),l(_),l(pl),l(hl),l(b),l(cl),l(x),l(Tl),l($),l(yl),l(vl),l(_l),l(P),l(Fl),l(bl),l(C),l(xl),l(H),l($l),l(Pl),l(Al),l(L),l(Cl),l(Hl),l(w),l(Ll),l(g),l(Ml),l(E),l(wl),l(gl),l(El),l(R),l(Rl),l(zl),l(k),l(kl),l(O),l(Ol),l(K),l(Kl),l(jl),l(Bl),l(j),l(Dl),l(Ul),l(D),l(Il),l(U),l(ql),l(I),l(Nl),l(Sl),l(Gl),l(q),l(Jl),l(Ql),l(S),l(Vl),l(G),l(Wl),l(J),l(Xl),l(Yl),l(Zl),l(Q),l(tr),l(er),l(W),l(lr),l(X),l(rr),l(Y),l(ar),l(dr),l(or),l(Z),l(ir),l(sr),l(et),l(nr),l(lt),l(ur),l(rt),l(mr),l(fr),l(pr),l(at),l(hr),l(cr),l(ot),l(Tr),l(it),l(yr),l(st),l(vr),l(nt),l(_r),l(Fr),l(br),l(ut),l(xr),l($r),l(ft),l(Pr),l(pt),l(Ar),l(ht),l(Cr),l(ct),l(Hr),l(Lr),l(Mr),l(Tt),l(wr),l(gr),l(vt),l(Er),l(_t),l(Rr),l(Ft),l(zr),l(kr),l(Or),l(bt),l(Kr),l(jr),l($t),l(Br),l(Pt),l(Dr),l(At),l(Ur),l(Ir),l(qr),l(Ct),l(Nr),l(Sr),l(Lt),l(Gr),l(Mt),l(Jr),l(wt),l(Qr),l(Vr),l(Wr),l(gt),l(Xr),l(Yr),l(Rt),l(Zr),l(zt),l(ta),l(kt),l(ea),l(Ot),l(la),l(ra),l(aa),l(Kt),l(da),l(oa),l(Bt),l(ia),l(Dt),l(sa),l(Ut),l(na),l(ua),l(ma),l(It),l(fa),l(pa),l(Nt),l(ha),l(St),l(ca),l(Ta),l(ya),l(Gt),l(va),l(_a),l(Qt),l(Fa),l(Vt),l(ba),l(Wt),l(xa),l($a),l(Pa),l(Xt),l(Aa),l(Ca),l(Zt),l(Ha),l(te),l(La),l(ee),l(Ma),l(wa),l(ga),l(le),l(Ea),l(Ra),l(ae),l(za),l(de),l(ka),l(oe),l(Oa),l(ie),l(Ka),l(ja),l(Ba),l(se),l(Da),l(Ua),l(ue),l(Ia),l(me),l(qa),l(fe),l(Na),l(pe),l(Sa),l(Ga),l(Ja),l(he),l(Qa),l(Va),l(Te),l(Wa),l(ye),l(Xa),l(ve),l(Ya),l(_e),l(Za),l(td),l(ed),l(Fe),l(ld),l(rd),l(xe),l(ad),l($e),l(dd),l(Pe),l(od),l(id),l(sd),l(Ae),l(nd),l(ud),l(He),l(md),l(Le),l(fd),l(Me),l(pd),l(hd),l(cd),l(we),l(Td),l(yd),l(Ee),l(vd),l(Re),l(_d),l(ze),l(Fd),l(bd),l(xd),l(ke),l($d),l(Pd),l(Ke),l(Ad),l(je),l(Cd),l(Be),l(Hd),l(Ld),l(Md),l(De),l(wd),l(gd),l(Ie),l(Ed),l(qe),l(Rd),l(Ne),l(zd),l(kd),l(Od),l(Se),l(Kd),l(jd),l(Je),l(Bd),l(Qe),l(Dd),l(Ve),l(Ud),l(Id),l(qd),l(We),l(Nd),l(Sd),l(Ye),l(Gd),l(Ze),l(Jd),l(tl),l(Qd),l(Vd),l(Wd),l(el),l(Xd),l(Yd),l(rl),l(Zd),l(al),l(to),l(eo),l(lo),l(dl),l(ro),l(ao),l(il),l(oo),l(io),l(so),l(no),l(ul)),l(v),T(F,t),T(A,t),T(M,t),T(z,t),T(B,t),T(N,t),T(V,t),T(tt,t),T(dt,t),T(mt,t),T(yt,t),T(xt,t),T(Ht,t),T(Et,t),T(jt,t),T(qt,t),T(Jt,t),T(Yt,t),T(re,t),T(ne,t),T(ce,t),T(be,t),T(Ce,t),T(ge,t),T(Oe,t),T(Ue,t),T(Ge,t),T(Xe,t),T(ll,t),T(ol,t),T(sl,t)}}}const as='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.permute_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathspermutedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> T </code>","local":"utilsmathssoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> T </code>","local":"utilsmathslogsoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> * </code>","local":"utilsmathsmaxarr--code--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths.bankers_round(x) ⇒ <code> number </code>","local":"utilsmathsbankersroundx--code-number-code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function ds(mo){return Xi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Yi{constructor(v){super(),Zi(this,v,ds,rs,Vi,{})}}export{ns as component};
